/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxStationConverter;

import com.tridiumX.knxStationConverter.BStationConverterOptions;
import com.tridiumX.knxStationConverter.BStationConverterOptionsPane;
import com.tridiumX.knxnetIp.addresses.BGroupAddress;
import com.tridiumX.knxnetIp.wb.BImportEtsProjectFilePane;
import java.io.File;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.tool.BWbTool;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

@NiagaraType
public final class BKnxStationConverterTool
extends BWbTool {
    public static final Type TYPE = Sys.loadType(BKnxStationConverterTool.class);
    private static final String[] KNX_STANDARD_PROXY_EXT_DISPLAY_NAMES = new String[]{"emergencyActive=%lexicon(knxnetIp:boolean.emergencyActive)%;", "emergencyInactive=%lexicon(knxnetIp:boolean.emergencyInactive)%;", "emergencyAuto=%lexicon(knxnetIp:boolean.emergencyAuto)%;", "active=%lexicon(knxnetIp:boolean.active)%;", "inactive=%lexicon(knxnetIp:boolean.inactive)%;", "auto=%lexicon(knxnetIp:boolean.auto)%;", "set=%lexicon(knxnetIp:boolean.set)%;", "emergencyOverride=%lexicon(knxnetIp:enum.emergencyOverride)%;", "emergencyAuto=%lexicon(knxnetIp:enum.emergencyAuto)%;", "override=%lexicon(knxnetIp:enum.override)%;", "auto=%lexicon(knxnetIp:enum.auto)%;", "set=%lexicon(knxnetIp:enum.set)%;", "emergencyOverride=%lexicon(knxnetIp:numeric.emergencyOverride)%;", "emergencyAuto=%lexicon(knxnetIp:numeric.emergencyAuto)%;", "override=%lexicon(knxnetIp:numeric.override)%;", "auto=%lexicon(knxnetIp:numeric.auto)%;", "set=%lexicon(knxnetIp:numeric.set)%;", "emergencyOverride=%lexicon(knxnetIp:string.emergencyOverride)%;", "emergencyAuto=%lexicon(knxnetIp:string.emergencyAuto)%;", "override=%lexicon(knxnetIp:string.override)%;", "auto=%lexicon(knxnetIp:string.auto)%;", "set=%lexicon(knxnetIp:string.set)%;"};
    private static final String[] DEMUX_TYPES = new String[]{"eib:Knx3ByteDemux", "eib:KnxBoilerModeDemux", "eib:KnxStatusWithModeDemux"};
    private static final String[] EIB_ACTION_TYPES = new String[]{"eib:KnxCounterDecrementAction", "eib:KnxCounterIncrementAction", "eib:KnxCounterPresetAction", "eib:KnxCounterResetAction", "eib:KnxStepBreakAction", "eib:KnxStepDownAction", "eib:KnxStepUpAction", "eib:KnxSwitchControlAutoAction", "eib:KnxSwitchControlOffAction", "eib:KnxSwitchControlOnAction", "eib:KnxTriggerOffAction", "eib:KnxTriggerOnAction", "eib:KnxSetAction", "eib:KnxToggleAction"};
    private static final String[] KNX_ACTION_TYPES = new String[]{"knx:KnxCounterDecrementAction", "knx:KnxCounterIncrementAction", "knx:KnxCounterPresetAction", "knx:KnxCounterResetAction", "knx:KnxStepBreakAction", "knx:KnxStepDownAction", "knx:KnxStepUpAction", "knx:KnxSwitchControlAutoAction", "knx:KnxSwitchControlOffAction", "knx:KnxSwitchControlOnAction", "knx:KnxSwitchOffAction", "knx:KnxSwitchOnAction", "knx:KnxSwitchSetAction", "knx:KnxSwitchToggleAction"};
    private static final String[] PROXY_EXT_TYPES = new String[]{"eib:KnxBooleanProxyExt", "eib:KnxEnumProxyExt", "eib:KnxNumericProxyExt", "eib:KnxStringProxyExt"};
    private static final String[] POINT_TYPES = new String[]{"c:BooleanPoint", "c:BooleanWritable", "c:EnumPoint", "c:EnumWritable", "c:NumericPoint", "c:NumericWritable", "c:StringPoint", "c:StringWritable"};
    private BWbShell shell;
    private int lastDeviceId;
    public static final String STATIONS_HOME = "~stations";
    private static final String STATION_CONVERTER_DIALOG_TITLE = "EIB to KNX Station Converter";
    private static final String STATION_UPDATER_DIALOG_TITLE = "KNX Station Updater";
    private static final BOrd DEFAULT_KNX_STATION_ORD = BOrd.make((String)"local:|module://knxStationConverter/knx/knx_station.xml");

    public Type getType() {
        return TYPE;
    }

    public CommandArtifact invoke(BWbShell shell) throws Exception {
        this.shell = shell;
        this.convertStation();
        return null;
    }

    private void convertStation() throws Exception {
        BStationConverterOptions scOptions = BStationConverterOptions.make();
        BStationConverterOptionsPane optionsPane = new BStationConverterOptionsPane(scOptions.getLastStationConverted());
        boolean bFinished = false;
        while (!bFinished) {
            int dialogResult = BDialog.open((BWidget)this.shell, (String)STATION_CONVERTER_DIALOG_TITLE, (Object)((Object)optionsPane), (int)3);
            if (dialogResult == 2) {
                bFinished = true;
                continue;
            }
            if (dialogResult == 1) {
                try {
                    BStationConverterOptionsPane.StationConverterOptions options = optionsPane.getStationConverterOptions();
                    scOptions.setLastStationConverted(options.stationName);
                    scOptions.save();
                    String outputStationName = options.stationName + "_Knx";
                    BKnxStationConverterTool.copyStationAssets(options.stationName, outputStationName);
                    this.convertStationFile(options.stationName, outputStationName);
                    bFinished = true;
                }
                catch (Exception ex) {
                    if (BDialog.open((BWidget)this.shell, (String)"Error converting Station", (Object)"Could not convert the selected Station.", (int)3, (BImage)BDialog.ERROR_ICON, (Throwable)ex) != 2) continue;
                    bFinished = true;
                }
                continue;
            }
            throw new Exception("The \"EIB to KNX Station Converter\" dialog returned a value (" + dialogResult + ") other than \"BDialog.OK\" (" + 1 + ") or \"BDialog.CANCEL\" (" + 2 + ").");
        }
    }

    private void convertStationFile(String inputStationName, String outputStationName) throws Exception {
        FilePath stationFilePath;
        FilePath importFilePath = stationFilePath = new FilePath("~stations/" + inputStationName + "/config.bog");
        XElem station = XParser.make((File)BFileSystem.INSTANCE.pathToLocalFile(importFilePath)).parse();
        XElem defaultStation = XParser.make((InputStream)((BIFile)DEFAULT_KNX_STATION_ORD.get()).getInputStream()).parse();
        FilePath outputFilePath = new FilePath("~stations/" + outputStationName + "/config.bog");
        XElem eibNetworkElem = BKnxStationConverterTool.findElement(station, "/p[@t='b:Station']/p[@t='d:DriverContainer']/p[@t='eib:EibnetIpNetwork']");
        if (eibNetworkElem != null) {
            FilePath eibOutputFilePath = new FilePath(TextUtil.replace((String)outputFilePath.getBody(), (String)".bog", (String)"_eib.xml"));
            BIFile eibOutputIFile = BFileSystem.INSTANCE.makeFile(eibOutputFilePath);
            XWriter eibWriter = new XWriter(eibOutputIFile.getOutputStream());
            eibWriter.prolog();
            BKnxStationConverterTool.writeStation(station, eibWriter);
            eibWriter.close();
            this.transformEibStationToKnx(station, defaultStation);
            FilePath knxOutputFilePath = new FilePath(TextUtil.replace((String)outputFilePath.getBody(), (String)".bog", (String)"_knx.xml"));
            BIFile knxOutputIFile = BFileSystem.INSTANCE.makeFile(knxOutputFilePath);
            XWriter knxWriter = new XWriter(knxOutputIFile.getOutputStream());
            knxWriter.prolog();
            BKnxStationConverterTool.writeStation(station, knxWriter);
            knxWriter.close();
            this.transformKnxStationToPropsVer29(station, defaultStation);
            knxOutputFilePath = new FilePath(TextUtil.replace((String)outputFilePath.getBody(), (String)".bog", (String)"_knx_29.xml"));
            knxOutputIFile = BFileSystem.INSTANCE.makeFile(knxOutputFilePath);
            knxWriter = new XWriter(knxOutputIFile.getOutputStream());
            knxWriter.prolog();
            BKnxStationConverterTool.writeStation(station, knxWriter);
            knxWriter.close();
            BIFile outputIFile = BFileSystem.INSTANCE.makeFile(outputFilePath);
            XWriter writer = new XWriter(outputIFile.getOutputStream());
            writer.setZipped(true);
            writer.prolog();
            BKnxStationConverterTool.writeStation(station, writer);
            writer.close();
            BDialog.info((BWidget)this.shell, (String)STATION_CONVERTER_DIALOG_TITLE, (Object)("EIB Station '" + inputStationName + "' has been converted to KNX Station '" + outputStationName + "'."));
        } else {
            XElem knxNetworkElem = BKnxStationConverterTool.findElement(station, "/p[@t='b:Station']/p[@t='d:DriverContainer']/p[@t='knx:KnxNetwork']");
            if (knxNetworkElem != null) {
                FilePath backupFilePath = BKnxStationConverterTool.getBackupFilePath(stationFilePath);
                FileUtil.move((File)BFileSystem.INSTANCE.pathToLocalFile(stationFilePath), (File)BFileSystem.INSTANCE.pathToLocalFile(backupFilePath));
                FilePath beforeFilePath = new FilePath(TextUtil.replace((String)stationFilePath.getBody(), (String)".bog", (String)"_before.xml"));
                BIFile beforeOutputIFile = BFileSystem.INSTANCE.makeFile(beforeFilePath);
                XWriter beforeWriter = new XWriter(beforeOutputIFile.getOutputStream());
                beforeWriter.prolog();
                BKnxStationConverterTool.writeStation(station, beforeWriter);
                beforeWriter.close();
                this.transformKnxStationToPropsVer29(station, defaultStation);
                FilePath afterFilePath = new FilePath(TextUtil.replace((String)stationFilePath.getBody(), (String)".bog", (String)"_after.xml"));
                BIFile afterOutputIFile = BFileSystem.INSTANCE.makeFile(afterFilePath);
                XWriter afterWriter = new XWriter(afterOutputIFile.getOutputStream());
                afterWriter.prolog();
                BKnxStationConverterTool.writeStation(station, afterWriter);
                afterWriter.close();
                BIFile outputIFile = BFileSystem.INSTANCE.makeFile(stationFilePath);
                XWriter writer = new XWriter(outputIFile.getOutputStream());
                writer.setZipped(true);
                writer.prolog();
                BKnxStationConverterTool.writeStation(station, writer);
                writer.close();
                BDialog.info((BWidget)this.shell, (String)STATION_UPDATER_DIALOG_TITLE, (Object)("KNX Station '" + inputStationName + "' has been updated to the latest 'Properties Version'."));
            } else {
                BDialog.info((BWidget)this.shell, (String)STATION_UPDATER_DIALOG_TITLE, (Object)("KNX Station '" + inputStationName + "' does not contain any instances of 'KnxNetwork' or 'EibnetIpNetwork' to convert."));
            }
        }
    }

    private static void copyStationAssets(String inputStationName, String outputStationName) {
        BFileSystem fileSystem = BFileSystem.INSTANCE;
        FilePath stationFilePath = new FilePath("~stations/" + inputStationName);
        FilePath destinationFilePath = new FilePath("~stations/" + outputStationName);
        BKnxStationConverterTool.copyFolder(fileSystem.pathToLocalFile(stationFilePath).toPath(), fileSystem.pathToLocalFile(destinationFilePath).toPath());
    }

    public static void copyFolder(Path source, Path dest) {
        try {
            Files.walk(source, new FileVisitOption[0]).forEach(sourceItem -> {
                try {
                    Path destPath = dest.resolve(source.relativize((Path)sourceItem));
                    if (Files.isDirectory(sourceItem, new LinkOption[0])) {
                        if (!destPath.toFile().exists()) {
                            Files.createDirectory(destPath, new FileAttribute[0]);
                        }
                    } else if (!sourceItem.endsWith("config.bog")) {
                        Files.copy(sourceItem, destPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                }
                catch (Exception e) {
                    System.out.println("Error copying station file " + sourceItem + " : " + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            System.out.println("Error copying station files " + e.getMessage());
        }
    }

    private static FilePath getBackupFilePath(FilePath existingFilePath) {
        String sFileName = existingFilePath.getBody();
        StringBuffer sb = new StringBuffer(sFileName.length() + 31);
        sb.append(sFileName.substring(0, sFileName.lastIndexOf(".bog")));
        sb.append("_backup ");
        BAbsTime now = BAbsTime.make();
        BImportEtsProjectFilePane.appendTime((StringBuffer)sb, (BAbsTime)now);
        sb.append('-');
        sb.append(TextUtil.padZeros((String)String.valueOf(now.getMillisecond()), (int)3));
        sb.append(".bog");
        return new FilePath(sb.toString().replace(':', '-'));
    }

    private void transformKnxStationToPropsVer29(XElem station, XElem defaultStation) throws Exception {
        XElem[] agDefParents = this.findAllElements(station, "p[p[@t='knx:ActionGroupDef']]");
        for (int j = 0; j < agDefParents.length; ++j) {
            XElem[] agDefs = BKnxStationConverterTool.findChildElements(agDefParents[j], "p[@t='knx:ActionGroupDef']");
            for (int k = 0; k < agDefs.length; ++k) {
                agDefParents[j].removeContent((XContent)agDefs[k]);
            }
        }
        for (int i = 0; i < POINT_TYPES.length; ++i) {
            XElem[] elems = this.findAllElements(station, "p[@t='" + POINT_TYPES[i] + "']");
            for (int j = 0; j < elems.length; ++j) {
                int k;
                XElem point = elems[j];
                XElem[] hdaParents = this.findAllElements(point, "p[p[@n='hideDynamicActions']]");
                for (k = 0; k < hdaParents.length; ++k) {
                    XElem hdaParent = hdaParents[k];
                    XElem[] hdaElems = BKnxStationConverterTool.findChildElements(hdaParent, "p[@n='hideDynamicActions']");
                    for (int l = 0; l < hdaElems.length; ++l) {
                        hdaParent.removeContent((XContent)hdaElems[l]);
                    }
                }
                for (k = 0; k < KNX_ACTION_TYPES.length; ++k) {
                    XElem[] actions = BKnxStationConverterTool.findChildElements(point, "p[@t='" + KNX_ACTION_TYPES[k] + "']");
                    for (int l = 0; l < actions.length; ++l) {
                        XElem returnTypeSpecElem;
                        XElem parameterTypeSpecElem;
                        XElem parentPointTypeElem;
                        XElem actionElem = actions[l];
                        XElem actionNameElem = BKnxStationConverterTool.findChildElement(actionElem, "p[@n='actionName']");
                        if (actionNameElem != null) {
                            actionElem.removeContent((XContent)actionNameElem);
                        }
                        if ((parentPointTypeElem = BKnxStationConverterTool.findChildElement(actionElem, "p[@n='parentPointType']")) != null) {
                            actionElem.removeContent((XContent)parentPointTypeElem);
                        }
                        if ((parameterTypeSpecElem = BKnxStationConverterTool.findChildElement(actionElem, "p[@n='parameterTypeSpec']")) != null) {
                            actionElem.removeContent((XContent)parameterTypeSpecElem);
                        }
                        if ((returnTypeSpecElem = BKnxStationConverterTool.findChildElement(actionElem, "p[@n='returnTypeSpec']")) == null) continue;
                        actionElem.removeContent((XContent)returnTypeSpecElem);
                    }
                }
                XElem[] nameMapElems = BKnxStationConverterTool.findChildElements(point, "p[@t='b:NameMap']");
                for (int k2 = 0; k2 < nameMapElems.length; ++k2) {
                    XElem elem = nameMapElems[k2];
                    int vAttrIdx = elem.attrIndex("v");
                    if (vAttrIdx < 0) continue;
                    String attrValue = elem.attrValue(vAttrIdx);
                    for (int l = 0; l < KNX_STANDARD_PROXY_EXT_DISPLAY_NAMES.length; ++l) {
                        attrValue = TextUtil.replace((String)attrValue, (String)KNX_STANDARD_PROXY_EXT_DISPLAY_NAMES[l], (String)"");
                    }
                    elem.setAttr(vAttrIdx, attrValue);
                }
            }
        }
    }

    private void transformEibStationToKnx(XElem station, XElem defaultStation) throws Exception {
        int lastHandle = this.findLargestHandle(station);
        XElem sysDefStationServices = BKnxStationConverterTool.findElement(station, "/p[@t='b:Station']/p[@t='d:DriverContainer']/p[@t='nd:NiagaraNetwork']/p[@t='nd:LocalSysDefStation']/p[@n='services']");
        int sysDefStationServicesAttrIdx = sysDefStationServices.attrIndex("v");
        if (sysDefStationServicesAttrIdx >= 0) {
            String sysDefStationServicesV = sysDefStationServices.attrValue(sysDefStationServicesAttrIdx);
            sysDefStationServices.setAttr(sysDefStationServicesAttrIdx, TextUtil.replace((String)sysDefStationServicesV, (String)"eibnetIp$3aEibnetIpNetwork;", (String)"knxnetIp$3aKnxNetwork;"));
        }
        XElem[] providerStationElems = BKnxStationConverterTool.findElements(station, "/p[@t='b:Station']/p[@t='d:DriverContainer']/p[@t='nd:NiagaraNetwork']/p[@t='nd:BogProvider']/p[@t='nd:ProviderStation']");
        for (int i = 0; i < providerStationElems.length; ++i) {
            int attrIdx;
            XElem elem = BKnxStationConverterTool.findElement(providerStationElems[i], "/p[@n='services']");
            if (elem == null || (attrIdx = elem.attrIndex("v")) < 0) continue;
            String attrValue = elem.attrValue(attrIdx);
            elem.setAttr(attrIdx, TextUtil.replace((String)attrValue, (String)"eibnetIp$3aEibnetIpNetwork;", (String)"knxnetIp$3aKnxNetwork;"));
        }
        XElem eibNetworkElem = BKnxStationConverterTool.findElement(station, "/p[@t='b:Station']/p[@t='d:DriverContainer']/p[@t='eib:EibnetIpNetwork']");
        if (eibNetworkElem != null) {
            int attrIdx;
            eibNetworkElem.setAttr("m", "knx=knxnetIp");
            eibNetworkElem.setAttr("t", "knx:KnxNetwork");
            XElem uploadElem = BKnxStationConverterTool.findChildElement(eibNetworkElem, "a[@n='upload']");
            if (uploadElem != null) {
                eibNetworkElem.removeContent((XContent)uploadElem);
            }
            XElem downloadElem = BKnxStationConverterTool.findChildElement(eibNetworkElem, "a[@n='download']");
            eibNetworkElem.removeContent((XContent)downloadElem);
            XElem[] workerElems = BKnxStationConverterTool.findChildElements(eibNetworkElem, "p[@t='eib:EibnetWorker']");
            for (int i = 0; i < workerElems.length; ++i) {
                eibNetworkElem.removeContent((XContent)workerElems[i]);
            }
            XElem imDelayElem = BKnxStationConverterTool.findChildElement(eibNetworkElem, "p[@n='interMessageDelay']");
            String interMessageDelay = "";
            if (imDelayElem != null && (attrIdx = imDelayElem.attrIndex("v")) >= 0) {
                interMessageDelay = imDelayElem.attrValue(attrIdx);
            }
            eibNetworkElem.removeContent((XContent)imDelayElem);
            XElem pollSchedulerElem = BKnxStationConverterTool.findChildElement(eibNetworkElem, "p[@t='basic:BasicPollScheduler']");
            pollSchedulerElem.removeAttr("m");
            pollSchedulerElem.setAttr("t", "knx:KnxPollScheduler");
            XElem linkLayerElem = BKnxStationConverterTool.findChildElement(eibNetworkElem, "p[@t='eib:EibnetIpLinkLayer']");
            if (linkLayerElem != null) {
                XElem adapterElem = BKnxStationConverterTool.findChildElement(linkLayerElem, "p[@n='localAdapter']");
                XElem adapterIdElem = BKnxStationConverterTool.findChildElement(linkLayerElem, "p[@n='localAdapterId']");
                XElem ipAddressElem = BKnxStationConverterTool.findChildElement(linkLayerElem, "p[@n='localIpAddress']");
                String sAdapterId = BKnxStationConverterTool.getTagFromDynamicEnum(adapterIdElem);
                String sDescription = BKnxStationConverterTool.getTagFromDynamicEnum(adapterElem);
                String sIpAddress = BKnxStationConverterTool.getTagFromDynamicEnum(ipAddressElem);
                XElem knxLocalInterfacesElem = BKnxStationConverterTool.findElement(defaultStation, "/p[@t='b:Station']/p[@t='d:DriverContainer']/p[@t='knx:KnxNetwork']/p[@t='knx:LocalInterfaces']");
                if (knxLocalInterfacesElem != null) {
                    XElem localInterfacesElem = BKnxStationConverterTool.shallowCopy(knxLocalInterfacesElem);
                    localInterfacesElem.setAttr("h", Integer.toHexString(++lastHandle));
                    XElem knxLocalInterfaceElem = BKnxStationConverterTool.findChildElement(knxLocalInterfacesElem, "p[@t='knx:LocalInterface']");
                    XElem localInterfaceElem = BKnxStationConverterTool.shallowCopy(knxLocalInterfaceElem);
                    localInterfaceElem.setAttr("h", Integer.toHexString(++lastHandle));
                    localInterfacesElem.addContent((XContent)localInterfaceElem);
                    localInterfaceElem.addContent((XContent)BKnxStationConverterTool.findChildElement(knxLocalInterfaceElem, "p[@n='localInterfaceId']").copy());
                    XElem newAdapterIdElem = BKnxStationConverterTool.findChildElement(knxLocalInterfaceElem, "p[@n='adapterId']").deepcopy();
                    XElem subAdapterIdElem = BKnxStationConverterTool.findChildElement(newAdapterIdElem, "p[@n='adapterId']");
                    subAdapterIdElem.setAttr("v", sAdapterId);
                    XElem subDescriptionElem = BKnxStationConverterTool.findChildElement(newAdapterIdElem, "p[@n='description']");
                    subDescriptionElem.setAttr("v", sDescription);
                    XElem subIpAddressElem = BKnxStationConverterTool.findChildElement(newAdapterIdElem, "p[@n='ipAddress']");
                    subIpAddressElem.setAttr("v", sIpAddress);
                    localInterfaceElem.addContent((XContent)newAdapterIdElem);
                    eibNetworkElem.replaceContent(eibNetworkElem.contentIndex((XContent)linkLayerElem), (XContent)localInterfacesElem);
                } else {
                    eibNetworkElem.removeContent((XContent)linkLayerElem);
                }
            }
            XElem tunnelElem = BKnxStationConverterTool.findChildElement(eibNetworkElem, "p[@t='eib:EibnetIpTunnelLayer']");
            eibNetworkElem.removeContent((XContent)tunnelElem);
            this.lastDeviceId = 0;
            this.transformDevices(eibNetworkElem, interMessageDelay);
        }
        for (int i = 0; i < POINT_TYPES.length; ++i) {
            XElem[] elems = this.findAllElements(station, "p[@t='" + POINT_TYPES[i] + "']");
            for (int j = 0; j < elems.length; ++j) {
                XElem point = elems[j];
                BKnxStationConverterTool.transformPoint(point);
            }
        }
        int firstLine = -1;
        XElem firstDemux = null;
        for (int i = 0; i < DEMUX_TYPES.length; ++i) {
            XElem[] demuxes = this.findAllElements(station, "p[@t='" + DEMUX_TYPES[i] + "']");
            for (int j = 0; j < demuxes.length; ++j) {
                if (firstLine != -1 && demuxes[j].line() >= firstLine) continue;
                firstLine = demuxes[j].line();
                firstDemux = demuxes[j];
            }
        }
        if (firstDemux != null) {
            firstDemux.setAttr("m", "eib=eibnetIp");
        }
    }

    private static XElem shallowCopy(XElem elem) {
        XElem var1 = new XElem();
        var1.setNs(elem.ns());
        var1.setName(elem.name());
        for (int i = 0; i < elem.attrSize(); ++i) {
            var1.addAttr(elem.attrName(i), elem.attrValue(i));
        }
        return var1;
    }

    private static String getTagFromDynamicEnum(XElem adapterIdElem) {
        int attrIdx = adapterIdElem.attrIndex("v");
        if (attrIdx >= 0) {
            String attrVal = adapterIdElem.attrValue(attrIdx);
            String[] vParts = TextUtil.split((String)attrVal, (char)'@');
            int currentOrdinal = Integer.parseInt(vParts[0]);
            if (vParts[1].startsWith("{") && vParts[1].endsWith("}")) {
                String[] enums = TextUtil.split((String)vParts[1].substring(1, vParts[1].length() - 1), (char)',');
                for (int i = 0; i < enums.length; ++i) {
                    String[] enumParts = TextUtil.split((String)enums[i], (char)'=');
                    int ordinal = Integer.parseInt(enumParts[1]);
                    if (ordinal != currentOrdinal) continue;
                    return SlotPath.unescape((String)enumParts[0]);
                }
            }
        }
        return "";
    }

    private void transformDevices(XElem topElem, String interMessageDelay) throws Exception {
        XElem[] elems = BKnxStationConverterTool.findChildElements(topElem, "p[@t='eib:EibnetIpDevice']");
        for (int i = 0; i < elems.length; ++i) {
            XElem device = elems[i];
            device.setAttr("t", "knx:KnxDevice");
            this.transformDevice(device, interMessageDelay);
        }
        XElem[] folders = BKnxStationConverterTool.findChildElements(topElem, "p[@t='eib:EibnetIpDeviceFolder']");
        for (int i = 0; i < folders.length; ++i) {
            folders[i].setAttr("t", "knx:KnxDeviceFolder");
            this.transformDevices(folders[i], interMessageDelay);
        }
    }

    private void transformDevice(XElem device, String interMessageDelay) throws Exception {
        XElem uploadElem = BKnxStationConverterTool.findChildElement(device, "a[@n='upload']");
        if (uploadElem != null) {
            device.removeContent((XContent)uploadElem);
        }
        XElem downloadElem = BKnxStationConverterTool.findChildElement(device, "a[@n='download']");
        device.removeContent((XContent)downloadElem);
        XElem connectElem = BKnxStationConverterTool.findChildElement(device, "a[@n='connect']");
        device.removeContent((XContent)connectElem);
        XElem disconnectElem = BKnxStationConverterTool.findChildElement(device, "a[@n='disconnect']");
        device.removeContent((XContent)disconnectElem);
        XElem descriptonElem = BKnxStationConverterTool.findChildElement(device, "p[@n='description']");
        if (descriptonElem != null) {
            descriptonElem.setAttr("n", "friendlyName");
        }
        XElem[] workerElems = BKnxStationConverterTool.findChildElements(device, "p[@t='eib:EibnetWorker']");
        for (int i = 0; i < workerElems.length; ++i) {
            device.removeContent((XContent)workerElems[i]);
        }
        XElem[] connectWorkerElems = BKnxStationConverterTool.findChildElements(device, "p[@t='eib:EibnetConnectWorker']");
        for (int i = 0; i < connectWorkerElems.length; ++i) {
            device.removeContent((XContent)connectWorkerElems[i]);
        }
        XElem pointDeviceExtElem = BKnxStationConverterTool.findChildElement(device, "p[@t='eib:EibnetIpPointDeviceExt']");
        if (pointDeviceExtElem != null) {
            pointDeviceExtElem.setAttr("t", "knx:KnxPointDeviceExt");
            this.transformPoints(pointDeviceExtElem);
        }
        XElem deviceIdElem = new XElem("p");
        deviceIdElem.setAttr("n", "deviceId");
        deviceIdElem.setAttr("v", Integer.toString(++this.lastDeviceId));
        device.addContent(device.contentIndex((XContent)BKnxStationConverterTool.findChildElement(device, "p[@t='a:AlarmSourceInfo']")) + 1, (XContent)deviceIdElem);
        XElem knxInstallationElem = new XElem("p");
        knxInstallationElem.setAttr("n", "knxInstallation");
        knxInstallationElem.setAttr("t", "knx:KnxInstallationRef");
        XElem enumElem = new XElem("p");
        enumElem.setAttr("n", "knxInstallationIdEnum");
        enumElem.setAttr("t", "b:DynamicEnum");
        enumElem.setAttr("v", "1");
        knxInstallationElem.addContent((XContent)enumElem);
        device.addContent(device.contentIndex((XContent)deviceIdElem) + 1, (XContent)knxInstallationElem);
    }

    private void transformPoints(XElem pointFolderElem) throws Exception {
        for (int i = 0; i < POINT_TYPES.length; ++i) {
            XElem[] elems = BKnxStationConverterTool.findChildElements(pointFolderElem, "p[@t='" + POINT_TYPES[i] + "']");
            for (int j = 0; j < elems.length; ++j) {
                XElem point = elems[j];
                BKnxStationConverterTool.transformPoint(point);
            }
        }
        XElem[] folders = BKnxStationConverterTool.findChildElements(pointFolderElem, "p[@t='eib:KnxPointFolder']");
        for (int i = 0; i < folders.length; ++i) {
            folders[i].setAttr("t", "knx:KnxPointFolder");
            this.transformPoints(folders[i]);
        }
    }

    private static void transformPoint(XElem point) throws Exception {
        int i;
        for (int i2 = 0; i2 < PROXY_EXT_TYPES.length; ++i2) {
            XElem[] elems = BKnxStationConverterTool.findChildElements(point, "p[@t='" + PROXY_EXT_TYPES[i2] + "']");
            for (int j = 0; j < elems.length; ++j) {
                XElem dataTypeElem;
                XElem proxyExtElem = elems[j];
                proxyExtElem.setAttr("t", TextUtil.replace((String)PROXY_EXT_TYPES[i2], (String)"eib:", (String)"knx:"));
                XElem gaFolderElem = BKnxStationConverterTool.findChildElement(proxyExtElem, "p[@t='eib:GroupAddressFolder']");
                if (gaFolderElem != null) {
                    gaFolderElem.setAttr("t", "knx:GroupAddresses");
                    XElem[] gaElems = BKnxStationConverterTool.findChildElements(gaFolderElem, "p[@t='eib:GroupAddress']");
                    for (int k = 0; k < gaElems.length; ++k) {
                        XElem gaElem = gaElems[k];
                        gaElem.setAttr("t", "knx:GroupAddress");
                        XElem addressElem = BKnxStationConverterTool.findChildElement(gaElem, "p[@n='address']");
                        int vAttrIdx = addressElem.attrIndex("v");
                        if (vAttrIdx < 0) continue;
                        String addr = addressElem.attrValue(vAttrIdx);
                        BGroupAddress groupAddr = BGroupAddress.make((String)addr);
                        addressElem.setAttr("v", Integer.toString(groupAddr.getAddress()));
                        XElem styleElem = new XElem("p");
                        styleElem.setAttr("n", "style");
                        styleElem.setAttr("t", "knx:KnxAddressStyleEnum");
                        styleElem.setAttr("v", groupAddr.getStyle().getTag());
                        gaElem.addContent((XContent)styleElem);
                    }
                }
                if ((dataTypeElem = BKnxStationConverterTool.findChildElement(proxyExtElem, "p[@n='dataType']")) != null) {
                    int attrIdx = dataTypeElem.attrIndex("v");
                    if (attrIdx < 0) continue;
                    String dataType = dataTypeElem.attrValue(attrIdx);
                    dataTypeElem.setAttr(attrIdx, BKnxStationConverterTool.getDataValueTypeId(dataType));
                    dataTypeElem.setAttr("n", "dataValueTypeId");
                    dataTypeElem.removeAttr("t");
                    continue;
                }
                XElem newDataTypeElem = new XElem("p");
                newDataTypeElem.setAttr("n", "dataValueTypeId");
                newDataTypeElem.setAttr("v", "DPST-1-1");
                proxyExtElem.addContent((XContent)newDataTypeElem);
            }
        }
        XElem[] nameMapElems = BKnxStationConverterTool.findChildElements(point, "p[@t='b:NameMap']");
        for (i = 0; i < nameMapElems.length; ++i) {
            XElem elem = nameMapElems[i];
            int vAttrIdx = elem.attrIndex("v");
            if (vAttrIdx < 0) continue;
            String attrValue = elem.attrValue(vAttrIdx);
            elem.setAttr(vAttrIdx, TextUtil.replace((String)attrValue, (String)"eibnetIp:", (String)"knxnetIp:"));
        }
        for (i = 0; i < EIB_ACTION_TYPES.length; ++i) {
            XElem[] elems = BKnxStationConverterTool.findChildElements(point, "p[@t='" + EIB_ACTION_TYPES[i] + "']");
            for (int j = 0; j < elems.length; ++j) {
                XElem elem = elems[j];
                elem.setAttr("t", KNX_ACTION_TYPES[i]);
            }
        }
    }

    private static String getDataValueTypeId(String dataType) {
        if (dataType.startsWith("unknown_")) {
            if (dataType.endsWith("bit")) {
                return "DPST-0-" + dataType.substring("unknown_".length(), dataType.length() - "bit".length());
            }
            int bits = Integer.parseInt(dataType.substring("unknown_".length(), dataType.length() - "byte".length())) * 8;
            return "DPST-0-" + Integer.toString(bits);
        }
        if (dataType.startsWith("dpt")) {
            int dt = Integer.parseInt(dataType.substring("dpt".length(), dataType.indexOf(95)));
            return "DPST-" + Integer.toString(dt / 1000) + "-" + Integer.toString(dt % 1000);
        }
        return dataType;
    }

    private static XElem findElement(XElem topElem, String xPath) {
        XElem[] elems = BKnxStationConverterTool.findElements(topElem, xPath);
        if (elems.length == 1) {
            return elems[0];
        }
        return null;
    }

    private static XElem findChildElement(XElem topElem, String xPathPart) {
        XElem[] elems = BKnxStationConverterTool.findChildElements(topElem, xPathPart);
        if (elems.length == 1) {
            return elems[0];
        }
        return null;
    }

    private static XElem[] findElements(XElem topElem, String xPath) {
        String[] xPathParts = TextUtil.split((String)xPath, (char)'/');
        XElem[] searchElems = new XElem[]{topElem};
        Array resultElems = new Array(XElem.class);
        for (int i = 0; i < xPathParts.length; ++i) {
            if (xPathParts[i].equals("")) continue;
            resultElems.clear();
            String xPathPart = xPathParts[i];
            for (int j = 0; j < searchElems.length; ++j) {
                XElem searchElem = searchElems[j];
                resultElems.addAll((Object[])BKnxStationConverterTool.findChildElements(searchElem, xPathPart));
            }
            searchElems = (XElem[])resultElems.trim();
        }
        return (XElem[])resultElems.trim();
    }

    private XElem[] findAllElements(XElem topElem, String xPath) {
        Array a = new Array(XElem.class);
        a.addAll((Object[])BKnxStationConverterTool.findChildElements(topElem, xPath));
        XElem[] elems = topElem.elems();
        for (int i = 0; i < elems.length; ++i) {
            a.addAll((Object[])this.findAllElements(elems[i], xPath));
        }
        return (XElem[])a.trim();
    }

    private static XElem[] findChildElements(XElem topElem, String xPathPart) {
        Array a = new Array(XElem.class);
        String elemName = xPathPart.substring(0, xPathPart.indexOf(91));
        String xPathCondition = xPathPart.substring(elemName.length() + 1, xPathPart.lastIndexOf(93));
        if (xPathCondition.startsWith("@")) {
            String attrName = xPathPart.substring(xPathPart.indexOf(64) + 1, xPathPart.indexOf(61));
            String attrValue = xPathPart.substring(xPathPart.indexOf(61) + 2, xPathPart.indexOf(93) - 1);
            XElem[] elems = topElem.elems(elemName);
            for (int j = 0; j < elems.length; ++j) {
                XElem elem = elems[j];
                int attrIdx = elem.attrIndex(attrName);
                if (attrIdx < 0 || !elem.attrValue(attrIdx).equals(attrValue)) continue;
                a.add((Object)elem);
            }
        } else {
            String attrName = xPathCondition.substring(xPathCondition.indexOf(64) + 1, xPathCondition.indexOf(61));
            String attrValue = xPathCondition.substring(xPathCondition.indexOf(61) + 2, xPathCondition.indexOf(93) - 1);
            XElem[] elems = topElem.elems(elemName);
            for (int j = 0; j < elems.length; ++j) {
                XElem elem = elems[j];
                int attrIdx = elem.attrIndex(attrName);
                if (attrIdx < 0 || !elem.attrValue(attrIdx).equals(attrValue)) continue;
                a.add((Object)topElem);
            }
        }
        return (XElem[])a.trim();
    }

    private static void writeStation(XElem stationElem, XWriter writer) {
        stationElem.write(writer);
    }

    private int findLargestHandle(XElem stationElem) {
        int h = 0;
        XElem[] children = stationElem.elems("p");
        for (int i = 0; i < children.length; ++i) {
            int childrenH;
            int childH;
            XElem child = children[i];
            int idx = child.attrIndex("h");
            if (idx >= 0 && (childH = Integer.parseInt(child.attrValue(idx), 16)) > h) {
                h = childH;
            }
            if ((childrenH = this.findLargestHandle(child)) <= h) continue;
            h = childrenH;
        }
        return h;
    }
}

