/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxStationConverter;

import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
public final class BStationConverterOptionsPane
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BStationConverterOptionsPane.class);
    private static final FilePath STATIONS_FILE_PATH = new FilePath("~stations");
    private final BLabel stationFileLabel = new BLabel("Station to convert:");
    private final BFrozenEnumFE station = new BFrozenEnumFE();

    public Type getType() {
        return TYPE;
    }

    public BStationConverterOptionsPane() {
    }

    public BStationConverterOptionsPane(String lastConvertedStation) {
        this.station.loadValue((BObject)BStationConverterOptionsPane.getStationsEnum(lastConvertedStation));
        BGridPane pane = new BGridPane(2);
        pane.add("stationFileLabel", (BValue)this.stationFileLabel);
        pane.add("station", (BValue)this.station);
        this.setTop((BWidget)pane);
    }

    public static final BDynamicEnum getStationsEnum(String lastConvertedStation) {
        Array entries = new Array(String.class);
        int sel = 0;
        BIFile stationsFolder = BFileSystem.INSTANCE.findFile(STATIONS_FILE_PATH);
        if (stationsFolder.isDirectory()) {
            BDirectory stationsDir = new BDirectory(stationsFolder.getStore());
            BIFile[] stations = stationsDir.listFiles();
            for (int i = 0; i < stations.length; ++i) {
                String entry = stations[i].getFileName();
                if (entry.equals(lastConvertedStation)) {
                    sel = entries.size();
                }
                entries.add((Object)SlotPath.escape((String)entry));
            }
        }
        return BDynamicEnum.make((int)sel, (BEnumRange)BEnumRange.make((String[])((String[])entries.trim())));
    }

    public StationConverterOptions getStationConverterOptions() throws CannotSaveException, Exception {
        StationConverterOptions options = new StationConverterOptions();
        options.stationName = SlotPath.unescape((String)((BDynamicEnum)this.station.saveValue()).getTag());
        return options;
    }

    public class StationConverterOptions {
        public String stationName;
    }
}

