/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ets;

import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyleEnum;
import com.tridiumX.knxnetIp.enums.BKnxComObjectSizeEnum;
import com.tridiumX.knxnetIp.ets.BEtsImportableComponent;
import com.tridiumX.knxnetIp.ets.EtsProjectImportUtil;
import com.tridiumX.knxnetIp.ets.IEtsGroupRangesContainer;
import com.tridiumX.knxnetIp.ets.enums.BEtsComObjectPriorityEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsGroupAddressStyleEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsNameSpaceEnum;
import com.tridiumX.knxnetIp.ets.job.BEtsProjectFileImportJob;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsApplicationProgram;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsApplicationProgramRef;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsHardware;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsHardware2Program;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsParameter;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsProduct;
import com.tridiumX.knxnetIp.ets.master.BEtsMaskVersion;
import com.tridiumX.knxnetIp.ets.master.BEtsMasterData;
import com.tridiumX.knxnetIp.ets.project.BEtsArea;
import com.tridiumX.knxnetIp.ets.project.BEtsComObjectInstanceRef;
import com.tridiumX.knxnetIp.ets.project.BEtsConnector;
import com.tridiumX.knxnetIp.ets.project.BEtsDeviceInstance;
import com.tridiumX.knxnetIp.ets.project.BEtsGroupAddress;
import com.tridiumX.knxnetIp.ets.project.BEtsGroupRange;
import com.tridiumX.knxnetIp.ets.project.BEtsInstallation;
import com.tridiumX.knxnetIp.ets.project.BEtsLine;
import com.tridiumX.knxnetIp.ets.project.BEtsProject;
import com.tridiumX.knxnetIp.ets.project.BEtsReceive;
import com.tridiumX.knxnetIp.wb.BImportedDevice;
import com.tridiumX.knxnetIp.wb.BImportedEtsProjectFile;
import com.tridiumX.knxnetIp.wb.BImportedPoint;
import com.tridiumX.knxnetIp.wb.BImportedPointGroup;
import com.tridiumX.knxnetIp.xml.XmlChildImportSpec;
import com.tridiumX.knxnetIp.xml.XmlPropertyImportSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="targetNamespace", type="BEtsNameSpaceEnum", defaultValue="BEtsNameSpaceEnum.DEFAULT", flags=65)
public final class BEtsProjectFile
extends BEtsImportableComponent {
    public static final Property targetNamespace = BEtsProjectFile.newProperty((int)65, (BValue)BEtsNameSpaceEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BEtsProjectFile.class);
    private HashMap<String, ArrayList<BEtsImportableComponent>> referersMap;
    private int m_iTotalAddresses;
    private int m_iCurrentAddress;

    public BEtsNameSpaceEnum getTargetNamespace() {
        return (BEtsNameSpaceEnum)this.get(targetNamespace);
    }

    public void setTargetNamespace(BEtsNameSpaceEnum v) {
        this.set(targetNamespace, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return false;
    }

    @Override
    public String getIdPropertyName() {
        return "";
    }

    @Override
    public XmlPropertyImportSpec[] getImportSpecs() {
        return null;
    }

    @Override
    public XmlChildImportSpec[] getImportChildSpecs() {
        return emptyChildImportSpecs;
    }

    public void interpretEtsElementsAsImportedDevicesAndPoints(BEtsProjectFileImportJob job) throws Exception {
        BEtsProject[] projects = (BEtsProject[])this.getChildren(BEtsProject.class);
        for (int i = 0; i < projects.length; ++i) {
            if (!job.getJobState().isRunning()) {
                return;
            }
            BEtsProject project = projects[i];
            BEtsGroupAddressStyleEnum etsGroupAddressStyle = project.getGroupAddressStyle();
            BKnxAddressStyleEnum groupAddressStyle = BKnxAddressStyleEnum.make((int)etsGroupAddressStyle.getOrdinal());
            job.getImportedEtsProjectFile().setGroupAddressStyle(groupAddressStyle);
            this.m_iTotalAddresses = 0;
            BEtsInstallation[] installations = (BEtsInstallation[])project.getChildren(BEtsInstallation.class);
            if (installations.length > 0) {
                BEtsInstallation installation;
                int j;
                for (j = 0; j < installations.length; ++j) {
                    installation = installations[j];
                    this.m_iTotalAddresses += this.countGroupAddresses(installation);
                    job.getImportedEtsProjectFile().setGroupAddressCount(this.m_iTotalAddresses);
                }
                this.m_iCurrentAddress = 0;
                for (j = 0; j < installations.length; ++j) {
                    if (!job.getJobState().isRunning()) {
                        return;
                    }
                    installation = installations[j];
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Processing installation " + installation.getName() + " at slotpath : " + installation.getSlotPath());
                    }
                    this.interpretTopology(installation, job);
                    this.preFetchReferers(installation);
                    this.interpretGroupRangesAsImportedPoints(0, groupAddressStyle, installation, job.getImportedEtsProjectFile().getImportedPoints(), job);
                }
                continue;
            }
            throw new Exception("No 'Installations' found in Project '" + project.getProjectName() + "'.");
        }
    }

    public final String[] getHardware2ProgramIds() {
        Vector<String> vHardware2ProgramIds = new Vector<String>(1, 1);
        BEtsProject[] projects = (BEtsProject[])this.getChildren(BEtsProject.class);
        for (int i = 0; i < projects.length; ++i) {
            BEtsProject project = projects[i];
            BEtsInstallation[] installations = (BEtsInstallation[])project.getChildren(BEtsInstallation.class);
            for (int j = 0; j < installations.length; ++j) {
                BEtsInstallation installation = installations[j];
                BEtsArea[] areas = (BEtsArea[])installation.getChildren(BEtsArea.class);
                for (int k = 0; k < areas.length; ++k) {
                    BEtsArea area = areas[k];
                    BEtsLine[] lines = (BEtsLine[])area.getChildren(BEtsLine.class);
                    for (int m = 0; m < lines.length; ++m) {
                        BEtsLine line = lines[m];
                        BEtsDeviceInstance[] deviceInstances = (BEtsDeviceInstance[])line.getChildren(BEtsDeviceInstance.class);
                        for (int n = 0; n < deviceInstances.length; ++n) {
                            BEtsDeviceInstance deviceInstance = deviceInstances[n];
                            String hardwareToProgramRefId = deviceInstance.getHardware2ProgramRefId();
                            if (hardwareToProgramRefId.equals("") || vHardware2ProgramIds.contains(hardwareToProgramRefId)) continue;
                            vHardware2ProgramIds.add(hardwareToProgramRefId);
                        }
                    }
                }
            }
        }
        String[] a = new String[vHardware2ProgramIds.size()];
        return vHardware2ProgramIds.toArray(a);
    }

    private void interpretTopology(BEtsInstallation installation, BEtsProjectFileImportJob job) throws Exception {
        BEtsArea[] areas = (BEtsArea[])installation.getChildren(BEtsArea.class);
        for (int k = 0; k < areas.length; ++k) {
            BEtsArea area = areas[k];
            BEtsLine[] lines = (BEtsLine[])area.getChildren(BEtsLine.class);
            for (int m = 0; m < lines.length; ++m) {
                BEtsLine line = lines[m];
                BEtsDeviceInstance[] deviceInstances = (BEtsDeviceInstance[])line.getChildren(BEtsDeviceInstance.class);
                for (int n = 0; n < deviceInstances.length; ++n) {
                    BValue product;
                    BEtsDeviceInstance deviceInstance = deviceInstances[n];
                    String hardwareToProgramRefId = deviceInstance.getHardware2ProgramRefId();
                    BEtsHardware2Program hardware2Program = this.getHardware2Program(hardwareToProgramRefId);
                    BEtsHardware hardware = (BEtsHardware)hardware2Program.getParent();
                    BEtsApplicationProgramRef[] applicationProgramRefs = (BEtsApplicationProgramRef[])hardware2Program.getChildren(BEtsApplicationProgramRef.class);
                    if (applicationProgramRefs.length <= 0) continue;
                    BEtsApplicationProgramRef applicationProgramRef = applicationProgramRefs[0];
                    BEtsApplicationProgram applicationProgram = (BEtsApplicationProgram)this.getReferee(applicationProgramRef.getRefId());
                    String maskVersion = applicationProgram.getMaskVersion();
                    boolean isIpDevice = false;
                    if (hardware.getIsIpEnabled()) {
                        isIpDevice = true;
                    } else {
                        BEtsParameter[] parameters = (BEtsParameter[])applicationProgram.getChildren(BEtsParameter.class);
                        for (int p = 0; p < parameters.length; ++p) {
                            BEtsParameter parameter = parameters[p];
                            String sName = parameter.getParameterName().toLowerCase();
                            if (sName.indexOf("ip") >= 0 && (sName.indexOf("addr") >= 0 || sName.indexOf("adr") >= 0)) {
                                isIpDevice = true;
                                break;
                            }
                            String sText = parameter.getText().toLowerCase();
                            if (sText.indexOf("ip") < 0 || sText.indexOf("addr") < 0 && sText.indexOf("adr") < 0) continue;
                            isIpDevice = true;
                            break;
                        }
                    }
                    if (!isIpDevice) continue;
                    BImportedDevice importedDevice = new BImportedDevice();
                    importedDevice.setKnxId(deviceInstance.getDeviceInstanceId());
                    importedDevice.setIndividualDeviceAddress(BIndividualDeviceAddress.make((int)((BEtsArea)line.getParent()).getAddress(), (int)line.getAddress(), (int)deviceInstance.getAddress()));
                    String deviceName = deviceInstance.getDeviceInstanceName();
                    if (deviceName.equals("") && (product = hardware.get(SlotPath.escape((String)deviceInstance.getProductRefId()))) instanceof BEtsProduct) {
                        deviceName = ((BEtsProduct)product).getText();
                    }
                    if (deviceName.equals("")) {
                        deviceName = importedDevice.getIndividualDeviceAddress().getFriendlyAddress();
                    }
                    importedDevice.setDeviceName(deviceName);
                    importedDevice.setMaskVersion(maskVersion);
                    if (!importedDevice.isValid()) continue;
                    BValue existingDeviceSlot = job.getImportedEtsProjectFile().getImportedDevices().get(SlotPath.escape((String)importedDevice.getDeviceName()));
                    if (existingDeviceSlot != null) {
                        importedDevice.setDeviceName(importedDevice.getIndividualDeviceAddress().getFriendlyAddress() + " " + importedDevice.getDeviceName());
                    }
                    job.getImportedEtsProjectFile().getImportedDevices().add(SlotPath.escape((String)(importedDevice.getDeviceName() + (existingDeviceSlot == null ? "" : " - " + importedDevice.getKnxId()))), (BValue)importedDevice);
                }
            }
        }
    }

    public final BEtsHardware2Program getHardware2Program(String hardwareToProgramRefId) {
        try {
            BEtsImportableComponent result = this.getReferee(hardwareToProgramRefId);
            if (result instanceof BEtsHardware2Program) {
                return (BEtsHardware2Program)result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private int countGroupAddresses(IEtsGroupRangesContainer parentGroupRange) {
        int iCount = 0;
        if (parentGroupRange instanceof BEtsGroupRange) {
            iCount += ((BEtsGroupAddress[])((BEtsGroupRange)parentGroupRange).getChildren(BEtsGroupAddress.class)).length;
        }
        BEtsGroupRange[] ranges = parentGroupRange.getGroupRanges();
        for (int i = 0; i < ranges.length; ++i) {
            iCount += this.countGroupAddresses(ranges[i]);
        }
        return iCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void interpretGroupRangesAsImportedPoints(int iDepth, BKnxAddressStyleEnum groupAddressStyle, IEtsGroupRangesContainer parentGroupRange, BImportedPointGroup parentPointGroup, BEtsProjectFileImportJob job) throws Exception {
        try {
            BEtsGroupRange[] aGroupRanges;
            BImportedEtsProjectFile importedFile = job.getImportedEtsProjectFile();
            if (importedFile != null && importedFile.getMaxGroupDepth() < iDepth + 1) {
                importedFile.setMaxGroupDepth(iDepth + 1);
            }
            if ((aGroupRanges = parentGroupRange.getGroupRanges()) == null) return;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Processing group ranges, aGroupRanges.length = \"" + aGroupRanges.length + "\"");
            }
            for (int k = 0; k < aGroupRanges.length; ++k) {
                if (!job.getJobState().isRunning()) {
                    return;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Processing group range number " + k + " which is at slotpath " + aGroupRanges[k].getSlotPath());
                }
                String knxId = "";
                try {
                    BEtsGroupRange knxGroupRange = aGroupRanges[k];
                    knxId = knxGroupRange.getGroupRangeId();
                    BImportedPointGroup importedPointGroup = BImportedPointGroup.make(knxId, iDepth, knxGroupRange.getGroupRangeName());
                    String sGroupRangeName = SlotPath.escape((String)importedPointGroup.getGroupName());
                    if (parentPointGroup.get(sGroupRangeName) != null) {
                        sGroupRangeName = sGroupRangeName + SlotPath.escape((String)(" (" + knxGroupRange.getRangeStart() + " - " + knxGroupRange.getRangeEnd() + ")"));
                    }
                    if (parentPointGroup.get(sGroupRangeName) != null) {
                        sGroupRangeName = sGroupRangeName + SlotPath.escape((String)(" {Id = '" + knxGroupRange.getGroupRangeId() + "'}"));
                    }
                    parentPointGroup.add(sGroupRangeName, (BValue)importedPointGroup);
                    job.logMessage("Group - '" + SlotPath.unescape((String)sGroupRangeName) + "'");
                    this.interpretGroupRangesAsImportedPoints(iDepth + 1, groupAddressStyle, knxGroupRange, importedPointGroup, job);
                    this.interpretGroupAddressesAsImportedPoints(iDepth + 1, groupAddressStyle, knxGroupRange, importedPointGroup, job);
                    continue;
                }
                catch (Exception ex) {
                    String sErr = "There was a problem in 'interpretGroupRangesAsImportedPoints', looping through the 'GroupRanges' of an 'IEtsGroupRangesContainer' with KnxID = '" + knxId + "',  where iDepth = '" + iDepth + "' & parentGroupRange = '" + parentGroupRange.toString() + "'.";
                    if (job.getImportProblemReports().add(sErr + "\n\r" + ex.toString())) return;
                }
            }
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception("There was a problem in 'interpretGroupRangesAsImportedPoints' where iDepth = '" + iDepth + "' & parentGroupRange = '" + parentGroupRange.toString() + "'.", t);
        }
    }

    private void interpretGroupAddressesAsImportedPoints(int iDepth, BKnxAddressStyleEnum groupAddressStyle, BEtsGroupRange knxGroupRange, BImportedPointGroup importedPointGroup, BEtsProjectFileImportJob job) throws Exception {
        BEtsGroupAddress[] aGroupAddresses = (BEtsGroupAddress[])knxGroupRange.getChildren(BEtsGroupAddress.class);
        for (int i = 0; i < aGroupAddresses.length; ++i) {
            if (!job.getJobState().isRunning()) {
                return;
            }
            String exExtra = "";
            try {
                exExtra = exExtra + "/n/ri = '" + i + "'";
                BEtsGroupAddress groupAddress = aGroupAddresses[i];
                String addressKnxId = groupAddress.getGroupAddressId();
                exExtra = exExtra + "/n/raddressKnxId = '" + addressKnxId + "'";
                BEtsImportableComponent[] referers = this.getReferers(addressKnxId);
                String dataPointType = groupAddress.getDatapointType();
                BImportedPoint importedPoint = BImportedPoint.make(addressKnxId, iDepth, groupAddress.getGroupAddressName(), groupAddressStyle, groupAddress.getAddress());
                if (referers.length > 0) {
                    BKnxComObjectSizeEnum comObjectSize = BKnxComObjectSizeEnum.unknownSize;
                    BEtsComObjectPriorityEnum priority = BEtsComObjectPriorityEnum.DEFAULT;
                    boolean sendNotReceive = true;
                    boolean isActive = false;
                    boolean readFlag = false;
                    boolean writeFlag = false;
                    boolean communicationFlag = false;
                    boolean transmitFlag = false;
                    boolean updateFlag = false;
                    boolean readOnInitFlag = false;
                    for (int j = 0; j < referers.length; ++j) {
                        BEtsComObjectPriorityEnum connectorPriority;
                        if (referers[j] instanceof BEtsReceive) {
                            sendNotReceive = false;
                        }
                        BEtsComObjectInstanceRef instanceRef = BEtsProjectFile.getInstanceRef(referers[j]);
                        BKnxComObjectSizeEnum connectorSize = instanceRef.getObjectSize(this);
                        if (comObjectSize.equals((Object)BKnxComObjectSizeEnum.unknownSize)) {
                            comObjectSize = connectorSize;
                        } else if (!connectorSize.equals((Object)comObjectSize)) {
                            throw new IllegalStateException("Different 'ComObjectSize's found for GroupAddress " + addressKnxId);
                        }
                        if (dataPointType.equals("")) {
                            dataPointType = instanceRef.getDatapointType(this);
                        }
                        if ((connectorPriority = instanceRef.getPriority(this)).getOrdinal() > priority.getOrdinal()) {
                            priority = connectorPriority;
                        }
                        isActive |= instanceRef.getIsActive();
                        readFlag |= instanceRef.getReadFlag(this);
                        writeFlag |= instanceRef.getWriteFlag(this);
                        communicationFlag |= instanceRef.getCommunicationFlag(this);
                        transmitFlag |= instanceRef.getTransmitFlag(this);
                        updateFlag |= instanceRef.getUpdateFlag(this);
                        readOnInitFlag |= instanceRef.getReadOnInitFlag(this);
                    }
                    importedPoint.setComObjectSize(comObjectSize);
                    importedPoint.setPriority(priority);
                    importedPoint.setSendNotReceive(sendNotReceive);
                    importedPoint.setIsActive(isActive);
                    importedPoint.setReadFlag(readFlag);
                    importedPoint.setWriteFlag(writeFlag);
                    importedPoint.setCommunicationFlag(communicationFlag);
                    importedPoint.setTransmitFlag(transmitFlag);
                    importedPoint.setUpdateFlag(updateFlag);
                    importedPoint.setReadOnInitFlag(readOnInitFlag);
                    exExtra = exExtra + "/n/rdataPointType = '" + dataPointType + "'";
                    importedPoint.setDataValueTypeId(dataPointType);
                    String sGroupAddressName = SlotPath.escape((String)importedPoint.getPointName());
                    if (importedPointGroup.get(sGroupAddressName) != null) {
                        sGroupAddressName = sGroupAddressName + SlotPath.escape((String)(" (" + groupAddress.getAddress() + ")"));
                    }
                    if (importedPointGroup.get(sGroupAddressName) != null) {
                        sGroupAddressName = sGroupAddressName + SlotPath.escape((String)(" {Id = '" + groupAddress.getGroupAddressId() + "'}"));
                    }
                    importedPointGroup.add(sGroupAddressName, (BValue)importedPoint);
                    job.logMessage(String.format("Processed GroupAddress - '%s'", SlotPath.unescape((String)sGroupAddressName)));
                } else if (job.includeUnassociatedGroupAdresses()) {
                    EtsProjectImportUtil.addUnassociatedGroupAddressToGroup(importedPointGroup, importedPoint, groupAddress, groupAddressStyle, job);
                }
                ++this.m_iCurrentAddress;
                this.updateProgress(job);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String sErr = "There was a problem in 'interpretGroupAddressesAsImportedPoints', looping through the 'aGroupAddresses' of a 'BEtsGroupRange' with KnxID = '" + knxGroupRange.getGroupRangeId() + "',  where iDepth = '" + iDepth + "' & knxGroupRange = '" + knxGroupRange.toString() + "'.";
                sErr = sErr + " exExtra = " + exExtra;
                if (job.getImportProblemReports().add(sErr + "\n\r" + ex.toString())) break;
            }
        }
    }

    private static BEtsComObjectInstanceRef getInstanceRef(BEtsImportableComponent referer) {
        if (referer instanceof BEtsConnector) {
            return (BEtsComObjectInstanceRef)((BEtsConnector)referer.as(BEtsConnector.class)).getParent();
        }
        if (referer instanceof BEtsComObjectInstanceRef) {
            return (BEtsComObjectInstanceRef)referer.as(BEtsComObjectInstanceRef.class);
        }
        throw new BajaRuntimeException("Unrecognized referer type: " + referer.getClass().getSimpleName());
    }

    private void updateProgress(BEtsProjectFileImportJob job) {
        if (job != null) {
            job.updateProgress(this.m_iCurrentAddress * 100 / this.m_iTotalAddresses);
        }
    }

    public BEtsImportableComponent getReferee(String iD) throws Exception {
        BEtsProjectFile result = null;
        if (!iD.equals("")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Referee iD to scan for = " + iD);
            }
            String[] idParts = TextUtil.split((String)iD, (char)'_');
            BEtsImportableComponent kic = this;
            String slotName = "";
            for (int i = 0; i < idParts.length; ++i) {
                slotName = slotName + (i == 0 ? "" : "_") + idParts[i];
                while (i > 1 && i < idParts.length) {
                    if (++i >= idParts.length) continue;
                    slotName = slotName + "_" + idParts[i];
                }
                BValue val = kic.get(SlotPath.escape((String)slotName));
                if (val == null) {
                    kic = null;
                    break;
                }
                if (!(val instanceof BEtsImportableComponent)) {
                    throw new Exception("An object of type other than 'BEtsImportableComponent' has been found in the 'Referee' 'Slot Path', slotName = \"" + slotName + "\".  Its TYPE is \"" + val.getType().toString() + "\".");
                }
                kic = (BEtsImportableComponent)val;
            }
            if (kic != null) {
                result = kic;
            }
        }
        return result;
    }

    private void preFetchReferers(BEtsInstallation installation) {
        BEtsNameSpaceEnum etsNameSpace = ((BImportedEtsProjectFile)this.getParent()).getEtsNamespace();
        if (etsNameSpace.getOrdinal() < 6) {
            this.preFetchReferersPre20(installation);
        } else {
            this.preFetchReferersPost20(installation);
        }
    }

    private void preFetchReferersPre20(BEtsInstallation installation) {
        this.referersMap = new HashMap(this.m_iTotalAddresses);
        BEtsArea[] areas = (BEtsArea[])installation.getChildren(BEtsArea.class);
        for (int i = 0; i < areas.length; ++i) {
            BEtsArea area = areas[i];
            BEtsLine[] lines = (BEtsLine[])area.getChildren(BEtsLine.class);
            for (int j = 0; j < lines.length; ++j) {
                BEtsLine line = lines[j];
                BEtsDeviceInstance[] devices = (BEtsDeviceInstance[])line.getChildren(BEtsDeviceInstance.class);
                for (int k = 0; k < devices.length; ++k) {
                    BEtsDeviceInstance device = devices[k];
                    BEtsComObjectInstanceRef[] refs = (BEtsComObjectInstanceRef[])device.getChildren(BEtsComObjectInstanceRef.class);
                    for (int m = 0; m < refs.length; ++m) {
                        BEtsComObjectInstanceRef ref = refs[m];
                        BEtsConnector[] sendAndReceives = (BEtsConnector[])ref.getChildren(BEtsConnector.class);
                        for (int n = 0; n < sendAndReceives.length; ++n) {
                            BEtsConnector sendOrReceive = sendAndReceives[n];
                            String key = sendOrReceive.getGroupAddressRefId();
                            if (!this.referersMap.containsKey(key)) {
                                ArrayList al = new ArrayList();
                                this.referersMap.put(key, al);
                            }
                            this.referersMap.get(key).add(sendOrReceive);
                        }
                    }
                }
            }
        }
    }

    private void preFetchReferersPost20(BEtsInstallation installation) {
        this.referersMap = new HashMap(this.m_iTotalAddresses);
        String groupAddressPrefix = ((BEtsProject)installation.getParent()).getProjectId() + "-" + installation.getInstallationId() + "_";
        BEtsArea[] areas = (BEtsArea[])installation.getChildren(BEtsArea.class);
        for (int i = 0; i < areas.length; ++i) {
            BEtsArea area = areas[i];
            BEtsLine[] lines = (BEtsLine[])area.getChildren(BEtsLine.class);
            for (int j = 0; j < lines.length; ++j) {
                BEtsLine line = lines[j];
                BEtsDeviceInstance[] devices = (BEtsDeviceInstance[])line.getChildren(BEtsDeviceInstance.class);
                for (int k = 0; k < devices.length; ++k) {
                    BEtsDeviceInstance device = devices[k];
                    BEtsComObjectInstanceRef[] refs = (BEtsComObjectInstanceRef[])device.getChildren(BEtsComObjectInstanceRef.class);
                    for (int m = 0; m < refs.length; ++m) {
                        BEtsComObjectInstanceRef ref = refs[m];
                        String[] groupAddressLinks = TextUtil.split((String)ref.getGroupAddressLinks(), (char)' ');
                        for (int n = 0; n < groupAddressLinks.length; ++n) {
                            String groupAddressLink = groupAddressLinks[n];
                            String key = groupAddressPrefix + groupAddressLink;
                            if (!this.referersMap.containsKey(key)) {
                                ArrayList al = new ArrayList();
                                this.referersMap.put(key, al);
                            }
                            this.referersMap.get(key).add(ref);
                        }
                    }
                }
            }
        }
    }

    public final BEtsImportableComponent[] getReferers(String knxId) throws Exception {
        try {
            ArrayList<BEtsImportableComponent> al;
            if (!knxId.equals("") && (al = this.referersMap.get(knxId)) != null) {
                BEtsImportableComponent[] a = new BEtsImportableComponent[al.size()];
                return al.toArray(a);
            }
            return new BEtsImportableComponent[0];
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public final BEtsDeviceInstance getDeviceInstanceById(String deviceInstanceId) {
        if (!deviceInstanceId.equals("")) {
            BEtsInstallation installation = this.getEtsInstallation(deviceInstanceId);
            BEtsArea[] areas = (BEtsArea[])installation.getChildren(BEtsArea.class);
            for (int i = 0; i < areas.length; ++i) {
                BEtsArea area = areas[i];
                BEtsLine[] lines = (BEtsLine[])area.getChildren(BEtsLine.class);
                for (int j = 0; j < lines.length; ++j) {
                    BEtsLine line = lines[j];
                    BEtsDeviceInstance[] devices = (BEtsDeviceInstance[])line.getChildren(BEtsDeviceInstance.class);
                    for (int k = 0; k < devices.length; ++k) {
                        BEtsDeviceInstance device = devices[k];
                        if (!device.getDeviceInstanceId().equals(deviceInstanceId)) continue;
                        return device;
                    }
                }
            }
        }
        return null;
    }

    public final BEtsMaskVersion getMaskVersion(String maskVersionId) {
        BEtsMasterData etsMasterData = (BEtsMasterData)this.get(SlotPath.escape((String)"Ets Master Data"));
        if (etsMasterData != null) {
            BEtsMaskVersion[] maskVersions = (BEtsMaskVersion[])etsMasterData.getChildren(BEtsMaskVersion.class);
            for (int i = 0; i < maskVersions.length; ++i) {
                if (!maskVersions[i].getMaskVersionId().equals(maskVersionId)) continue;
                return maskVersions[i];
            }
        }
        return null;
    }

    private final BEtsInstallation getEtsInstallation(String knxId) {
        BEtsImportableComponent kic = (BEtsImportableComponent)this.get(SlotPath.escape((String)knxId.substring(0, 6)));
        kic = (BEtsImportableComponent)kic.get(SlotPath.escape((String)("Installation Data - " + knxId.substring(7, knxId.indexOf(95)))));
        return (BEtsInstallation)kic;
    }
}

