/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ets;

import com.tridiumX.knxnetIp.addresses.BKnxAddressStyle;

public final class EtsUtil {
    private EtsUtil() {
    }

    public static boolean validEtsProjectFileExtension(String extension) {
        return extension.equalsIgnoreCase("knxproj");
    }

    public static boolean validEtsProjectFilename(String etsProjectFileName) {
        return etsProjectFileName.toLowerCase().endsWith(".knxproj".toLowerCase());
    }

    public static String invalidEtsProjectFileName(String etsProjectFileName) {
        String fileName = etsProjectFileName.substring(etsProjectFileName.lastIndexOf(47));
        return String.format("The ETS project filename specified ('%s') does not end with %s", fileName, ".knxproj");
    }

    public static boolean isValidGroupAddress(String groupAddress, BKnxAddressStyle addressStyle) {
        if (groupAddress == null || groupAddress.isEmpty() || addressStyle == null || groupAddress.charAt(0) == addressStyle.getSeparator()) {
            return false;
        }
        return EtsUtil.validateGroupAddress(groupAddress, addressStyle);
    }

    public static boolean validateGroupAddress(String groupAddress, BKnxAddressStyle addressStyle) {
        int expectedFields = addressStyle.getFieldLengths().length;
        String[] parts = groupAddress.split(String.valueOf(addressStyle.getSeparator()));
        if (parts.length != expectedFields) {
            return false;
        }
        boolean isValid = true;
        boolean allZero = true;
        byte[] expectedFieldLengths = addressStyle.getFieldLengths();
        for (int i = 0; isValid && i < parts.length; ++i) {
            String addressPart = parts[i];
            try {
                int value = Integer.parseUnsignedInt(addressPart);
                byte fieldLength = expectedFieldLengths[i];
                isValid = value >> fieldLength == 0;
                allZero &= value == 0;
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return isValid && !allZero;
    }
}

