/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui;

import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxDataDefs;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxStationDataDefs;
import com.tridiumX.knxnetIp.ui.BKnxDataDefsImportDialog;
import com.tridiumX.knxnetIp.ui.ICheckDataDefsDialogClient;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.wb.BKnxWbDataDefs;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BCheckDataDefsDialog
extends BProgressDialog {
    public static final Type TYPE = Sys.loadType(BCheckDataDefsDialog.class);
    private static final Logger logCheckDataDefsDialog = Logger.getLogger(TYPE.getModule().getModuleName() + ".checkDataDefsDialog");
    private static final HashMap<String, BAbsTime> cachedCheckTimes = new HashMap();
    private static final Lexicon lex = Lexicon.make((String)TYPE.getModule().getModuleName());
    private static final String CHECK_DATA_DEFS_DIALOG_BASE_LEX_KEY = "checkDataDefsDialog.";
    private static final String CHECK_DATA_DEFS_DIALOG_TITLE_LEX_KEY = "checkDataDefsDialog.title";
    private static final String CHECK_DATA_DEFS_DIALOG_TITLE_DEFAULT = "Checking 'KNX Data Definitions'";
    private static final String CHECK_DATA_DEFS_DIALOG_MESSAGE_LEX_KEY = "checkDataDefsDialog.message";
    private static final String CHECK_DATA_DEFS_DIALOG_MESSAGE_DEFAULT = "Checking 'KNX Data Definitions' ...";
    private static final String BAD_WORKBENCH_DATA_DEFS_DIALOG_BASE_LEX_KEY = "workbenchDataDefsDialog.";
    private static final String BAD_WORKBENCH_DATA_DEFS_DIALOG_TITLE_LEX_KEY = "workbenchDataDefsDialog.title";
    private static final String BAD_WORKBENCH_DATA_DEFS_DIALOG_TITLE_DEFAULT = "Import Temporarily Disabled";
    private static final String BAD_WORKBENCH_DATA_DEFS_DIALOG_MESSAGE_LEX_KEY = "workbenchDataDefsDialog.message";
    private static final String BAD_WORKBENCH_DATA_DEFS_DIALOG_MESSAGE_DEFAULT = "The Workbench Service's 'KNX Data Defs' are missing/corrupted.  Importing ETS project files is temporarily unavailable.\n\rDo you want to load the 'Data Defs' now?";
    private static final String BAD_WORKBENCH_DATA_DEFS_NO_DEFAULTS_DIALOG_MESSAGE_LEX_KEY = "workbenchDataDefsDialog.noDefsMessage";
    private static final String BAD_WORKBENCH_DATA_DEFS_NO_DEFAULTS_DIALOG_MESSAGE_DEFAULT = "The Workbench Service's 'KNX Data Defs' are missing/corrupted and no valid 'KNX Data Defs' are available to import.\n\rImporting ETS project files is temporarily unavailable.";
    private static final String NEWER_DATA_DEFS_DIALOG_BASE_LEX_KEY = "newerDataDefsFileDialog.";
    private static final String NEWER_DATA_DEFS_DIALOG_TITLE_LEX_KEY = "newerDataDefsFileDialog.title";
    private static final String NEWER_DATA_DEFS_DIALOG_TITLE_DEFAULT = "Newer 'KNX Data Defs' File Available";
    private static final String NEWER_DATA_DEFS_DIALOG_MESSAGE_LEX_KEY = "newerDataDefsFileDialog.message";
    private static final String NEWER_DATA_DEFS_DIALOG_MESSAGE_DEFAULT = "A newer ''KNX Data Defs'' file version (''{0}'') is available.  Currently using version ''{1}''.\n\rDo you want to load this 'Data Defs' file now?";
    private static final String SEVERE_NON_EXISTANT_NEWER_DATA_DEFS_LEX_KEY = "severeNonExistantNewerDataDefs.message";
    private static final String SEVERE_NON_EXISTANT_NEWER_DATA_DEFS__DEFAULT = "A newer ''KNX Data Defs'' file version (''{0}'') is indicated but doesn't actually exist.  Currently using version ''{1}''.";
    private static final String BAD_STATION_DATA_DEFS_DIALOG_BASE_LEX_KEY = "stationDataDefsDialog.";
    private static final String BAD_STATION_DATA_DEFS_DIALOG_TITLE_LEX_KEY = "stationDataDefsDialog.title";
    private static final String BAD_STATION_DATA_DEFS_DIALOG_TITLE_DEFAULT = "Import Temporarily Disabled";
    private static final String BAD_STATION_DATA_DEFS_DIALOG_MESSAGE_LEX_KEY = "stationDataDefsDialog.message";
    private static final String BAD_STATION_DATA_DEFS_DIALOG_MESSAGE_DEFAULT = "The Station's 'KNX Data Defs' are missing/corrupted.  Importing ETS project files is temporarily unavailable.\n\rDo you want to load the 'Data Defs' now?";
    private static final String DIFFERENT_VERSION_DATA_DEFS_DIALOG_BASE_LEX_KEY = "differentVersionDataDefsDialog.";
    private static final String DIFFERENT_VERSION_DATA_DEFS_DIALOG_TITLE_LEX_KEY = "differentVersionDataDefsDialog.title";
    private static final String DIFFERENT_VERSION_DATA_DEFS_DIALOG_TITLE_DEFAULT = "Different 'KNX Data Definitions' Versions";
    private static final String DIFFERENT_VERSION_DATA_DEFS_DIALOG_MESSAGE_LEX_KEY = "differentVersionDataDefsDialog.message";
    private static final String DIFFERENT_VERSION_DATA_DEFS_DIALOG_MESSAGE_DEFAULT = "The versions of the ''KNX Data Defs'' in the workbench tool (''{0}'') and this station (''{1}'') are different.\n\nDo you want to copy the workbench tool version to this station?";

    public Type getType() {
        return TYPE;
    }

    public static final void doCheckDataDefs(ICheckDataDefsDialogClient manager, BObject obj, Context cx) {
        BAbsTime lastCheckTime;
        if (manager.getNetwork() != null && (lastCheckTime = BCheckDataDefsDialog.getCachedCheckTime(manager.getNetwork().getNavOrd().toString())) != null) {
            manager.doLoadValueAsync(obj, cx);
            return;
        }
        BCheckDataDefsDialog.checkDataDefs(manager, obj, cx);
    }

    public static final void doCheckDataDefs(ICheckDataDefsDialogClient manager, Context cx) {
        BCheckDataDefsDialog.checkDataDefs(manager, null, cx);
    }

    private static final void checkDataDefs(ICheckDataDefsDialogClient manager, BObject obj, Context cx) {
        BIcon icon = BIcon.make((String)"module://icons/x32/clock.png");
        BCheckDataDefsDialog.open((BWidget)((BWidget)manager), (String)lex.get(CHECK_DATA_DEFS_DIALOG_TITLE_LEX_KEY, CHECK_DATA_DEFS_DIALOG_TITLE_DEFAULT), (BProgressDialog.Worker)new CheckDataDefsWorker(manager, obj, cx), (BImage)BImage.make((BIcon)icon));
        if (manager.getNetwork() != null && manager.getNetwork().getKnxDataDefs().isDataIntegrityGood(false)) {
            BCheckDataDefsDialog.putCachedCheckTime(manager.getNetwork().getNavOrd().toString(), BAbsTime.make());
        }
    }

    private static BAbsTime getCachedCheckTime(String key) {
        return cachedCheckTimes.get(key);
    }

    private static void putCachedCheckTime(String key, BAbsTime checkTime) {
        cachedCheckTimes.put(key, checkTime);
    }

    private static void checkKnxDataDefs(CheckDataDefsWorker worker, BKnxNetwork network) {
        try {
            BProgressDialog parent = worker.getDialog();
            BKnxStationDataDefs latestDefs = BKnxDataDefsImportDialog.findLatestDefs((BWidget)worker.getDialog());
            int latestVersion = latestDefs != null ? Integer.parseInt(latestDefs.getVersion()) : -1;
            boolean bFinished = false;
            while (!bFinished) {
                BKnxWbService wbService = BKnxWbService.getService();
                BKnxWbDataDefs wbDataDefs = wbService.getKnxDataDefs();
                if (!wbDataDefs.isDataIntegrityGood(true)) {
                    if (latestDefs != null) {
                        if (BKnxWbService.getImportSettings().getAutomaticallyUseNewerDataDefs()) {
                            wbDataDefs.setKnxDefs((BKnxDataDefs)latestDefs.getKnxDefs().newCopy(true));
                            wbDataDefs.doCheckDataIntegrity();
                            System.gc();
                            continue;
                        }
                        int dialogResult = BDialog.open((BWidget)parent, (String)lex.get(BAD_WORKBENCH_DATA_DEFS_DIALOG_TITLE_LEX_KEY, "Import Temporarily Disabled"), (Object)lex.get(BAD_WORKBENCH_DATA_DEFS_DIALOG_MESSAGE_LEX_KEY, BAD_WORKBENCH_DATA_DEFS_DIALOG_MESSAGE_DEFAULT), (int)12, (BImage)BDialog.QUESTION_ICON);
                        if (dialogResult == 4) {
                            wbDataDefs.setKnxDefs((BKnxDataDefs)latestDefs.getKnxDefs().newCopy(true));
                            wbDataDefs.doCheckDataIntegrity();
                            System.gc();
                            continue;
                        }
                        bFinished = true;
                        continue;
                    }
                    BDialog.error((BWidget)parent, (String)lex.get(BAD_WORKBENCH_DATA_DEFS_DIALOG_TITLE_LEX_KEY, "Import Temporarily Disabled"), (Object)lex.get(BAD_WORKBENCH_DATA_DEFS_NO_DEFAULTS_DIALOG_MESSAGE_LEX_KEY, BAD_WORKBENCH_DATA_DEFS_NO_DEFAULTS_DIALOG_MESSAGE_DEFAULT));
                    bFinished = true;
                    continue;
                }
                int currentVersion = Integer.parseInt(wbDataDefs.getVersion());
                if (latestVersion > currentVersion) {
                    if (latestDefs != null) {
                        if (BKnxWbService.getImportSettings().getAutomaticallyUseNewerDataDefs()) {
                            wbDataDefs.setKnxDefs((BKnxDataDefs)latestDefs.getKnxDefs().newCopy(true));
                            wbDataDefs.doCheckDataIntegrity();
                            System.gc();
                            continue;
                        }
                        int dialogResult = BDialog.open((BWidget)parent, (String)lex.get(NEWER_DATA_DEFS_DIALOG_TITLE_LEX_KEY, NEWER_DATA_DEFS_DIALOG_TITLE_DEFAULT), (Object)MessageFormat.format(lex.get(NEWER_DATA_DEFS_DIALOG_MESSAGE_LEX_KEY, NEWER_DATA_DEFS_DIALOG_MESSAGE_DEFAULT), latestDefs.getVersion(), wbDataDefs.getVersion()), (int)12, (BImage)BDialog.QUESTION_ICON);
                        if (dialogResult == 4) {
                            wbDataDefs.setKnxDefs((BKnxDataDefs)latestDefs.getKnxDefs().newCopy(true));
                            wbDataDefs.doCheckDataIntegrity();
                            System.gc();
                            continue;
                        }
                    } else {
                        BCheckDataDefsDialog.getLogger().severe(MessageFormat.format(lex.get(SEVERE_NON_EXISTANT_NEWER_DATA_DEFS_LEX_KEY, SEVERE_NON_EXISTANT_NEWER_DATA_DEFS__DEFAULT), new Integer(latestVersion), wbDataDefs.getVersion()));
                    }
                }
                worker.updateProgress("Checking 'Station Data Defs' ...");
                if (network != null) {
                    int dialogResult;
                    BKnxStationDataDefs stationDataDefs = network.getKnxDataDefs();
                    stationDataDefs.loadSlots();
                    if (!stationDataDefs.isDataIntegrityGood(true)) {
                        if (BKnxWbService.getImportSettings().getAutomaticallyUseNewerDataDefs()) {
                            stationDataDefs.setKnxDefs((BKnxDataDefs)wbDataDefs.getKnxDefs().newCopy(true));
                            continue;
                        }
                        dialogResult = BDialog.open((BWidget)parent, (String)lex.get(BAD_STATION_DATA_DEFS_DIALOG_TITLE_LEX_KEY, "Import Temporarily Disabled"), (Object)lex.get(BAD_STATION_DATA_DEFS_DIALOG_MESSAGE_LEX_KEY, BAD_STATION_DATA_DEFS_DIALOG_MESSAGE_DEFAULT), (int)12, (BImage)BDialog.QUESTION_ICON);
                        if (dialogResult == 4) {
                            stationDataDefs.setKnxDefs((BKnxDataDefs)wbDataDefs.getKnxDefs().newCopy(true));
                            continue;
                        }
                        bFinished = true;
                        continue;
                    }
                    stationDataDefs.getKnxDefs().loadSlots();
                    if (!wbDataDefs.getKnxDefs().getVersion().equals(stationDataDefs.getKnxDefs().getVersion())) {
                        if (BKnxWbService.getImportSettings().getAutomaticallyUseNewerDataDefs()) {
                            stationDataDefs.setKnxDefs((BKnxDataDefs)wbDataDefs.getKnxDefs().newCopy(true));
                            continue;
                        }
                        dialogResult = BDialog.open((BWidget)parent, (String)lex.get(DIFFERENT_VERSION_DATA_DEFS_DIALOG_TITLE_LEX_KEY, DIFFERENT_VERSION_DATA_DEFS_DIALOG_TITLE_DEFAULT), (Object)MessageFormat.format(lex.get(DIFFERENT_VERSION_DATA_DEFS_DIALOG_MESSAGE_LEX_KEY, DIFFERENT_VERSION_DATA_DEFS_DIALOG_MESSAGE_DEFAULT), wbDataDefs.getKnxDefs().getVersion(), stationDataDefs.getKnxDefs().getVersion()), (int)12, (BImage)BDialog.QUESTION_ICON);
                        if (dialogResult == 4) {
                            stationDataDefs.setKnxDefs((BKnxDataDefs)wbDataDefs.getKnxDefs().newCopy(true));
                            continue;
                        }
                        bFinished = true;
                        continue;
                    }
                    bFinished = true;
                    continue;
                }
                bFinished = true;
            }
        }
        catch (Throwable t) {
            CatchAll.throwable((Throwable)t);
        }
    }

    private static Logger getLogger() {
        return logCheckDataDefsDialog;
    }

    private static class CheckDataDefsWorker
    extends BProgressDialog.Worker {
        private final ICheckDataDefsDialogClient manager;
        private final BObject obj;
        private final Context cx;

        CheckDataDefsWorker(ICheckDataDefsDialogClient manager, BObject obj, Context cx) {
            this.manager = manager;
            this.obj = obj;
            this.cx = cx;
        }

        public void doRun() throws Exception {
            BLabel message = this.getDialog().getMessageLabel();
            message.setText(lex.get(BCheckDataDefsDialog.CHECK_DATA_DEFS_DIALOG_MESSAGE_LEX_KEY, BCheckDataDefsDialog.CHECK_DATA_DEFS_DIALOG_MESSAGE_DEFAULT));
            this.getDialog().getProgressBar().setIndeterminate(true);
            if (this.obj != null) {
                this.manager.doLoadValueAsync(this.obj, this.cx);
            }
            BCheckDataDefsDialog.checkKnxDataDefs(this, this.manager.getNetwork());
        }

        public void doCancel() throws Exception {
        }
    }
}

