/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui;

import com.tridiumX.knxnetIp.comms.BDiscoveryKnxInstallations;
import com.tridiumX.knxnetIp.comms.BKnxInstallationRef;
import com.tridiumX.knxnetIp.comms.BProxyDeviceRef;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.job.BDiscoverDevicesJob;
import com.tridiumX.knxnetIp.job.BDiscoveredDevice;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxStationDataDefs;
import com.tridiumX.knxnetIp.ui.BCheckDataDefsDialog;
import com.tridiumX.knxnetIp.ui.ICheckDataDefsDialogClient;
import com.tridiumX.knxnetIp.ui.commands.CheckDataDefsCommand;
import com.tridiumX.knxnetIp.ui.editors.BKnxInstallationRefFE;
import com.tridiumX.knxnetIp.ui.editors.BProxyDeviceRefFE;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.util.Dump;
import com.tridiumX.knxnetIp.wb.BKnxWbDataDefs;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import com.tridiumX.knxnetIp.wb.DiscoverDevicesController;
import com.tridiumX.knxnetIp.wb.IKnxDeviceManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.driver.ui.device.DeviceState;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"knxnetIp:KnxNetwork", "knxnetIp:KnxDeviceFolder"}, requiredPermissions="W")})
public final class BKnxDeviceManager
extends BDeviceManager
implements IKnxDeviceManager,
ICheckDataDefsDialogClient {
    public static final Type TYPE = Sys.loadType(BKnxDeviceManager.class);
    private BKnxNetwork network;
    private KnxInstallationMgrColumnProp colKnxInstallation;
    private MgrColumn colIpAddress;
    private MgrColumn colPortNumber;
    private MgrColumn colIndividualDeviceAddress;
    private MgrColumn colConnectionMethod;
    private ProxyDeviceMgrColumn colProxyDevice;
    private MgrColumn colFriendlyName;
    private MgrColumn colMacAddress;
    public BVector discoveredDevices = new BVector();
    static final UiLexicon lex = new UiLexicon(BKnxDeviceManager.class);
    private static final Logger log = Logger.getLogger("knxnetIp.deviceManager");
    private static final String DEVICEMANAGER_MGRTYPEINFO_DESCRIPTION_LEX_KEY = "deviceManager.mgrTypeInfo.description";
    private static final MgrTypeInfo[] NEW_TYPES = new MgrTypeInfo[]{new MyTypeInfoImpl(BKnxDevice.TYPE.getTypeInfo(), lex.getText("deviceManager.mgrTypeInfo.description"))};

    public Type getType() {
        return TYPE;
    }

    protected MgrController makeController() {
        return new KnxDeviceMgrController(this);
    }

    protected MgrModel makeModel() {
        return new KnxDeviceMgrModel(this);
    }

    protected MgrState makeState() {
        return new KnxDeviceMgrState();
    }

    protected MgrLearn makeLearn() {
        return new KnxDeviceMgrLearn(this);
    }

    public void handleComponentEvent(BComponentEvent event) {
        String slotName;
        if (log.isLoggable(Level.FINE)) {
            log.fine("BKnxDeviceManager.handleComponentEvent(BComponentEvent event = " + Dump.dump((BComponentEvent)event, (String)"\t"));
        }
        super.handleComponentEvent(event);
        BJob discJob = this.getLearn().getJob();
        if (discJob != null && event.getSourceComponent() == discJob && event.getId() == 5 && (slotName = event.getSlotName()).equals(BDiscoverDevicesJob.deviceLearned.getName())) {
            BDiscoveredDevice value = (BDiscoveredDevice)event.getValue();
            if (log.isLoggable(Level.FINE)) {
                log.fine("intercepted 'DeviceLearned' topic - IpAddress=" + value.getIpAddress() + " IndividualDeviceAddress=" + value.getIndividualDeviceAddress() + " MacAddress=" + value.getMacAddress() + " FriendlyName=" + value.getFriendlyName());
            }
            String deviceFriendlyName = this.getDeviceFriendlyName(value);
            this.discoveredDevices.add(SlotPath.escape((String)deviceFriendlyName), (BValue)value);
            this.updateDiscoveryRows();
        }
    }

    private String getDeviceFriendlyName(BDiscoveredDevice value) {
        String devName = value.getFriendlyName();
        if (devName.isEmpty()) {
            devName = this.getLexicon().get("friendlyName");
        }
        if (this.discoveredDevices.get(SlotPath.escape((String)devName)) != null && this.discoveredDevices.get(SlotPath.escape((String)(devName = devName + ' ' + value.getIpAddress()))) != null) {
            devName = devName + (32 + value.getControlHPAI().getPort());
        }
        return devName;
    }

    public void doLoadValue(BObject obj, Context cx) {
        try {
            this.getNetwork();
            long start = System.currentTimeMillis();
            BCheckDataDefsDialog.doCheckDataDefs(this, obj, cx);
            if (log.isLoggable(Level.FINE)) {
                System.out.println("BKnxDeviceManager.doLoadValue(...) Total: " + (System.currentTimeMillis() - start));
            }
            if (this.discoveredDevices != null && ((BDiscoveredDevice[])this.discoveredDevices.getChildren(BDiscoveredDevice.class)).length != 0) {
                ((DeviceController)this.getController()).learnMode.setSelected(true);
            } else {
                ((DeviceController)this.getController()).learnMode.setSelected(false);
            }
            ((KnxDeviceMgrController)this.getController()).updateCommands();
        }
        catch (Throwable t) {
            CatchAll.throwable((Throwable)t);
        }
    }

    @Override
    public BKnxNetwork getNetwork() {
        if (this.network == null) {
            this.network = (BKnxNetwork)((BIDeviceFolder)this.getCurrentValue()).getNetwork();
        }
        return this.network;
    }

    @Override
    public void doLoadValueAsync(BObject obj, Context cx) {
        long start = System.currentTimeMillis();
        super.doLoadValue(obj, cx);
        if (log.isLoggable(Level.FINE)) {
            System.out.println("BKnxDeviceManager.doLoadValueAsync: " + (System.currentTimeMillis() - start));
        }
    }

    private void updateDiscoveryRows() {
        Object[] devices = (BDiscoveredDevice[])this.discoveredDevices.getChildren(BDiscoveredDevice.class);
        this.getLearn().updateRoots(devices);
    }

    @Override
    public final boolean processDiscoveryRequest(BDiscoveryKnxInstallations discoveryKnxInstallations, Context cx) throws Exception {
        this.discoveredDevices = new BVector();
        this.updateDiscoveryRows();
        try {
            BOrd job = this.getNetwork().getLocalInterfaces().submitDeviceDiscoveryJob(discoveryKnxInstallations);
            if (job != null) {
                this.getLearn().setJob(job);
                return true;
            }
        }
        catch (ActionInvokeException ex) {
            if (ex.getCause() instanceof NotRunningException) {
                BDialog.error((BWidget)this, (Object)ex.getCause().getMessage());
            }
            throw ex;
        }
        return false;
    }

    @Override
    public final BVector getDiscoveredDevices() {
        return this.discoveredDevices;
    }

    public static MgrTypeInfo[] getNewTypes() {
        return NEW_TYPES;
    }

    @Override
    public void clearDiscoveredRows() {
        this.discoveredDevices = new BVector();
        MgrLearn knxLearn = this.getLearn();
        Object[] a = new Object[]{};
        knxLearn.updateRoots(a);
    }

    static class MyTypeInfoImpl
    extends MgrTypeInfo {
        TypeInfo ti;
        String displayName;

        MyTypeInfoImpl(TypeInfo proto) {
            this.ti = proto;
        }

        MyTypeInfoImpl(TypeInfo proto, String disp) {
            this.ti = proto;
            this.displayName = disp;
        }

        MyTypeInfoImpl() {
            this.ti = BKnxDevice.TYPE.getTypeInfo();
            this.displayName = lex.getText(BKnxDeviceManager.DEVICEMANAGER_MGRTYPEINFO_DESCRIPTION_LEX_KEY);
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            if (this.ti.is(BKnxDevice.TYPE)) {
                return lex.getText(BKnxDeviceManager.DEVICEMANAGER_MGRTYPEINFO_DESCRIPTION_LEX_KEY);
            }
            return this.ti.getDisplayName(null);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.ti.getIcon(null));
        }

        public BComponent newInstance() {
            return (BComponent)this.ti.getInstance();
        }

        public boolean isMatchable(BComponent db) {
            return db.getType().is(this.ti);
        }
    }

    class KnxDeviceMgrState
    extends DeviceState {
        private BVector discoveredDevices = null;

        KnxDeviceMgrState() {
        }

        protected void saveForOrd(BAbstractManager manager) {
            BKnxDeviceManager devManager = (BKnxDeviceManager)manager;
            this.discoveredDevices = devManager.discoveredDevices;
        }

        protected void restoreForOrd(BAbstractManager manager) {
            BKnxDeviceManager devManager = (BKnxDeviceManager)manager;
            devManager.discoveredDevices = this.discoveredDevices;
            devManager.updateDiscoveryRows();
        }
    }

    public class ProxyDeviceMgrColumnProp
    extends MgrColumn.Prop {
        public ProxyDeviceMgrColumnProp(String name, Property prop, int flags) {
            super(name, prop, flags);
        }

        public ProxyDeviceMgrColumnProp(Property prop, int flags) {
            super(prop, flags);
        }

        public ProxyDeviceMgrColumnProp(Property prop) {
            super(prop);
        }

        public final String toDisplayString(Object row, Object value, Context cx) {
            if (row instanceof BDiscoveredDevice) {
                BDynamicEnum rowConnectionMethod = ((BDiscoveredDevice)row).getConnectionMethod();
                if (rowConnectionMethod.getOrdinal() == 1) {
                    return ((BProxyDeviceRef)value).getProxyDeviceIdEnum().getDisplayTag(cx);
                }
                return "NA";
            }
            return "";
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BProxyDeviceRefFE editor = null;
            editor = currentEditor != null && currentEditor instanceof BProxyDeviceRefFE ? (BProxyDeviceRefFE)currentEditor : new BProxyDeviceRefFE();
            editor.setNetwork(BKnxDeviceManager.this.getNetwork());
            editor.loadValue((BObject)rows[0].getCell((MgrColumn)BKnxDeviceManager.this.colProxyDevice));
            return editor;
        }
    }

    public class ProxyDeviceMgrColumn
    extends MgrColumn {
        public ProxyDeviceMgrColumn(String displayName, int flags) {
            super(displayName, flags);
        }

        public ProxyDeviceMgrColumn(String displayName) {
            super(displayName);
        }

        public Object get(Object row) {
            if (row instanceof BKnxDevice) {
                return ((BKnxDevice)row).getProxyDevice();
            }
            return null;
        }

        public final String toDisplayString(Object row, Object value, Context cx) {
            if (row instanceof BKnxDevice) {
                if (value instanceof BProxyDeviceRef) {
                    return ((BProxyDeviceRef)value).getProxyDeviceIdEnum().getDisplayTag(cx);
                }
                return "NA";
            }
            return "";
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BDynamicEnum connectionMethod = null;
            boolean mixedConnectionMethods = false;
            for (int i = 0; i < rows.length; ++i) {
                BValue rowConnectionMethod = rows[i].getCell(BKnxDeviceManager.this.colConnectionMethod);
                if (!(rowConnectionMethod instanceof BDynamicEnum)) continue;
                if (connectionMethod == null) {
                    connectionMethod = (BDynamicEnum)rowConnectionMethod;
                    continue;
                }
                if (connectionMethod.getOrdinal() == ((BDynamicEnum)rowConnectionMethod).getOrdinal()) continue;
                mixedConnectionMethods = true;
                break;
            }
            if (!mixedConnectionMethods && connectionMethod != null && connectionMethod.getOrdinal() == 1) {
                BProxyDeviceRefFE editor = null;
                editor = currentEditor != null && currentEditor instanceof BProxyDeviceRefFE ? (BProxyDeviceRefFE)currentEditor : new BProxyDeviceRefFE();
                editor.setNetwork(BKnxDeviceManager.this.getNetwork());
                editor.loadValue((BObject)rows[0].getCell((MgrColumn)BKnxDeviceManager.this.colProxyDevice));
                return editor;
            }
            return null;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            ProxyDeviceMgrColumn.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, null);
        }

        public BValue load(MgrEditRow row) throws Exception {
            BKnxDevice knxDevice;
            BComponent complex = row.getTarget();
            if (complex instanceof BKnxDevice && (knxDevice = (BKnxDevice)complex).getConnectionMethod().getOrdinal() == 1) {
                BProxyDeviceRef proxyDevice = knxDevice.getProxyDevice();
                return proxyDevice.newCopy();
            }
            return new BProxyDeviceRef();
        }

        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
            BComponent target = row.getTarget();
            if (target instanceof BKnxDevice) {
                BKnxDevice knxDevice = (BKnxDevice)target;
                BValue connectionMethod = row.getCell(BKnxDeviceManager.this.colConnectionMethod);
                if (connectionMethod instanceof BDynamicEnum) {
                    if (((BDynamicEnum)connectionMethod).getOrdinal() == 1) {
                        BProxyDeviceRef old = knxDevice.getProxyDevice();
                        if (old == null || !old.equivalent((Object)value)) {
                            knxDevice.setProxyDevice((BProxyDeviceRef)value.newCopy(), cx);
                        }
                    } else {
                        knxDevice.setProxyDevice(null, cx);
                    }
                }
            }
        }
    }

    public class ConnectionMethodMgrColumnProp
    extends MgrColumn.Prop {
        public ConnectionMethodMgrColumnProp(String name, Property prop, int flags) {
            super(name, prop, flags);
        }

        public ConnectionMethodMgrColumnProp(Property prop, int flags) {
            super(prop, flags);
        }

        public ConnectionMethodMgrColumnProp(Property prop) {
            super(prop);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            super.fromEditor(rows, colIndex, editor);
            BMgrEditDialog dialog = this.getMgrEditDialog(editor);
            dialog.syncInputPane();
        }

        private BMgrEditDialog getMgrEditDialog(BWbEditor wbEditor) {
            for (BComplex p = wbEditor.getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof BMgrEditDialog)) continue;
                return (BMgrEditDialog)p;
            }
            return null;
        }
    }

    public class KnxInstallationMgrColumnProp
    extends MgrColumn.Prop {
        public KnxInstallationMgrColumnProp(String name, Property prop, int flags) {
            super(name, prop, flags);
        }

        public KnxInstallationMgrColumnProp(Property prop, int flags) {
            super(prop, flags);
        }

        public KnxInstallationMgrColumnProp(Property prop) {
            super(prop);
        }

        public final String toDisplayString(Object row, Object value, Context cx) {
            if (value instanceof BKnxInstallationRef) {
                return ((BKnxInstallationRef)value).getKnxInstallationIdEnum().getDisplayTag(cx);
            }
            return super.toDisplayString(row, value, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BKnxInstallationRefFE editor = null;
            editor = currentEditor != null && currentEditor instanceof BKnxInstallationRefFE ? (BKnxInstallationRefFE)currentEditor : new BKnxInstallationRefFE();
            editor.setNetwork(BKnxDeviceManager.this.getNetwork());
            editor.loadValue((BObject)rows[0].getCell((MgrColumn)BKnxDeviceManager.this.colKnxInstallation));
            return editor;
        }
    }

    final class KnxDeviceMgrModel
    extends DeviceModel {
        KnxDeviceMgrModel(BKnxDeviceManager mgr) {
            super((BDeviceManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Path(2), new MgrColumn.Name(), new MgrColumn.Type(2), new DeviceExtsColumn((BDevice)new BKnxDevice()), new MgrColumn.Prop(BDevice.enabled, 1), BKnxDeviceManager.this.colKnxInstallation = new KnxInstallationMgrColumnProp(BKnxDevice.knxInstallation, 1), BKnxDeviceManager.this.colIpAddress = (MgrColumn)new MgrColumn.Prop(BKnxDevice.ipAddress, 1), BKnxDeviceManager.this.colPortNumber = (MgrColumn)new MgrColumn.Prop(BKnxDevice.controlPortNumber, 1), BKnxDeviceManager.this.colIndividualDeviceAddress = (MgrColumn)new MgrColumn.Prop(BKnxDevice.individualDeviceAddress, 1), BKnxDeviceManager.this.colConnectionMethod = (MgrColumn)new ConnectionMethodMgrColumnProp(BKnxDevice.connectionMethod, 1), BKnxDeviceManager.this.colProxyDevice = new ProxyDeviceMgrColumn("Proxy Device", 1), BKnxDeviceManager.this.colMacAddress = (MgrColumn)new MgrColumn.Prop(BKnxDevice.macAddress, 5), BKnxDeviceManager.this.colFriendlyName = (MgrColumn)new MgrColumn.Prop(BKnxDevice.friendlyName, 5), new MgrColumn.Prop(BDevice.status, 0)};
        }

        public boolean accept(BComponent component) {
            if (component instanceof BKnxDevice) {
                BKnxDeviceManager.this.registerForComponentEvents(component, 1);
            }
            return true;
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            String[] names = new String[rows.length];
            BKnxDevice[] values = new BKnxDevice[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                names[i] = SlotPath.escape((String)rows[i].getName());
                values[i] = (BKnxDevice)rows[i].getTarget();
            }
            Mark mark = new Mark((BObject[])values, names);
            BComponent container = rows[0].getEdit().getAddContainer();
            mark.moveTo((BObject)container, null);
            return null;
        }
    }

    class KnxDeviceMgrLearn
    extends MgrLearn {
        public KnxDeviceMgrLearn(BKnxDeviceManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new KnxInstallationMgrColumnProp(BDiscoveredDevice.knxInstallation, 0), new MgrColumn.Prop(BDiscoveredDevice.ipAddress, 0), new MgrColumn.Prop(BDiscoveredDevice.individualDeviceAddress, 0), new MgrColumn.Prop(BDiscoveredDevice.macAddress, 0), new MgrColumn.Prop(BDiscoveredDevice.friendlyName, 0), new ConnectionMethodMgrColumnProp(BDiscoveredDevice.connectionMethod, 0), new ProxyDeviceMgrColumnProp(BDiscoveredDevice.proxyDevice, 0), new MgrColumn.Prop(BDiscoveredDevice.comment, 0)};
        }

        public boolean isExisting(Object discovery, BComponent component) {
            if (component instanceof BKnxDevice && discovery instanceof BDiscoveredDevice) {
                BDiscoveredDevice disc = (BDiscoveredDevice)discovery;
                BKnxDevice dev = (BKnxDevice)component;
                return disc.getMacAddress().equals(dev.getMacAddress());
            }
            return false;
        }

        public final void jobComplete(BJob job) {
            BKnxDeviceManager.this.updateDiscoveryRows();
        }

        public final MgrTypeInfo[] toTypes(Object dis) {
            return new MgrTypeInfo[]{new MyTypeInfoImpl()};
        }

        public final void toRow(Object dis, MgrEditRow row) throws Exception {
            BDiscoveredDevice disc = (BDiscoveredDevice)dis;
            if (row.getName() == null || row.getName().equals("")) {
                row.setName(SlotPath.unescape((String)disc.getName()));
            }
            if (disc.getKnxInstallation().getKnxInstallationIdEnum().getOrdinal() != 0) {
                row.setCell((MgrColumn)BKnxDeviceManager.this.colKnxInstallation, disc.getKnxInstallation().newCopy(true));
            }
            if (!disc.getControlHPAI().getIpAddress().equals("")) {
                row.setCell(BKnxDeviceManager.this.colIpAddress, (BValue)BString.make((String)disc.getControlHPAI().getIpAddress()));
            }
            if (disc.getControlHPAI().getPort() != -1) {
                row.setCell(BKnxDeviceManager.this.colPortNumber, (BValue)BInteger.make((int)disc.getControlHPAI().getPort()));
            }
            if (disc.getIndividualDeviceAddress().getAddress() != 0) {
                row.setCell(BKnxDeviceManager.this.colIndividualDeviceAddress, disc.getIndividualDeviceAddress().newCopy(true));
            }
            row.setCell(BKnxDeviceManager.this.colConnectionMethod, (BValue)disc.getConnectionMethod());
            if (disc.getProxyDevice().getProxyDeviceIdEnum().getOrdinal() != 0) {
                row.setCell((MgrColumn)BKnxDeviceManager.this.colProxyDevice, disc.getProxyDevice().newCopy(true));
            }
            if (!disc.getMacAddress().equals("")) {
                row.setCell(BKnxDeviceManager.this.colMacAddress, (BValue)BString.make((String)disc.getMacAddress()));
            }
            if (!disc.getFriendlyName().equals("")) {
                row.setCell(BKnxDeviceManager.this.colFriendlyName, (BValue)BString.make((String)disc.getFriendlyName()));
            }
        }
    }

    class KnxDeviceMgrController
    extends DeviceController {
        public final MgrController.MgrCommand checkDataDefsCommand;

        public KnxDeviceMgrController(BKnxDeviceManager manager) {
            super((BDeviceManager)manager);
            this.checkDataDefsCommand = new CheckDataDefsCommand((BWidget)manager, (Lexicon)lex, log);
            this.checkDataDefsCommand.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return MgrController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.checkDataDefsCommand});
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            return new DiscoverDevicesController().doImport((BKnxDeviceManager)this.getManager(), "Discover/Import Devices", BKnxDeviceManager.this.getNetwork().getLocalInterfaces(), cx);
        }

        public void updateCommands() {
            boolean bDisableAll = true;
            try {
                BKnxStationDataDefs stationDataDefs;
                BKnxNetwork network;
                BKnxWbDataDefs wbDataDefs;
                BKnxWbService wbService = BKnxWbService.getService();
                if (wbService != null && (wbDataDefs = wbService.getKnxDataDefs()) != null && wbDataDefs.isDataIntegrityGood(false) && (network = BKnxDeviceManager.this.network) != null && (stationDataDefs = network.getKnxDataDefs()) != null && stationDataDefs.isDataIntegrityGood(false)) {
                    bDisableAll = false;
                }
                if (bDisableAll) {
                    MgrController.IMgrCommand[] commands = this.getCommands();
                    for (int i = 0; i < commands.length; ++i) {
                        if (!(commands[i] instanceof Command) || commands[i] instanceof CheckDataDefsCommand) continue;
                        ((Command)commands[i]).setEnabled(false);
                    }
                } else {
                    this.checkDataDefsCommand.setEnabled(true);
                    this.newFolder.setEnabled(true);
                    this.allDescendants.setEnabled(true);
                    this.newCommand.setEnabled(true);
                    this.learnMode.setEnabled(true);
                    super.updateCommands();
                }
            }
            catch (Throwable t) {
                CatchAll.throwable((Throwable)t);
            }
        }
    }
}

