/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui;

import com.tridium.util.ArrayUtil;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.enums.BKnxComObjectSizeEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsComObjectPriorityEnum;
import com.tridiumX.knxnetIp.ets.job.BEtsProjectFileImportJob;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxStationDataDefs;
import com.tridiumX.knxnetIp.point.BDataValueType;
import com.tridiumX.knxnetIp.point.BKnxBooleanProxyExt;
import com.tridiumX.knxnetIp.point.BKnxEnumProxyExt;
import com.tridiumX.knxnetIp.point.BKnxNumericProxyExt;
import com.tridiumX.knxnetIp.point.BKnxPointFolder;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import com.tridiumX.knxnetIp.point.BKnxStringProxyExt;
import com.tridiumX.knxnetIp.point.actions.BKnxAction;
import com.tridiumX.knxnetIp.ui.BCheckDataDefsDialog;
import com.tridiumX.knxnetIp.ui.BDiscoveredPoint;
import com.tridiumX.knxnetIp.ui.BOptionalAction;
import com.tridiumX.knxnetIp.ui.BOptionalActions;
import com.tridiumX.knxnetIp.ui.ICheckDataDefsDialogClient;
import com.tridiumX.knxnetIp.ui.KnxPointMgrEdit;
import com.tridiumX.knxnetIp.ui.KnxPointMgrEditRow;
import com.tridiumX.knxnetIp.ui.PointManagerRenderers;
import com.tridiumX.knxnetIp.ui.commands.CheckDataDefsCommand;
import com.tridiumX.knxnetIp.ui.commands.DepthExpandCommand;
import com.tridiumX.knxnetIp.ui.editors.BDataValueTypeFE;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.wb.BKnxWbDataDefs;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import com.tridiumX.knxnetIp.wb.IImportEtsProjectFilesManager;
import com.tridiumX.knxnetIp.wb.ImportEtsProjectFilesController;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.driver.ui.point.PointState;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"knxnetIp:KnxPointDeviceExt", "knxnetIp:KnxPointFolder"}, requiredPermissions="W")})
@NiagaraAction(name="configureDefaultDataTypesForDataSizes")
public final class BKnxPointManager
extends BPointManager
implements IImportEtsProjectFilesManager,
ICheckDataDefsDialogClient {
    public static final Action configureDefaultDataTypesForDataSizes = BKnxPointManager.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BKnxPointManager.class);
    private static final String DISPLAY_NAMES = "displayNames";
    private BKnxNetwork network;
    public BVector discoveredPoints = new BVector();
    private int maxGroupDepth = 0;
    private MgrColumn colEnabled;
    private MgrColumn colPointFacets;
    private MgrColumn colDeviceFacets;
    private MgrColumn colKnxId;
    private MgrColumn colGroupAddress;
    private MgrColumn colDataValueTypeId;
    private MgrColumn colPollEnable;
    private MgrColumn colPollOnceOnSub;
    private MgrColumn colPollOnceOnOper;
    private MgrColumn colPollUntilAnswer;
    private MgrColumn colPollAfterWrite;
    private MgrColumn colPollFrequency;
    private OptionalActionsMgrColumn colOptionalActions;
    private MgrColumn colWriteOnly;
    private final PointManagerRenderers renderers = new PointManagerRenderers(this);
    private final DepthExpandCommand expandAllCommand = new DepthExpandCommand((BWidget)this, (Lexicon)lex);
    static final UiLexicon lex = UiLexicon.makeUiLexicon(BKnxPointManager.class);
    private static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName() + ".pointManager");

    public void configureDefaultDataTypesForDataSizes() {
        this.invoke(configureDefaultDataTypesForDataSizes, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BKnxPointManager() {
        this.expandAllCommand.setFlags(16);
    }

    protected MgrController makeController() {
        return new KnxPointMgrController(this);
    }

    protected MgrModel makeModel() {
        return new KnxPointMgrModel(this);
    }

    protected MgrState makeState() {
        return new KnxPointMgrState();
    }

    protected MgrLearn makeLearn() {
        return new KnxPointMgrLearn(this);
    }

    public void handleComponentEvent(BComponentEvent event) {
        String slotName;
        if (event.getId() == 5 && (slotName = event.getSlotName()).equals(BKnxProxyExt.busDataReceived.getName())) {
            return;
        }
        super.handleComponentEvent(event);
    }

    public void doConfigureDefaultDataTypesForDataSizes() {
    }

    final void updateDiscoveryRows() {
        if (this.discoveredPoints.getChildComponents().length > 0) {
            Object[] discoveredRows = this.discoveredPoints.getChildComponents();
            this.getLearn().updateRoots(discoveredRows);
        }
    }

    public void doLoadValue(BObject obj, Context cx) {
        try {
            this.network = BKnxPointManager.getNetwork((BIPointFolder)obj);
            long start = System.currentTimeMillis();
            BCheckDataDefsDialog.doCheckDataDefs(this, obj, cx);
            if (log.isLoggable(Level.FINE)) {
                log.fine("BKnxPointManager.doLoadValue(...) Total: " + (System.currentTimeMillis() - start));
            }
            ((PointController)this.getController()).learnMode.setSelected(this.discoveredPoints != null && this.discoveredPoints.getChildComponents().length != 0);
            this.getController().updateCommands();
        }
        catch (Throwable t) {
            CatchAll.throwable((Throwable)t);
        }
    }

    private static BKnxNetwork getNetwork(BIPointFolder obj) {
        BComplex parent;
        for (parent = ((BComplex)obj).getParent(); parent != null && !(parent instanceof BDeviceNetwork); parent = parent.getParent()) {
        }
        if (parent != null) {
            if (parent instanceof BKnxNetwork) {
                return (BKnxNetwork)parent;
            }
            BDriverContainer driverContainer = (BDriverContainer)parent.getParent();
            BDeviceNetwork[] devNetworks = (BDeviceNetwork[])driverContainer.getChildren(BDeviceNetwork.class);
            for (int i = 0; i < devNetworks.length; ++i) {
                if (!(devNetworks[i] instanceof BKnxNetwork)) continue;
                devNetworks[i].loadSlots();
                return (BKnxNetwork)devNetworks[i];
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public BKnxNetwork getNetwork() {
        if (this.network == null) {
            this.network = (BKnxNetwork)((BIPointFolder)this.getCurrentValue()).getNetwork();
        }
        return this.network;
    }

    @Override
    public void doLoadValueAsync(BObject obj, Context cx) {
        long start = System.currentTimeMillis();
        super.doLoadValue(obj, cx);
        if (log.isLoggable(Level.FINE)) {
            log.fine("BKnxPointManager.doLoadValueAsync: " + (System.currentTimeMillis() - start));
        }
    }

    private static void setActionName(BControlPoint point, String actionName, BFormat newDisplayName, Context context) {
        BNameMap displayNames = (BNameMap)point.get(DISPLAY_NAMES);
        BNameMap newNames = null;
        if (newDisplayName == null || newDisplayName.getFormat().length() == 0) {
            if (displayNames != null) {
                newNames = BNameMap.remove((BNameMap)displayNames, (String)actionName);
            }
        } else {
            newNames = BNameMap.make((BNameMap)(displayNames == null ? BNameMap.NULL : displayNames), (String)actionName, (BFormat)newDisplayName);
        }
        if (newNames != null) {
            if (newNames.isNull()) {
                if (displayNames != null) {
                    point.remove(DISPLAY_NAMES, context);
                }
            } else if (displayNames == null) {
                point.add(DISPLAY_NAMES, (BValue)newNames, 4, context);
            } else {
                point.set(DISPLAY_NAMES, (BValue)newNames);
            }
        }
    }

    public BOptionalActions getOptionalActions(MgrEditRow row) {
        MgrTypeInfo rowTypeInfo = row.getType();
        Type rowType = null;
        try {
            rowType = rowTypeInfo.newInstance().getType();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String dataValueTypeId = row.getCell(this.colDataValueTypeId).toString();
        BDataValueTypeDef dataValueTypeDef = this.network.getKnxDataDefs().getKnxDefs().getDataValueTypeDef(dataValueTypeId);
        BKnxComObjectSizeEnum comObjectSize = dataValueTypeDef == null ? BKnxComObjectSizeEnum.unknownSize : dataValueTypeDef.getComObjectSize();
        return BKnxPointManager.getOptionalActions(rowType, comObjectSize, (BControlPoint)row.getTarget());
    }

    public static BOptionalActions getOptionalActions(Type rowType, BKnxComObjectSizeEnum comObjectSize, BControlPoint point) {
        BOptionalActions optionalActions;
        block7: {
            optionalActions = new BOptionalActions();
            try {
                BOptionalAction optionalAction;
                BKnxAction knxAction;
                int i;
                if (point != null) {
                    BKnxAction[] existingActions = (BKnxAction[])point.getChildren(BKnxAction.class);
                    for (i = 0; i < existingActions.length; ++i) {
                        knxAction = existingActions[i];
                        optionalAction = new BOptionalAction();
                        optionalAction.setActionTypeInfo(knxAction.getType().getTypeSpec());
                        optionalAction.setExists(true);
                        optionalActions.add(knxAction.getType().getTypeName(), (BValue)optionalAction);
                    }
                }
                if (rowType != null) {
                    TypeInfo[] actionTypes = Sys.getRegistry().getConcreteTypes(BKnxAction.TYPE.getTypeInfo());
                    for (i = 0; i < actionTypes.length; ++i) {
                        knxAction = (BKnxAction)actionTypes[i].getInstance();
                        if (!knxAction.getControlPointType().equals(rowType) && !knxAction.getControlPointType().equals(rowType.getSuperType()) || !knxAction.getComObjectSize().equals((Object)BKnxComObjectSizeEnum.DEFAULT) && !knxAction.getComObjectSize().equals((Object)comObjectSize)) continue;
                        optionalAction = (BOptionalAction)optionalActions.get(knxAction.getType().getTypeName());
                        if (optionalAction == null) {
                            optionalAction = new BOptionalAction();
                            optionalAction.setActionTypeInfo(knxAction.getType().getTypeSpec());
                            optionalActions.add(knxAction.getType().getTypeName(), (BValue)optionalAction);
                        }
                        optionalAction.setValid(true);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block7;
                log.log(Level.FINE, "Failed to add optional actions", e);
            }
        }
        return optionalActions;
    }

    private static BMgrEditDialog getMgrEditDialog(BWbEditor wbEditor) {
        for (BComplex p = wbEditor.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof BMgrEditDialog)) continue;
            return (BMgrEditDialog)p;
        }
        return null;
    }

    @Override
    public void clearDiscoveredRows() {
        this.discoveredPoints = new BVector();
        this.maxGroupDepth = 0;
        MgrLearn knxLearn = this.getLearn();
        Object[] a = new Object[]{};
        knxLearn.updateRoots(a);
    }

    class KnxPointMgrState
    extends PointState {
        private BVector discoveredPoints = null;
        int maxGroupDepth = 0;

        KnxPointMgrState() {
        }

        protected void saveForOrd(BAbstractManager manager) {
            BKnxPointManager devManager = (BKnxPointManager)manager;
            this.discoveredPoints = devManager.discoveredPoints;
            this.maxGroupDepth = devManager.maxGroupDepth;
        }

        protected void restoreForOrd(BAbstractManager manager) {
            BKnxPointManager devManager = (BKnxPointManager)manager;
            devManager.discoveredPoints = this.discoveredPoints;
            devManager.maxGroupDepth = this.maxGroupDepth;
            devManager.updateDiscoveryRows();
        }
    }

    public class DataValueTypeMgrColumn
    extends MgrColumn.PropPath {
        public DataValueTypeMgrColumn(Property[] props, int flags) {
            super(props, flags);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BString val = (BString)rows[0].getCell(colIndex);
            BDataValueTypeDef dvtDef = BKnxWbService.getService().getKnxDataDefs().getKnxDefs().getDataValueTypeDef(val.getString());
            BKnxComObjectSizeEnum comObjectSize = dvtDef != null ? BDataValueType.make((BDataValueTypeDef)dvtDef).getComObjectSize() : BKnxComObjectSizeEnum._1_Bit;
            MgrTypeInfo mgrTypeInfo = null;
            for (int i = 0; i < rows.length; ++i) {
                BKnxComObjectSizeEnum compareComObjectSize;
                MgrEditRow row = rows[i];
                BString compareValue = (BString)row.getCell(colIndex);
                BDataValueTypeDef compareDvtDef = BKnxWbService.getService().getKnxDataDefs().getKnxDefs().getDataValueTypeDef(compareValue.getString());
                BKnxComObjectSizeEnum bKnxComObjectSizeEnum = compareComObjectSize = compareDvtDef != null ? BDataValueType.make((BDataValueTypeDef)compareDvtDef).getComObjectSize() : BKnxComObjectSizeEnum._1_Bit;
                if (!comObjectSize.equals((Object)compareComObjectSize)) {
                    return null;
                }
                if (mgrTypeInfo == null) {
                    mgrTypeInfo = row.getType();
                    continue;
                }
                if (mgrTypeInfo.equals((Object)row.getType())) continue;
                return null;
            }
            if (mgrTypeInfo == null) {
                return null;
            }
            String s = mgrTypeInfo.toSlotName();
            BDataValueTypeFE editor = (BDataValueTypeFE)BTypeSpec.make((String)(BDataValueTypeFE.TYPE.getTypeSpec() + s)).getInstance();
            if (currentEditor != null && currentEditor.getClass() == ((Object)((Object)editor)).getClass()) {
                editor = (BDataValueTypeFE)currentEditor;
            }
            editor.loadValue((BObject)val);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor wbEditor) throws Exception {
            BDataValueTypeFE editor = (BDataValueTypeFE)wbEditor;
            BString val = (BString)editor.saveValue();
            try {
                BKnxNetwork network = BKnxPointManager.this.getNetwork();
                BDataValueTypeDef def = network.getKnxDataDefs().getKnxDefs().getDataValueTypeDef(val.getString());
                if (def != null) {
                    def.loadSlots();
                }
                BFacets facets = def == null ? null : def.getDefinedFacets((Object)rows[0].getType().newInstance());
                for (int i = 0; i < rows.length; ++i) {
                    KnxPointMgrEditRow row = (KnxPointMgrEditRow)rows[i];
                    row.setCell(colIndex, (BValue)val);
                    if (def != null) {
                        if (BKnxPointManager.this.colDeviceFacets != null) {
                            row.setCell(BKnxPointManager.this.colDeviceFacets, (BValue)facets);
                        }
                        if (BKnxPointManager.this.colPointFacets != null) {
                            row.setCell(BKnxPointManager.this.colPointFacets, (BValue)facets);
                        }
                        if (!row.getTarget().isMounted()) {
                            boolean writeFlag = row.getDiscovery() == null ? true : ((BDiscoveredPoint)row.getDiscovery()).getWriteFlag();
                            MgrTypeInfo[] mtInfos = BDiscoveredPoint.toTypes(def, writeFlag);
                            ((KnxPointMgrEditRow)rows[i]).setAvailableTypes(mtInfos);
                        }
                    }
                    BOptionalActions optionalActions = BKnxPointManager.this.getOptionalActions(row);
                    if (BKnxPointManager.this.colOptionalActions == null) continue;
                    row.setCell(BKnxPointManager.this.colOptionalActions, (BValue)optionalActions);
                }
                BMgrEditDialog dialog = BKnxPointManager.getMgrEditDialog(wbEditor);
                dialog.syncInputPane();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public class TypeMgrColumn
    extends MgrColumn.Type {
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            super.fromEditor(rows, colIndex, widget);
            try {
                BKnxNetwork network = BKnxPointManager.this.getNetwork();
                boolean changesMade = false;
                for (int i = 0; i < rows.length; ++i) {
                    KnxPointMgrEditRow row = (KnxPointMgrEditRow)rows[i];
                    String dvtId = ((BString)row.getCell(BKnxPointManager.this.colDataValueTypeId)).getString();
                    BDataValueTypeDef def = network.getKnxDataDefs().getKnxDefs().getDataValueTypeDef(dvtId);
                    def.loadSlots();
                    BFacets facets = def.getDefinedFacets((Object)row.getType().newInstance());
                    if (BKnxPointManager.this.colDeviceFacets != null) {
                        row.setCell(BKnxPointManager.this.colDeviceFacets, (BValue)facets);
                        changesMade = true;
                    }
                    if (BKnxPointManager.this.colPointFacets != null) {
                        row.setCell(BKnxPointManager.this.colPointFacets, (BValue)facets);
                        changesMade = true;
                    }
                    if (!row.getTarget().isMounted()) {
                        boolean writeFlag = row.getDiscovery() == null ? true : ((BDiscoveredPoint)row.getDiscovery()).getWriteFlag();
                        MgrTypeInfo[] mtInfos = BDiscoveredPoint.toTypes(def, writeFlag);
                        row.setAvailableTypes(mtInfos);
                        changesMade = true;
                    }
                    BOptionalActions optionalActions = BKnxPointManager.this.getOptionalActions(row);
                    if (BKnxPointManager.this.colOptionalActions == null) continue;
                    row.setCell(BKnxPointManager.this.colOptionalActions, (BValue)optionalActions);
                    changesMade = true;
                }
                if (changesMade) {
                    BMgrEditDialog dialog = BKnxPointManager.getMgrEditDialog(widget);
                    dialog.syncInputPane();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    public class OptionalActionsMgrColumn
    extends MgrColumn {
        protected OptionalActionsMgrColumn(String displayName) {
            super(displayName);
        }

        public OptionalActionsMgrColumn(String displayName, int flags) {
            super(displayName, flags);
        }

        public Object get(Object row) {
            if (row instanceof BControlPoint) {
                BKnxComObjectSizeEnum comObjectSize = BKnxPointManager.this.network.getKnxDataDefs().getKnxDefs().getDataValueTypeDef(((BKnxProxyExt)((BControlPoint)row).getProxyExt()).getDataValueTypeId()).getComObjectSize();
                return BKnxPointManager.getOptionalActions(null, comObjectSize, (BControlPoint)row);
            }
            return null;
        }

        public BValue load(MgrEditRow row) throws Exception {
            return BKnxPointManager.this.getOptionalActions(row);
        }

        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
            BControlPoint point = (BControlPoint)row.getTarget();
            if (point != null) {
                BOptionalAction[] optionalActions = (BOptionalAction[])value.asComponent().getChildren(BOptionalAction.class);
                for (int i = 0; i < optionalActions.length; ++i) {
                    BKnxAction[] aKnxActions;
                    BOptionalAction optionalAction = optionalActions[i];
                    BKnxAction knxAction = (BKnxAction)optionalAction.getActionTypeInfo().getInstance();
                    if (optionalAction.getCreate() && (aKnxActions = (BKnxAction[])point.getChildren(knxAction.getClass())).length == 0) {
                        point.add(knxAction.getActionSlotName(), (BValue)knxAction);
                        String newName = "%lexicon(" + knxAction.getType() + ")%";
                        BKnxPointManager.setActionName(point, knxAction.getActionSlotName(), BFormat.make((String)newName), cx);
                    }
                    if (!optionalAction.getRemove()) continue;
                    aKnxActions = (BKnxAction[])point.getChildren(knxAction.getClass());
                    for (int j = 0; j < aKnxActions.length; ++j) {
                        BKnxPointManager.setActionName(point, aKnxActions[j].getName(), null, cx);
                        point.remove(aKnxActions[j].getName());
                    }
                }
                ((BKnxProxyExt)point.getProxyExt()).checkActionSlots();
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows.length != 1) {
                if (currentEditor != null) {
                    currentEditor.setEnabled(false);
                }
                return null;
            }
            BOptionalActions optionalActions = (BOptionalActions)rows[0].getCell(colIndex);
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)optionalActions);
            }
            editor.setEnabled(true);
            editor.loadValue((BObject)optionalActions);
            return editor;
        }
    }

    class KnxPointMgrModel
    extends PointModel {
        KnxPointMgrModel(BKnxPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected BMgrTable makeTable() {
            BMgrTable table = super.makeTable();
            table.setCellRenderer(((BKnxPointManager)BKnxPointManager.this).renderers.modelRenderer);
            return table;
        }

        protected MgrColumn[] makeColumns() {
            Object[] columns = super.makeColumns();
            BBooleanPoint dummyPoint = new BBooleanPoint();
            BKnxProxyExt dummyProxyExt = this.newInstance((BControlPoint)dummyPoint);
            dummyPoint.setProxyExt((BAbstractProxyExt)dummyProxyExt);
            boolean foundOne = false;
            for (int i = 0; i < columns.length; ++i) {
                MgrColumn column = columns[i];
                if (column instanceof MgrColumn.Type) {
                    columns[i] = new TypeMgrColumn();
                }
                if (!(column instanceof MgrColumn.PropPath)) continue;
                Object obj = column.get((Object)dummyPoint);
                if (obj instanceof BBoolean) {
                    BKnxPointManager.this.colEnabled = column;
                }
                if (!(obj instanceof BFacets)) continue;
                if (foundOne) {
                    BKnxPointManager.this.colDeviceFacets = column;
                    BKnxPointManager.this.colDeviceFacets.setReadOnly();
                    break;
                }
                BKnxPointManager.this.colPointFacets = column;
                foundOne = true;
            }
            Object[] moreColumns = new MgrColumn[]{BKnxPointManager.this.colKnxId = (MgrColumn)new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BKnxProxyExt.knxId}, 5), BKnxPointManager.this.colGroupAddress = (MgrColumn)new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BKnxProxyExt.groupAddresses}, 1), BKnxPointManager.this.colDataValueTypeId = (MgrColumn)new DataValueTypeMgrColumn(new Property[]{BControlPoint.proxyExt, BKnxProxyExt.dataValueTypeId}, 1), BKnxPointManager.this.colPollEnable = (MgrColumn)new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BKnxProxyExt.pollEnable}, 1), BKnxPointManager.this.colPollOnceOnSub = (MgrColumn)new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BKnxProxyExt.pollOnceOnSubscribed}, 3), BKnxPointManager.this.colPollOnceOnOper = (MgrColumn)new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BKnxProxyExt.pollOnceOnOperational}, 3), BKnxPointManager.this.colPollUntilAnswer = (MgrColumn)new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BKnxProxyExt.pollUntilAnswer}, 3), BKnxPointManager.this.colPollAfterWrite = (MgrColumn)new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BKnxProxyExt.pollAfterWrite}, 3), BKnxPointManager.this.colPollFrequency = (MgrColumn)new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BKnxProxyExt.pollFrequency}, 3), BKnxPointManager.this.colOptionalActions = new OptionalActionsMgrColumn("optionalActions", 3), BKnxPointManager.this.colWriteOnly = (MgrColumn)new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BKnxProxyExt.writeOnly}, 1)};
            return (MgrColumn[])ArrayUtil.add((Object[])columns, (Object[])moreColumns);
        }

        public boolean accept(BComponent component) {
            BAbstractProxyExt proxyExt;
            if (component instanceof BControlPoint && (proxyExt = ((BControlPoint)component).getProxyExt()) instanceof BKnxProxyExt) {
                this.getManager().registerForComponentEvents((BComponent)proxyExt, 1);
            }
            return super.accept(component);
        }

        public int getSubscribeDepth() {
            return 1;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BComponent instance = type.newInstance();
            BControlPoint controlPoint = (BControlPoint)instance;
            BKnxProxyExt ext = this.newInstance(controlPoint);
            if (ext != null) {
                ext.setDataValueTypeId("DPST-1-1");
                controlPoint.setProxyExt((BAbstractProxyExt)ext);
                return controlPoint;
            }
            return instance;
        }

        private final BKnxProxyExt newInstance(BControlPoint controlPoint) {
            if (controlPoint instanceof BBooleanPoint) {
                return new BKnxBooleanProxyExt();
            }
            if (controlPoint instanceof BEnumPoint) {
                return new BKnxEnumProxyExt();
            }
            if (controlPoint instanceof BNumericPoint) {
                return new BKnxNumericProxyExt();
            }
            if (controlPoint instanceof BStringPoint) {
                return new BKnxStringProxyExt();
            }
            return null;
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            for (int i = 0; i < rows.length; ++i) {
                this.addInstance(rows[i], cx);
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private CommandArtifact addInstance(MgrEditRow row, Context cx) throws Exception {
            BDiscoveredPoint disc = (BDiscoveredPoint)row.getDiscovery();
            BComponent instance = row.getTarget();
            if (disc != null) {
                Vector<BDiscoveredPoint> vParents = new Vector<BDiscoveredPoint>(disc.getDepth(), 1);
                BDataValueTypeDef def = disc.getDataValueTypeDef();
                if (!disc.getIsGroup() && def == null) {
                    log.info("Unable to add GroupAddress '" + disc.getGroupAddresses().getPrimaryGroupAddress().getFriendlyAddress() + "' - NO DataValueType SPECIFIED");
                }
                if (disc.getDepth() <= 0) return null;
                BDiscoveredPoint discPoint = disc;
                while (discPoint.getDepth() > 0) {
                    if ((discPoint = (BDiscoveredPoint)discPoint.getParent()) == null) throw new Exception("Missing 'Discovery Point' parent.");
                    vParents.add(discPoint);
                }
                BPointDeviceExt parentFolder = ((BIPointFolder)BKnxPointManager.this.getCurrentValue()).getDeviceExt();
                for (int i = vParents.size(); i > 0; --i) {
                    BDiscoveredPoint parentPoint = (BDiscoveredPoint)vParents.get(i - 1);
                    String sFolderName = SlotPath.escape((String)parentPoint.getGroupName());
                    if (sFolderName.equals("")) throw new Exception("sFolderName == ''");
                    BKnxPointFolder kpFolder = null;
                    BValue propParentFolder = parentFolder.get(sFolderName);
                    if (propParentFolder != null) {
                        kpFolder = (BKnxPointFolder)propParentFolder;
                    } else {
                        kpFolder = new BKnxPointFolder(parentPoint.getIsField());
                        Context tx = Transaction.start((BComponent)parentFolder, (Context)cx);
                        Mark mark = new Mark((BObject)kpFolder, sFolderName);
                        mark.moveTo((BObject)parentFolder, cx);
                        Transaction.end((BComponent)parentFolder, (Context)tx);
                        kpFolder = (BKnxPointFolder)parentFolder.get(sFolderName);
                    }
                    parentFolder = kpFolder;
                }
                String sInstanceName = row.getName();
                if (sInstanceName == null || sInstanceName.equals("")) throw new Exception("sInstanceName == ''");
                Context tx = Transaction.start((BComponent)parentFolder, (Context)cx);
                Mark mark = new Mark((BObject)instance, sInstanceName);
                mark.moveTo((BObject)parentFolder, cx);
                Transaction.end((BComponent)parentFolder, (Context)tx);
                return null;
            } else {
                BComponent targetParent = row.getTargetParent();
                if (targetParent == null) {
                    targetParent = ((BIPointFolder)BKnxPointManager.this.getCurrentValue()).getDeviceExt();
                }
                Context tx = Transaction.start((BComponent)targetParent, (Context)cx);
                Mark mark = new Mark((BObject)instance, row.getName());
                mark.moveTo((BObject)targetParent, cx);
                Transaction.end((BComponent)targetParent, (Context)tx);
            }
            return null;
        }
    }

    class KnxPointMgrLearn
    extends MgrLearn {
        KnxPointMgrLearn(BKnxPointManager manager) {
            super((BAbstractManager)manager);
        }

        protected BLearnTable makeTable() {
            BLearnTable table = super.makeTable();
            table.setCellRenderer(((BKnxPointManager)BKnxPointManager.this).renderers.learnRenderer);
            return table;
        }

        public Object[] getChildren(Object discovery) {
            BDiscoveredPoint disc = (BDiscoveredPoint)discovery;
            if (disc.getIsGroup()) {
                return disc.getChildren(BDiscoveredPoint.class);
            }
            BDataValueTypeDef dataValueTypeDef = disc.getDataValueTypeDef();
            if (this.isComposite(disc, dataValueTypeDef)) {
                return disc.getChildren(BDiscoveredPoint.class);
            }
            return new Object[0];
        }

        private boolean isComposite(BDiscoveredPoint disc, BDataValueTypeDef dataValueTypeDef) {
            return dataValueTypeDef != null && dataValueTypeDef.isCompositeDataValueType() && !disc.getUseComposite();
        }

        public BImage getIcon(Object discovery) {
            if (this.isGroup(discovery)) {
                return null;
            }
            MgrTypeInfo[] mtInfos = this.toTypes(discovery);
            if (mtInfos != null && mtInfos.length > 0) {
                try {
                    BComponent comp = mtInfos[0].newInstance();
                    return BImage.make((BIcon)comp.getIcon());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            return super.getIcon(discovery);
        }

        public boolean hasChildren(Object discovery) {
            BDiscoveredPoint disc = (BDiscoveredPoint)discovery;
            BDataValueTypeDef dataValueTypeDef = disc.getDataValueTypeDef();
            return disc.getIsGroup() || this.isComposite(disc, dataValueTypeDef);
        }

        public boolean isDepthExpandable(int depth) {
            return depth <= BKnxPointManager.this.maxGroupDepth + 1;
        }

        public boolean isExisting(Object dis, BComponent comp) {
            if (comp instanceof BControlPoint) {
                BDiscoveredPoint dp = (BDiscoveredPoint)dis;
                BControlPoint cp = (BControlPoint)comp;
                BAbstractProxyExt p = cp.getProxyExt();
                if (p instanceof BKnxProxyExt) {
                    BKnxProxyExt ppe = (BKnxProxyExt)p;
                    return ppe.getGroupAddresses().getPrimaryGroupAddress().getAddress() == dp.getGroupAddresses().getPrimaryGroupAddress().getAddress();
                }
            }
            return false;
        }

        public boolean isGroup(Object discovery) {
            BDiscoveredPoint disc = (BDiscoveredPoint)discovery;
            BDataValueTypeDef dataValueTypeDef = disc.getDataValueTypeDef();
            return disc.getIsGroup() || this.isComposite(disc, dataValueTypeDef);
        }

        public boolean isMatchable(Object discovery, BComponent database) {
            boolean b = false;
            if (discovery != null && database != null && discovery instanceof BDiscoveredPoint && database instanceof BControlPoint) {
                BDiscoveredPoint kDP = (BDiscoveredPoint)discovery;
                BKnxProxyExt kPE = (BKnxProxyExt)((BControlPoint)database).getProxyExt();
                if (kDP.getKnxId().equals(kPE.getKnxId())) {
                    b = true;
                }
            }
            return b;
        }

        public void jobComplete(BJob job) {
            BKnxPointManager.this.discoveredPoints = ((BEtsProjectFileImportJob)job).getDiscoveredPoints();
            BKnxPointManager.this.maxGroupDepth = ((BEtsProjectFileImportJob)job).getImportedEtsProjectFile().getMaxGroupDepth();
            BKnxPointManager.this.updateDiscoveryRows();
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BDiscoveredPoint.groupName), new MgrColumn.Prop(BDiscoveredPoint.groupAddresses), new MgrColumn.Prop(BDiscoveredPoint.knxId), new MgrColumn.Prop(BDiscoveredPoint.sendNotReceive, 2), new MgrColumn.Prop(BDiscoveredPoint.dataValueTypeId), new MgrColumn.Prop(BDiscoveredPoint.comObjectSize), new MgrColumn.Prop(BDiscoveredPoint.priority), new MgrColumn.Prop(BDiscoveredPoint.readFlag, 2), new MgrColumn.Prop(BDiscoveredPoint.writeFlag, 2), new MgrColumn.Prop(BDiscoveredPoint.communicationFlag, 2), new MgrColumn.Prop(BDiscoveredPoint.transmitFlag, 2), new MgrColumn.Prop(BDiscoveredPoint.updateFlag, 2), new MgrColumn.Prop(BDiscoveredPoint.readOnInitFlag, 2), new MgrColumn.Prop(BDiscoveredPoint.deviceFacets)};
        }

        public void toRow(Object discovered, MgrEditRow row) throws Exception {
            BControlPoint point = (BControlPoint)row.getTarget();
            try {
                BDiscoveredPoint disc = (BDiscoveredPoint)discovered;
                row.setDefaultName(SlotPath.escape((String)disc.getGroupName()));
                row.setCell(BKnxPointManager.this.colEnabled, (BValue)BBoolean.make((!point.isWritablePoint() ? 1 : 0) != 0));
                row.setCell(BKnxPointManager.this.colKnxId, (BValue)BString.make((String)disc.getKnxId()));
                row.setCell(BKnxPointManager.this.colGroupAddress, (BValue)disc.getGroupAddresses());
                row.setCell(BKnxPointManager.this.colPointFacets, (BValue)BFacets.make((BFacets)disc.getDeviceFacets()));
                row.setCell(BKnxPointManager.this.colDeviceFacets, (BValue)BFacets.make((BFacets)disc.getDeviceFacets()));
                row.setCell(BKnxPointManager.this.colDataValueTypeId, (BValue)BString.make((String)disc.getDataValueTypeId()));
                row.setCell(BKnxPointManager.this.colPollFrequency, (BValue)this.getPollFreqFromPriority(disc.getPriority()));
                row.setCell(BKnxPointManager.this.colPollEnable, (BValue)BBoolean.make((disc.getCommunicationFlag() && disc.getReadFlag() && !disc.getTransmitFlag() ? 1 : 0) != 0));
                row.setCell(BKnxPointManager.this.colPollOnceOnOper, (BValue)BBoolean.make((disc.getCommunicationFlag() && disc.getReadFlag() && disc.getTransmitFlag() ? 1 : 0) != 0));
                row.setCell(BKnxPointManager.this.colPollOnceOnSub, (BValue)BBoolean.make((disc.getCommunicationFlag() && disc.getReadFlag() && disc.getTransmitFlag() ? 1 : 0) != 0));
                row.setCell(BKnxPointManager.this.colPollUntilAnswer, (BValue)BBoolean.make((disc.getCommunicationFlag() && disc.getReadFlag() && disc.getTransmitFlag() ? 1 : 0) != 0));
                row.setCell(BKnxPointManager.this.colPollAfterWrite, (BValue)BBoolean.make((boolean)disc.getPollAfterWrite()));
                row.setCell(BKnxPointManager.this.colWriteOnly, BKnxProxyExt.writeOnly.getDefaultValue());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private BPollFrequency getPollFreqFromPriority(BEtsComObjectPriorityEnum priority) {
            BPollFrequency frequency = BPollFrequency.DEFAULT;
            if (priority != null) {
                switch (priority.getOrdinal()) {
                    case 0: {
                        frequency = BPollFrequency.slow;
                        break;
                    }
                    case 1: {
                        frequency = BPollFrequency.normal;
                        break;
                    }
                    case 2: {
                        frequency = BPollFrequency.fast;
                    }
                }
            }
            return frequency;
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            BDiscoveredPoint disc = (BDiscoveredPoint)discovery;
            if (this.isGroup(discovery)) {
                return null;
            }
            BDataValueTypeDef def = disc.getDataValueTypeDef();
            return BDiscoveredPoint.toTypes(def, disc.getWriteFlag());
        }
    }

    class KnxPointMgrController
    extends PointController {
        public final MgrController.MgrCommand checkDataDefsCommand;

        public KnxPointMgrController(BKnxPointManager manager) {
            super((BPointManager)manager);
            this.checkDataDefsCommand = new CheckDataDefsCommand((BWidget)manager, (Lexicon)lex, log);
            this.checkDataDefsCommand.setFlags(7);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            return new ImportEtsProjectFilesController().doImport(this.getManager(), "Import Points from an ETS project", false, cx);
        }

        public MgrEdit makeEdit(String label) {
            return new KnxPointMgrEdit(this.getManager(), label);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return KnxPointMgrController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.checkDataDefsCommand, BKnxPointManager.this.expandAllCommand});
        }

        public void updateCommands() {
            boolean bDisableAll = true;
            try {
                BKnxStationDataDefs stationDataDefs;
                BKnxNetwork network;
                BKnxWbDataDefs wbDataDefs;
                BKnxWbService wbService = BKnxWbService.getService();
                if (wbService != null && (wbDataDefs = wbService.getKnxDataDefs()) != null && wbDataDefs.isDataIntegrityGood(false) && (network = BKnxPointManager.this.network) != null && (stationDataDefs = network.getKnxDataDefs()) != null && stationDataDefs.isDataIntegrityGood(false)) {
                    bDisableAll = false;
                }
                if (bDisableAll) {
                    MgrController.IMgrCommand[] commands = this.getCommands();
                    for (int i = 0; i < commands.length; ++i) {
                        if (!(commands[i] instanceof Command) || commands[i] instanceof CheckDataDefsCommand) continue;
                        ((Command)commands[i]).setEnabled(false);
                    }
                } else {
                    this.checkDataDefsCommand.setEnabled(true);
                    this.newFolder.setEnabled(true);
                    this.allDescendants.setEnabled(true);
                    this.newCommand.setEnabled(true);
                    this.learnMode.setEnabled(true);
                    super.updateCommands();
                }
            }
            catch (Throwable t) {
                CatchAll.throwable((Throwable)t);
            }
        }
    }
}

