/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui;

import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public final class KnxPointMgrEditRow
extends MgrEditRow {
    BComponent target;
    MgrTypeInfo[] types;

    public KnxPointMgrEditRow(BComponent target, Object discovery, MgrTypeInfo[] types) {
        super(target, discovery, types);
        this.target = target;
        this.types = types;
    }

    public BComponent getTarget() {
        return this.target;
    }

    public BComponent getTargetParent() {
        BComponent parent = (BComponent)this.target.getParent();
        if (parent != null) {
            return parent;
        }
        return this.getEdit().getAddContainer();
    }

    public MgrTypeInfo[] getAvailableTypes() {
        return this.types;
    }

    public void setAvailableTypes(MgrTypeInfo[] mtInfos) {
        this.types = mtInfos;
    }

    public void setType(MgrTypeInfo type) throws Exception {
        int typeColumn = this.getTypeColumnIndex();
        if (typeColumn < 0) {
            return;
        }
        BFacets dummy = BFacets.makePickle((BFacets)BFacets.make((String)"x", (BIDataValue)BBoolean.TRUE), (Object)type);
        this.setCell(typeColumn, (BValue)dummy);
        if (this.target.isMounted()) {
            throw new IllegalStateException("Cannot change type of mounted component");
        }
        this.target = this.getManager().getModel().newInstance(type);
    }

    public void commit(Context cx) throws Exception {
        this.saveCells((Context)(this.target.isMounted() ? cx : null));
        BComponent parent = this.getTargetParent();
        String name = this.getName();
        if (this.target.isMounted() && name != null && !name.equals(this.target.getName())) {
            parent.rename(this.target.getPropertyInParent(), name, cx);
        }
    }

    public void dumpCells() {
        System.out.println("KnxPointMgrEditRow " + this.target.getType());
        MgrColumn[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            System.out.println("  " + cols[i].getDisplayName() + " = " + this.getCell(i).toString());
        }
    }
}

