/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui;

import com.tridium.ui.theme.Theme;
import com.tridiumX.knxnetIp.point.BKnxPointFolder;
import com.tridiumX.knxnetIp.ui.BDiscoveredPoint;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.sys.BComponent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;

public class PointManagerRenderers {
    final TableCellRenderer learnRenderer = new KnxLearnCellRenderer();
    final TableCellRenderer modelRenderer = new KnxPointModelCellRenderer();
    private final BPointManager pointManager;
    private static final BBrush fieldBrush = Theme.table().getBandBrush();
    private static final BFont fieldFont = BFont.make((BFont)Theme.label().getTextFont(), (int)2);

    PointManagerRenderers(BPointManager pointManager) {
        this.pointManager = pointManager;
    }

    private BFont getKnxCellFont(TableCellRenderer.Cell cell, boolean isLearnTable) {
        if (this.isFieldRow(cell, isLearnTable)) {
            return fieldFont;
        }
        return null;
    }

    private BBrush getKnxCellBackground(TableCellRenderer.Cell cell, boolean isLearnTable) {
        if (this.isFieldRow(cell, isLearnTable)) {
            return fieldBrush;
        }
        return null;
    }

    private boolean isFieldRow(TableCellRenderer.Cell cell, boolean isLearnTable) {
        BComponent component;
        BComponent bComponent = component = isLearnTable ? (BComponent)this.pointManager.getLearn().getTable().getObjectAt(cell.row) : this.pointManager.getModel().getTable().getComponentAt(cell.row);
        return isLearnTable ? component instanceof BDiscoveredPoint && ((BDiscoveredPoint)component.as(BDiscoveredPoint.class)).getIsField() : component instanceof BKnxPointFolder && ((BKnxPointFolder)component.as(BKnxPointFolder.class)).getIsField();
    }

    class KnxLearnCellRenderer
    extends TreeTableCellRenderer {
        KnxLearnCellRenderer() {
        }

        public BFont getFont(TableCellRenderer.Cell cell) {
            BFont font = PointManagerRenderers.this.getKnxCellFont(cell, true);
            return font != null ? font : super.getFont(cell);
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            try {
                Object obj = ((BLearnTable)this.getTable()).getObjectAt(cell.row);
                MgrColumn col = ((BLearnTable)this.getTable()).columnIndexToMgrColumn(cell.column);
                return col.toDisplayString(obj, cell.value, PointManagerRenderers.this.pointManager.getCurrentContext());
            }
            catch (Exception e) {
                return "";
            }
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BBrush brush = PointManagerRenderers.this.getKnxCellBackground(cell, true);
            return brush != null ? brush : super.getBackground(cell);
        }
    }

    class KnxPointModelCellRenderer
    extends TableCellRenderer {
        KnxPointModelCellRenderer() {
        }

        public BFont getFont(TableCellRenderer.Cell cell) {
            BFont font = PointManagerRenderers.this.getKnxCellFont(cell, false);
            return font != null ? font : super.getFont(cell);
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BBrush brush = PointManagerRenderers.this.getKnxCellBackground(cell, false);
            return brush != null ? brush : super.getBackground(cell);
        }
    }
}

