/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui.editors;

import com.tridium.util.ArrayUtil;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridiumX.knxnetIp.comms.BProxyDeviceRef;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.driver.BKnxDeviceFolder;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import java.util.Vector;
import javax.baja.driver.BDevice;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"knxnetIp:ProxyDeviceRef"})})
public final class BProxyDeviceRefFE
extends BFrozenEnumFE {
    public static final Type TYPE = Sys.loadType(BProxyDeviceRefFE.class);
    private BKnxNetwork knxNetwork;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject v, Context cx) {
        if (v instanceof BComplex) {
            BComplex parent;
            for (parent = (BComplex)v; parent != null && !(parent instanceof BKnxNetwork); parent = parent.getParent()) {
            }
            if (parent != null) {
                this.knxNetwork = (BKnxNetwork)parent;
            }
        }
        BProxyDeviceRef reference = (BProxyDeviceRef)v;
        BDynamicEnum dynEnum = reference.getProxyDeviceIdEnum();
        BEnumRange enumRange = this.getEnumRange(dynEnum);
        if (!dynEnum.getRange().equals((Object)enumRange)) {
            dynEnum = BDynamicEnum.make((int)dynEnum.getOrdinal(), (BEnumRange)enumRange);
        }
        super.doLoadValue((BObject)dynEnum, cx);
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        BDynamicEnum dynEnum = (BDynamicEnum)super.doSaveValue(value, cx);
        if (value instanceof BProxyDeviceRef) {
            ((BProxyDeviceRef)value).setProxyDeviceIdEnum(dynEnum);
            return value;
        }
        return value;
    }

    public void setNetwork(BKnxNetwork network) {
        this.knxNetwork = network;
    }

    private BEnumRange getEnumRange(BDynamicEnum dynamicEnum) {
        BKnxDevice currentProxyDevice = this.getProxyDeviceById(dynamicEnum.getOrdinal());
        int idx = currentProxyDevice == null && dynamicEnum.getOrdinal() != 0 ? 2 : 1;
        BKnxDevice[] knxDevices = this.getProxyDevices();
        int knxDeviceCount = knxDevices.length + idx;
        int[] ordinals = new int[knxDeviceCount];
        String[] tags = new String[knxDeviceCount];
        ordinals[0] = 0;
        tags[0] = SlotPath.escape((String)"No 'Proxy Device' selected");
        if (idx == 2) {
            ordinals[1] = dynamicEnum.getOrdinal();
            tags[1] = SlotPath.escape((String)(dynamicEnum.getTag() + " [" + this.getLexicon().get("notFound") + "]"));
        }
        for (int i = 0; i < knxDevices.length; ++i) {
            String name;
            BKnxDevice knxDevice = knxDevices[i];
            knxDevice.loadSlots();
            ordinals[i + idx] = knxDevice.getDeviceId();
            tags[i + idx] = name = SlotPath.escape((String)this.getDeviceName(knxDevice));
        }
        return BEnumRange.make((int[])ordinals, (String[])tags);
    }

    private String getDeviceName(BKnxDevice knxDevice) {
        BComplex parent;
        Array v = new Array(String.class);
        for (parent = knxDevice.getParent(); parent != null && !(parent instanceof BKnxNetwork); parent = parent.getParent()) {
            if (!(parent instanceof BKnxDeviceFolder)) continue;
            v.add((Object)parent.getDisplayName(this.getCurrentContext()));
        }
        if (parent != null) {
            String name = knxDevice.getDisplayName(this.getCurrentContext());
            StringBuffer sb = new StringBuffer(name.length());
            if (v.size() > 0) {
                Object[] a = (String[])v.reverse().trim();
                sb.append(ArrayUtil.join((Object[])a, (String)"/"));
                sb.append("/");
            }
            sb.append(name);
            return sb.toString();
        }
        return "Parent 'KnxNetwork' not found !!!";
    }

    private BKnxDevice getProxyDeviceById(int id) {
        if (id != 0) {
            BKnxNetwork network = this.knxNetwork;
            BDevice[] knxDevices = network.getDevices();
            for (int i = 0; i < knxDevices.length; ++i) {
                if (!(knxDevices[i] instanceof BKnxDevice)) continue;
                BKnxDevice knxDevice = (BKnxDevice)knxDevices[i];
                knxDevice.loadSlots();
                if (knxDevice.getDeviceId() != id) continue;
                return knxDevice;
            }
        }
        return null;
    }

    private BKnxDevice[] getProxyDevices() {
        BKnxNetwork network = this.knxNetwork;
        BDevice[] devices = network.getDevices();
        Vector<BKnxDevice> vector = new Vector<BKnxDevice>(0, 1);
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BKnxDevice)) continue;
            vector.add((BKnxDevice)devices[i]);
        }
        BKnxDevice[] knxDevices = vector.toArray(new BKnxDevice[vector.size()]);
        return knxDevices;
    }
}

