/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui.editors;

import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridiumX.knxnetIp.comms.BLocalInterface;
import com.tridiumX.knxnetIp.comms.BLocalInterfaces;
import com.tridiumX.knxnetIp.comms.BTcpIpAdapter;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="listActionPerformed")
public final class BTcpIpAdapterFE
extends BWbFieldEditor {
    public static final Action listActionPerformed = BTcpIpAdapterFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTcpIpAdapterFE.class);
    private BLocalInterfaces interfaces;
    private BTcpIpAdapter adapter;
    private int visibleColumns = 20;
    private final BLabel textField = new BLabel();
    private final BList listField = new BList();
    private final BDropDown dropDown = new BDropDown((BWidget)this.textField, (BWidget)this.listField);

    public void listActionPerformed() {
        this.invoke(listActionPerformed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTcpIpAdapterFE() {
        this.linkTo("lk0", (BComponent)this.listField, (Slot)BList.actionPerformed, (Slot)listActionPerformed);
        this.setContent((BWidget)this.dropDown);
    }

    protected void doLoadValue(BObject value, Context context) {
        if (value instanceof BTcpIpAdapter) {
            BTcpIpAdapter adapter = (BTcpIpAdapter)value;
            BComplex parent = adapter.getParent();
            if (parent == null || !(parent instanceof BLocalInterface)) {
                throw new IllegalStateException("The given 'value' must be a child of a BLocalInterface instance.");
            }
            BLocalInterface localInterface = (BLocalInterface)parent;
            if ((parent = localInterface.getParent()) == null || !(parent instanceof BLocalInterfaces)) {
                throw new IllegalStateException("The given 'value' must be a grandchild of a BLocalInterfaces instance.");
            }
            this.adapter = new BTcpIpAdapter();
            this.adapter.copyFrom((BComplex)adapter);
            this.interfaces = (BLocalInterfaces)parent;
            BTcpIpHostSettings hostSettings = this.getTcpIpHostSettings();
            this.dropDown.setDropDownEnabled(hostSettings != null);
            this.textField.setText(adapter.getAdapterId());
            if (this.visibleColumns < adapter.getAdapterId().length()) {
                this.visibleColumns = adapter.getAdapterId().length();
            }
        } else {
            throw new IllegalArgumentException("The given 'value' TYPE is '" + value.getTypeDisplayName(context) + "', expecting 'BTcpIpAdapter'.");
        }
        this.prepareList();
        this.relayout();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        if (value instanceof BTcpIpAdapter) {
            ((BTcpIpAdapter)value).copyFrom((BComplex)this.adapter, cx);
            return value;
        }
        throw new CannotSaveException("The given 'value' TYPE is '" + value.getTypeDisplayName(cx) + "', expecting 'BTcpIpAdapter'.");
    }

    public void doListActionPerformed() {
        BTcpIpAdapter adapter;
        this.adapter = adapter = (BTcpIpAdapter)this.listField.getSelectedItem();
        this.textField.setText(adapter.getAdapterId());
        this.dropDown.closeDropDown();
        this.setModified();
    }

    private BTcpIpHostSettings getTcpIpHostSettings() {
        if (this.interfaces != null) {
            return this.interfaces.fetchTcpIpHostSettings();
        }
        return null;
    }

    private void prepareList() {
        String adapterId = this.textField.getText();
        ListModel model = this.listField.getModel();
        this.listField.setMultipleSelection(false);
        model.removeAllItems();
        model.addItem((Object)new BTcpIpAdapter());
        boolean currentFound = false;
        int idx = 0;
        int currentIndex = 0;
        if (adapterId.equals("")) {
            currentFound = true;
            currentIndex = idx;
        }
        ++idx;
        BTcpIpHostSettings hostSettings = this.getTcpIpHostSettings();
        if (hostSettings != null) {
            SlotCursor c = hostSettings.getAdapters().getProperties();
            while (c.next(BTcpIpAdapterSettings.class)) {
                BTcpIpAdapterSettings as = (BTcpIpAdapterSettings)c.get();
                BTcpIpAdapter adapter = new BTcpIpAdapter();
                adapter.setAdapterId(as.getAdapterId());
                adapter.setDisabled(!as.getIsAdapterEnabled());
                adapter.setDescription(as.getDescription());
                adapter.setIpAddress(as.getIpAddress());
                adapter.setSubnetMask(as.getSubnetMask());
                if (this.visibleColumns < as.getAdapterId().length()) {
                    this.visibleColumns = as.getAdapterId().length();
                }
                if (!currentFound && adapterId.equals(adapter.getAdapterId())) {
                    currentFound = true;
                    currentIndex = idx;
                }
                model.addItem((Object)adapter);
                ++idx;
            }
        }
        if (!currentFound && !this.adapter.getIpAddress().equals("")) {
            this.adapter.setMissing(true);
            model.addItem((Object)this.adapter);
            currentIndex = idx;
        }
        this.dropDown.relayout();
        this.listField.setSelectedIndex(currentIndex);
    }
}

