/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.wb;

import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridiumX.knxnetIp.wb.BEtsProjectFileOrdFE;
import com.tridiumX.knxnetIp.wb.BFileNameDecorationEnum;
import com.tridiumX.knxnetIp.wb.BImportEtsProjectFileOptions;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="loadFromCacheSelected"), @NiagaraAction(name="loadFromFileSelected"), @NiagaraAction(name="fileToImportChanged"), @NiagaraAction(name="nameDecorationChanged")})
public class BImportEtsProjectFilePane
extends BEdgePane {
    public static final Action loadFromCacheSelected = BImportEtsProjectFilePane.newAction((int)0, null);
    public static final Action loadFromFileSelected = BImportEtsProjectFilePane.newAction((int)0, null);
    public static final Action fileToImportChanged = BImportEtsProjectFilePane.newAction((int)0, null);
    public static final Action nameDecorationChanged = BImportEtsProjectFilePane.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BImportEtsProjectFilePane.class);
    private static final String ETS_FILE_FILTER_LEX_KEY_BASE = "etsFileFilter.";
    private static final String ETS_FILE_FILTER_DESCRIPTION_LEX_KEY = "etsFileFilter.description";
    private static final String ETS_FILE_FILTER_DESCRIPTION_DEFAULT = "Exported ETS Project Files (*.knxproj)";
    private final ToggleCommandGroup<ToggleCommand> toggleDataSource = new ToggleCommandGroup();
    private final BRadioButton loadFromCache = new BRadioButton(this.toggleDataSource, lex.get("loadFromCache.label", "Import from cache :"));
    private final BRadioButton loadFromFile = new BRadioButton(this.toggleDataSource, lex.get("loadFromFile.label", "Import from file :"));
    private final BFrozenEnumFE fileInCache = new BFrozenEnumFE();
    private final BLabel fileToImportLbl = new BLabel(lex.get("fileToImport.label", "File to import :"));
    private final BEtsProjectFileOrdFE fileToImport = new BEtsProjectFileOrdFE();
    private final BLabel nameDecorationLbl = new BLabel(lex.get("nameDecoration.label", "Name Decoration :"));
    private final BFrozenEnumFE nameDecoration = new BFrozenEnumFE();
    private final BLabel nameInCacheLbl = new BLabel(lex.get("nameInCache.label", "Name in cache :"));
    private final BTextField nameInCache = new BTextField("", 60);
    private static final Lexicon lex = Lexicon.make(BImportEtsProjectFilePane.class);

    public void loadFromCacheSelected() {
        this.invoke(loadFromCacheSelected, null, null);
    }

    public void loadFromFileSelected() {
        this.invoke(loadFromFileSelected, null, null);
    }

    public void fileToImportChanged() {
        this.invoke(fileToImportChanged, null, null);
    }

    public void nameDecorationChanged() {
        this.invoke(nameDecorationChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BImportEtsProjectFilePane() {
    }

    public BImportEtsProjectFilePane(boolean importOnly) {
        BKnxWbService knxWbService = BKnxWbService.getService();
        if (!importOnly) {
            BDynamicEnum importedFilesEnum = knxWbService.getImportedFiles().getImportedFilesNamesDynEnum();
            if (importedFilesEnum != null && importedFilesEnum.getRange().getOrdinals().length > 0) {
                this.loadFromCache.setEnabled(true);
                if (BKnxWbService.getImportSettings().getLastPointsDiscoveryFromCache()) {
                    this.loadFromCache.setSelected(true);
                } else {
                    this.loadFromFile.setSelected(true);
                }
                this.fileInCache.loadValue((BObject)importedFilesEnum);
                this.fileInCache.setEnabled(true);
            } else {
                this.loadFromCache.setEnabled(false);
                this.fileInCache.setEnabled(false);
                this.loadFromFile.setSelected(true);
            }
        } else {
            this.loadFromFile.setSelected(true);
        }
        this.fileToImport.loadValue((BObject)BKnxWbService.getImportSettings().getLastUsedKNXFileOrd());
        this.fileToImport.getTextField().setEditable(false);
        this.fileToImport.setFileIFileFilters((IFileFilter[])new ExtFileFilter[]{new ExtFileFilter(lex.get(ETS_FILE_FILTER_DESCRIPTION_LEX_KEY, ETS_FILE_FILTER_DESCRIPTION_DEFAULT), new String[]{"knxproj"})});
        this.nameDecoration.loadValue((BObject)BKnxWbService.getImportSettings().getFileNameDecoration());
        this.updateControls();
        this.updateNameInCache();
        if (!importOnly) {
            this.linkTo((BComponent)this.loadFromCache, (Slot)BRadioButton.selected, (Slot)loadFromCacheSelected);
            this.linkTo((BComponent)this.loadFromFile, (Slot)BRadioButton.selected, (Slot)loadFromFileSelected);
        }
        this.linkTo((BComponent)this.fileToImport, (Slot)BWbFieldEditor.setModified, (Slot)fileToImportChanged);
        this.linkTo((BComponent)this.nameDecoration, (Slot)BWbFieldEditor.setModified, (Slot)nameDecorationChanged);
        BGridPane grid = new BGridPane(2);
        if (!importOnly) {
            grid.add("loadFromCache", (BValue)this.loadFromCache);
            grid.add("fileInCache", (BValue)this.fileInCache);
            grid.add("loadFromFile", (BValue)this.loadFromFile);
        } else {
            grid.add("sourceFileLabel", (BValue)this.fileToImportLbl);
        }
        grid.add("sourceFile", (BValue)this.fileToImport);
        grid.add("nameDecorationLabel", (BValue)this.nameDecorationLbl);
        grid.add("nameDecoration", (BValue)this.nameDecoration);
        grid.add("newFileTemplateNameLabel", (BValue)this.nameInCacheLbl);
        grid.add("newFileTemplateName", (BValue)this.nameInCache);
        this.setTop((BWidget)grid);
    }

    public void setEnabled(boolean v) {
        super.setEnabled(v);
        this.updateControls();
    }

    public void doLoadFromCacheSelected() {
        this.updateControls();
    }

    public void doLoadFromFileSelected() {
        this.updateControls();
    }

    public void doFileToImportChanged() {
        this.updateNameInCache();
    }

    public void doNameDecorationChanged() {
        try {
            this.nameDecoration.saveValue();
        }
        catch (CannotSaveException ex) {
            ex.printStackTrace();
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.updateControls();
        this.updateNameInCache();
        BKnxWbService.getImportSettings().setFileNameDecoration((BFileNameDecorationEnum)this.nameDecoration.getCurrentValue());
    }

    private void updateControls() {
        boolean b = this.getEnabled();
        this.loadFromCache.setEnabled(b);
        this.loadFromFile.setEnabled(b);
        this.fileInCache.setReadonly(!b || !this.loadFromCache.getSelected());
        this.fileInCache.setEnabled(b && this.loadFromCache.getSelected());
        boolean fileSourceSelected = b && this.loadFromFile.getSelected();
        this.fileToImport.setReadonly(!fileSourceSelected);
        this.fileToImport.setEnabled(fileSourceSelected);
        this.nameDecorationLbl.setEnabled(fileSourceSelected);
        this.nameDecoration.setReadonly(!fileSourceSelected);
        this.nameDecoration.setEnabled(fileSourceSelected);
        this.nameInCacheLbl.setEnabled(fileSourceSelected);
        this.nameInCache.setEnabled(fileSourceSelected);
        this.nameInCache.setEditable(b && this.nameDecoration.getCurrentValue().equals((Object)BFileNameDecorationEnum.none));
    }

    private void updateNameInCache() {
        BIFile file = null;
        BOrd fileOrd = BOrd.make((BOrd)BLocalHost.INSTANCE.getAbsoluteOrd(), (String)this.fileToImport.getTextField().getText());
        try {
            BObject objFile = fileOrd.get();
            if (objFile instanceof BIFile) {
                file = (BIFile)objFile;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (file != null && !file.isDirectory()) {
            StringBuffer strBuf = new StringBuffer(file.getFileName().length() + (this.nameDecoration.getCurrentValue().equals((Object)BFileNameDecorationEnum.none) ? 0 : 20));
            if (this.nameDecoration.getCurrentValue().equals((Object)BFileNameDecorationEnum.prependFileDateAndTime)) {
                BImportEtsProjectFilePane.appendTime(strBuf, file.getLastModified());
                strBuf.append(" ");
            }
            strBuf.append(file.getFileName());
            if (this.nameDecoration.getCurrentValue().equals((Object)BFileNameDecorationEnum.appendFileDateAndTime)) {
                strBuf.append(" ");
                BImportEtsProjectFilePane.appendTime(strBuf, file.getLastModified());
            }
            this.nameInCache.setText(strBuf.toString());
        } else {
            this.nameInCache.setText("");
        }
    }

    public static final void appendTime(StringBuffer strBuf, BAbsTime time) {
        strBuf.append(TextUtil.padZeros((String)String.valueOf(time.getYear()), (int)4));
        strBuf.append("-");
        strBuf.append(TextUtil.padZeros((String)String.valueOf(time.getMonth().getOrdinal() + 1), (int)2));
        strBuf.append("-");
        strBuf.append(TextUtil.padZeros((String)String.valueOf(time.getDay()), (int)2));
        strBuf.append(" ");
        strBuf.append(TextUtil.padZeros((String)String.valueOf(time.getHour()), (int)2));
        strBuf.append(":");
        strBuf.append(TextUtil.padZeros((String)String.valueOf(time.getMinute()), (int)2));
        strBuf.append(":");
        strBuf.append(TextUtil.padZeros((String)String.valueOf(time.getSecond()), (int)2));
    }

    public BImportEtsProjectFileOptions getImportOptions() {
        BImportEtsProjectFileOptions result = new BImportEtsProjectFileOptions();
        result.setLoadFromFile(this.loadFromFile.isSelected());
        if (this.loadFromFile.isSelected()) {
            result.setNameInCache(this.nameInCache.getText().toString());
            result.setSourceFileOrd(BOrd.make((String)this.fileToImport.getTextField().getText().toString()));
        } else {
            try {
                result.setNameInCache(((BDynamicEnum)this.fileInCache.saveValue()).getTag());
            }
            catch (Exception e) {
                result.setNameInCache("?");
                e.printStackTrace();
            }
        }
        return result;
    }
}

