/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.wb;

import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyleEnum;
import com.tridiumX.knxnetIp.ets.BEtsProjectFile;
import com.tridiumX.knxnetIp.ets.EtsProjectImportUtil;
import com.tridiumX.knxnetIp.ets.enums.BEtsNameSpaceEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsProjectFileImportStateEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsProjectFileVerificationResultEnum;
import com.tridiumX.knxnetIp.ets.job.BEtsProjectFileImportJob;
import com.tridiumX.knxnetIp.job.BDiscoveredDevice;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.ui.BDiscoveredPoint;
import com.tridiumX.knxnetIp.wb.BImportedDevice;
import com.tridiumX.knxnetIp.wb.BImportedDevices;
import com.tridiumX.knxnetIp.wb.BImportedEtsProjectFiles;
import com.tridiumX.knxnetIp.wb.BImportedPoint;
import com.tridiumX.knxnetIp.wb.BImportedPointGroup;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="etsProjectFileOrd", type="BOrd", defaultValue="BOrd.DEFAULT", flags=65, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, \"workbench:StringFE\")"), @Facet(value="BFacets.make(BFacets.FIELD_WIDTH, BInteger.make(100))")}), @NiagaraProperty(name="checkForSourceFileChanges", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lastVerifiedTime", type="BAbsTime", defaultValue="BAbsTime.make(0)", flags=65), @NiagaraProperty(name="lastVerificationResult", type="BEtsProjectFileVerificationResultEnum", defaultValue="BEtsProjectFileVerificationResultEnum.DEFAULT", flags=73), @NiagaraProperty(name="importState", type="BEtsProjectFileImportStateEnum", defaultValue="BEtsProjectFileImportStateEnum.DEFAULT", flags=73), @NiagaraProperty(name="lastImportedFileModificationTime", type="BAbsTime", defaultValue="BAbsTime.make(0)", flags=73), @NiagaraProperty(name="etsProjectFile", type="BEtsProjectFile", defaultValue="new BEtsProjectFile()", flags=3), @NiagaraProperty(name="etsNamespace", type="BEtsNameSpaceEnum", defaultValue="BEtsNameSpaceEnum.DEFAULT", flags=1), @NiagaraProperty(name="groupAddressStyle", type="BKnxAddressStyleEnum", defaultValue="BKnxAddressStyleEnum.DEFAULT", flags=1), @NiagaraProperty(name="maxGroupDepth", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="groupAddressCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="importedDevices", type="BImportedDevices", defaultValue="new BImportedDevices()", flags=1), @NiagaraProperty(name="importedPoints", type="BImportedPointGroup", defaultValue="new BImportedPointGroup()", flags=1)})
@NiagaraActions(value={@NiagaraAction(name="clearImportCache"), @NiagaraAction(name="verifyFile"), @NiagaraAction(name="saveToCache")})
public class BImportedEtsProjectFile
extends BComponent {
    public static final Property etsProjectFileOrd = BImportedEtsProjectFile.newProperty((int)65, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:StringFE"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)100))));
    public static final Property checkForSourceFileChanges = BImportedEtsProjectFile.newProperty((int)4, (boolean)true, null);
    public static final Property lastVerifiedTime = BImportedEtsProjectFile.newProperty((int)65, (BValue)BAbsTime.make((long)0L), null);
    public static final Property lastVerificationResult = BImportedEtsProjectFile.newProperty((int)73, (BValue)BEtsProjectFileVerificationResultEnum.DEFAULT, null);
    public static final Property importState = BImportedEtsProjectFile.newProperty((int)73, (BValue)BEtsProjectFileImportStateEnum.DEFAULT, null);
    public static final Property lastImportedFileModificationTime = BImportedEtsProjectFile.newProperty((int)73, (BValue)BAbsTime.make((long)0L), null);
    public static final Property etsProjectFile = BImportedEtsProjectFile.newProperty((int)3, (BValue)new BEtsProjectFile(), null);
    public static final Property etsNamespace = BImportedEtsProjectFile.newProperty((int)1, (BValue)BEtsNameSpaceEnum.DEFAULT, null);
    public static final Property groupAddressStyle = BImportedEtsProjectFile.newProperty((int)1, (BValue)BKnxAddressStyleEnum.DEFAULT, null);
    public static final Property maxGroupDepth = BImportedEtsProjectFile.newProperty((int)1, (int)0, null);
    public static final Property groupAddressCount = BImportedEtsProjectFile.newProperty((int)1, (int)0, null);
    public static final Property importedDevices = BImportedEtsProjectFile.newProperty((int)1, (BValue)new BImportedDevices(), null);
    public static final Property importedPoints = BImportedEtsProjectFile.newProperty((int)1, (BValue)new BImportedPointGroup(), null);
    public static final Action clearImportCache = BImportedEtsProjectFile.newAction((int)0, null);
    public static final Action verifyFile = BImportedEtsProjectFile.newAction((int)0, null);
    public static final Action saveToCache = BImportedEtsProjectFile.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BImportedEtsProjectFile.class);
    private int m_iCurrentAddress;
    public static final String FIELDGROUP_SUFFIX = " Fields";

    public BOrd getEtsProjectFileOrd() {
        return (BOrd)this.get(etsProjectFileOrd);
    }

    public void setEtsProjectFileOrd(BOrd v) {
        this.set(etsProjectFileOrd, (BValue)v, null);
    }

    public boolean getCheckForSourceFileChanges() {
        return this.getBoolean(checkForSourceFileChanges);
    }

    public void setCheckForSourceFileChanges(boolean v) {
        this.setBoolean(checkForSourceFileChanges, v, null);
    }

    public BAbsTime getLastVerifiedTime() {
        return (BAbsTime)this.get(lastVerifiedTime);
    }

    public void setLastVerifiedTime(BAbsTime v) {
        this.set(lastVerifiedTime, (BValue)v, null);
    }

    public BEtsProjectFileVerificationResultEnum getLastVerificationResult() {
        return (BEtsProjectFileVerificationResultEnum)this.get(lastVerificationResult);
    }

    public void setLastVerificationResult(BEtsProjectFileVerificationResultEnum v) {
        this.set(lastVerificationResult, (BValue)v, null);
    }

    public BEtsProjectFileImportStateEnum getImportState() {
        return (BEtsProjectFileImportStateEnum)this.get(importState);
    }

    public void setImportState(BEtsProjectFileImportStateEnum v) {
        this.set(importState, (BValue)v, null);
    }

    public BAbsTime getLastImportedFileModificationTime() {
        return (BAbsTime)this.get(lastImportedFileModificationTime);
    }

    public void setLastImportedFileModificationTime(BAbsTime v) {
        this.set(lastImportedFileModificationTime, (BValue)v, null);
    }

    public BEtsProjectFile getEtsProjectFile() {
        return (BEtsProjectFile)this.get(etsProjectFile);
    }

    public void setEtsProjectFile(BEtsProjectFile v) {
        this.set(etsProjectFile, (BValue)v, null);
    }

    public BEtsNameSpaceEnum getEtsNamespace() {
        return (BEtsNameSpaceEnum)this.get(etsNamespace);
    }

    public void setEtsNamespace(BEtsNameSpaceEnum v) {
        this.set(etsNamespace, (BValue)v, null);
    }

    public BKnxAddressStyleEnum getGroupAddressStyle() {
        return (BKnxAddressStyleEnum)this.get(groupAddressStyle);
    }

    public void setGroupAddressStyle(BKnxAddressStyleEnum v) {
        this.set(groupAddressStyle, (BValue)v, null);
    }

    public int getMaxGroupDepth() {
        return this.getInt(maxGroupDepth);
    }

    public void setMaxGroupDepth(int v) {
        this.setInt(maxGroupDepth, v, null);
    }

    public int getGroupAddressCount() {
        return this.getInt(groupAddressCount);
    }

    public void setGroupAddressCount(int v) {
        this.setInt(groupAddressCount, v, null);
    }

    public BImportedDevices getImportedDevices() {
        return (BImportedDevices)this.get(importedDevices);
    }

    public void setImportedDevices(BImportedDevices v) {
        this.set(importedDevices, (BValue)v, null);
    }

    public BImportedPointGroup getImportedPoints() {
        return (BImportedPointGroup)this.get(importedPoints);
    }

    public void setImportedPoints(BImportedPointGroup v) {
        this.set(importedPoints, (BValue)v, null);
    }

    public void clearImportCache() {
        this.invoke(clearImportCache, null, null);
    }

    public void verifyFile() {
        this.invoke(verifyFile, null, null);
    }

    public void saveToCache() {
        this.invoke(saveToCache, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BImportedEtsProjectFiles;
    }

    public void changed(Property prop, Context cx) {
        if (this.isRunning()) {
            return;
        }
        boolean bSaveImportCache = false;
        if (prop.equals(checkForSourceFileChanges)) {
            bSaveImportCache = true;
        }
        if (bSaveImportCache && (cx == null || !cx.equals(Context.decoding))) {
            this.doSaveToCache();
        }
    }

    public String toString(Context context) {
        String s = this.getImportFileName();
        if (!s.equals("")) {
            return s;
        }
        return super.toString(context) + " - " + this.getEtsProjectFileOrd().toString();
    }

    public void doClearImportCache() {
        this.setImportState(BEtsProjectFileImportStateEnum.notImported);
        this.setEtsProjectFile(new BEtsProjectFile());
        this.setGroupAddressStyle(BKnxAddressStyleEnum.DEFAULT);
        this.setGroupAddressCount(0);
        this.setMaxGroupDepth(0);
        this.setImportedDevices(new BImportedDevices());
        this.setImportedPoints(new BImportedPointGroup());
        this.doSaveToCache();
    }

    public void doVerifyFile() {
        this.verifyEtsProjectFile();
    }

    public void doSaveToCache() {
        BKnxWbService wbService;
        if (this.isMounted() && (wbService = (BKnxWbService)this.getParent().getParent()) != null) {
            wbService.doSaveImportCache();
        }
    }

    public final void verifyEtsProjectFile() {
        try {
            BIFile iFile;
            BEtsProjectFileVerificationResultEnum eResult = BEtsProjectFileVerificationResultEnum.FileNotFound;
            BOrd ordFile = this.getEtsProjectFileOrd();
            BObject o = null;
            try {
                o = ordFile.get();
            }
            catch (Exception ex) {
                o = null;
            }
            if (o instanceof BIFile && (iFile = (BIFile)ordFile.get()) != null) {
                BAbsTime timeLastModified = iFile.getLastModified();
                eResult = timeLastModified.isAfter(this.getLastImportedFileModificationTime()) ? BEtsProjectFileVerificationResultEnum.FileHasChanged : BEtsProjectFileVerificationResultEnum.FileOk;
            }
            this.setLastVerificationResult(eResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setLastVerificationResult(BEtsProjectFileVerificationResultEnum.VerificationFailed);
        }
        this.setLastVerifiedTime(BAbsTime.now());
    }

    public void interpretImportedDevicesAsDiscoveryDevices(BEtsProjectFileImportJob job) {
        BImportedDevices importedDevices = this.getImportedDevices();
        BImportedDevice[] aDevices = importedDevices.getImportedDevices();
        for (int i = 0; i < aDevices.length; ++i) {
            BDiscoveredDevice discoveredDevice = new BDiscoveredDevice();
            discoveredDevice.setIpAddress(aDevices[i].getIpAddress());
            discoveredDevice.setFriendlyName(aDevices[i].getDeviceName());
            discoveredDevice.setEtsProjectFile(this.getEtsProjectFileOrd().encodeToString());
            discoveredDevice.setDeviceInstanceId(aDevices[i].getKnxId());
            discoveredDevice.setIndividualDeviceAddress((BIndividualDeviceAddress)aDevices[i].getIndividualDeviceAddress().newCopy(true));
            discoveredDevice.getControlHPAI().setIpAddress(aDevices[i].getIpAddress());
            int port = -1;
            try {
                port = Integer.parseInt(aDevices[i].getPort());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            discoveredDevice.getControlHPAI().setPort(port);
            discoveredDevice.setMaskVersion(aDevices[i].getMaskVersion());
            job.logMessage("Processed Device - '" + discoveredDevice.getFriendlyName() + "'");
            job.fireDeviceLearned((BValue)discoveredDevice);
        }
        job.logMessage("Found " + aDevices.length + " Device(s)");
    }

    public void interpretImportedPointsAsDiscoveryPoints(BEtsProjectFileImportJob job) throws Exception {
        this.m_iCurrentAddress = 0;
        this.interpretImportedPointGroupsAsDiscoveryPoints(0, this.getGroupAddressStyle(), this.getImportedPoints(), job.getDiscoveredPoints(), job);
        job.logMessage("Found " + this.getGroupAddressCount() + " Group Address(es)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void interpretImportedPointGroupsAsDiscoveryPoints(int iDepth, BKnxAddressStyleEnum groupAddressStyle, BImportedPointGroup discoveryGroupRanges, BVector discoveredPoints, BEtsProjectFileImportJob job) throws Exception {
        try {
            BImportedPointGroup[] aGroupRanges = discoveryGroupRanges.getImportedPointGroups();
            if (aGroupRanges == null) return;
            for (int k = 0; k < aGroupRanges.length; ++k) {
                if (!job.getJobState().isRunning()) {
                    return;
                }
                String knxId = "";
                try {
                    BImportedPointGroup knxGroupRange = aGroupRanges[k];
                    knxId = knxGroupRange.getKnxId();
                    BDiscoveredPoint discoveredPointGroup = BDiscoveredPoint.makeGroup(knxId, iDepth, knxGroupRange.getGroupName());
                    String sGroupRangeName = SlotPath.escape((String)discoveredPointGroup.getGroupName());
                    if (discoveredPoints.get(sGroupRangeName) != null) {
                        sGroupRangeName = sGroupRangeName + SlotPath.escape((String)(" {Id = '" + knxGroupRange.getKnxId() + "'}"));
                    }
                    discoveredPoints.add(sGroupRangeName, (BValue)discoveredPointGroup);
                    job.logMessage("Processed Group - '" + SlotPath.unescape((String)sGroupRangeName) + "'");
                    this.interpretImportedPointGroupsAsDiscoveryPoints(iDepth + 1, groupAddressStyle, knxGroupRange, discoveredPointGroup, job);
                    this.interpretImportedPointsAsDiscoveryPoints(iDepth + 1, groupAddressStyle, knxGroupRange, discoveredPointGroup, job);
                    continue;
                }
                catch (Exception ex) {
                    String sErr = "There was a problem in 'interpretImportedPointGroupsAsDiscoveryPoints', looping through the 'ImportedPointGroups' of an 'BImportedPointGroup' with KnxID = '" + knxId + "',  where iDepth = '" + iDepth + "' & discoveryGroupRanges = '" + discoveryGroupRanges.toString() + "'.";
                    if (job.getImportProblemReports().add(sErr + "\n\r" + ex.toString())) return;
                }
            }
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception("There was a problem in 'interpretImportedPointGroupsAsDiscoveryPoints' where iDepth = '" + iDepth + "' & discoveryGroupRanges = '" + discoveryGroupRanges.toString() + "'.", t);
        }
    }

    private static String interpretImportedPointDataPointType(BImportedPoint importedPoint) {
        String[] dpts = TextUtil.split((String)importedPoint.getDataValueTypeId(), (char)' ');
        if (dpts.length > 0 && !dpts[0].equals("")) {
            String dataPointType = BKnxWbService.getService().getKnxDataDefs().getKnxDefs().getDefaultDatapointTypeForType(dpts[0]);
            if (!dataPointType.equals("")) {
                return dataPointType;
            }
            return dpts[0];
        }
        return BKnxWbService.getService().getKnxDataDefs().getKnxDefs().getDefaultDatapointTypeForSize(importedPoint.getComObjectSize());
    }

    private void interpretImportedPointsAsDiscoveryPoints(int iDepth, BKnxAddressStyleEnum groupAddressStyle, BImportedPointGroup knxGroupRange, BDiscoveredPoint discoveredGroup, BEtsProjectFileImportJob job) throws Exception {
        BImportedPoint[] importedPoints = (BImportedPoint[])knxGroupRange.getChildren(BImportedPoint.class);
        for (int i = 0; i < importedPoints.length; ++i) {
            if (!job.getJobState().isRunning()) {
                return;
            }
            StringBuilder exExtra = new StringBuilder();
            try {
                exExtra.append("/n/ri = '" + i + "'");
                BImportedPoint importedPoint = importedPoints[i];
                String addressKnxId = importedPoint.getKnxId();
                exExtra.append("/n/raddressKnxId = '" + addressKnxId + "'");
                BDiscoveredPoint discoveredPoint = BDiscoveredPoint.make(addressKnxId, iDepth, groupAddressStyle, importedPoint.getPointName(), importedPoint.getGroupAddresses());
                discoveredPoint.setComObjectSize(importedPoint.getComObjectSize());
                discoveredPoint.setDataValueTypeId(BImportedEtsProjectFile.interpretImportedPointDataPointType(importedPoint));
                discoveredPoint.setPriority(importedPoint.getPriority());
                boolean bSendNotReceive = importedPoint.getSendNotReceive();
                discoveredPoint.setSendNotReceive(bSendNotReceive);
                discoveredPoint.copyFlags(importedPoint);
                BDataValueTypeDef dataValueTypeDef = BKnxWbService.getService().getKnxDataDefs().getKnxDefs().getDataValueTypeDef(discoveredPoint.getDataValueTypeId());
                if (dataValueTypeDef != null) {
                    String dataValueTypeId = dataValueTypeDef.getKNX_ID();
                    discoveredPoint.setDataValueTypeId(dataValueTypeDef.getKNX_ID());
                    if (dataValueTypeDef.isCompositeDataValueType()) {
                        if (!dataValueTypeDef.getNPTA_ID().equals("")) {
                            BDiscoveredPoint compositeDiscoveryPoint = new BDiscoveredPoint();
                            compositeDiscoveryPoint.copyFrom((BComplex)discoveredPoint);
                            compositeDiscoveryPoint.setUseComposite(true);
                            String sGroupAddressName = SlotPath.escape((String)compositeDiscoveryPoint.getGroupName());
                            EtsProjectImportUtil.addDiscoveredPointToGroup(discoveredGroup, compositeDiscoveryPoint, importedPoint, sGroupAddressName);
                        }
                        String sGroupName = discoveredPoint.getGroupName() + FIELDGROUP_SUFFIX;
                        discoveredPoint.setGroupName(sGroupName);
                        discoveredPoint.setIsField(true);
                        BDataValueTypeDef[] aFieldDefs = dataValueTypeDef.getDataValueTypeFieldDefs();
                        if (aFieldDefs != null) {
                            for (int j = 0; j < aFieldDefs.length; ++j) {
                                BDataValueTypeDef fieldSpec = aFieldDefs[j];
                                fieldSpec.loadSlots();
                                BDiscoveredPoint discoveredField = BDiscoveredPoint.make(addressKnxId + "_F" + fieldSpec.getKNX_ID().substring(dataValueTypeId.length()), iDepth + 1, groupAddressStyle, fieldSpec.getDPT_Name(), importedPoint.getGroupAddresses());
                                discoveredField.setComObjectSize(fieldSpec.getComObjectSize());
                                discoveredField.setDataValueTypeId(fieldSpec.getKNX_ID());
                                discoveredField.setPriority(discoveredPoint.getPriority());
                                discoveredField.setSendNotReceive(bSendNotReceive);
                                discoveredField.copyFlags(discoveredPoint);
                                discoveredPoint.add(SlotPath.escape((String)discoveredField.getGroupName()) + '?', (BValue)discoveredField);
                            }
                        }
                    }
                }
                String sGroupAddressName = SlotPath.escape((String)discoveredPoint.getGroupName());
                EtsProjectImportUtil.addDiscoveredPointToGroup(discoveredGroup, discoveredPoint, importedPoint, sGroupAddressName);
                job.logMessage("Processed Address - '" + SlotPath.unescape((String)sGroupAddressName) + "'");
                ++this.m_iCurrentAddress;
                this.updateProgress(job);
                continue;
            }
            catch (Exception ex) {
                String sErr = "There was a problem in 'interpretImportedPointsAsDiscoveryPoints', looping through the 'aGroupAddresses' of a 'BEtsGroupRange' with KnxID = '" + knxGroupRange.getKnxId() + "',  where iDepth = '" + iDepth + "' & knxGroupRange = '" + knxGroupRange.toString() + "'.";
                sErr = sErr + " exExtra = " + exExtra;
                if (job.getImportProblemReports().add(sErr + "\n\r" + ex.toString())) break;
            }
        }
    }

    public String getImportFileName() {
        String s = "";
        BOrd ord = this.getEtsProjectFileOrd();
        if (ord != null) {
            OrdQuery[] ordQueries = ord.parse();
            for (int i = ordQueries.length - 1; i >= 0; --i) {
                OrdQuery ordQuery = ordQueries[i];
                if (!ordQuery.getScheme().equals("file")) continue;
                String sPath = ordQuery.getBody();
                String[] aPathParts = TextUtil.split((String)sPath, (char)'/');
                s = aPathParts[aPathParts.length - 1];
                break;
            }
        }
        return s;
    }

    private void updateProgress(BEtsProjectFileImportJob job) {
        if (job != null) {
            job.updateProgress(this.m_iCurrentAddress * 100 / this.getGroupAddressCount());
        }
    }
}

