/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.xml;

import com.tridiumX.knxnetIp.knxDataDefs.IXmlImportableComponent;
import com.tridiumX.knxnetIp.xml.BXmlPropertySetTypeEnum;
import com.tridiumX.knxnetIp.xml.IXmlImportableComponentSpec;
import com.tridiumX.knxnetIp.xml.IXmlImporterHelper;
import com.tridiumX.knxnetIp.xml.XmlChildImportSpec;
import com.tridiumX.knxnetIp.xml.XmlInputStream;
import com.tridiumX.knxnetIp.xml.XmlPropertyImportSpec;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class XmlImporter {
    private XmlInputStream xmlInputStream = null;
    private static final Logger log = Logger.getLogger("knxnetIp.xmlImporter");

    public boolean loadFromInputStream(IXmlImporterHelper importerHelper, InputStream inputStream, long size, IXmlImportableComponent importee) throws Throwable {
        return this.loadFromInputStream(importerHelper, inputStream, size, importee, null);
    }

    public boolean loadFromInputStream(IXmlImporterHelper importerHelper, InputStream inputStream, long size, IXmlImportableComponent importee, IXmlImportableComponentSpec importSpec) throws Throwable {
        boolean r = false;
        if (inputStream != null) {
            XParser xmlParser = null;
            try {
                this.xmlInputStream = new XmlInputStream(inputStream, size);
                xmlParser = XParser.make((InputStream)this.xmlInputStream);
                r = this.loadFrom_XParser(importerHelper, xmlParser, null, importee, importSpec);
            }
            catch (Throwable t) {
                t.printStackTrace();
                String s = "ERROR: - An Exception occurred in function 'loadFrom_XML_File(IXmlImporterHelper, BIFile)' in 'XmlImporter'.\n\r" + t.getMessage();
                if (importerHelper != null) {
                    importerHelper.getImportProblemReports().add(s);
                }
                throw new Throwable(s, t);
            }
            finally {
                if (xmlParser != null) {
                    xmlParser.close();
                    xmlParser = null;
                }
                if (this.xmlInputStream != null) {
                    this.xmlInputStream.close();
                    this.xmlInputStream = null;
                }
            }
        }
        return r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean loadFrom_XParser(IXmlImporterHelper importerHelper, XParser xParser, BComponent importParent, IXmlImportableComponent importeeComponent, IXmlImportableComponentSpec importSpec) throws Throwable {
        XmlChildImportSpec[] childImportSpecs;
        boolean r = false;
        if (xParser == null) {
            String s = "";
            s = "'xParser == null'";
            s = "ERROR - Unable to import '" + importeeComponent.asComponent().getTypeDisplayName(null) + "' because " + s + ".";
            log.log(Level.SEVERE, s);
            return r;
        }
        IXmlImportableComponent importee = importeeComponent;
        IXmlImportableComponentSpec importeeSpec = importSpec;
        if (importeeSpec == null && importee instanceof IXmlImportableComponentSpec) {
            importeeSpec = (IXmlImportableComponentSpec)importee;
        }
        if (importeeSpec == null) {
            throw new IllegalArgumentException("Cannot load Component '" + importeeComponent + "' from XML because it doesn't have any XML attribute to Property Slot imports specs.");
        }
        XmlPropertyImportSpec[] importSpecs = importeeSpec.getImportSpecs();
        if (log.isLoggable(Level.FINE)) {
            log.fine("importSpecs.length = " + importSpecs.length);
        }
        if ((childImportSpecs = importeeSpec.getImportChildSpecs()) == null) {
            childImportSpecs = new XmlChildImportSpec[]{};
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("childImportSpecs.length = " + childImportSpecs.length);
        }
        Vector<COpenTag> vOpenTags = new Vector<COpenTag>(1, 1);
        XElem xe = xParser.elem();
        if (xe == null && xParser.depth() == 0 && xParser.type() != -1) {
            xParser.next();
            xe = xParser.elem();
        }
        importerHelper.updateProgress(this.xmlInputStream.getPercentRead());
        if (xe == null) {
            String s = "";
            s = "'xe == null'";
            s = "ERROR - Unable to import '" + importeeComponent.asComponent().getTypeDisplayName(null) + "' because " + s + ".";
            log.log(Level.SEVERE, s);
            return r;
        }
        XElem xeCurrent = null;
        boolean b = true;
        boolean bCancelled = importerHelper.isCancelled();
        int iStart = 0;
        int jStart = -1;
        try {
            while (!(bCancelled = importerHelper.isCancelled())) {
                String sTagName;
                xeCurrent = xParser.elem();
                if (xParser.type() == 1) {
                    sTagName = xeCurrent.name();
                    vOpenTags.add(new COpenTag(sTagName, xParser.depth()));
                    int i = 0;
                    for (i = iStart; i < importSpecs.length; ++i) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("iStart = " + iStart);
                            log.fine("i = " + i);
                        }
                        XmlPropertyImportSpec propertySpec = importSpecs[i];
                        String sSpecElementName = propertySpec.getElementName();
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("sSpecElementName = " + sSpecElementName);
                            log.fine("sTagName = " + sTagName);
                        }
                        if (sTagName.equals(sSpecElementName)) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("propertySpec.getPropertyName() = " + propertySpec.getPropertyName());
                                log.fine("propertySpec.getAttributeName() = " + propertySpec.getAttributeName());
                            }
                            String sPropertyName = propertySpec.getPropertyName();
                            String sAttrName = propertySpec.getAttributeName();
                            if (!sPropertyName.equals("") && !sAttrName.equals("")) {
                                int attrIdx;
                                String sNewVal = propertySpec.getDefaultValue();
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("sNewVal = '" + sNewVal + "' (default)");
                                }
                                if ((attrIdx = xeCurrent.attrIndex(sAttrName)) != -1) {
                                    sNewVal = xeCurrent.get(sAttrName);
                                } else if (!propertySpec.getAttributeIsOptional()) {
                                    Property prop;
                                    StringBuffer sErr = new StringBuffer("The mandatory attribute \"" + sAttrName + "\" of XML element \"" + sTagName + "\"");
                                    if (importParent != null && (prop = importParent.getPropertyInParent()) != null) {
                                        sErr.append(" (propertyInParent = \"" + prop.getName() + "\")");
                                    }
                                    sErr.append(" is missing.");
                                    throw new Exception(sErr.toString());
                                }
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("sNewVal = '" + sNewVal + "'");
                                }
                                BXmlPropertySetTypeEnum propSetType = XmlImporter.getPropertySetType(propertySpec);
                                switch (propSetType.getOrdinal()) {
                                    case 1: {
                                        if (importee.asComponent().get(propertySpec.getPropertyName()) instanceof BBoolean) {
                                            if (sNewVal.equals("0") || sNewVal.equals("1")) {
                                                importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BBoolean.make((boolean)sNewVal.equals("1")));
                                                break;
                                            }
                                            importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BBoolean.make((boolean)sNewVal.toLowerCase().equals("true")));
                                            break;
                                        }
                                        importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BString.make((String)sNewVal));
                                        break;
                                    }
                                    case 2: {
                                        BFrozenEnum frozenEnum;
                                        if (importee.asComponent().get(propertySpec.getPropertyName()) instanceof BBoolean) {
                                            importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BBoolean.make((boolean)sNewVal.equals("1")));
                                            break;
                                        }
                                        if (importee.asComponent().get(propertySpec.getPropertyName()) instanceof BFrozenEnum) {
                                            frozenEnum = (BFrozenEnum)importee.asComponent().get(propertySpec.getPropertyName());
                                            importee.asComponent().set(propertySpec.getPropertyName(), (BValue)frozenEnum.getRange().get(BInteger.make((String)sNewVal).getInt(), false));
                                            break;
                                        }
                                        if (importee.asComponent().get(propertySpec.getPropertyName()) instanceof BInteger) {
                                            importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BInteger.make((String)sNewVal));
                                            break;
                                        }
                                        if (importee.asComponent().get(propertySpec.getPropertyName()) instanceof BLong) {
                                            importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BLong.make((String)sNewVal));
                                            break;
                                        }
                                        importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BString.make((String)sNewVal));
                                        break;
                                    }
                                    case 3: {
                                        BFrozenEnum frozenEnum;
                                        if (importee.asComponent().get(propertySpec.getPropertyName()) instanceof BBoolean) {
                                            importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BBoolean.make((boolean)sNewVal.toLowerCase().equals("true")));
                                            break;
                                        }
                                        if (importee.asComponent().get(propertySpec.getPropertyName()) instanceof BDouble) {
                                            importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BDouble.make((String)sNewVal));
                                            break;
                                        }
                                        if (importee.asComponent().get(propertySpec.getPropertyName()) instanceof BFloat) {
                                            importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BFloat.make((String)sNewVal));
                                            break;
                                        }
                                        if (importee.asComponent().get(propertySpec.getPropertyName()) instanceof BInteger) {
                                            importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BInteger.make((String)sNewVal));
                                            break;
                                        }
                                        if (importee.asComponent().get(propertySpec.getPropertyName()) instanceof BFrozenEnum) {
                                            if (sNewVal.equals("")) break;
                                            sNewVal = importerHelper.preProcessEnumImport(propertySpec, sNewVal);
                                            frozenEnum = (BFrozenEnum)importee.asComponent().get(propertySpec.getPropertyName());
                                            importee.asComponent().set(propertySpec.getPropertyName(), (BValue)frozenEnum.getRange().get(sNewVal));
                                            break;
                                        }
                                        importee.asComponent().set(propertySpec.getPropertyName(), (BValue)BString.make((String)sNewVal));
                                    }
                                }
                            }
                        } else {
                            propertySpec = null;
                            break;
                        }
                        propertySpec = null;
                    }
                    if ((iStart = i) == importSpecs.length) {
                        if (jStart == -1) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("importee.toDebugString() = " + importee.asComponent().toDebugString());
                                log.fine("importeeComponent.toDebugString() = " + importeeComponent.asComponent().toDebugString());
                                log.fine("importeeSpec.getSlotName(importee.asComponent()) = " + importeeSpec.getSlotName(importee.asComponent()));
                            }
                            if (importParent != null && importee.asComponent().getParent() == null && importeeSpec.doesImporteeMatchFilter(importParent, importee)) {
                                importee = XmlImporter.addChild(importParent, importee, importeeSpec);
                            }
                            jStart = 0;
                        } else if (childImportSpecs.length > 0) {
                            XElem xeCurrentChild = null;
                            sTagName = xeCurrent.name();
                            int j = 0;
                            for (j = jStart; j < childImportSpecs.length; ++j) {
                                XmlChildImportSpec childSpec = childImportSpecs[j];
                                String sChildSpecElementName = childSpec.getElementName();
                                String sSwallowGroupElemNames = childSpec.getSwallowGroupElemNames();
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("sTagName = " + sTagName);
                                    log.fine("xeCurrent.attrSize() = " + xeCurrent.attrSize());
                                }
                                boolean bSwallow = false;
                                if (!(sSwallowGroupElemNames.equals("") || sSwallowGroupElemNames.equals(sChildSpecElementName) && xeCurrent.attrSize() != 0)) {
                                    String[] aSwallowGroupElemNames = TextUtil.split((String)sSwallowGroupElemNames, (char)':');
                                    for (int k = 0; k < aSwallowGroupElemNames.length; ++k) {
                                        String sSwallowGroupElemName = aSwallowGroupElemNames[k];
                                        if (sSwallowGroupElemName.equals("") || !sTagName.equals(sSwallowGroupElemName)) continue;
                                        if (xParser.next() == -1) {
                                            throw new BajaRuntimeException("Unexpected 'EndOfFile' in the middle of importing '" + childSpec.getChildClassName() + "' child elements of '?'.");
                                        }
                                        if (xParser.type() != 1) {
                                            if (xParser.type() != 2) throw new Exception("Expected 'ElementStart' [0x01], found instead '[0x0" + xParser.type() + "]' in the middle of importing '" + childSpec.getChildClassName() + "' child elements of '" + sTagName + "'.");
                                            if (!xParser.elem().name().equals(sTagName)) throw new Exception("Expected 'ElementStart' [0x01], found instead '[0x0" + xParser.type() + "]' in the middle of importing '" + childSpec.getChildClassName() + "' child elements of '" + sTagName + "'.");
                                            bSwallow = true;
                                            break;
                                        }
                                        xeCurrent = xParser.elem();
                                        sTagName = xeCurrent.name();
                                        vOpenTags.add(new COpenTag(sTagName, xParser.depth()));
                                    }
                                }
                                if (bSwallow) break;
                                if (!sTagName.equals(sChildSpecElementName)) continue;
                                xeCurrentChild = xParser.elem();
                                if (xeCurrentChild == xe || xParser.type() != 1) break;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("xeCurrentChild.name() = " + xeCurrentChild.name());
                                }
                                BTypeSpec oTS = null;
                                oTS = childSpec.getChildClassName().indexOf(58) == -1 ? BTypeSpec.make((String)"knxnetIp", (String)childSpec.getChildClassName()) : BTypeSpec.make((String)childSpec.getChildClassName());
                                BObject oTSInstance = oTS.getInstance();
                                IXmlImportableComponentSpec childImportSpec = null;
                                IXmlImportableComponent oChild = null;
                                if (oTSInstance instanceof IXmlImportableComponentSpec) {
                                    childImportSpec = (IXmlImportableComponentSpec)oTSInstance;
                                    oChild = childImportSpec.newInstance();
                                } else {
                                    oChild = (IXmlImportableComponent)oTSInstance;
                                }
                                try {
                                    this.loadFrom_XParser(importerHelper, xParser, importee.asComponent(), oChild, childImportSpec);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    throw e;
                                }
                                xeCurrent = xParser.elem();
                                sTagName = xeCurrent.name();
                                if (!log.isLoggable(Level.FINE)) break;
                                log.fine("xParser.type() = " + xParser.type());
                                log.fine("After Children - sTagName = " + sTagName);
                                log.fine("vOpenTags.size() = " + vOpenTags.size());
                                break;
                            }
                        }
                    }
                }
                if (xParser.type() == 2) {
                    xeCurrent = xParser.elem();
                    sTagName = xeCurrent.name();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("ELEM_END - sTagName = " + sTagName);
                        log.fine("vOpenTags.size() = " + vOpenTags.size());
                    }
                    if (vOpenTags.size() <= 0) throw new Exception("Malformed XML, excess closing element tag '" + sTagName + "' found at line " + xParser.line() + " column " + xParser.column() + ".");
                    COpenTag oOpenTag = (COpenTag)vOpenTags.lastElement();
                    if (!sTagName.equals(oOpenTag.tagName)) throw new Exception("Malformed XML, closing element tag '" + sTagName + "' doesn't match expected element tag '" + ((COpenTag)vOpenTags.lastElement()).tagName + "' at line " + xParser.line() + " column " + xParser.column() + ".");
                    if (xParser.depth() != oOpenTag.tagDepth) throw new Exception("Malformed XML, closing element tag '" + sTagName + "' doesn't match expected element tag '" + ((COpenTag)vOpenTags.lastElement()).tagName + "' at line " + xParser.line() + " column " + xParser.column() + ".");
                    vOpenTags.removeElementAt(vOpenTags.size() - 1);
                    if (vOpenTags.size() == 0) break;
                }
                if (iStart <= importSpecs.length && jStart <= childImportSpecs.length && xParser.next() != -1) continue;
            }
            if (bCancelled) {
            } else if (vOpenTags.size() > 0) {
                throw new Exception("Malformed XML, missing a closing element tag '" + ((COpenTag)vOpenTags.lastElement()).tagName + "' at line " + xParser.line() + " column " + xParser.column() + ".");
            }
        }
        catch (Throwable t) {
            b = false;
            t.printStackTrace();
            String s = "A ('Throwable') Problem has occurred while importing an ETS project file.";
            s = s + "\n\rIn XmlImporter::loadFrom_XParser() ";
            s = s + "\n\rt.toString() = '" + t.toString() + "'";
            s = s + "\n\rt.getMessage() = '" + t.getMessage() + "'";
            importerHelper.getImportProblemReports().add(s);
            throw new Throwable(s, t);
        }
        finally {
            if (xeCurrent != null) {
                xeCurrent = null;
            }
        }
        if (bCancelled) {
            if (!log.isLoggable(Level.FINE)) return false;
            log.fine("The import was cancelled.");
            return false;
        }
        if (!log.isLoggable(Level.FINE)) return b;
        log.fine("OK - Able to import '" + importeeComponent.asComponent().getTypeDisplayName(null) + "' because xParser & xElem are not null.");
        return b;
    }

    private static BXmlPropertySetTypeEnum getPropertySetType(XmlPropertyImportSpec propImportSpec) {
        BXmlPropertySetTypeEnum propSetType = BXmlPropertySetTypeEnum.DEFAULT;
        int attributeType = propImportSpec.getAttributeType().getOrdinal();
        switch (attributeType) {
            case 2: {
                propSetType = BXmlPropertySetTypeEnum.bool;
                break;
            }
            case 5: {
                propSetType = BXmlPropertySetTypeEnum.integer;
                break;
            }
            case 7: {
                propSetType = BXmlPropertySetTypeEnum.string;
                break;
            }
            default: {
                propSetType = BXmlPropertySetTypeEnum.string;
            }
        }
        return propSetType;
    }

    public static final IXmlImportableComponent addChild(BComponent importParent, IXmlImportableComponent importChild, IXmlImportableComponentSpec importChildSpec) {
        String slotName;
        if (log.isLoggable(Level.FINE)) {
            log.fine("importParent.toDebugString() = " + importParent.toDebugString());
            log.fine("importChild.toDebugString() = " + importChild.asComponent().toDebugString());
        }
        if ((slotName = SlotPath.escape((String)importChildSpec.getSlotName(importChild.asComponent()))).equals("")) {
            slotName = SlotPath.escape((String)importChild.asComponent().getTypeDisplayName(null)) + "?";
        }
        IXmlImportableComponent returnChild = null;
        Property existingProperty = importParent.getProperty(slotName);
        if (existingProperty == null) {
            importParent.add(slotName, (BValue)importChild.asComponent());
            returnChild = importChild;
        } else {
            BValue val = importParent.get(existingProperty);
            ((BComponent)val).copyFrom((BComplex)importChild.asComponent());
            returnChild = (IXmlImportableComponent)importParent.get(slotName);
        }
        return returnChild;
    }

    private class COpenTag {
        public String tagName = "";
        public int tagDepth = -1;

        public COpenTag(String sTagName, int iDepth) {
            this.tagName = sTagName;
            this.tagDepth = iDepth;
        }
    }
}

