/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.xml;

import com.tridiumX.knxnetIp.ets.enums.BEtsAttributeTypeEnum;
import javax.baja.sys.Property;

public final class XmlPropertyImportSpec {
    private String propertyName;
    private String elementName;
    private String attributeName;
    private BEtsAttributeTypeEnum attributeType = BEtsAttributeTypeEnum.DEFAULT;
    private boolean attributeIsOptional;
    private String defaultValue;

    private XmlPropertyImportSpec() {
    }

    public static final XmlPropertyImportSpec make(Property property, String elementName, String attributeName, BEtsAttributeTypeEnum attributeType) {
        return XmlPropertyImportSpec.factory(property, elementName, attributeName, attributeType, false, "");
    }

    public static final XmlPropertyImportSpec make(Property property, String elementName, String attributeName, BEtsAttributeTypeEnum attributeType, boolean attributeIsOptional) {
        return XmlPropertyImportSpec.factory(property, elementName, attributeName, attributeType, attributeIsOptional, "");
    }

    public static final XmlPropertyImportSpec make(Property property, String elementName, String attributeName, BEtsAttributeTypeEnum attributeType, boolean attributeIsOptional, String defaultValue) {
        return XmlPropertyImportSpec.factory(property, elementName, attributeName, attributeType, attributeIsOptional, defaultValue);
    }

    private static final XmlPropertyImportSpec factory(Property property, String elementName, String attributeName, BEtsAttributeTypeEnum attributeType, boolean attributeIsOptional, String defaultValue) {
        XmlPropertyImportSpec spec = new XmlPropertyImportSpec();
        spec.propertyName = property.getName();
        spec.elementName = elementName;
        spec.attributeName = attributeName;
        spec.attributeType = attributeType;
        spec.attributeIsOptional = attributeIsOptional;
        spec.defaultValue = defaultValue;
        return spec;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final String getElementName() {
        return this.elementName;
    }

    public final String getAttributeName() {
        return this.attributeName;
    }

    public final BEtsAttributeTypeEnum getAttributeType() {
        return this.attributeType;
    }

    public final boolean getAttributeIsOptional() {
        return this.attributeIsOptional;
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }
}

