/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.zip;

import com.tridiumX.knxnetIp.zip.BZipDecryptSectionEnum;
import com.tridiumX.knxnetIp.zip.BZipDecryptStateEnum;
import com.tridiumX.knxnetIp.zip.CRC32;
import com.tridiumX.knxnetIp.zip.ZipConst;
import java.io.IOException;
import java.io.InputStream;

public class EncryptedZipInputStream
extends InputStream {
    private final InputStream inStream;
    private final int[] keys = new int[3];
    private final int[] pwdKeys = new int[3];
    private BZipDecryptStateEnum state = BZipDecryptStateEnum.signature;
    private BZipDecryptSectionEnum section;
    private int skipBytes;
    private int compressedSize;
    private int crc;
    private int bufOffset = 8;
    private final int[] buf = new int[8];
    private static final int BUF_SIZE = 8;

    public EncryptedZipInputStream(InputStream stream, char[] password) {
        this.inStream = stream;
        this.pwdKeys[0] = 305419896;
        this.pwdKeys[1] = 591751049;
        this.pwdKeys[2] = 878082192;
        for (int i = 0; i < password.length; ++i) {
            EncryptedZipInputStream.updateKeys((byte)(password[i] & 0xFF), this.pwdKeys);
        }
    }

    @Override
    public int read() throws IOException {
        int result = this.delegateRead();
        if (this.skipBytes == 0) {
            switch (this.state.getOrdinal()) {
                case 0: {
                    if (!this.peekAheadEquals(ZipConst.LFH_SIGNATURE)) {
                        this.state = BZipDecryptStateEnum.tail;
                        break;
                    }
                    this.section = BZipDecryptSectionEnum.file_header;
                    this.skipBytes = 5;
                    this.state = BZipDecryptStateEnum.flags_;
                    break;
                }
                case 1: {
                    if ((result & 1) == 0) {
                        throw new IllegalStateException("ZIP not password protected.");
                    }
                    if ((result & 0x40) != 0) {
                        throw new IllegalStateException("Strong encryption used.");
                    }
                    if ((result & 8) != 0) {
                        this.compressedSize = -1;
                        this.state = BZipDecryptStateEnum.fn_length;
                        this.skipBytes = 19;
                    } else {
                        this.state = BZipDecryptStateEnum.crc;
                        this.skipBytes = 10;
                    }
                    result &= 0xFFFFFFFE;
                    break;
                }
                case 8: {
                    this.crc = result;
                    this.state = BZipDecryptStateEnum.compressed_size;
                    break;
                }
                case 2: {
                    int[] values = new int[4];
                    this.peekAhead(values);
                    this.compressedSize = 0;
                    int valueInc = 12;
                    for (int i = 0; i < 4; ++i) {
                        this.compressedSize += values[i] << 8 * i;
                        int n = i;
                        values[n] = values[n] - valueInc;
                        if (values[i] < 0) {
                            valueInc = 1;
                            int n2 = i;
                            values[n2] = values[n2] + 256;
                            continue;
                        }
                        valueInc = 0;
                    }
                    this.overrideBuffer(values);
                    result = values[0];
                    this.state = this.section == BZipDecryptSectionEnum.data_descriptor ? BZipDecryptStateEnum.signature : BZipDecryptStateEnum.fn_length;
                    this.skipBytes = 7;
                    break;
                }
                case 3: {
                    int[] values = new int[4];
                    this.peekAhead(values);
                    this.skipBytes = 3 + values[0] + values[2] + (values[1] + values[3]) * 256;
                    this.state = BZipDecryptStateEnum.header;
                    break;
                }
                case 5: {
                    this.section = BZipDecryptSectionEnum.file_data;
                    this.initKeys();
                    byte lastValue = 0;
                    for (int i = 0; i < 12; ++i) {
                        lastValue = (byte)(result ^ this.decryptByte());
                        this.updateKeys(lastValue);
                        result = this.delegateRead();
                    }
                    if ((lastValue & 0xFF) != this.crc) {
                        throw new IllegalStateException("Wrong password!");
                    }
                    if (this.compressedSize > 0) {
                        this.compressedSize -= 12;
                    }
                    this.state = BZipDecryptStateEnum.data;
                }
                case 6: {
                    if (this.compressedSize == -1 && this.peekAheadEquals(ZipConst.DD_SIGNATURE)) {
                        this.section = BZipDecryptSectionEnum.data_descriptor;
                        this.skipBytes = 5;
                        this.state = BZipDecryptStateEnum.crc;
                        break;
                    }
                    result = (result ^ this.decryptByte()) & 0xFF;
                    this.updateKeys((byte)result);
                    if (this.compressedSize > 0) {
                        --this.compressedSize;
                    }
                    if (this.compressedSize != 0) break;
                    this.state = BZipDecryptStateEnum.signature;
                    break;
                }
            }
        } else {
            --this.skipBytes;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.inStream.close();
        super.close();
    }

    private int delegateRead() throws IOException {
        ++this.bufOffset;
        if (this.bufOffset >= 8) {
            this.fetchData(0);
            this.bufOffset = 0;
        }
        return this.buf[this.bufOffset];
    }

    private boolean peekAheadEquals(int[] values) throws IOException {
        this.prepareBuffer(values);
        for (int i = 0; i < values.length; ++i) {
            if (this.buf[this.bufOffset + i] == values[i]) continue;
            return false;
        }
        return true;
    }

    private void prepareBuffer(int[] values) throws IOException {
        if (values.length > 8 - this.bufOffset) {
            for (int i = this.bufOffset; i < 8; ++i) {
                this.buf[i - this.bufOffset] = this.buf[i];
            }
            this.fetchData(8 - this.bufOffset);
            this.bufOffset = 0;
        }
    }

    private void peekAhead(int[] values) throws IOException {
        this.prepareBuffer(values);
        System.arraycopy(this.buf, this.bufOffset, values, 0, values.length);
    }

    private void overrideBuffer(int[] values) throws IOException {
        this.prepareBuffer(values);
        System.arraycopy(values, 0, this.buf, this.bufOffset, values.length);
    }

    private void fetchData(int offset) throws IOException {
        for (int i = offset; i < 8; ++i) {
            this.buf[i] = this.inStream.read();
            if (this.buf[i] == -1) break;
        }
    }

    private void initKeys() {
        System.arraycopy(this.pwdKeys, 0, this.keys, 0, this.keys.length);
    }

    private void updateKeys(byte charCode) {
        EncryptedZipInputStream.updateKeys(charCode, this.keys);
    }

    private byte decryptByte() {
        int temp = this.keys[2] | 2;
        return (byte)(temp * (temp ^ 1) >>> 8);
    }

    private static void updateKeys(byte charCode, int[] keys) {
        keys[0] = CRC32.crc32(keys[0], charCode);
        keys[1] = keys[1] + (keys[0] & 0xFF);
        keys[1] = keys[1] * 134775813 + 1;
        keys[2] = CRC32.crc32(keys[2], (byte)(keys[1] >> 24));
    }
}

