/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.addresses;

import com.tridiumX.knxnetIp.addresses.BKnxAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyleEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BGroupAddress
extends BKnxAddress {
    public static final Type TYPE = Sys.loadType(BGroupAddress.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BGroupAddress() {
        super(BKnxAddressStyleEnum.threeLevel);
    }

    public BGroupAddress(int address) {
        super(address, BKnxAddressStyleEnum.threeLevel);
    }

    public BGroupAddress(BKnxAddressStyleEnum groupAddressStyle) {
        super(groupAddressStyle);
    }

    public static BGroupAddress make(int address, BKnxAddressStyleEnum groupAddressStyle) {
        return new BGroupAddress(address, groupAddressStyle);
    }

    public static final BGroupAddress make(String address) throws Exception {
        BGroupAddress groupAddr = null;
        String[] parts = TextUtil.split((String)address, (char)'/');
        switch (parts.length) {
            case 1: {
                groupAddr = new BGroupAddress(BKnxAddressStyleEnum.free);
                break;
            }
            case 2: {
                groupAddr = new BGroupAddress(BKnxAddressStyleEnum.twoLevel);
                break;
            }
            case 3: {
                groupAddr = new BGroupAddress(BKnxAddressStyleEnum.threeLevel);
            }
        }
        if (groupAddr != null) {
            groupAddr.setFriendlyAddress(address);
        }
        return groupAddr;
    }

    public boolean isZero() {
        return this.getAddress() == 0;
    }

    public BGroupAddress(int address, BKnxAddressStyleEnum groupAddressStyle) {
        super(address, groupAddressStyle);
    }
}

