/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.addresses;

import com.tridiumX.knxnetIp.addresses.BGroupAddress;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="primaryGroupAddress", type="BGroupAddress", defaultValue="new BGroupAddress()")
public class BGroupAddresses
extends BVector {
    public static final Property primaryGroupAddress = BGroupAddresses.newProperty((int)0, (BValue)new BGroupAddress(), null);
    public static final Type TYPE = Sys.loadType(BGroupAddresses.class);
    private final IntHashMap groups = new IntHashMap();
    private static final BIcon icon = BIcon.std((String)"deviceFolder.png");

    public BGroupAddress getPrimaryGroupAddress() {
        return (BGroupAddress)this.get(primaryGroupAddress);
    }

    public void setPrimaryGroupAddress(BGroupAddress v) {
        this.set(primaryGroupAddress, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.reRegisterLDataListener(false);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BKnxProxyExt;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (context != null && (context.equals(Context.decoding) || context.equals(Context.copying))) {
            return;
        }
        this.reRegisterLDataListener(true);
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (context != null && context.equals(Context.decoding)) {
            return;
        }
        this.reRegisterLDataListener(true);
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        this.reRegisterLDataListener(true);
    }

    public BIcon getIcon() {
        return icon;
    }

    public void add(int address) {
        BGroupAddress[] groupAddressess = (BGroupAddress[])this.getChildren(BGroupAddress.class);
        for (int i = 0; i < groupAddressess.length; ++i) {
            if (groupAddressess[i].getAddress() != address) continue;
            return;
        }
        BGroupAddress groupAddress = BGroupAddress.make(address, this.getPrimaryGroupAddress().getStyle());
        this.add("ga" + Integer.toHexString(address), (BValue)groupAddress);
    }

    private void reRegisterLDataListener(boolean doUnRegister) {
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BKnxProxyExt) {
            if (doUnRegister) {
                ((BKnxProxyExt)parent).unregisterLDataListener();
            }
            this.initializeGroups();
            ((BKnxProxyExt)parent).registerLDataListener();
        }
    }

    private void initializeGroups() {
        if (!this.isRunning()) {
            return;
        }
        Property[] props = this.getDynamicPropertiesArray();
        this.groups.clear();
        int key = this.getPrimaryGroupAddress().getAddress();
        if (key != 0) {
            this.groups.put(key, (Object)this.getPrimaryGroupAddress());
            for (int i = 0; i < props.length; ++i) {
                BGroupAddress aGroup = (BGroupAddress)this.get(props[i]);
                key = aGroup.getAddress();
                if (key != 0) {
                    if (this.groups.containsKey(key)) continue;
                    this.groups.put(key, (Object)aGroup);
                    continue;
                }
                this.groups.clear();
                break;
            }
        }
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        IntHashMap.Iterator i = this.groups.iterator();
        while (i.hasNext()) {
            BGroupAddress ga = (BGroupAddress)i.next();
            int key = i.key();
            sb.append("\t key:").append(key).append(" ").append(ga.toString(null)).append("\n");
        }
        System.out.println(sb.toString());
        return sb.toString();
    }

    public boolean exists(int groupInt) {
        return this.groups.containsKey(groupInt);
    }

    public IntHashMap getGroups() {
        return this.groups;
    }

    public String toString(Context cx) {
        StringBuffer sb = new StringBuffer(this.getPrimaryGroupAddress().toString(cx));
        BGroupAddress[] groupAddressess = (BGroupAddress[])this.getChildren(BGroupAddress.class);
        for (int i = 1; i < groupAddressess.length; ++i) {
            sb.append(" ").append(groupAddressess[i].toString(cx));
        }
        return sb.toString();
    }
}

