/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.addresses;

import com.tridiumX.knxnetIp.addresses.BKnxAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyleEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BIndividualDeviceAddress
extends BKnxAddress {
    public static final Type TYPE = Sys.loadType(BIndividualDeviceAddress.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIndividualDeviceAddress() {
        super(BKnxAddressStyleEnum.individualDevice);
    }

    public BIndividualDeviceAddress(int address) {
        super(address, BKnxAddressStyleEnum.individualDevice);
    }

    public static final BIndividualDeviceAddress make(int area, int line, int device) {
        int address = (area & 0xF) << 12 | (line & 0xF) << 8 | device & 0xFF;
        BIndividualDeviceAddress individualDeviceAddress = new BIndividualDeviceAddress(address);
        return individualDeviceAddress;
    }

    @Override
    public BKnxAddressStyleEnum getStyle() {
        return BKnxAddressStyleEnum.individualDevice;
    }

    @Override
    public void setStyle(BKnxAddressStyleEnum v) {
        if (!v.equals((Object)BKnxAddressStyleEnum.individualDevice)) {
            throw new IllegalArgumentException("An 'Individual Device Address' may not have any other 'Address Style' than 'InidividualDevice'.");
        }
        this.set(style, (BValue)v, null);
    }
}

