/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.comms.BCommsCounters;
import com.tridiumX.knxnetIp.comms.BConnection;
import com.tridiumX.knxnetIp.comms.BConnectionCommsCounters;
import com.tridiumX.knxnetIp.comms.BConnectionsCommsCounters;
import com.tridiumX.knxnetIp.comms.BEndPoint;
import com.tridiumX.knxnetIp.comms.BFrameReceiverCommsCounters;
import com.tridiumX.knxnetIp.comms.BKnxInstallation;
import com.tridiumX.knxnetIp.comms.BTunnelConnection;
import com.tridiumX.knxnetIp.comms.IDiscoveryListener;
import com.tridiumX.knxnetIp.comms.IEndPointListener;
import com.tridiumX.knxnetIp.comms.IMulticastProvider;
import com.tridiumX.knxnetIp.comms.ReceivedFrame;
import com.tridiumX.knxnetIp.comms.enums.BConnectionErrorsEnum;
import com.tridiumX.knxnetIp.comms.enums.BConnectionsStateEnum;
import com.tridiumX.knxnetIp.comms.enums.BKnxIpFrameValidationResultEnum;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.CoreConnectRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreConnectResponse;
import com.tridiumX.knxnetIp.comms.frames.CoreConnectionStateRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreConnectionStateResponse;
import com.tridiumX.knxnetIp.comms.frames.CoreDescriptionRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreDescriptionResponse;
import com.tridiumX.knxnetIp.comms.frames.CoreDisconnectRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreDisconnectResponse;
import com.tridiumX.knxnetIp.comms.frames.CoreSearchResponse;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.TunnellingCri;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.knxSpec.BTunnellingLayerEnum;
import com.tridiumX.knxnetIp.util.BIIncludeInTrace;
import com.tridiumX.knxnetIp.util.BKnxWorker;
import com.tridiumX.knxnetIp.util.CatchAll;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDeviceExt;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.QueueFullException;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maximumReceivedPacketsQueSize", type="int", defaultValue="Constants.CONTROL_END_POINT_RECEIVE_QUEUE_SIZE_DEFAULT", facets={@Facet(value="BFacets.make(BFacets.MIN, Constants.CONTROL_END_POINT_RECEIVE_QUEUE_SIZE_MINIMUM)")}), @NiagaraProperty(name="controlEndPoint", type="BEndPoint", defaultValue="new BEndPoint()", flags=1), @NiagaraProperty(name="commsCounters", type="BCommsCounters", defaultValue="new BConnectionsCommsCounters()", flags=65540), @NiagaraProperty(name="includeInTrace", type="boolean", defaultValue="true", flags=65540), @NiagaraProperty(name="tunnelConn", type="BTunnelConnection", defaultValue="new BTunnelConnection()")})
public final class BConnections
extends BDeviceExt
implements BIIncludeInTrace {
    public static final Property maximumReceivedPacketsQueSize = BConnections.newProperty((int)0, (int)5, (BFacets)BFacets.make((String)"min", (int)2));
    public static final Property controlEndPoint = BConnections.newProperty((int)1, (BValue)new BEndPoint(), null);
    public static final Property commsCounters = BConnections.newProperty((int)65540, (BValue)new BConnectionsCommsCounters(), null);
    public static final Property includeInTrace = BConnections.newProperty((int)65540, (boolean)true, null);
    public static final Property tunnelConn = BConnections.newProperty((int)0, (BValue)new BTunnelConnection(), null);
    public static final Type TYPE = Sys.loadType(BConnections.class);
    private final Object connectionsProcessorThreadMonitor = new Object();
    private ConnectionsProcessorThread connectionsProcessorThread;
    protected static final Logger logConnections = Logger.getLogger(TYPE.getModule().getModuleName() + ".comms.connections");
    protected static final String RX_PACKET_WORKER_BASE_NAME = "CtrlRxPktWrkr";

    public int getMaximumReceivedPacketsQueSize() {
        return this.getInt(maximumReceivedPacketsQueSize);
    }

    public void setMaximumReceivedPacketsQueSize(int v) {
        this.setInt(maximumReceivedPacketsQueSize, v, null);
    }

    public BEndPoint getControlEndPoint() {
        return (BEndPoint)this.get(controlEndPoint);
    }

    public void setControlEndPoint(BEndPoint v) {
        this.set(controlEndPoint, (BValue)v, null);
    }

    public BCommsCounters getCommsCounters() {
        return (BCommsCounters)this.get(commsCounters);
    }

    public void setCommsCounters(BCommsCounters v) {
        this.set(commsCounters, (BValue)v, null);
    }

    @Override
    public boolean getIncludeInTrace() {
        return this.getBoolean(includeInTrace);
    }

    @Override
    public void setIncludeInTrace(boolean v) {
        this.setBoolean(includeInTrace, v, null);
    }

    public BTunnelConnection getTunnelConn() {
        return (BTunnelConnection)this.get(tunnelConn);
    }

    public void setTunnelConn(BTunnelConnection v) {
        this.set(tunnelConn, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BKnxDevice;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BConnection;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(maximumReceivedPacketsQueSize)) {
            this.checkConnections();
        }
    }

    public void updateStatus() {
        if (!Sys.isStationStarted()) {
            return;
        }
        if (((BKnxDevice)this.getDevice()).getConnectionMethod().getOrdinal() == 0) {
            this.checkConnections();
        }
    }

    private BConnection[] getConnections() {
        return (BConnection[])this.getChildren(BConnection.class);
    }

    private BConnection getConnectionByChannelId(int channelId) {
        if (channelId < 0 || channelId > 255) {
            throw new IllegalArgumentException("channelId '" + channelId + "' is Out of Range (" + 0 + " to " + 255 + ")");
        }
        if (channelId == this.getTunnelConn().getChannelId()) {
            return this.getTunnelConn();
        }
        return null;
    }

    public void checkConnections() {
        BKnxDevice device = (BKnxDevice)this.getDevice();
        if (device == null) {
            this.checkConnections(null, null);
        } else {
            BKnxInstallation knxInstallation = device.getKnxInstallationInstance();
            this.checkConnections(device, knxInstallation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnections(BKnxDevice device, BKnxInstallation knxInstallation) {
        if (!Sys.isStationStarted()) {
            return;
        }
        Object object = this.connectionsProcessorThreadMonitor;
        synchronized (object) {
            if (this.connectionsProcessorThread != null) {
                if (!this.connectionsProcessorThread.isAlive()) {
                    this.connectionsProcessorThread = null;
                    return;
                }
                if (this.connectionsProcessorThread.hasConfigChanged(device, knxInstallation)) {
                    this.connectionsProcessorThread.requestClose();
                    return;
                }
            }
        }
        if (device == null) {
            throw new NullPointerException("device");
        }
        if (knxInstallation == null) {
            return;
        }
        object = this.connectionsProcessorThreadMonitor;
        synchronized (object) {
            if (this.connectionsProcessorThread != null && (!device.isRunning() || device.isDisabled() || device.isFault() || knxInstallation.getStatus().isDisabled() || knxInstallation.getStatus().isFault())) {
                this.connectionsProcessorThread.requestClose();
                return;
            }
        }
        if (!device.isRunning() || device.isDisabled() || device.isFault() || knxInstallation.getStatus().isDisabled() || knxInstallation.getStatus().isFault()) {
            return;
        }
        object = this.connectionsProcessorThreadMonitor;
        synchronized (object) {
            if (this.connectionsProcessorThread == null) {
                this.connectionsProcessorThread = new ConnectionsProcessorThread(device, knxInstallation);
                this.connectionsProcessorThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnections() {
        Object object = this.connectionsProcessorThreadMonitor;
        synchronized (object) {
            if (this.connectionsProcessorThread != null) {
                try {
                    this.connectionsProcessorThread.requestClose();
                    while (this.connectionsProcessorThread.isAlive()) {
                        try {
                            this.connectionsProcessorThread.join(500L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        catch (Throwable t) {
                            CatchAll.throwable(t);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    this.connectionsProcessorThread = null;
                }
            }
        }
    }

    public static void connectionClosed(BConnection connection) {
        connection.closeDataEndPoint();
    }

    public void sendDescriptionRequest() throws IOException {
        try {
            CoreDescriptionRequest req = new CoreDescriptionRequest(this.getControlEndPoint().getLocalInetAddress(), this.getControlEndPoint().getLocalPort());
            if (this.connectionTraceEnabled()) {
                BConnections.getLogger().fine("tx " + req.toLogString() + KnxIpFrame.getToDeviceLogString(this.getControlEndPoint()));
            }
            this.getControlEndPoint().send(req);
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            throw new IOException("unknown host " + ex.toString());
        }
    }

    public void sendConnectRequest(BConnection connection) {
        if (!this.getControlEndPoint().isEndPointOpen()) {
            return;
        }
        if (this.getControlEndPoint().getRemotePort() == -1) {
            return;
        }
        try {
            TunnellingCri cri = new TunnellingCri();
            cri.setLayer(BTunnellingLayerEnum.linkLayer);
            CoreConnectRequest req = new CoreConnectRequest(this.getControlEndPoint().getLocalInetAddress(), this.getControlEndPoint().getLocalPort(), connection.getDataEndPoint().getLocalPort(), cri);
            if (this.connectionTraceEnabled()) {
                BConnections.getLogger().fine("tx " + req.toLogString() + KnxIpFrame.getToDeviceLogString(this.getControlEndPoint()));
            }
            this.getControlEndPoint().send(req);
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void sendConnectionStateRequest(BConnection connection) throws IOException {
        this.sendConnectionStateRequest(connection.getChannelId(), this.getControlEndPoint());
        this.sendConnectionStateRequest(this.getTunnelConn().getChannelId(), this.getTunnelConn().getDataEndPoint());
    }

    private void sendConnectionStateRequest(int channelId, BEndPoint endPoint) throws IOException {
        CoreConnectionStateRequest req = new CoreConnectionStateRequest(channelId, endPoint.getLocalInetAddress(), endPoint.getLocalPort());
        if (this.connectionTraceEnabled()) {
            BConnections.getLogger().fine(String.format("tx %s%s", req.toLogString(), KnxIpFrame.getToDeviceLogString(endPoint)));
        }
        endPoint.send(req);
    }

    public void sendDisconnectRequest(BConnection connection) throws IOException {
        try {
            CoreDisconnectRequest req = new CoreDisconnectRequest(connection.getChannelId(), this.getControlEndPoint().getLocalInetAddress(), this.getControlEndPoint().getLocalPort());
            if (this.connectionTraceEnabled()) {
                BConnections.getLogger().fine("tx " + req.toLogString() + KnxIpFrame.getToDeviceLogString(this.getControlEndPoint()));
            }
            this.getControlEndPoint().send(req);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new IOException("unknown host");
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        if (!this.isRunning()) {
            return;
        }
        out.startProps();
        out.trTitle((Object)TYPE.getTypeName(), 2);
        out.prop((Object)"connectionsProcessorThread", (Object)this.connectionsProcessorThread);
        if (this.connectionsProcessorThread != null) {
            out.endProps();
            this.connectionsProcessorThread.spy(out);
            out.startProps();
        }
        out.endProps();
    }

    private static Logger getLogger() {
        return logConnections;
    }

    public static void commsTrace(String traceMessage) {
        BKnxNetwork.commsTrace(TYPE, traceMessage);
    }

    private boolean connectionTraceEnabled() {
        return this.getIncludeInTrace() && BConnections.getLogger().isLoggable(Level.FINE);
    }

    private class ConnectionsProcessorThread
    extends Thread
    implements IDiscoveryListener,
    IEndPointListener {
        private BKnxDevice device = null;
        private BIndividualDeviceAddress individualDeviceAddress = null;
        private InetAddress deviceInetAddress = null;
        private int deviceControlPortNumber = -1;
        private int deviceKnxInstallationId = 0;
        private IMulticastProvider knxInstallation = null;
        private InetAddress interfaceInetAddress = null;
        private final Object connectionsStateLock = new Object();
        private BConnectionsStateEnum connectionsState = BConnectionsStateEnum.connectionsClosed;
        private boolean mustClose = false;
        private BConnection connectionBeingChanged = null;
        private int attemptsRemaining = 0;
        private int lastUsedConnectionIdx = 0;
        private final Object rxPacketWorkerLock = new Object();
        private BKnxWorker rxPacketWorker = null;

        private ConnectionsProcessorThread(BKnxDevice device, BKnxInstallation knxInstallation) {
            this.device = device;
            this.individualDeviceAddress = (BIndividualDeviceAddress)device.getIndividualDeviceAddress().newCopy(true);
            this.deviceInetAddress = device.getDeviceInetAddress();
            this.deviceControlPortNumber = device.getControlPortNumber();
            this.deviceKnxInstallationId = device.getKnxInstallation().getKnxInstallationIdEnum().getOrdinal();
            this.knxInstallation = knxInstallation;
            this.interfaceInetAddress = knxInstallation.getLocalInterface().getLocalAddress();
        }

        void transitionToState(BConnectionsStateEnum newState) {
            if (BConnections.getLogger().isLoggable(Level.FINEST)) {
                BConnections.getLogger().finest(String.format("%s transitioning from state: %s to %s with %s attempts remaining", new Object[]{this.deviceInetAddress.getHostAddress(), this.connectionsState, newState, this.attemptsRemaining}));
            }
            this.connectionsState = newState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasConfigChanged(BKnxDevice device, BKnxInstallation knxInstallation) {
            if (this.mustClose) {
                return false;
            }
            if (device == null) {
                return true;
            }
            if (knxInstallation == null) {
                return true;
            }
            BIndividualDeviceAddress deviceIndividualAddress = device.getIndividualDeviceAddress();
            if (deviceIndividualAddress.getAddress() != this.individualDeviceAddress.getAddress()) {
                return true;
            }
            InetAddress inetAddress = device.getDeviceInetAddress();
            if (inetAddress == null && this.deviceInetAddress != null) {
                return true;
            }
            if (inetAddress != null && !inetAddress.equals(this.deviceInetAddress)) {
                return true;
            }
            if (device.getControlPortNumber() != this.deviceControlPortNumber) {
                return true;
            }
            if (device.getKnxInstallation().getKnxInstallationIdEnum().getOrdinal() != this.deviceKnxInstallationId) {
                return true;
            }
            InetAddress installationInetAddress = knxInstallation.getLocalInterface().getLocalAddress();
            if (installationInetAddress == null) {
                return true;
            }
            if (!installationInetAddress.equals(this.interfaceInetAddress)) {
                return true;
            }
            Object object = this.rxPacketWorkerLock;
            synchronized (object) {
                if (this.rxPacketWorker != null && this.rxPacketWorker.getMaxQueueSize() != BConnections.this.getMaximumReceivedPacketsQueSize()) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            this.setName("DevCon" + (this.deviceInetAddress != null ? this.deviceInetAddress.getHostAddress() : this.individualDeviceAddress.getFriendlyAddress()) + "Intrfc" + (this.interfaceInetAddress != null ? this.interfaceInetAddress.getHostAddress() : this.knxInstallation.getLocalInterface().getName()));
            Object object = this.connectionsStateLock;
            synchronized (object) {
                try {
                    this.transitionToState(BConnectionsStateEnum.connectionsClosed);
                    while (!this.mustClose) {
                        boolean doWait = true;
                        block42 : switch (this.connectionsState.getOrdinal()) {
                            case 0: {
                                if (this.deviceInetAddress == null || this.deviceControlPortNumber == -1) {
                                    BConnections.commsTrace("Control End Point Remote Port Number = NO_IP_PORT_NUMBER (-1)");
                                    try {
                                        this.transitionToState(BConnectionsStateEnum.fetchingControlPortNumber);
                                        this.knxInstallation.registerMulticastListener(this);
                                        try {
                                            this.knxInstallation.sendSearchRequest();
                                            try {
                                                doWait = false;
                                                this.connectionsStateLock.wait(10000L);
                                            }
                                            catch (InterruptedException interruptedException) {
                                            }
                                            catch (Throwable t) {
                                                CatchAll.throwable(t);
                                            }
                                        }
                                        catch (IOException ex) {
                                            ex.printStackTrace();
                                        }
                                        catch (Throwable t) {
                                            CatchAll.throwable(t);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            this.knxInstallation.unregisterMulticastListener(this);
                                        }
                                        catch (Throwable t) {
                                            CatchAll.throwable(t);
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        this.knxInstallation.unregisterMulticastListener(this);
                                    }
                                    catch (Throwable t) {
                                        CatchAll.throwable(t);
                                    }
                                    break;
                                }
                                this.transitionToState(BConnectionsStateEnum.openingControlPort);
                                doWait = false;
                                break;
                            }
                            case 1: {
                                this.device.pingFail("No 'Search Response' received from device.");
                                this.transitionToState(BConnectionsStateEnum.connectionsClosed);
                                break;
                            }
                            case 2: {
                                if (this.deviceControlPortNumber == -1) {
                                    BConnections.getLogger().log(Level.SEVERE, this.deviceInetAddress.getHostAddress() + ":openConnections cannot process because device control port number is invalid.");
                                    this.transitionToState(BConnectionsStateEnum.connectionsClosed);
                                    break;
                                }
                                try {
                                    BConnections.this.getControlEndPoint().openEndPoint(this, this.knxInstallation.getLocalInterface(), this.interfaceInetAddress, this.deviceInetAddress, -1, this.deviceControlPortNumber);
                                }
                                catch (SocketException ex) {
                                    ex.printStackTrace();
                                }
                                if (!BConnections.this.getControlEndPoint().isEndPointOpen()) {
                                    this.device.pingFail("Unable to open 'Control End Point' - cable may be unplugged.");
                                    this.transitionToState(BConnectionsStateEnum.connectionsClosed);
                                    if (this.interfaceInetAddress != null) break;
                                    try {
                                        this.interfaceInetAddress = this.knxInstallation.getLocalInterface().getLocalAddress();
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                    break;
                                }
                                Object ex = this.rxPacketWorkerLock;
                                synchronized (ex) {
                                    this.rxPacketWorker = BKnxWorker.make(BConnections.RX_PACKET_WORKER_BASE_NAME + this.deviceInetAddress.getHostAddress() + "Port" + this.deviceControlPortNumber, BConnections.this.getMaximumReceivedPacketsQueSize());
                                    this.rxPacketWorker.start();
                                }
                                this.transitionToState(BConnectionsStateEnum.fetchingDescription);
                                this.attemptsRemaining = 4;
                                doWait = false;
                                break;
                            }
                            case 3: {
                                if (this.attemptsRemaining < 4 && BConnections.this.connectionTraceEnabled()) {
                                    BConnections.getLogger().fine(this.deviceInetAddress.getHostAddress() + ":fetching description timeout - remaining attempts " + this.attemptsRemaining);
                                }
                                if (this.attemptsRemaining > 0) {
                                    --this.attemptsRemaining;
                                    try {
                                        BConnections.this.sendDescriptionRequest();
                                    }
                                    catch (IOException ex) {
                                        if (BConnections.this.connectionTraceEnabled()) {
                                            BConnections.getLogger().log(Level.FINE, "Failed to send 'CORE_DESCRIPTION_REQUEST'", ex);
                                        }
                                        if (this.attemptsRemaining != 0) break;
                                        doWait = false;
                                        this.device.pingFail("Failed to send 'CORE_DESCRIPTION_REQUEST'. " + ex.getLocalizedMessage());
                                        this.transitionToState(BConnectionsStateEnum.closingControlPort);
                                        break;
                                    }
                                    catch (Throwable t) {
                                        CatchAll.throwable(t);
                                    }
                                    try {
                                        doWait = false;
                                        this.connectionsStateLock.wait(10000L);
                                    }
                                    catch (InterruptedException t) {
                                    }
                                    catch (Throwable t) {
                                        CatchAll.throwable(t);
                                    }
                                    break;
                                }
                                this.device.pingFail("No 'Description Response' received from device.");
                                this.transitionToState(BConnectionsStateEnum.closingControlPort);
                                break;
                            }
                            case 4: {
                                BConnection[] connections = BConnections.this.getConnections();
                                int iConnection = this.lastUsedConnectionIdx;
                                for (int i = 0; i < connections.length; ++i) {
                                    if (iConnection >= connections.length) {
                                        iConnection = 0;
                                    }
                                    this.lastUsedConnectionIdx = iConnection + 1;
                                    BConnection connection = connections[iConnection];
                                    if (connection.isConnected()) {
                                        if (connection.getMustClose()) {
                                            doWait = false;
                                            this.closeConnection(connection);
                                            break block42;
                                        }
                                        if (connection.isHeartBeatNeeded()) {
                                            this.connectionBeingChanged = connection;
                                            this.transitionToState(BConnectionsStateEnum.fetchingConnectionState);
                                            this.attemptsRemaining = 4;
                                            doWait = false;
                                            break block42;
                                        }
                                    } else if (connection.isReadyToOpen()) {
                                        if (!this.device.getDIBs().getSupportedServiceFamilies().isServiceTypeSupported(connection.getTypeCode())) {
                                            connection.setLastConnectError(BConnectionErrorsEnum.eConnectionTypeNotSupported);
                                            break block42;
                                        }
                                        this.connectionBeingChanged = connection;
                                        BConnections.getLogger().info("starting connection from " + (this.interfaceInetAddress == null ? "null" : this.interfaceInetAddress.getHostAddress()) + " to " + this.deviceInetAddress.getHostAddress());
                                        try {
                                            connection.openDataEndPoint(this.knxInstallation.getLocalInterface(), this.deviceInetAddress);
                                        }
                                        catch (SocketException ex) {
                                            ex.printStackTrace();
                                            connection.setLastConnectError(BConnectionErrorsEnum.eCantOpenDataEndPoint);
                                            break block42;
                                        }
                                        this.transitionToState(BConnectionsStateEnum.openingConnection);
                                        this.attemptsRemaining = 4;
                                        doWait = false;
                                        break block42;
                                    }
                                    ++iConnection;
                                }
                                break;
                            }
                            case 5: {
                                if (this.attemptsRemaining < 4 && BConnections.this.connectionTraceEnabled()) {
                                    BConnections.getLogger().fine(this.deviceInetAddress.getHostAddress() + ":CONNECT_RESPONSE timeout - remaining attempts " + this.attemptsRemaining);
                                }
                                if (this.attemptsRemaining > 0) {
                                    --this.attemptsRemaining;
                                    try {
                                        BConnections.this.sendConnectRequest(this.connectionBeingChanged);
                                        doWait = false;
                                        this.connectionsStateLock.wait(10000L);
                                    }
                                    catch (InterruptedException connections) {
                                    }
                                    catch (Throwable t) {
                                        CatchAll.throwable(t);
                                    }
                                    break;
                                }
                                this.connectionBeingChanged.setLastConnectError(BConnectionErrorsEnum.eConnectResponseTimeout);
                                this.connectionBeingChanged.closeDataEndPoint();
                                this.connectionBeingChanged = null;
                                this.transitionToState(BConnectionsStateEnum.descriptionFetched);
                                break;
                            }
                            case 6: {
                                if (this.attemptsRemaining < 4 && BConnections.this.connectionTraceEnabled()) {
                                    BConnections.getLogger().fine(this.deviceInetAddress.getHostAddress() + ":CONNECTIONSTATE_RESPONSE timeout - remaining attempts " + this.attemptsRemaining);
                                }
                                if (this.attemptsRemaining > 0) {
                                    --this.attemptsRemaining;
                                    try {
                                        BConnections.this.sendConnectionStateRequest(this.connectionBeingChanged);
                                        doWait = false;
                                        this.connectionsStateLock.wait(10000L);
                                    }
                                    catch (InterruptedException t) {
                                    }
                                    catch (IOException ex) {
                                        BConnections.getLogger().log(Level.SEVERE, "Error sending connection state request", ex);
                                    }
                                    catch (Throwable t) {
                                        CatchAll.throwable(t);
                                    }
                                    break;
                                }
                                this.connectionBeingChanged.setLastConnectError(BConnectionErrorsEnum.eConnectionStateResponseTimeout);
                                Object connection = this.connectionBeingChanged;
                                this.connectionBeingChanged = null;
                                this.transitionToState(BConnectionsStateEnum.descriptionFetched);
                                ((BConnection)connection).getCommsCounters().incCounter(BConnectionCommsCounters.closedBecauseConnectionStateResponseTimeout);
                                this.closeConnection((BConnection)connection);
                                break;
                            }
                            case 7: {
                                if (this.mustClose) break;
                                this.transitionToState(BConnectionsStateEnum.descriptionFetched);
                                break;
                            }
                            case 8: {
                                if (this.connectionBeingChanged != null) {
                                    this.connectionBeingChanged.setLastConnectError(BConnectionErrorsEnum.eDisconnectResponseTimeout);
                                    this.connectionBeingChanged.setConnected(false);
                                    BConnections.connectionClosed(this.connectionBeingChanged);
                                    this.connectionBeingChanged = null;
                                }
                                this.transitionToState(BConnectionsStateEnum.closingConnections);
                                break;
                            }
                            case 9: {
                                Object connection = this.rxPacketWorkerLock;
                                synchronized (connection) {
                                    if (this.rxPacketWorker != null) {
                                        this.rxPacketWorker.stop();
                                    }
                                    this.rxPacketWorker = null;
                                }
                                BConnections.this.getControlEndPoint().closeEndPoint();
                                this.transitionToState(BConnectionsStateEnum.connectionsClosed);
                                break;
                            }
                        }
                        if (!doWait) continue;
                        try {
                            this.connectionsStateLock.wait(1000L);
                        }
                        catch (InterruptedException connection) {
                        }
                        catch (Throwable t) {
                            CatchAll.throwable(t);
                        }
                    }
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
                finally {
                    try {
                        Thread.interrupted();
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                    }
                    BConnection[] connections = BConnections.this.getConnections();
                    for (int i = 0; i < connections.length; ++i) {
                        try {
                            connections[i].getCommsCounters().incCounter(BConnectionCommsCounters.closedBecauseConnectionsProcessorStopping);
                            this.closeConnection(connections[i]);
                            continue;
                        }
                        catch (Throwable t) {
                            CatchAll.throwable(t);
                        }
                    }
                    try {
                        Object i = this.rxPacketWorkerLock;
                        synchronized (i) {
                            if (this.rxPacketWorker != null) {
                                this.rxPacketWorker.stop();
                            }
                            this.rxPacketWorker = null;
                        }
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                    }
                    try {
                        BConnections.this.getControlEndPoint().closeEndPoint();
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                    }
                    try {
                        this.knxInstallation.unregisterMulticastListener(this);
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                    }
                }
            }
            if (this.device != null) {
                this.device.setHardwareAndServicesDIBs(null);
            }
            this.device = null;
            this.knxInstallation = null;
        }

        void requestClose() {
            if (!this.mustClose) {
                this.mustClose = true;
                this.interrupt();
            }
        }

        private void closeConnection(BConnection connection) {
            if (connection == null) {
                throw new NullPointerException("connection");
            }
            if (!connection.isConnected()) {
                BConnections.connectionClosed(connection);
                return;
            }
            if (!BConnections.this.getControlEndPoint().isEndPointOpen()) {
                return;
            }
            connection.setMustClose();
            if (BConnections.this.connectionTraceEnabled()) {
                BConnections.getLogger().fine("Closing Connection - " + connection);
            }
            try {
                connection.doConnectionClosing();
                this.connectionBeingChanged = connection;
                this.transitionToState(BConnectionsStateEnum.closingConnection);
                try {
                    BConnections.this.sendDisconnectRequest(connection);
                    this.connectionsStateLock.wait(5000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
                connection.setConnected(false);
                BConnections.connectionClosed(connection);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rcvSearchFrame(BKnxInstallation knxInstallation, KnxIpFrame frame) throws IOException {
            if (frame instanceof CoreSearchResponse) {
                CoreSearchResponse searchResponse = (CoreSearchResponse)frame;
                Object object = this.connectionsStateLock;
                synchronized (object) {
                    if (this.connectionsState.equals((Object)BConnectionsStateEnum.fetchingControlPortNumber)) {
                        if (BConnections.this.connectionTraceEnabled()) {
                            BConnections.getLogger().fine("searchResponse = " + searchResponse);
                        }
                        if (this.device != null && this.device.isRunning() && !this.device.isDisabled()) {
                            if (BConnections.this.connectionTraceEnabled()) {
                                BConnections.getLogger().fine("searchResponse.getDeviceInfoDIB().getIndividualAddress() = " + searchResponse.getDeviceInfoDIB().getIndividualAddress().getFriendlyAddress());
                                BConnections.getLogger().fine("device.getIndividualDeviceAddress() = " + this.device.getIndividualDeviceAddress().getFriendlyAddress());
                                BConnections.getLogger().fine("searchResponse.hpai.getInetAddress() = " + searchResponse.getHpai().getAddress());
                                BConnections.getLogger().fine("deviceInetAddress = " + (this.deviceInetAddress == null ? "null" : this.deviceInetAddress.getHostAddress()));
                            }
                            if (this.deviceInetAddress == null) {
                                if (this.individualDeviceAddress.getAddress() != 0 && searchResponse.getDeviceInfoDIB().getIndividualAddress().getAddress() == this.individualDeviceAddress.getAddress()) {
                                    this.device.setIpAddress(searchResponse.getHpai().getAddress().getHostAddress());
                                    this.transitionToState(BConnectionsStateEnum.connectionsClosed);
                                    if (BConnections.this.connectionTraceEnabled()) {
                                        BConnections.getLogger().fine("connectionsStateLock.notify();");
                                    }
                                    this.connectionsStateLock.notify();
                                }
                            } else if (searchResponse.getHpai().getAddress().equals(this.deviceInetAddress)) {
                                if (this.individualDeviceAddress.getAddress() == 0) {
                                    this.device.getIndividualDeviceAddress().setAddress(searchResponse.getDeviceInfoDIB().getIndividualAddress().getAddress());
                                }
                                if (this.deviceControlPortNumber == -1) {
                                    this.deviceControlPortNumber = searchResponse.getHpai().getPort();
                                    if (this.device.getControlPortNumber() == -1) {
                                        this.device.setControlPortNumber(this.deviceControlPortNumber);
                                    }
                                }
                                this.transitionToState(BConnectionsStateEnum.openingControlPort);
                                if (BConnections.this.connectionTraceEnabled()) {
                                    BConnections.getLogger().fine("connectionsStateLock.notify();");
                                }
                                this.connectionsStateLock.notify();
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void receiveFrame(KnxIpFrame frame) {
            Object object = this.rxPacketWorkerLock;
            synchronized (object) {
                if (this.rxPacketWorker != null) {
                    try {
                        this.rxPacketWorker.post(new ReceivedFrame(frame, recFrame -> this.processRxFrame((KnxIpFrame)recFrame), this.rxPacketWorker.getName()));
                    }
                    catch (QueueFullException ex) {
                        BConnections.this.getCommsCounters().incCounter(BFrameReceiverCommsCounters.rxFramesLostQueueFull);
                        BConnections.getLogger().log(Level.SEVERE, BConnections.this.getControlEndPoint().getEndPointName() + " Received Packet Lost - Queue Full - packet [ " + frame.getHexString() + " ] from " + frame.packet.getAddress().getHostAddress() + " srcPort = " + frame.packet.getPort(), ex);
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                        if (!(t instanceof ThreadDeath)) return;
                        throw (ThreadDeath)t;
                    }
                } else {
                    BConnections.this.getCommsCounters().incCounter(BFrameReceiverCommsCounters.rxFramesLostNoPacketWorker);
                }
                return;
            }
        }

        private void processRxFrame(KnxIpFrame frame) {
            InetAddress srcIp;
            if (BConnections.this.connectionTraceEnabled()) {
                BConnections.getLogger().fine("rx frame " + frame.getLogString());
            }
            if (!(srcIp = frame.packet.getAddress()).equals(BConnections.this.getControlEndPoint().getRemoteInetAddress())) {
                if (BConnections.this.connectionTraceEnabled()) {
                    BConnections.getLogger().fine(srcIp.getHostAddress() + " does not map to this device " + BConnections.this.getControlEndPoint().getRemoteInetAddress().getHostAddress());
                }
                return;
            }
            if (!frame.validationResult.equals((Object)BKnxIpFrameValidationResultEnum.packetIsValid)) {
                switch (frame.validationResult.getOrdinal()) {
                    case 3: {
                        BConnections.getLogger().log(Level.SEVERE, "Invalid Frame Header Received - " + frame.validationResult.getTag() + " - " + frame.frameHeader.protocolVersion);
                        break;
                    }
                    default: {
                        BConnections.getLogger().log(Level.SEVERE, "Invalid Frame Header Received - " + frame.validationResult.getTag());
                    }
                }
                return;
            }
            switch (frame.frameHeader.getServiceType()) {
                case 2: {
                    this.processKnxnetIpCore(frame);
                    break;
                }
                default: {
                    if (!BConnections.this.connectionTraceEnabled()) break;
                    BConnections.getLogger().fine("rx " + frame.toLogString() + " - Not Supported on a Device's 'Control' EndPoint");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processKnxnetIpCore(KnxIpFrame frame) {
            switch (frame.frameHeader.frameType.getOrdinal()) {
                case 513: {
                    if (!BConnections.this.connectionTraceEnabled()) return;
                    BConnections.getLogger().fine("rx CORE SEARCH_REQUEST, processing not implemented");
                    return;
                }
                case 514: {
                    if (!BConnections.this.connectionTraceEnabled()) return;
                    BConnections.getLogger().fine("rx CORE SEARCH_RESPONSE from " + BConnections.this.getControlEndPoint().getRemoteInetAddress() + " on the WRONG EndPoint i.e. Device Control EndPoint");
                    return;
                }
                case 515: {
                    if (!BConnections.this.connectionTraceEnabled()) return;
                    BConnections.getLogger().fine("rx CORE DESCRIPTION_REQUEST from " + BConnections.this.getControlEndPoint().getRemoteInetAddress() + ", processing not implemented");
                    return;
                }
                case 516: {
                    CoreDescriptionResponse descriptionResponse = null;
                    try {
                        descriptionResponse = (CoreDescriptionResponse)BKnxIpFrameTypeEnum.makeTypedFrame(frame);
                        Object object = this.connectionsStateLock;
                        synchronized (object) {
                            if (this.connectionsState.equals((Object)BConnectionsStateEnum.fetchingDescription)) {
                                if (BConnections.this.connectionTraceEnabled()) {
                                    BConnections.getLogger().fine("rx " + descriptionResponse.toLogString());
                                }
                                if (this.device != null && this.device.isRunning() && !this.device.isDisabled()) {
                                    this.device.setHardwareAndServicesDIBs(descriptionResponse);
                                    if (this.individualDeviceAddress.getAddress() == 0) {
                                        this.device.getIndividualDeviceAddress().setAddress(descriptionResponse.getDeviceInfoDIB().getIndividualAddress().getAddress());
                                        this.transitionToState(BConnectionsStateEnum.descriptionFetched);
                                    } else if (this.individualDeviceAddress.getAddress() != descriptionResponse.getDeviceInfoDIB().getIndividualAddress().getAddress()) {
                                        this.device.pingFail("Mismatched 'Individual Device Address' - Description Response = '" + descriptionResponse.getDeviceInfoDIB().getIndividualAddress().getFriendlyAddress() + "' expecting '" + this.individualDeviceAddress.getFriendlyAddress() + "'.");
                                        this.mustClose = true;
                                    } else {
                                        this.transitionToState(BConnectionsStateEnum.descriptionFetched);
                                    }
                                }
                                this.connectionsStateLock.notifyAll();
                            } else {
                                BConnections.getLogger().log(Level.SEVERE, "rx " + descriptionResponse.toLogString() + " - NO DESCRIPTION_REQUEST Pending");
                            }
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                case 517: {
                    BConnections.getLogger().info("rx CORE CONNECT_REQUEST from " + BConnections.this.getControlEndPoint().getRemoteInetAddress() + ", processing not implemented");
                    return;
                }
                case 518: {
                    CoreConnectResponse connectResponse = null;
                    try {
                        connectResponse = (CoreConnectResponse)BKnxIpFrameTypeEnum.makeTypedFrame(frame);
                        Object ex = this.connectionsStateLock;
                        synchronized (ex) {
                            if (this.connectionsState.equals((Object)BConnectionsStateEnum.openingConnection)) {
                                if (this.connectionBeingChanged != null) {
                                    if (this.connectionBeingChanged.handleConnectResponse(connectResponse)) {
                                        if (BConnections.this.connectionTraceEnabled()) {
                                            BConnections.getLogger().fine("rx " + connectResponse.toLogString());
                                        }
                                        this.connectionBeingChanged.setConnected(true);
                                    } else {
                                        this.connectionBeingChanged.setLastConnectError(BConnectionErrorsEnum.make(connectResponse.getStatus()));
                                        BConnections.getLogger().log(Level.SEVERE, "rx " + connectResponse.toLogString());
                                        this.mustClose = true;
                                    }
                                    this.connectionBeingChanged = null;
                                    this.transitionToState(BConnectionsStateEnum.descriptionFetched);
                                    this.connectionsStateLock.notifyAll();
                                } else {
                                    BConnections.getLogger().log(Level.SEVERE, "rx " + connectResponse.toLogString() + " - connectionBeingChanged == null!");
                                }
                            } else {
                                BConnections.getLogger().info("rx " + connectResponse.toLogString() + " - UNEXPECTED - No CONNECT_REQUEST pending.");
                            }
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                case 522: {
                    CoreDisconnectResponse disconnectResponse = null;
                    try {
                        disconnectResponse = (CoreDisconnectResponse)BKnxIpFrameTypeEnum.makeTypedFrame(frame);
                        Object ex = this.connectionsStateLock;
                        synchronized (ex) {
                            if (this.connectionsState.equals((Object)BConnectionsStateEnum.closingConnection)) {
                                if (this.connectionBeingChanged != null) {
                                    BConnection connection = BConnections.this.getConnectionByChannelId(disconnectResponse.getChannelId());
                                    if (connection != null) {
                                        if (connection.equals(this.connectionBeingChanged)) {
                                            connection.handleDisconnectResponse(disconnectResponse);
                                            if (disconnectResponse.getStatus() == 0) {
                                                if (BConnections.this.connectionTraceEnabled()) {
                                                    BConnections.getLogger().fine("rx " + disconnectResponse.toLogString());
                                                }
                                            } else {
                                                BConnections.getLogger().log(Level.SEVERE, "rx " + disconnectResponse.toLogString());
                                            }
                                            connection.setLastConnectError(BConnectionErrorsEnum.make(disconnectResponse.getStatus()));
                                            this.connectionBeingChanged = null;
                                            this.transitionToState(BConnectionsStateEnum.closingConnections);
                                            this.connectionsStateLock.notifyAll();
                                        } else {
                                            BConnections.getLogger().info("rx " + disconnectResponse.toLogString() + " - UNEXPECTED - Wrong Channel.");
                                        }
                                    } else {
                                        BConnections.getLogger().info("rx " + disconnectResponse.toLogString() + " - UNKNOWN Channel ID");
                                    }
                                } else {
                                    BConnections.getLogger().log(Level.SEVERE, "rx " + disconnectResponse.toLogString() + " - connectionBeingChanged == null!");
                                }
                            } else {
                                BConnections.getLogger().info("rx " + disconnectResponse.toLogString() + " - UNEXPECTED - No Disconnect request pending.");
                            }
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                case 519: {
                    if (!BConnections.this.connectionTraceEnabled()) return;
                    BConnections.getLogger().fine("rx CORE CONNECTIONSTATE_REQUEST from " + BConnections.this.getControlEndPoint().getRemoteInetAddress() + ":, processing not implemented");
                    return;
                }
                case 520: {
                    CoreConnectionStateResponse connectionStateResponse = null;
                    try {
                        connectionStateResponse = (CoreConnectionStateResponse)BKnxIpFrameTypeEnum.makeTypedFrame(frame);
                        Object ex = this.connectionsStateLock;
                        synchronized (ex) {
                            if (this.connectionsState.equals((Object)BConnectionsStateEnum.fetchingConnectionState)) {
                                if (this.connectionBeingChanged != null) {
                                    BConnection connection = BConnections.this.getConnectionByChannelId(connectionStateResponse.getChannelId());
                                    if (connection != null) {
                                        if (connection.equals(this.connectionBeingChanged)) {
                                            connection.handleConnectionStateResponse(connectionStateResponse);
                                            if (connectionStateResponse.getStatus() == 0) {
                                                if (BConnections.this.connectionTraceEnabled()) {
                                                    BConnections.getLogger().fine("rx " + connectionStateResponse.toLogString());
                                                }
                                            } else {
                                                BConnections.getLogger().log(Level.SEVERE, "rx " + connectionStateResponse.toLogString());
                                            }
                                            connection.setLastConnectError(BConnectionErrorsEnum.make(connectionStateResponse.getStatus()));
                                            this.connectionBeingChanged = null;
                                            this.transitionToState(BConnectionsStateEnum.descriptionFetched);
                                            this.connectionsStateLock.notifyAll();
                                        } else {
                                            BConnections.getLogger().info("rx " + connectionStateResponse.toLogString() + " - UNEXPECTED - Wrong Channel.");
                                        }
                                    } else {
                                        BConnections.getLogger().info("rx " + connectionStateResponse.toLogString() + " - UNKNOWN Channel ID.");
                                    }
                                } else {
                                    BConnections.getLogger().log(Level.SEVERE, "rx " + connectionStateResponse.toLogString() + " - connectionBeingChanged == null!");
                                }
                            } else {
                                BConnections.getLogger().info("rx " + connectionStateResponse.toLogString() + " - UNEXPECTED - No HeartBeat request pending.");
                            }
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                case 521: {
                    CoreDisconnectRequest disconnectRequest = null;
                    try {
                        disconnectRequest = (CoreDisconnectRequest)BKnxIpFrameTypeEnum.makeTypedFrame(frame);
                        if (!disconnectRequest.getHpai().getAddress().equals(BConnections.this.getControlEndPoint().getRemoteInetAddress())) {
                            BConnections.commsTrace("received HPAI Address " + disconnectRequest.getHpai().getAddress() + " dosen't match the expected Address " + BConnections.this.getControlEndPoint().getRemoteIPAddress());
                            return;
                        }
                        if (disconnectRequest.getHpai().getPort() != BConnections.this.getControlEndPoint().getRemotePort()) {
                            BConnections.commsTrace("received HPAI Port " + disconnectRequest.getHpai().getPort() + " dosen't match the expected Port " + BConnections.this.getControlEndPoint().getRemotePort());
                            return;
                        }
                        if (BConnections.this.connectionTraceEnabled()) {
                            BConnections.getLogger().fine("rx CORE DISCONNECT_REQUEST from " + BConnections.this.getControlEndPoint().getRemoteInetAddress() + ": for channel " + disconnectRequest.getChannelId());
                        }
                        CoreDisconnectResponse response = null;
                        BConnection connection = BConnections.this.getConnectionByChannelId(disconnectRequest.getChannelId());
                        if (connection != null && connection.handleDisconnectRequest(disconnectRequest)) {
                            response = new CoreDisconnectResponse(disconnectRequest.getChannelId(), 0);
                        }
                        if (response == null) {
                            response = new CoreDisconnectResponse(disconnectRequest.getChannelId(), 33);
                        }
                        this.sendDisconnectResponse(response);
                        return;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                default: {
                    BConnections.getLogger().log(Level.SEVERE, BConnections.this.getControlEndPoint().getRemoteInetAddress() + ": received invalid/unknown CORE service subtype - " + (Object)((Object)frame.frameHeader.frameType));
                }
            }
        }

        private void sendDisconnectResponse(CoreDisconnectResponse response) {
            if (BConnections.this.connectionTraceEnabled()) {
                BConnections.getLogger().fine("tx " + response.toLogString() + KnxIpFrame.getToDeviceLogString(BConnections.this.getControlEndPoint()));
            }
            try {
                BConnections.this.getControlEndPoint().send(response);
            }
            catch (IOException e) {
                BConnections.getLogger().log(Level.SEVERE, "Error sending disconnect response", e);
            }
        }

        public void spy(SpyWriter out) throws Exception {
            if (!BConnections.this.isRunning()) {
                return;
            }
            out.startProps();
            out.trTitle((Object)this.getClass().getName(), 2);
            out.prop((Object)"device", (Object)this.device);
            out.prop((Object)"deviceInetAddress", (Object)this.deviceInetAddress.getHostAddress());
            out.prop((Object)"deviceControlPortNumber", this.deviceControlPortNumber);
            out.prop((Object)"knxInstallation", (Object)this.knxInstallation);
            out.prop((Object)"interfaceInetAddress", (Object)(this.interfaceInetAddress == null ? "null" : this.interfaceInetAddress.getHostAddress()));
            out.prop((Object)"connectionsState", (Object)this.connectionsState);
            out.prop((Object)"mustClose", this.mustClose);
            out.prop((Object)"connectionBeingChanged", (Object)this.connectionBeingChanged);
            out.prop((Object)"attemptsRemaining", this.attemptsRemaining);
            out.prop((Object)"lastUsedConnectionIdx", this.lastUsedConnectionIdx);
            out.prop((Object)"rxPacketWorker", (Object)this.rxPacketWorker);
            out.endProps();
        }
    }
}

