/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridiumX.knxnetIp.comms.BAbstractLocalInterface;
import com.tridiumX.knxnetIp.comms.BEndPointCommsCounters;
import com.tridiumX.knxnetIp.comms.DumpComms;
import com.tridiumX.knxnetIp.comms.IEndPointListener;
import com.tridiumX.knxnetIp.comms.enums.BCommsStateEnum;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.util.BIIncludeInTrace;
import com.tridiumX.knxnetIp.util.CatchAll;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="endPointState", type="BCommsStateEnum", defaultValue="BCommsStateEnum.DEFAULT", flags=3), @NiagaraProperty(name="localIPAddress", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=3), @NiagaraProperty(name="localPort", type="int", defaultValue="Constants.NO_IP_PORT_NUMBER", flags=3), @NiagaraProperty(name="remoteIPAddress", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=3), @NiagaraProperty(name="remotePort", type="int", defaultValue="Constants.NO_IP_PORT_NUMBER", flags=3), @NiagaraProperty(name="maxPacketSize", type="int", defaultValue="KnxSpec.MAX_PACKET_LENGTH_DEFAULT", facets={@Facet(value="BFacets.makeInt(KnxSpec.MAX_PACKET_LENGTH_MINIMUM, KnxSpec.MAX_PACKET_LENGTH_MAXIMUM)")}), @NiagaraProperty(name="commsCounters", type="BEndPointCommsCounters", defaultValue="new BEndPointCommsCounters()", flags=65540), @NiagaraProperty(name="includeInTrace", type="boolean", defaultValue="true", flags=65540)})
@NiagaraAction(name="dumpSocket", flags=4)
public final class BEndPoint
extends BComponent
implements BIIncludeInTrace {
    public static final Property endPointState = BEndPoint.newProperty((int)3, (BValue)BCommsStateEnum.DEFAULT, null);
    public static final Property localIPAddress = BEndPoint.newProperty((int)3, (String)"", null);
    public static final Property localPort = BEndPoint.newProperty((int)3, (int)-1, null);
    public static final Property remoteIPAddress = BEndPoint.newProperty((int)3, (String)"", null);
    public static final Property remotePort = BEndPoint.newProperty((int)3, (int)-1, null);
    public static final Property maxPacketSize = BEndPoint.newProperty((int)0, (int)128, (BFacets)BFacets.makeInt((int)128, (int)512));
    public static final Property commsCounters = BEndPoint.newProperty((int)65540, (BValue)new BEndPointCommsCounters(), null);
    public static final Property includeInTrace = BEndPoint.newProperty((int)65540, (boolean)true, null);
    public static final Action dumpSocket = BEndPoint.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BEndPoint.class);
    private final Object openEndPointLock = new Object();
    private static final int MAX_OPEN_END_POINT_TRIES = 3;
    private static final int WAIT_FOR_END_POINT_STATE_TIMEOUT_MILLIS = 1000;
    private final Object endPointStateMonitor = new Object();
    private BAbstractLocalInterface localInterface = null;
    private InetAddress localInetAddress = null;
    private InetAddress remoteInetAddress = null;
    private final Object transmitLock = new Object();
    private long lastTxMessageTicks = 0L;
    private PacketReceiverThread packetRxThread = null;
    private IEndPointListener listener = null;
    private static final Logger logEndPoint = Logger.getLogger(TYPE.getModule().getModuleName() + ".comms.endpoint");

    public BCommsStateEnum getEndPointState() {
        return (BCommsStateEnum)this.get(endPointState);
    }

    public void setEndPointState(BCommsStateEnum v) {
        this.set(endPointState, (BValue)v, null);
    }

    public String getLocalIPAddress() {
        return this.getString(localIPAddress);
    }

    public void setLocalIPAddress(String v) {
        this.setString(localIPAddress, v, null);
    }

    public int getLocalPort() {
        return this.getInt(localPort);
    }

    public void setLocalPort(int v) {
        this.setInt(localPort, v, null);
    }

    public String getRemoteIPAddress() {
        return this.getString(remoteIPAddress);
    }

    public void setRemoteIPAddress(String v) {
        this.setString(remoteIPAddress, v, null);
    }

    public int getRemotePort() {
        return this.getInt(remotePort);
    }

    public void setRemotePort(int v) {
        this.setInt(remotePort, v, null);
    }

    public int getMaxPacketSize() {
        return this.getInt(maxPacketSize);
    }

    public void setMaxPacketSize(int v) {
        this.setInt(maxPacketSize, v, null);
    }

    public BEndPointCommsCounters getCommsCounters() {
        return (BEndPointCommsCounters)this.get(commsCounters);
    }

    public void setCommsCounters(BEndPointCommsCounters v) {
        this.set(commsCounters, (BValue)v, null);
    }

    @Override
    public boolean getIncludeInTrace() {
        return this.getBoolean(includeInTrace);
    }

    @Override
    public void setIncludeInTrace(boolean v) {
        this.setBoolean(includeInTrace, v, null);
    }

    public void dumpSocket() {
        this.invoke(dumpSocket, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return false;
    }

    public boolean isChildLegal(BComponent child) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property property, Context context) {
        Object object;
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(localPort) && this.getLocalPort() != -1) {
            object = this.endPointStateMonitor;
            synchronized (object) {
                if (this.packetRxThread != null) {
                    this.packetRxThread.updateThreadName();
                }
            }
        }
        if (property.equals(remotePort) && this.getRemotePort() != -1) {
            object = this.endPointStateMonitor;
            synchronized (object) {
                if (this.packetRxThread != null) {
                    this.packetRxThread.updateThreadName();
                }
            }
        }
    }

    public String toString(Context context) {
        return super.toString(context) + ": state=" + (Object)((Object)this.getEndPointState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDumpSocket() {
        Object object = this.endPointStateMonitor;
        synchronized (object) {
            if (this.packetRxThread == null) {
                System.out.println("packetRxThread == null");
            } else {
                this.packetRxThread.dumpSocket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openEndPoint(IEndPointListener listener, BAbstractLocalInterface localInterface, InetAddress localIp, InetAddress remoteIp, int localPort, int remotePort) throws SocketException {
        if (listener == null) {
            return;
        }
        if (localIp == null) {
            return;
        }
        if (remoteIp == null) {
            return;
        }
        Object object = this.openEndPointLock;
        synchronized (object) {
            Object object2;
            if (this.getEndPointState().equals((Object)BCommsStateEnum.open)) {
                if (localIp.equals(this.localInetAddress)) {
                    return;
                }
                this.closeEndPoint();
            }
            boolean stateOk = false;
            int i = 0;
            while (i < 3) {
                ++i;
                object2 = this.endPointStateMonitor;
                synchronized (object2) {
                    switch (this.getEndPointState().getOrdinal()) {
                        case 0: 
                        case 4: {
                            stateOk = true;
                            i = 3;
                            break;
                        }
                        default: {
                            try {
                                this.endPointStateMonitor.wait(1000L);
                                break;
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            }
            if (!stateOk) {
                throw new IllegalStateException("Cannot open EndPoint '" + this.getEndPointName() + "' - State seems stuck at '" + this.getEndPointState().getTag() + "'");
            }
            if (!this.getEndPointState().equals((Object)BCommsStateEnum.open)) {
                try {
                    this.setEndPointState(BCommsStateEnum.opening);
                    this.listener = listener;
                    this.localInterface = localInterface;
                    this.setLocalInetAddress(localIp);
                    this.setRemoteInetAddress(remoteIp);
                    this.setLocalPort(localPort);
                    this.setRemotePort(remotePort);
                    object2 = this.endPointStateMonitor;
                    synchronized (object2) {
                        this.packetRxThread = new PacketReceiverThread();
                        this.packetRxThread.start();
                        for (i = 0; i < 3; ++i) {
                            if (this.getEndPointState().equals((Object)BCommsStateEnum.open)) break;
                            try {
                                this.endPointStateMonitor.wait(1000L);
                                continue;
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                                break;
                            }
                            catch (Throwable t) {
                                CatchAll.throwable(t);
                                continue;
                            }
                        }
                        if (!this.getEndPointState().equals((Object)BCommsStateEnum.open)) {
                            throw new SocketException("unable to open the EndPoint");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.setEndPointState(BCommsStateEnum.fault);
                    throw new SocketException(ex.toString());
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
            }
        }
    }

    public String getEndPointName() {
        return this.getPropertyInParent().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeEndPoint() {
        Object object = this.openEndPointLock;
        synchronized (object) {
            if (this.getEndPointState().equals((Object)BCommsStateEnum.open)) {
                this.setEndPointState(BCommsStateEnum.closing);
            }
            if (this.packetRxThread != null) {
                try {
                    this.packetRxThread.requestClose();
                    while (this.packetRxThread.isAlive()) {
                        if (BEndPoint.getLogger().isLoggable(Level.FINE)) {
                            BEndPoint.getLogger().fine(String.format("%s waiting to close, state: [%s/%s]", this.packetRxThread.getName(), this.packetRxThread.isAlive(), this.packetRxThread.isInterrupted()));
                        }
                        try {
                            this.packetRxThread.join(1500L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.packetRxThread = null;
            } else if (!this.getEndPointState().equals((Object)BCommsStateEnum.closed)) {
                BEndPoint.getLogger().log(Level.SEVERE, "packetRxThread == null AND endPointState [ '" + this.getEndPointState().getTag() + "' ] != closed");
                this.setEndPointState(BCommsStateEnum.fault);
            }
            this.setLocalInetAddress(null);
            this.setRemoteInetAddress(null);
            this.setRemotePort(-1);
        }
    }

    public InetAddress getLocalInetAddress() {
        return this.localInetAddress;
    }

    private void setLocalInetAddress(InetAddress localIp) {
        this.localInetAddress = localIp;
        this.setLocalIPAddress(localIp == null ? "" : localIp.getHostAddress());
    }

    public InetAddress getRemoteInetAddress() {
        return this.remoteInetAddress;
    }

    private void setRemoteInetAddress(InetAddress remoteIp) {
        this.remoteInetAddress = remoteIp;
        this.setRemoteIPAddress(remoteIp == null ? "" : remoteIp.getHostAddress());
    }

    public boolean isEndPointOpen() {
        return this.getEndPointState().equals((Object)BCommsStateEnum.open);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endPointOpened() {
        Object object = this.endPointStateMonitor;
        synchronized (object) {
            if (this.getEndPointState().equals((Object)BCommsStateEnum.opening)) {
                this.setEndPointState(BCommsStateEnum.open);
            }
            this.endPointStateMonitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endPointClosed() {
        Object object = this.endPointStateMonitor;
        synchronized (object) {
            if (this.getEndPointState().equals((Object)BCommsStateEnum.closing)) {
                this.setEndPointState(BCommsStateEnum.closed);
            }
            this.endPointStateMonitor.notify();
        }
    }

    private void receiveDatagramPacket(DatagramPacket packet, DatagramSocket ipSocket) {
        KnxIpFrame frame = KnxIpFrame.make(packet);
        frame.rxInterfaceId = this.localInterface.getLocalInterfaceId();
        frame.rxLocalAddress = ipSocket.getLocalAddress();
        frame.rxLocalPort = ipSocket.getLocalPort();
        this.getCommsCounters().incCounter(BEndPointCommsCounters.packetsReceived);
        if (this.getIncludeInTrace() && BEndPoint.getLogger().isLoggable(Level.FINE)) {
            BEndPoint.getLogger().fine(this.getEndPointName() + " rx packet [ " + ByteArrayUtil.toHexString((byte[])packet.getData(), (int)packet.getOffset(), (int)packet.getLength(), (String)" ") + " ] from Device " + packet.getAddress().getHostAddress() + ":" + packet.getPort() + " via LocalInterfaceId " + frame.rxInterfaceId + " " + frame.rxLocalAddress.getHostAddress() + ":" + frame.rxLocalPort);
        }
        switch (frame.validationResult.getOrdinal()) {
            case 7: {
                if (this.listener != null) {
                    this.listener.receiveFrame(frame);
                    break;
                }
                this.getCommsCounters().incCounter(BEndPointCommsCounters.framesLostBecauseListenerIsNull);
                if (!this.getIncludeInTrace() || !BEndPoint.getLogger().isLoggable(Level.FINE)) break;
                BEndPoint.getLogger().fine("listener == null");
                break;
            }
            case 3: {
                this.getCommsCounters().incCounter(BEndPointCommsCounters.framesReceivedWithUnsupportedProtocolVersion);
                BEndPoint.getLogger().log(Level.SEVERE, "Invalid Frame Header Received - " + frame.validationResult.getTag() + " - " + frame.frameHeader.protocolVersion);
                break;
            }
            default: {
                this.getCommsCounters().incCounter(BEndPointCommsCounters.invalidFrameHeaders);
                BEndPoint.getLogger().log(Level.SEVERE, "Invalid Frame Header Received - " + frame.validationResult.getTag());
                return;
            }
        }
    }

    public void send(KnxIpFrame request, InetAddress remoteAddress, int remotePortNumber) throws IllegalArgumentException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("'request' is NULL");
        }
        if (remoteAddress == null) {
            throw new IOException("'remoteAddress' is NULL");
        }
        if (remotePortNumber < 0 || remotePortNumber > 65535) {
            throw new IllegalArgumentException("'remotePortNumber' = " + remotePortNumber + " is NOT valid.");
        }
        if (!this.isEndPointOpen()) {
            throw new IOException("EndPoint is CLOSED");
        }
        byte[] bytes = request.getBytes();
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, remoteAddress, remotePortNumber);
        if (this.packetRxThread != null) {
            this.getCommsCounters().incCounter(BEndPointCommsCounters.packetsSent);
            this.packetRxThread.send(packet);
        }
    }

    public void send(KnxIpFrame request) throws IOException {
        this.send(request, this.remoteInetAddress, this.getRemotePort());
    }

    public void transmit(KnxIpFrame request, long interMessageDelay) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("'request' is NULL");
        }
        if (this.remoteInetAddress == null) {
            throw new IOException("'remoteInetAddress is NULL");
        }
        if (!this.isEndPointOpen()) {
            throw new IOException("EndPoint is CLOSED");
        }
        byte[] bytes = request.getBytes();
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.remoteInetAddress, this.getRemotePort());
        this.transmit(packet, interMessageDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transmit(DatagramPacket packet, long interMessageDelay) throws IOException {
        Object object = this.transmitLock;
        synchronized (object) {
            this.performInterMessageDelay(interMessageDelay);
            if (this.packetRxThread != null) {
                try {
                    this.getCommsCounters().incCounter(BEndPointCommsCounters.packetsSentWithInterMessageDelay);
                    this.packetRxThread.send(packet);
                    this.lastTxMessageTicks = Clock.ticks();
                }
                catch (BindException e) {
                    BEndPoint.getLogger().log(Level.SEVERE, packet.getAddress().getHostAddress() + " " + e.getMessage());
                    throw new IOException(e.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new IOException(ex.toString());
                }
            } else {
                BEndPoint.getLogger().log(Level.SEVERE, "cannot transmit packet because 'packetRxThread' is NULL");
                throw new IOException("cannot transmit packet because 'packetRxThread' is NULL");
            }
        }
    }

    private void performInterMessageDelay(long interMessageDelay) {
        long minDelay = Math.max(interMessageDelay, 15L);
        long difference = Clock.ticks() - this.lastTxMessageTicks;
        if (difference >= minDelay) {
            return;
        }
        long sleepTime = Math.max(minDelay - difference, 15L);
        try {
            Thread.sleep(sleepTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Logger getLogger() {
        return logEndPoint;
    }

    final class PacketReceiverThread
    extends Thread {
        private boolean pktReceiverAlive = false;
        private boolean goodSocket = false;
        private boolean mustClose = false;
        private InetAddress ignoreInetAddress = null;
        private DatagramSocket ipSocket = null;
        private final Object ipSocketLock = new Object();

        PacketReceiverThread() {
        }

        public final void updateThreadName() {
            this.setName(BEndPoint.this.getEndPointName() + "PktRx" + BEndPoint.this.getLocalInetAddress().getHostAddress() + "P" + BEndPoint.this.getLocalPort() + "Rmt" + BEndPoint.this.getRemoteInetAddress().getHostAddress() + "Port" + BEndPoint.this.getRemotePort());
        }

        @Override
        public final void run() {
            this.updateThreadName();
            this.pktReceiverAlive = true;
            while (this.pktReceiverAlive && !this.mustClose) {
                if (!this.goodSocket) {
                    try {
                        this.openSocket();
                        this.goodSocket = true;
                        Thread.sleep(1000L);
                        BEndPoint.this.endPointOpened();
                    }
                    catch (IOException ex) {
                        this.pktReceiverAlive = false;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        this.pktReceiverAlive = false;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        this.pktReceiverAlive = false;
                    }
                    continue;
                }
                try {
                    byte[] packBuf = new byte[BEndPoint.this.getMaxPacketSize()];
                    DatagramPacket incomingPacket = new DatagramPacket(packBuf, packBuf.length);
                    this.ipSocket.receive(incomingPacket);
                    if (!incomingPacket.getAddress().equals(this.ignoreInetAddress)) {
                        BEndPoint.this.receiveDatagramPacket(incomingPacket, this.ipSocket);
                        continue;
                    }
                    BEndPoint.this.getCommsCounters().incCounter(BEndPointCommsCounters.rxOwnPacketsIgnored);
                    if (!BEndPoint.this.getIncludeInTrace() || !BEndPoint.getLogger().isLoggable(Level.FINE)) continue;
                    BEndPoint.getLogger().fine("received packet was sent by this EndPoints adapter, so ignore it.");
                }
                catch (NullPointerException e) {
                    if (this.ipSocket == null) {
                        BEndPoint.getLogger().log(Level.SEVERE, "DatagramSocket is null");
                    }
                    e.printStackTrace();
                    break;
                }
                catch (SocketTimeoutException e) {
                }
                catch (InterruptedIOException ex) {
                    BEndPoint.getLogger().info("InterruptedIOException: " + ex.toString());
                }
                catch (SocketException e) {
                    e.printStackTrace();
                    if (!this.pktReceiverAlive) continue;
                    this.goodSocket = false;
                    BEndPoint.this.endPointClosed();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    BEndPoint.getLogger().log(Level.SEVERE, "Error receiving KNXnet/IP packet!", e);
                }
                catch (Throwable t) {
                    BEndPoint.getLogger().log(Level.SEVERE, "Unknown exception in KNXnet/IP End Point:", t);
                }
            }
            this.closeSocket();
            BEndPoint.this.endPointClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dumpSocket() {
            Object object = this.ipSocketLock;
            synchronized (object) {
                if (this.ipSocket == null) {
                    System.out.println("ipSocket == null");
                } else {
                    DumpComms.dumpSocket(this.ipSocket);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeSocket() {
            Object object = this.ipSocketLock;
            synchronized (object) {
                if (this.ipSocket != null) {
                    if (BEndPoint.this.remoteInetAddress.isMulticastAddress()) {
                        BEndPoint.this.localInterface.releaseAMulticastSocket(this.ipSocket);
                    } else {
                        if (this.ipSocket.isConnected()) {
                            this.ipSocket.disconnect();
                        }
                        BEndPoint.this.localInterface.releaseALocalSocket(this.ipSocket);
                    }
                    BEndPoint.this.setLocalPort(-1);
                }
                BEndPoint.this.listener = null;
                BEndPoint.this.localInterface = null;
                this.ipSocket = null;
                this.ignoreInetAddress = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openSocket() throws SocketException {
            Object object = this.ipSocketLock;
            synchronized (object) {
                if (this.ipSocket != null) {
                    StringBuffer sb = new StringBuffer("Socket is ALREADY OPEN");
                    sb.append(" - ").append(this.ipSocket.getLocalAddress().getHostAddress());
                    sb.append(":").append(this.ipSocket.getLocalPort());
                    throw new SocketException(sb.toString());
                }
                DatagramSocket socket = null;
                if (BEndPoint.this.remoteInetAddress.isMulticastAddress()) {
                    try {
                        socket = BEndPoint.this.localInterface.obtainAMulticastSocket(BEndPoint.this.remoteInetAddress, BEndPoint.this.getRemotePort());
                    }
                    catch (SocketException ex) {
                        BEndPoint.getLogger().log(Level.SEVERE, "unable to obtain the 'Multicast' socket.", ex);
                        throw new SocketException("unable to obtain the 'Multicast' socket");
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                    }
                    if (BEndPoint.this.getIncludeInTrace() && BEndPoint.getLogger().isLoggable(Level.FINE)) {
                        BEndPoint.getLogger().fine("setting EndPoint socket, EndPoint Port=" + (socket == null ? "null" : Integer.toString(socket.getLocalPort())));
                    }
                    this.ipSocket = socket;
                } else {
                    try {
                        socket = BEndPoint.this.localInterface.obtainALocalSocket(BEndPoint.this.getLocalPort());
                        if (BEndPoint.this.getIncludeInTrace() && BEndPoint.getLogger().isLoggable(Level.FINE)) {
                            BEndPoint.getLogger().fine("setting EndPoint socket, EndPoint Port=" + socket.getLocalPort());
                        }
                        BEndPoint.this.setLocalPort(socket.getLocalPort());
                    }
                    catch (SocketException ex) {
                        BEndPoint.getLogger().log(Level.SEVERE, "unable to create an EndPoint socket.", ex);
                        throw ex;
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                    }
                    this.ipSocket = socket;
                    this.ignoreInetAddress = BEndPoint.this.localInterface.getLocalAddress();
                }
                if (this.ipSocket == null) {
                    throw new SocketException("unable to open the local port " + BEndPoint.this.getLocalPort());
                }
                if (BEndPoint.this.getIncludeInTrace() && BEndPoint.getLogger().isLoggable(Level.FINE)) {
                    BEndPoint.getLogger().fine("using port " + BEndPoint.this.getLocalPort());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(DatagramPacket packet) throws IllegalArgumentException, IOException {
            if (packet == null) {
                throw new IllegalArgumentException("'packet' is NULL");
            }
            Object object = this.ipSocketLock;
            synchronized (object) {
                block12: {
                    if (this.ipSocket == null) {
                        throw new IOException("'ipSocket' is NULL");
                    }
                    if (!this.ipSocket.isBound()) {
                        throw new IOException("'ipSocket' is NOT BOUND");
                    }
                    if (this.ipSocket.isClosed()) {
                        throw new IOException("'ipSocket' is CLOSED");
                    }
                    if (BEndPoint.this.getIncludeInTrace() && BEndPoint.getLogger().isLoggable(Level.FINE)) {
                        BEndPoint.getLogger().fine(BEndPoint.this.getEndPointName() + " tx packet [ " + ByteArrayUtil.toHexString((byte[])packet.getData(), (String)" ") + " ] to Device " + packet.getAddress().getHostAddress() + ":" + packet.getPort() + " via LocalInterface " + this.ipSocket.getLocalAddress().getHostAddress() + ":" + this.ipSocket.getLocalPort());
                    }
                    if (this.ipSocket != null) {
                        try {
                            this.ipSocket.send(packet);
                        }
                        catch (IOException ex) {
                            throw ex;
                        }
                        catch (Throwable t) {
                            CatchAll.throwable(t);
                            if (!(t instanceof ThreadDeath)) break block12;
                            throw (ThreadDeath)t;
                        }
                    }
                }
            }
        }

        void requestClose() {
            this.mustClose = true;
            this.interrupt();
        }
    }
}

