/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridiumX.knxnetIp.addresses.BGroupAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyle;
import com.tridiumX.knxnetIp.comms.ICommsConnection;
import com.tridiumX.knxnetIp.comms.IConnectionClient;
import com.tridiumX.knxnetIp.comms.ILDataConnection;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessage;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.comms.enums.BSendCemiMessageResultEnum;
import com.tridiumX.knxnetIp.comms.frames.ConnectedRequestIpFrame;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.knxSpec.BApciCodesEnum;
import com.tridiumX.knxnetIp.knxSpec.BCemiMessageCodesEnum;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import com.tridiumX.knxnetIp.util.BKnxWorker;
import com.tridiumX.knxnetIp.util.CatchAll;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="lDataWorker", type="BKnxWorker", defaultValue="BKnxWorker.make(BGroupDataManager.L_DATA_WORKER_NAME, Constants.L_DATA_MANAGER_QUEUE_SIZE_DEFAULT)", flags=5, facets={@Facet(value="BFacets.make(BFacets.MIN, Constants.L_DATA_MANAGER_QUEUE_SIZE_MINIMUM)")}), @NiagaraProperty(name="hopCount", type="int", defaultValue="KnxSpec.HOP_COUNT_DEFAULT", flags=4, facets={@Facet(value="BFacets.makeInt(KnxSpec.HOP_COUNT_MINIMUM, KnxSpec.HOP_COUNT_MAXIMUM)")}), @NiagaraProperty(name="maxPendingReads", type="int", defaultValue="KnxSpec.PENDING_DATA_LINK_LAYER_READS_DEFAULT", facets={@Facet(value="BFacets.make(BFacets.MIN, KnxSpec.PENDING_DATA_LINK_LAYER_READS_MINIMUM)"), @Facet(value="BFacets.make(BFacets.MAX, KnxSpec.PENDING_DATA_LINK_LAYER_READS_MAXIMUM)")}), @NiagaraProperty(name="readBeforeWriteTimeout", type="BRelTime", defaultValue="BRelTime.make(KnxSpec.DATA_LINK_LAYER_READ_REPLY_TIMEOUT_MILLIS_DEFAULT)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE)"), @Facet(value="BFacets.make(BFacets.MIN, BRelTime.make(KnxSpec.DATA_LINK_LAYER_READ_REPLY_TIMEOUT_MILLIS_MINIMUM))"), @Facet(value="BFacets.make(BFacets.MAX, BRelTime.make(KnxSpec.DATA_LINK_LAYER_READ_REPLY_TIMEOUT_MILLIS_MAXIMUM))")})})
@NiagaraActions(value={@NiagaraAction(name="dumpObjectMap"), @NiagaraAction(name="checkPendingReads", flags=4)})
public final class BGroupDataManager
extends BDeviceExt
implements IConnectionClient {
    public static final Property lDataWorker = BGroupDataManager.newProperty((int)5, (BValue)BKnxWorker.make("LDataWorker", 1000), (BFacets)BFacets.make((String)"min", (int)2));
    public static final Property hopCount = BGroupDataManager.newProperty((int)4, (int)6, (BFacets)BFacets.makeInt((int)0, (int)7));
    public static final Property maxPendingReads = BGroupDataManager.newProperty((int)0, (int)4, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)10)));
    public static final Property readBeforeWriteTimeout = BGroupDataManager.newProperty((int)0, (BValue)BRelTime.make((long)500L), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)6000L))));
    public static final Action dumpObjectMap = BGroupDataManager.newAction((int)0, null);
    public static final Action checkPendingReads = BGroupDataManager.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BGroupDataManager.class);
    private final Object groupAddressMapLock = new Object();
    private final IntHashMap groupAddressMap = new IntHashMap(100);
    private final Object dataConnectionLock = new Object();
    private ILDataConnection dataConnection;
    private final Object sendRequestLock = new Object();
    private final Object writeMonitor = new Object();
    private LDataWriteOperation writeOperation;
    private CemiMessage readBeforeWriteMsg;
    private final Object pendingReadsMapLock = new Object();
    private final IntHashMap pendingReadsMap = new IntHashMap();
    private Clock.Ticket pendingReadsTicket;
    private static final String L_DATA_WORKER_NAME = "LDataWorker";
    public static final BIcon groupIcon = BIcon.make((String)"module://icons/x16/r2/group.png");

    public BKnxWorker getLDataWorker() {
        return (BKnxWorker)this.get(lDataWorker);
    }

    public void setLDataWorker(BKnxWorker v) {
        this.set(lDataWorker, (BValue)v, null);
    }

    public int getHopCount() {
        return this.getInt(hopCount);
    }

    public void setHopCount(int v) {
        this.setInt(hopCount, v, null);
    }

    public int getMaxPendingReads() {
        return this.getInt(maxPendingReads);
    }

    public void setMaxPendingReads(int v) {
        this.setInt(maxPendingReads, v, null);
    }

    public BRelTime getReadBeforeWriteTimeout() {
        return (BRelTime)this.get(readBeforeWriteTimeout);
    }

    public void setReadBeforeWriteTimeout(BRelTime v) {
        this.set(readBeforeWriteTimeout, (BValue)v, null);
    }

    public void dumpObjectMap() {
        this.invoke(dumpObjectMap, null, null);
    }

    public void checkPendingReads() {
        this.invoke(checkPendingReads, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BKnxDevice;
    }

    public boolean isChildLegal(BComponent child) {
        return false;
    }

    public BIcon getIcon() {
        return groupIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus() {
        Object object = this.dataConnectionLock;
        synchronized (object) {
            if (this.dataConnection != null) {
                BKnxDevice device = (BKnxDevice)this.getDevice();
                if (device != null && !device.isDisabled() && !device.isFault()) {
                    this.dataConnection.registerClient(this);
                    return;
                }
                this.dataConnection.unregisterClient(this);
            }
        }
    }

    @Override
    public void connectionOpened() {
        try {
            BKnxDevice device = (BKnxDevice)this.getDevice();
            if (device != null && device.isRunning()) {
                device.pingOk();
            }
        }
        catch (Throwable t) {
            CatchAll.throwable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosing() {
        try {
            BKnxDevice device = (BKnxDevice)this.getDevice();
            if (device != null && device.isRunning()) {
                device.pingFail("Connection closed.");
            }
        }
        catch (Exception e) {
            CatchAll.throwable(e);
        }
        Object object = this.writeMonitor;
        synchronized (object) {
            this.writeMonitor.notifyAll();
        }
        this.clearOutstandingReads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOutstandingReads() {
        try {
            Object object = this.pendingReadsMapLock;
            synchronized (object) {
                this.pendingReadsMap.clear();
            }
        }
        catch (Exception e) {
            CatchAll.throwable(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processCemiMessage(ICommsConnection connection, ConnectedRequestIpFrame frame) {
        CemiMessage msg = frame.getCemi();
        if (msg.getCemiMessageCode().equals((Object)BCemiMessageCodesEnum.L_Data_ind) && (msg.getApciCode().equals((Object)BApciCodesEnum.A_GroupValue_Response_PDU) || msg.getApciCode().equals((Object)BApciCodesEnum.A_GroupValue_Write_PDU))) {
            int key = msg.getDestination().getAddress();
            Object object = this.writeMonitor;
            synchronized (object) {
                if (this.writeOperation != null && this.writeOperation.destination.getAddress() == key) {
                    this.readBeforeWriteMsg = msg;
                    this.writeMonitor.notify();
                }
            }
            object = this.pendingReadsMapLock;
            synchronized (object) {
                if (this.pendingReadsMap.containsKey(key)) {
                    this.pendingReadsMap.remove(key);
                    this.pendingReadsMapLock.notify();
                }
            }
            Vector<BKnxProxyExt> v = this.getGroupedExtensions(key);
            ThreadDeath caughtThreadDeath = null;
            for (int i = 0; i < v.size(); ++i) {
                BKnxProxyExt ext = v.elementAt(i);
                try {
                    ext.setValue(msg);
                    continue;
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                    if (!(t instanceof ThreadDeath)) continue;
                    caughtThreadDeath = (ThreadDeath)t;
                }
            }
            if (caughtThreadDeath != null) {
                throw caughtThreadDeath;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerProxyExt(BKnxProxyExt ext) {
        boolean addressesRegistered = false;
        Object object = this.groupAddressMapLock;
        synchronized (object) {
            IntHashMap.Iterator iterator = ext.getGroupAddresses().getGroups().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                int newKey = iterator.key();
                if (newKey == 0) continue;
                Vector<BKnxProxyExt> extensionsInGroup = this.getGroupedExtensions(newKey);
                if (extensionsInGroup.isEmpty()) {
                    this.groupAddressMap.put(newKey, extensionsInGroup);
                }
                if (!extensionsInGroup.contains(ext)) {
                    extensionsInGroup.add(ext);
                }
                addressesRegistered = true;
            }
            if (!this.groupAddressMap.isEmpty()) {
                // empty if block
            }
        }
        return addressesRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProxyExt(BKnxProxyExt ext) {
        Object object = this.groupAddressMapLock;
        synchronized (object) {
            IntHashMap.Iterator iterator = this.groupAddressMap.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                int newKey = iterator.key();
                if (newKey == 0) continue;
                Vector<BKnxProxyExt> v = this.getGroupedExtensions(newKey);
                while (v.contains(ext)) {
                    v.removeElement(ext);
                }
                if (!v.isEmpty()) continue;
                this.groupAddressMap.remove(newKey);
            }
            if (this.groupAddressMap.isEmpty()) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<BKnxProxyExt> getGroupedExtensions(int address) {
        Vector groupedExtensions = null;
        try {
            Object object = this.groupAddressMapLock;
            synchronized (object) {
                groupedExtensions = (Vector)this.groupAddressMap.get(address);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Error getting groupedExtensions", e);
        }
        if (groupedExtensions == null) {
            groupedExtensions = new Vector();
        }
        return groupedExtensions;
    }

    public void doDumpObjectMap() {
        IntHashMap.Iterator iterator = this.groupAddressMap.iterator();
        StringBuffer sb = new StringBuffer();
        sb.append("---ALL GROUPS---\n");
        while (iterator.hasNext()) {
            Vector v = (Vector)iterator.next();
            sb.append("  group key:" + BKnxAddressStyle.kas3LevelGroup.getFriendlyAddress(new BGroupAddress(iterator.key())) + " ");
            sb.append("  group key:" + BKnxAddressStyle.kas3LevelGroup.getFriendlyAddress(new BGroupAddress(iterator.key())) + " ");
            for (int i = 0; i < v.size(); ++i) {
                BComponent comp = (BComponent)v.get(i);
                sb.append(comp.getParent().getDisplayName(null)).append("  ");
            }
            sb.append("\n");
        }
        this.getLogger().info(sb.toString());
    }

    public IFuture postRead(BKnxProxyExt originator, BGroupAddress sourceAddress) {
        LDataReadOperation operation = new LDataReadOperation(originator, sourceAddress);
        return this.getLDataWorker().post(operation);
    }

    public IFuture postWrite(BKnxProxyExt originator, BGroupAddress destination, BDataValueTypeDef def, CemiMessageData msgData) {
        LDataWriteOperation operation = new LDataWriteOperation(originator, destination, def, msgData);
        return this.getLDataWorker().post(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDataConnection(ILDataConnection connection) {
        Object object = this.dataConnectionLock;
        synchronized (object) {
            BKnxDevice device;
            if (!(this.dataConnection == null || connection != null && this.dataConnection.equals(connection))) {
                try {
                    this.dataConnection.unregisterClient(this);
                }
                finally {
                    this.dataConnection = null;
                }
            }
            if (this.dataConnection == null) {
                this.dataConnection = connection;
            }
            if (this.dataConnection != null && (device = (BKnxDevice)this.getDevice()) != null && !device.isDisabled() && !device.isFault()) {
                this.dataConnection.registerClient(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.dataConnectionLock;
        synchronized (object) {
            if (this.dataConnection != null) {
                return this.dataConnection.isConnected();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BSendCemiMessageResultEnum sendReadRequest(BGroupAddress groupAddress) {
        Object object = this.sendRequestLock;
        synchronized (object) {
            if (!this.isConnected()) {
                return BSendCemiMessageResultEnum.notConnected;
            }
            Object object2 = this.pendingReadsMapLock;
            synchronized (object2) {
                while (this.pendingReadsMap.size() >= this.getMaxPendingReads()) {
                    try {
                        this.pendingReadsMapLock.wait(100L);
                    }
                    catch (InterruptedException ex) {
                        if (!this.isTraceHandledExceptionsOn()) continue;
                        ex.printStackTrace();
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
            }
            BSendCemiMessageResultEnum result = this.dataConnection.sendLDataReadRequest(this.getHopCount(), groupAddress);
            if (result.equals((Object)BSendCemiMessageResultEnum.good)) {
                Object object3 = this.pendingReadsMapLock;
                synchronized (object3) {
                    int key = groupAddress.getAddress();
                    if (this.pendingReadsMap.containsKey(key)) {
                        ((PendingRead)this.pendingReadsMap.get(key)).ticks = Clock.ticks() + 3000L;
                    } else {
                        this.pendingReadsMap.put(key, (Object)new PendingRead(key, Clock.ticks() + 3000L));
                    }
                    if (this.pendingReadsTicket == null) {
                        this.pendingReadsTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)3000L), (Action)checkPendingReads, null);
                    }
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BSendCemiMessageResultEnum sendWriteRequest(LDataWriteOperation operation, BGroupAddress groupAddress, CemiMessageData msgData) {
        Object object = this.sendRequestLock;
        synchronized (object) {
            BSendCemiMessageResultEnum bSendCemiMessageResultEnum;
            block30: {
                BSendCemiMessageResultEnum bSendCemiMessageResultEnum2;
                block29: {
                    BSendCemiMessageResultEnum bSendCemiMessageResultEnum3;
                    block28: {
                        if (!this.isConnected()) {
                            return BSendCemiMessageResultEnum.notConnected;
                        }
                        if (!operation.readModifyWrite) {
                            return this.dataConnection.sendLDataWriteRequest(this.getHopCount(), groupAddress, msgData);
                        }
                        Object object2 = this.writeMonitor;
                        synchronized (object2) {
                            try {
                                this.writeOperation = operation;
                                this.readBeforeWriteMsg = null;
                                BSendCemiMessageResultEnum result = this.sendReadRequest(groupAddress);
                                if (result.equals((Object)BSendCemiMessageResultEnum.good)) {
                                    block26: {
                                        try {
                                            this.writeMonitor.wait(this.getReadBeforeWriteTimeout().getMillis());
                                            try {
                                                if (this.readBeforeWriteMsg != null) break block26;
                                                bSendCemiMessageResultEnum3 = BSendCemiMessageResultEnum.confirmTimedOut;
                                            }
                                            catch (Exception e) {
                                                if (this.isTraceHandledExceptionsOn()) {
                                                    e.printStackTrace();
                                                }
                                                BSendCemiMessageResultEnum bSendCemiMessageResultEnum4 = BSendCemiMessageResultEnum.exception;
                                                return bSendCemiMessageResultEnum4;
                                            }
                                        }
                                        catch (Exception e) {
                                            if (this.isTraceHandledExceptionsOn()) {
                                                e.printStackTrace();
                                            }
                                            BSendCemiMessageResultEnum bSendCemiMessageResultEnum5 = BSendCemiMessageResultEnum.exception;
                                            return bSendCemiMessageResultEnum5;
                                        }
                                        break block28;
                                    }
                                    CemiMessageData rxData = this.readBeforeWriteMsg.getData();
                                    for (int i = 0; i < operation.msgData.data.length; ++i) {
                                        int n = i;
                                        rxData.data[n] = (byte)(rxData.data[n] & ~operation.msgData.mask[i]);
                                        int n2 = i;
                                        rxData.data[n2] = (byte)(rxData.data[n2] | operation.msgData.data[i]);
                                    }
                                    operation.writtenData = rxData;
                                    bSendCemiMessageResultEnum2 = this.dataConnection.sendLDataWriteRequest(this.getHopCount(), groupAddress, rxData);
                                    break block29;
                                }
                                bSendCemiMessageResultEnum = result;
                                break block30;
                            }
                            catch (Exception e) {
                                if (this.isTraceHandledExceptionsOn()) {
                                    e.printStackTrace();
                                }
                                BSendCemiMessageResultEnum bSendCemiMessageResultEnum6 = BSendCemiMessageResultEnum.exception;
                                return bSendCemiMessageResultEnum6;
                            }
                        }
                    }
                    return bSendCemiMessageResultEnum3;
                }
                return bSendCemiMessageResultEnum2;
            }
            return bSendCemiMessageResultEnum;
            {
                finally {
                    this.writeOperation = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckPendingReads() {
        Object object = this.pendingReadsMapLock;
        synchronized (object) {
            PendingRead pendingRead;
            if (this.pendingReadsTicket != null) {
                this.pendingReadsTicket.cancel();
                this.pendingReadsTicket = null;
            }
            IntHashMap.Iterator iterator = this.pendingReadsMap.iterator();
            long now = Clock.ticks();
            while (iterator.hasNext()) {
                pendingRead = (PendingRead)iterator.next();
                if (now < pendingRead.ticks) continue;
                Vector<BKnxProxyExt> v = this.getGroupedExtensions(pendingRead.groupAddress);
                for (int i = 0; i < v.size(); ++i) {
                    BKnxProxyExt ext = v.elementAt(i);
                    try {
                        ext.readFail("no Data following CONfirmation");
                        continue;
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
                this.pendingReadsMap.remove(pendingRead.groupAddress);
            }
            iterator = null;
            iterator = this.pendingReadsMap.iterator();
            if (iterator.hasNext()) {
                pendingRead = (PendingRead)iterator.next();
                this.pendingReadsTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)Math.max(10L, pendingRead.ticks - now)), (Action)checkPendingReads, null);
            }
        }
    }

    private boolean isTraceHandledExceptionsOn() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    private Logger getLogger() {
        BDevice device = this.getDevice();
        return device == null ? Logger.getLogger(this.getType().getTypeName()) : device.getLogger();
    }

    private final class LDataWriteOperation
    implements Runnable,
    ICoalesceable {
        protected final BKnxProxyExt originator;
        protected final BGroupAddress destination;
        protected final boolean readModifyWrite;
        protected final int hashCode;
        protected final CemiMessageData msgData;
        private Vector<LDataWriteOperation> mergedWrites;
        protected CemiMessageData writtenData;

        private LDataWriteOperation(BKnxProxyExt originator, BGroupAddress destination, BDataValueTypeDef def, CemiMessageData msgData) {
            this.originator = originator;
            this.destination = destination;
            this.msgData = msgData;
            this.readModifyWrite = def.isAField();
            this.hashCode = this.readModifyWrite ? destination.hashCode() : originator.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            ThreadDeath caughtThreadDeath = null;
            try {
                CemiMessageData data;
                BSendCemiMessageResultEnum result;
                block19: {
                    result = BGroupDataManager.this.sendWriteRequest(this, this.destination, this.msgData);
                    data = this.readModifyWrite ? this.writtenData : this.msgData;
                    try {
                        this.originator.writeCompleted(result, data);
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                        if (!(t instanceof ThreadDeath)) break block19;
                        throw (ThreadDeath)t;
                    }
                }
                if (this.mergedWrites == null) return;
                for (LDataWriteOperation op : this.mergedWrites) {
                    try {
                        op.originator.writeCompleted(result, data);
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                        return;
                    }
                }
            }
            catch (Throwable t) {
                String failCause;
                block20: {
                    CatchAll.throwable(t);
                    if (t instanceof ThreadDeath) {
                        caughtThreadDeath = (ThreadDeath)t;
                    }
                    failCause = t.toString();
                    try {
                        this.originator.writeFail(failCause);
                    }
                    catch (Throwable t2) {
                        CatchAll.throwable(t2);
                        if (!(t2 instanceof ThreadDeath)) break block20;
                        caughtThreadDeath = (ThreadDeath)t2;
                    }
                }
                if (this.mergedWrites != null) {
                    for (LDataWriteOperation op : this.mergedWrites) {
                        try {
                            op.originator.writeFail(failCause);
                        }
                        catch (Throwable t2) {
                            CatchAll.throwable(t2);
                            if (!(t2 instanceof ThreadDeath)) continue;
                            caughtThreadDeath = (ThreadDeath)t2;
                        }
                    }
                }
            }
            finally {
                if (caughtThreadDeath != null) {
                    throw caughtThreadDeath;
                }
            }
        }

        public Object getCoalesceKey() {
            return this;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            if (this.readModifyWrite) {
                LDataWriteOperation two = (LDataWriteOperation)c;
                if (this.msgData.data.length == two.msgData.data.length && this.msgData.shouldOptimize() == two.msgData.shouldOptimize()) {
                    for (int i = 0; i < this.msgData.data.length; ++i) {
                        this.msgData.data[i] = (byte)(this.msgData.data[i] & ~two.msgData.mask[i] | two.msgData.data[i]);
                        int n = i;
                        this.msgData.mask[n] = (byte)(this.msgData.mask[n] | two.msgData.mask[i]);
                    }
                    if (this.mergedWrites == null) {
                        this.mergedWrites = new Vector(1, 1);
                    }
                    this.mergedWrites.add(two);
                }
                return this;
            }
            return c;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof LDataWriteOperation) {
                LDataWriteOperation o = (LDataWriteOperation)object;
                if (this.readModifyWrite) {
                    return this.destination.getAddress() == o.destination.getAddress() && this.readModifyWrite == o.readModifyWrite && this.msgData.data.length == o.msgData.data.length && this.msgData.shouldOptimize() == o.msgData.shouldOptimize();
                }
                return this.originator == o.originator;
            }
            return false;
        }

        public String toString() {
            return "LDataWriteOperation (" + ("originator=" + (this.originator == null ? "null" : this.originator.toString())) + (", destination=" + (this.destination == null ? "null" : this.destination.toString())) + (", readModifyWrite=" + this.readModifyWrite) + (", hashCode=" + this.hashCode) + (", msgData=" + (this.msgData == null ? "null" : this.msgData.toString())) + (", mergedWrites=" + (this.mergedWrites == null ? "null" : this.mergedWrites.toString())) + (", writtenData=" + (this.writtenData == null ? "null" : this.writtenData.toString())) + ')';
        }
    }

    private final class LDataReadOperation
    implements Runnable,
    ICoalesceable {
        protected final BKnxProxyExt originator;
        protected final BGroupAddress sourceGroupAddress;
        protected final int hashCode;

        private LDataReadOperation(BKnxProxyExt originator, BGroupAddress sourceAddress) {
            this.originator = originator;
            this.sourceGroupAddress = sourceAddress;
            this.hashCode = sourceAddress.hashCode();
        }

        @Override
        public void run() {
            try {
                BSendCemiMessageResultEnum result = BGroupDataManager.this.sendReadRequest(this.sourceGroupAddress);
                if (!result.isGood()) {
                    if (result.equals((Object)BSendCemiMessageResultEnum.notConnected)) {
                        BGroupDataManager.this.getLogger().warning(String.format("Device not connected so cancelled read of: %s", this.sourceGroupAddress));
                    } else {
                        this.originator.readFail("confirmation - " + result.getDisplayTag(null));
                    }
                }
            }
            catch (Exception e) {
                CatchAll.throwable(e);
                this.originator.readFail(e.toString());
            }
        }

        public Object getCoalesceKey() {
            return this.sourceGroupAddress;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            LDataReadOperation operation = (LDataReadOperation)c;
            if (operation.equals(this)) {
                return this;
            }
            return c;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof LDataReadOperation) {
                LDataReadOperation operation = (LDataReadOperation)object;
                return this.sourceGroupAddress.getAddress() == operation.sourceGroupAddress.getAddress();
            }
            return false;
        }

        public String toString() {
            return "LDataReadOperation (originator=" + this.originator + ", sourceGroupAddress=" + this.sourceGroupAddress + ")";
        }
    }

    private static final class PendingRead {
        private final int groupAddress;
        private long ticks;

        private PendingRead(int groupAddress, long ticks) {
            this.groupAddress = groupAddress;
            this.ticks = ticks;
        }
    }
}

