/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridium.nre.util.IPAddressUtil;
import com.tridiumX.knxnetIp.comms.BAbstractLocalInterface;
import com.tridiumX.knxnetIp.comms.BCommsCounters;
import com.tridiumX.knxnetIp.comms.BEndPoint;
import com.tridiumX.knxnetIp.comms.BFrameReceiverCommsCounters;
import com.tridiumX.knxnetIp.comms.BLocalInterface;
import com.tridiumX.knxnetIp.comms.IDiscoveryListener;
import com.tridiumX.knxnetIp.comms.IEndPointListener;
import com.tridiumX.knxnetIp.comms.ILDataConnection;
import com.tridiumX.knxnetIp.comms.IMulticastListener;
import com.tridiumX.knxnetIp.comms.IMulticastProvider;
import com.tridiumX.knxnetIp.comms.IRoutingListener;
import com.tridiumX.knxnetIp.comms.ReceivedFrame;
import com.tridiumX.knxnetIp.comms.enums.BKnxInstallationConfigStatus;
import com.tridiumX.knxnetIp.comms.enums.BKnxIpFrameValidationResultEnum;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.CoreSearchRequest;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.util.BIIncludeInTrace;
import com.tridiumX.knxnetIp.util.BKnxWorker;
import com.tridiumX.knxnetIp.util.CatchAll;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.license.Feature;
import javax.baja.license.LicenseManager;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.QueueFullException;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="faultCause", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=67), @NiagaraProperty(name="configStatus", type="BKnxInstallationConfigStatus", defaultValue="BKnxInstallationConfigStatus.ok", flags=75), @NiagaraProperty(name="knxInstallationId", type="int", defaultValue="0", flags=65), @NiagaraProperty(name="multicastIpAddress", type="String", defaultValue="KnxSpec.SYSTEM_SETUP_MULTICAST_ADDRESS", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, \"platform:IpHostFE\")")}), @NiagaraProperty(name="multicastPortNumber", type="int", defaultValue="KnxSpec.KNXNETIP_PORT_NUMBER", facets={@Facet(value="BFacets.makeInt(Constants.MIN_LOCAL_IP_PORT, Constants.MAX_IP_PORT_NUMBER)")}), @NiagaraProperty(name="maximumReceivedPacketsQueSize", type="int", defaultValue="Constants.MULTICAST_END_POINT_RECEIVE_QUEUE_SIZE_DEFAULT", facets={@Facet(value="BFacets.make(BFacets.MIN, Constants.MULTICAST_END_POINT_RECEIVE_QUEUE_SIZE_MINIMUM)")}), @NiagaraProperty(name="multicastEndPoint", type="BEndPoint", defaultValue="new BEndPoint()", flags=1), @NiagaraProperty(name="commsCounters", type="BCommsCounters", defaultValue="new BFrameReceiverCommsCounters()", flags=65540), @NiagaraProperty(name="includeInTrace", type="boolean", defaultValue="true", flags=65540)})
public final class BKnxInstallation
extends BComponent
implements BIIncludeInTrace,
IMulticastProvider,
IEndPointListener {
    public static final Property status = BKnxInstallation.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property enabled = BKnxInstallation.newProperty((int)0, (boolean)true, null);
    public static final Property faultCause = BKnxInstallation.newProperty((int)67, (String)"", null);
    public static final Property configStatus = BKnxInstallation.newProperty((int)75, (BValue)BKnxInstallationConfigStatus.ok, null);
    public static final Property knxInstallationId = BKnxInstallation.newProperty((int)65, (int)0, null);
    public static final Property multicastIpAddress = BKnxInstallation.newProperty((int)0, (String)"224.0.23.12", (BFacets)BFacets.make((String)"fieldEditor", (String)"platform:IpHostFE"));
    public static final Property multicastPortNumber = BKnxInstallation.newProperty((int)0, (int)3671, (BFacets)BFacets.makeInt((int)1, (int)65535));
    public static final Property maximumReceivedPacketsQueSize = BKnxInstallation.newProperty((int)0, (int)5, (BFacets)BFacets.make((String)"min", (int)2));
    public static final Property multicastEndPoint = BKnxInstallation.newProperty((int)1, (BValue)new BEndPoint(), null);
    public static final Property commsCounters = BKnxInstallation.newProperty((int)65540, (BValue)new BFrameReceiverCommsCounters(), null);
    public static final Property includeInTrace = BKnxInstallation.newProperty((int)65540, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BKnxInstallation.class);
    private static final String KNX_INSTALLATION_LIMIT_KEY = "installation.limit";
    private static final int DEFAULT_KNX_INSTALLATION_LIMIT = 0;
    private static final int NO_KNX_INSTALLATION_LIMIT = -1;
    private static final Object knxInstallationsLock = new Object();
    private static final Vector<BKnxInstallation> knxInstallations = new Vector(1, 1);
    private boolean configFault = false;
    private boolean fatalFault;
    private final Object multicastListenersLock = new Object();
    private Vector<IMulticastListener> multicastListeners = null;
    private final Object rxPacketWorkerLock = new Object();
    private BKnxWorker rxPacketWorker = null;
    private static final Logger logKnxInstallation = Logger.getLogger(TYPE.getModule().getModuleName() + ".comms.knxInstallation");
    private static final String RX_PACKET_WORKER_BASE_NAME = "InstallationRxPktWrkr";

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BKnxInstallationConfigStatus getConfigStatus() {
        return (BKnxInstallationConfigStatus)this.get(configStatus);
    }

    public void setConfigStatus(BKnxInstallationConfigStatus v) {
        this.set(configStatus, (BValue)v, null);
    }

    public int getKnxInstallationId() {
        return this.getInt(knxInstallationId);
    }

    public void setKnxInstallationId(int v) {
        this.setInt(knxInstallationId, v, null);
    }

    public String getMulticastIpAddress() {
        return this.getString(multicastIpAddress);
    }

    public void setMulticastIpAddress(String v) {
        this.setString(multicastIpAddress, v, null);
    }

    public int getMulticastPortNumber() {
        return this.getInt(multicastPortNumber);
    }

    public void setMulticastPortNumber(int v) {
        this.setInt(multicastPortNumber, v, null);
    }

    public int getMaximumReceivedPacketsQueSize() {
        return this.getInt(maximumReceivedPacketsQueSize);
    }

    public void setMaximumReceivedPacketsQueSize(int v) {
        this.setInt(maximumReceivedPacketsQueSize, v, null);
    }

    public BEndPoint getMulticastEndPoint() {
        return (BEndPoint)this.get(multicastEndPoint);
    }

    public void setMulticastEndPoint(BEndPoint v) {
        this.set(multicastEndPoint, (BValue)v, null);
    }

    public BCommsCounters getCommsCounters() {
        return (BCommsCounters)this.get(commsCounters);
    }

    public void setCommsCounters(BCommsCounters v) {
        this.set(commsCounters, (BValue)v, null);
    }

    @Override
    public boolean getIncludeInTrace() {
        return this.getBoolean(includeInTrace);
    }

    @Override
    public void setIncludeInTrace(boolean v) {
        this.setBoolean(includeInTrace, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BAbstractLocalInterface;
    }

    public final void started() throws Exception {
        super.started();
        this.checkLicensed();
        this.checkRouterConnection();
        this.updateConfigStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopped() throws Exception {
        super.stopped();
        Object object = knxInstallationsLock;
        synchronized (object) {
            if (knxInstallations.contains(this)) {
                knxInstallations.remove(this);
            }
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(configStatus)) {
            if (!this.getConfigStatus().isConfigFault()) {
                this.configOk();
            } else {
                this.configFail(this.getConfigStatus().toString(context));
            }
        }
        if (property.equals(enabled)) {
            if (!this.isRunning()) {
                return;
            }
            this.updateStatus();
        } else if (property.equals(multicastIpAddress) || property.equals(multicastPortNumber)) {
            if (context == null || !context.equals(Context.copying) && !context.equals(Context.decoding)) {
                this.updateConfigStatus();
                if (this.getLocalInterface() != null) {
                    this.getLocalInterface().checkConfigKnxInstallationsIps();
                }
            }
        } else if (property.equals(maximumReceivedPacketsQueSize)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLicensed() {
        Object object = knxInstallationsLock;
        synchronized (object) {
            if (this.getKnxInstallationId() == 0) {
                int maxKnxInstallationId = 0;
                for (int i = 0; i < knxInstallations.size(); ++i) {
                    int knxInstallationId = knxInstallations.elementAt(i).getKnxInstallationId();
                    if (maxKnxInstallationId >= knxInstallationId) continue;
                    maxKnxInstallationId = knxInstallationId;
                }
                this.setKnxInstallationId(maxKnxInstallationId + 1);
            }
            if (!knxInstallations.contains(this)) {
                LicenseManager licenseManager = Sys.getLicenseManager();
                Feature feature = licenseManager.checkFeature("tridium", TYPE.getModule().getModuleName());
                int knxInstallationsLimit = 0;
                String knxInstallationsLimitAttribute = feature.get(KNX_INSTALLATION_LIMIT_KEY);
                if (knxInstallationsLimitAttribute != null) {
                    if (knxInstallationsLimitAttribute.equals("none")) {
                        knxInstallationsLimit = -1;
                    } else {
                        try {
                            knxInstallationsLimit = Integer.parseInt(knxInstallationsLimitAttribute);
                        }
                        catch (Throwable t) {
                            CatchAll.throwable(t);
                        }
                    }
                }
                boolean licenseOk = knxInstallationsLimit == -1 || knxInstallations.size() < knxInstallationsLimit;
                knxInstallations.addElement(this);
                if (!licenseOk) {
                    this.setConfigStatus(BKnxInstallationConfigStatus.knxInstallationNotLicensed);
                    this.fatalFault = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final BKnxInstallation getKnxInstallationById(int id) {
        Object object = knxInstallationsLock;
        synchronized (object) {
            for (int i = 0; i < knxInstallations.size(); ++i) {
                if (knxInstallations.elementAt(i).getKnxInstallationId() != id) continue;
                return knxInstallations.elementAt(i);
            }
            return null;
        }
    }

    public final void updateStatus() {
        BStatus parentStatus;
        int newStatus = this.getStatus().getBits();
        newStatus &= 3;
        BAbstractLocalInterface localInterface = (BAbstractLocalInterface)this.getParent();
        BStatus bStatus = parentStatus = localInterface == null ? BStatus.ok : localInterface.getStatus();
        newStatus = !this.getEnabled() || parentStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.fatalFault || this.configFault || parentStatus.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        this.setStatus(BStatus.make((int)newStatus));
        this.updateDevicesStatus();
    }

    public final void configOk() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public final void configFail(String cause) {
        if (cause.equals("")) {
            this.configOk();
        } else {
            this.configFault = true;
            if (this.fatalFault) {
                return;
            }
            this.setFaultCause(cause);
            this.updateStatus();
        }
    }

    public boolean isConfigFault() {
        return this.configFault;
    }

    void updateConfigStatus() {
        BLocalInterface localInterface;
        int newStatus;
        block6: {
            newStatus = this.getConfigStatus().getBits();
            String multicastIpAddressString = this.getMulticastIpAddress();
            if (IPAddressUtil.isNumericAddr((String)multicastIpAddressString) && IPAddressUtil.isIpv4Address((String)multicastIpAddressString)) {
                newStatus &= 0xFFFFFFFD;
                try {
                    InetAddress inetAddress = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)multicastIpAddressString));
                    if (!inetAddress.isMulticastAddress()) {
                        newStatus |= 4;
                        newStatus &= 0xFFFFFFF7;
                        break block6;
                    }
                    newStatus &= 0xFFFFFFFB;
                }
                catch (Exception ex) {
                    newStatus |= 2;
                    newStatus &= 0xFFFFFFF3;
                }
            } else {
                newStatus |= 2;
                newStatus &= 0xFFFFFFF3;
            }
        }
        if ((localInterface = this.getLocalInterface()) != null) {
            newStatus = localInterface.isDuplicateMulticastIpAddressAndPort(this) ? (newStatus |= 8) : (newStatus &= 0xFFFFFFF7);
        }
        this.setConfigStatus(new BKnxInstallationConfigStatus(newStatus));
    }

    protected final BKnxNetwork getNetwork() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BKnxNetwork)) continue;
            return (BKnxNetwork)parent;
        }
        return null;
    }

    protected final void updateDevicesStatus() {
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BKnxDevice)) continue;
            try {
                ((BKnxDevice)devices[i]).updateConfigStatus();
                continue;
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }

    protected final BDevice[] getDevices() {
        BKnxNetwork network = this.getNetwork();
        if (network != null) {
            return network.getDevices();
        }
        return new BDevice[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void registerMulticastListener(IMulticastListener listener) {
        if (!this.isRunning()) {
            throw new NotRunningException("LocalInterface not running");
        }
        this.updateConfigStatus();
        if (this.getStatus().isDisabled()) {
            throw new IllegalStateException("LocalInterface is disabled");
        }
        if (this.getStatus().isFault()) {
            throw new IllegalStateException("LocalInterface has a config fault");
        }
        Object object = this.multicastListenersLock;
        synchronized (object) {
            if (this.multicastListeners == null) {
                InetAddress multicastSetupIpAddress = null;
                try {
                    multicastSetupIpAddress = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)this.getMulticastIpAddress()));
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                BAbstractLocalInterface localInterface = (BAbstractLocalInterface)this.getParent();
                if (localInterface != null) {
                    if (localInterface.getUseBacnetToSend()) {
                        try {
                            localInterface.openRawAdapter();
                        }
                        catch (Throwable t) {
                            CatchAll.throwable(t);
                        }
                    }
                    try {
                        this.getMulticastEndPoint().openEndPoint(this, localInterface, localInterface.getLocalAddress(), multicastSetupIpAddress, this.getMulticastPortNumber(), this.getMulticastPortNumber());
                    }
                    catch (SocketException ex) {
                        BKnxInstallation.getLogger().log(Level.SEVERE, "Failed to open multicast end point", ex);
                    }
                    if (this.getMulticastEndPoint().isEndPointOpen()) {
                        this.multicastListeners = new Vector(1, 1);
                        Object object2 = this.rxPacketWorkerLock;
                        synchronized (object2) {
                            this.rxPacketWorker = BKnxWorker.make(RX_PACKET_WORKER_BASE_NAME + localInterface.getLocalAddress().getHostAddress() + "Port" + this.getMulticastPortNumber(), this.getMaximumReceivedPacketsQueSize());
                            this.rxPacketWorker.start();
                        }
                    }
                } else {
                    BKnxInstallation.getLogger().warning("Multicast end point could not be opened - no local interface found");
                }
            }
            if (this.multicastListeners != null) {
                if (!this.multicastListeners.contains(listener)) {
                    this.multicastListeners.add(listener);
                }
            } else {
                throw new IllegalStateException("multicastListeners == null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMulticastListener(IMulticastListener listener) {
        Object object = this.multicastListenersLock;
        synchronized (object) {
            if (this.multicastListeners != null) {
                while (this.multicastListeners.contains(listener)) {
                    this.multicastListeners.remove(listener);
                }
                if (this.multicastListeners.isEmpty()) {
                    this.multicastListeners = null;
                }
            }
            if (this.multicastListeners == null) {
                Object object2 = this.rxPacketWorkerLock;
                synchronized (object2) {
                    if (this.rxPacketWorker != null) {
                        this.rxPacketWorker.stop();
                        this.rxPacketWorker = null;
                    }
                }
                this.getMulticastEndPoint().closeEndPoint();
                BLocalInterface localInterface = (BLocalInterface)this.getParent();
                if (localInterface != null) {
                    localInterface.closeRawAdapter();
                }
            }
        }
    }

    @Override
    public final void sendSearchRequest() throws IOException {
        BEndPoint endPoint = this.getMulticastEndPoint();
        if (endPoint == null) {
            throw new IOException("'Multicast' EndPoint is null.");
        }
        if (!endPoint.isEndPointOpen()) {
            throw new IOException("'Multicast' EndPoint is not open.");
        }
        CoreSearchRequest searchRequest = new CoreSearchRequest(endPoint.getRemoteInetAddress(), endPoint.getLocalPort());
        if (this.getIncludeInTrace() && BKnxInstallation.getLogger().isLoggable(Level.FINE)) {
            BKnxInstallation.getLogger().fine("tx " + searchRequest.toLogString() + KnxIpFrame.getToDeviceLogString(endPoint));
        }
        endPoint.send(searchRequest);
    }

    @Override
    public BLocalInterface getLocalInterface() {
        return (BLocalInterface)this.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void receiveFrame(KnxIpFrame frame) {
        if (this.getIncludeInTrace() && BKnxInstallation.getLogger().isLoggable(Level.FINE)) {
            BKnxInstallation.getLogger().fine("rx frame " + frame.getLogString());
        }
        if (!frame.validationResult.equals((Object)BKnxIpFrameValidationResultEnum.packetIsValid)) {
            switch (frame.validationResult.getOrdinal()) {
                case 3: {
                    BKnxInstallation.getLogger().log(Level.SEVERE, "Invalid Frame Header Received - " + frame.validationResult.getTag() + " - " + frame.frameHeader.protocolVersion);
                    break;
                }
                default: {
                    BKnxInstallation.getLogger().log(Level.SEVERE, "Invalid Frame Header Received - " + frame.validationResult.getTag());
                }
            }
            return;
        }
        switch (frame.frameHeader.getServiceType()) {
            case 2: {
                Object object = this.rxPacketWorkerLock;
                synchronized (object) {
                    if (this.rxPacketWorker != null) {
                        try {
                            this.rxPacketWorker.post(new ReceivedFrame(frame, recFrame -> this.processRxFrame((KnxIpFrame)recFrame), this.rxPacketWorker.getName()));
                        }
                        catch (QueueFullException ex) {
                            this.getCommsCounters().incCounter(BFrameReceiverCommsCounters.rxFramesLostQueueFull);
                            BKnxInstallation.getLogger().log(Level.SEVERE, this.getMulticastEndPoint().getEndPointName() + " Received Packet Lost - Queue Full - packet [ " + frame.getHexString() + " ] from " + frame.packet.getAddress().getHostAddress() + " srcPort = " + frame.packet.getPort(), ex);
                        }
                        catch (Throwable t) {
                            CatchAll.throwable(t);
                            if (!(t instanceof ThreadDeath)) break;
                            throw (ThreadDeath)t;
                        }
                    } else {
                        this.getCommsCounters().incCounter(BFrameReceiverCommsCounters.rxFramesLostNoPacketWorker);
                    }
                    break;
                }
            }
            case 5: {
                Object object = this.multicastListenersLock;
                synchronized (object) {
                    if (this.multicastListeners != null) {
                        for (int i = 0; i < this.multicastListeners.size(); ++i) {
                            try {
                                IMulticastListener listener = this.multicastListeners.elementAt(i);
                                if (!(listener instanceof IRoutingListener)) continue;
                                ((IRoutingListener)listener).receiveFrame(this, frame);
                                continue;
                            }
                            catch (Throwable t) {
                                CatchAll.throwable(t);
                                if (!(t instanceof ThreadDeath)) continue;
                                throw (ThreadDeath)t;
                            }
                        }
                    }
                    break;
                }
            }
            default: {
                if (!this.getIncludeInTrace() || !BKnxInstallation.getLogger().isLoggable(Level.FINE)) break;
                BKnxInstallation.getLogger().fine("rx " + frame.toLogString() + " - Not Supported on a 'Multicast' EndPoint");
            }
        }
    }

    protected final void processRxFrame(KnxIpFrame frame) {
        if (this.getIncludeInTrace() && BKnxInstallation.getLogger().isLoggable(Level.FINE)) {
            BKnxInstallation.getLogger().fine("rx non Routing frame " + frame.getLogString());
        }
        if (!frame.validationResult.equals((Object)BKnxIpFrameValidationResultEnum.packetIsValid)) {
            switch (frame.validationResult.getOrdinal()) {
                case 3: {
                    BKnxInstallation.getLogger().log(Level.SEVERE, "Invalid Frame Header Received - " + frame.validationResult.getTag() + " - " + frame.frameHeader.protocolVersion);
                    break;
                }
                default: {
                    BKnxInstallation.getLogger().log(Level.SEVERE, "Invalid Frame Header Received - " + frame.validationResult.getTag());
                }
            }
            return;
        }
        switch (frame.frameHeader.getServiceType()) {
            case 2: {
                try {
                    this.processKnxnetIpCore(frame);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            default: {
                if (!this.getIncludeInTrace() || !BKnxInstallation.getLogger().isLoggable(Level.FINE)) break;
                BKnxInstallation.getLogger().fine("rx " + frame.toLogString() + " - Not Supported on a Multicast EndPoint");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processKnxnetIpCore(KnxIpFrame frame) throws IOException {
        KnxIpFrame searchFrame = BKnxIpFrameTypeEnum.makeTypedFrame(frame);
        switch (frame.frameHeader.frameType.getOrdinal()) {
            case 513: 
            case 514: {
                if (this.getIncludeInTrace() && BKnxInstallation.getLogger().isLoggable(Level.FINE)) {
                    BKnxInstallation.getLogger().fine("rx " + searchFrame.toLogString());
                }
                Object object = this.multicastListenersLock;
                synchronized (object) {
                    if (this.multicastListeners != null) {
                        for (int i = 0; i < this.multicastListeners.size(); ++i) {
                            try {
                                IMulticastListener listener = this.multicastListeners.elementAt(i);
                                if (!(listener instanceof IDiscoveryListener)) continue;
                                ((IDiscoveryListener)listener).rcvSearchFrame(this, searchFrame);
                                continue;
                            }
                            catch (Throwable t) {
                                CatchAll.throwable(t);
                                if (!(t instanceof ThreadDeath)) continue;
                                throw (ThreadDeath)t;
                            }
                        }
                    }
                    break;
                }
            }
            default: {
                if (!this.getIncludeInTrace() || !BKnxInstallation.getLogger().isLoggable(Level.FINE)) break;
                BKnxInstallation.getLogger().fine("rx " + searchFrame.toLogString() + " - Not Supported on a Multicast EndPoint");
            }
        }
    }

    private void checkRouterConnection() {
        block4: {
            BValue value = this.get("routerConnection");
            try {
                TypeInfo routerTypeInfo = Sys.getRegistry().getType("knxServer:RouterConnection");
                if (value != null) {
                    if (value.getType().getTypeInfo().equals(routerTypeInfo)) {
                        return;
                    }
                    this.remove("routerConnection");
                }
                this.add("routerConnection", routerTypeInfo.getInstance().asValue(), 1);
            }
            catch (TypeNotFoundException ex) {
                if (value == null) break block4;
                this.remove("routerConnection");
            }
        }
    }

    public final ILDataConnection getConnection() {
        BValue value = this.get("routerConnection");
        if (value != null && value instanceof ILDataConnection) {
            return (ILDataConnection)value;
        }
        return null;
    }

    protected static final Logger getLogger() {
        return logKnxInstallation;
    }
}

