/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import com.tridiumX.knxnetIp.comms.BAbstractLocalInterface;
import com.tridiumX.knxnetIp.comms.BDiscoveryKnxInstallations;
import com.tridiumX.knxnetIp.comms.BKnxInstallation;
import com.tridiumX.knxnetIp.comms.BLocalInterface;
import com.tridiumX.knxnetIp.comms.BTcpIpAdapter;
import com.tridiumX.knxnetIp.comms.DumpComms;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.job.BDiscoverDevicesJob;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.util.Dump;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BNetworkExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="localInterface", type="BLocalInterface", defaultValue="new BLocalInterface()")
@NiagaraActions(value={@NiagaraAction(name="fetchKnxInstallations", parameterType="BInteger", defaultValue="BInteger.DEFAULT", returnType="BDynamicEnum", flags=4), @NiagaraAction(name="fetchKnxInstallationsEnum", parameterType="BDynamicEnum", defaultValue="BDynamicEnum.DEFAULT", returnType="BDynamicEnum", flags=4), @NiagaraAction(name="fetchTcpIpHostSettings", returnType="BTcpIpHostSettings", flags=4), @NiagaraAction(name="submitDeviceDiscoveryJob", parameterType="BDiscoveryKnxInstallations", defaultValue="new BDiscoveryKnxInstallations()", returnType="BOrd", flags=4), @NiagaraAction(name="dumpNetworkInterfaces"), @NiagaraAction(name="dumpTcpIpPlatformService"), @NiagaraAction(name="dumpEthernetPlatformService")})
public final class BLocalInterfaces
extends BNetworkExt {
    public static final Property localInterface = BLocalInterfaces.newProperty((int)0, (BValue)new BLocalInterface(), null);
    public static final Action fetchKnxInstallations = BLocalInterfaces.newAction((int)4, (BValue)BInteger.DEFAULT, null);
    public static final Action fetchKnxInstallationsEnum = BLocalInterfaces.newAction((int)4, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Action fetchTcpIpHostSettings = BLocalInterfaces.newAction((int)4, null);
    public static final Action submitDeviceDiscoveryJob = BLocalInterfaces.newAction((int)4, (BValue)new BDiscoveryKnxInstallations(), null);
    public static final Action dumpNetworkInterfaces = BLocalInterfaces.newAction((int)0, null);
    public static final Action dumpTcpIpPlatformService = BLocalInterfaces.newAction((int)0, null);
    public static final Action dumpEthernetPlatformService = BLocalInterfaces.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BLocalInterfaces.class);
    private int lastUsedInterfaceId = 0;
    private static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName() + ".comms.interfaces");

    public BLocalInterface getLocalInterface() {
        return (BLocalInterface)this.get(localInterface);
    }

    public void setLocalInterface(BLocalInterface v) {
        this.set(localInterface, (BValue)v, null);
    }

    public BDynamicEnum fetchKnxInstallations(BInteger parameter) {
        return (BDynamicEnum)this.invoke(fetchKnxInstallations, (BValue)parameter, null);
    }

    public BDynamicEnum fetchKnxInstallationsEnum(BDynamicEnum parameter) {
        return (BDynamicEnum)this.invoke(fetchKnxInstallationsEnum, (BValue)parameter, null);
    }

    public BTcpIpHostSettings fetchTcpIpHostSettings() {
        return (BTcpIpHostSettings)this.invoke(fetchTcpIpHostSettings, null, null);
    }

    public BOrd submitDeviceDiscoveryJob(BDiscoveryKnxInstallations parameter) {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, (BValue)parameter, null);
    }

    public void dumpNetworkInterfaces() {
        this.invoke(dumpNetworkInterfaces, null, null);
    }

    public void dumpTcpIpPlatformService() {
        this.invoke(dumpTcpIpPlatformService, null, null);
    }

    public void dumpEthernetPlatformService() {
        this.invoke(dumpEthernetPlatformService, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void updateStatus() {
        BLocalInterface[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                interfaces[i].updateStatus();
                continue;
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BKnxNetwork;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BLocalInterface;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (property.getType().equals(BAbstractLocalInterface.TYPE)) {
            BAbstractLocalInterface localInterface = (BAbstractLocalInterface)this.get(property);
            this.checkInterfaceId(localInterface);
        }
    }

    public void started() throws Exception {
        super.started();
        if (log.isLoggable(Level.FINE)) {
            BTcpIpHostSettings hostSettings = this.doFetchTcpIpHostSettings();
            System.out.println("BTcpIpHostSettings hostSettings = " + Dump.dump((BComplex)hostSettings));
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.checkConfigAdapters();
    }

    public BLocalInterface getLocalInterfaceById(int id) {
        BLocalInterface[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].getLocalInterfaceId() != id) continue;
            return interfaces[i];
        }
        return null;
    }

    public final BKnxInstallation[] getKnxInstallations() {
        BLocalInterface[] localInterfaces = this.getInterfaces();
        int knxInstallationCount = 0;
        for (int i = 0; i < localInterfaces.length; ++i) {
            BLocalInterface localInterface = localInterfaces[i];
            localInterface.loadSlots();
            BKnxInstallation[] knxInstallations = (BKnxInstallation[])localInterface.getChildren(BKnxInstallation.class);
            knxInstallationCount += knxInstallations.length;
        }
        BKnxInstallation[] aKnxInstallations = new BKnxInstallation[knxInstallationCount];
        int itemIndex = 0;
        for (int i = 0; i < localInterfaces.length; ++i) {
            BLocalInterface localInterface = localInterfaces[i];
            BKnxInstallation[] knxInstallations = (BKnxInstallation[])localInterface.getChildren(BKnxInstallation.class);
            for (int j = 0; j < knxInstallations.length; ++j) {
                BKnxInstallation knxInstallation = knxInstallations[j];
                knxInstallation.loadSlots();
                aKnxInstallations[itemIndex++] = knxInstallation;
            }
        }
        return aKnxInstallations;
    }

    private BKnxInstallation getKnxInstallationById(int id) {
        if (id != 0) {
            BLocalInterface[] aLocalInterfaces = this.getInterfaces();
            for (int i = 0; i < aLocalInterfaces.length; ++i) {
                BLocalInterface localInterface = aLocalInterfaces[i];
                localInterface.loadSlots();
                BKnxInstallation[] aKnxInstallations = (BKnxInstallation[])localInterface.getChildren(BKnxInstallation.class);
                for (int j = 0; j < aKnxInstallations.length; ++j) {
                    BKnxInstallation knxInstallation = aKnxInstallations[j];
                    knxInstallation.loadSlots();
                    if (knxInstallation.getKnxInstallationId() != id) continue;
                    return knxInstallation;
                }
            }
        }
        return null;
    }

    private BLocalInterface[] getInterfaces() {
        this.loadSlots();
        return (BLocalInterface[])this.getChildren(BLocalInterface.class);
    }

    public void checkConfigAdapters() {
        BLocalInterface[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            BLocalInterface localInterface = interfaces[i];
            try {
                localInterface.updateConfigStatus();
                continue;
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }

    public boolean isAdapterAlreadyInUse(BAbstractLocalInterface abstractLocalInterface) {
        boolean isAlreadyInUse = false;
        String interfaceAdapterId = abstractLocalInterface.getAdapterId().getAdapterId();
        if (!interfaceAdapterId.equals(BTcpIpAdapter.adapterId.getDefaultValue().toString())) {
            BLocalInterface[] interfaces = this.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                BLocalInterface localInterface = interfaces[i];
                String adapterId = localInterface.getAdapterId().getAdapterId();
                if (!adapterId.equals(interfaceAdapterId)) continue;
                if (localInterface.equals(abstractLocalInterface)) break;
                isAlreadyInUse = true;
                break;
            }
        }
        return isAlreadyInUse;
    }

    public void pingInterfaces() {
        BLocalInterface[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i].pingInterface();
        }
    }

    public void checkInterfaceIds() {
        BLocalInterface[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.checkInterfaceId(interfaces[i]);
            if (i <= 0) continue;
            for (int j = 0; j < i; ++j) {
                if (interfaces[i].getLocalInterfaceId() != interfaces[j].getLocalInterfaceId()) continue;
                interfaces[i].setLocalInterfaceId(this.getNextAvailableInterfaceId());
            }
        }
    }

    private void checkInterfaceId(BAbstractLocalInterface localInterface) {
        if (localInterface.getLocalInterfaceId() == 0) {
            localInterface.setLocalInterfaceId(this.getNextAvailableInterfaceId());
        }
    }

    private int getNextAvailableInterfaceId() {
        BLocalInterface[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (this.lastUsedInterfaceId >= interfaces[i].getLocalInterfaceId()) continue;
            this.lastUsedInterfaceId = interfaces[i].getLocalInterfaceId();
        }
        return ++this.lastUsedInterfaceId;
    }

    public final BDynamicEnum doFetchKnxInstallations(BInteger lastUsedDiscoveryKnxInsallation, Context cx) {
        if (this.isRunning()) {
            BLocalInterface[] localInterfaces = this.getInterfaces();
            int knxInstallationCount = 0;
            for (int i = 0; i < localInterfaces.length; ++i) {
                BLocalInterface localInterface = localInterfaces[i];
                localInterface.loadSlots();
                BKnxInstallation[] knxInstallations = (BKnxInstallation[])localInterface.getChildren(BKnxInstallation.class);
                knxInstallationCount += knxInstallations.length;
            }
            String[] names = new String[knxInstallationCount + 1];
            int[] ids = new int[knxInstallationCount + 1];
            int itemIndex = 0;
            ids[itemIndex] = 0;
            names[itemIndex++] = "All";
            int sel = 0;
            for (int i = 0; i < localInterfaces.length; ++i) {
                BLocalInterface localInterface = localInterfaces[i];
                BKnxInstallation[] knxInstallations = (BKnxInstallation[])localInterface.getChildren(BKnxInstallation.class);
                for (int j = 0; j < knxInstallations.length; ++j) {
                    BKnxInstallation knxInstallation = knxInstallations[j];
                    ids[itemIndex] = knxInstallation.getKnxInstallationId();
                    names[itemIndex++] = SlotPath.escape((String)(knxInstallation.getDisplayName(cx) + " (" + localInterface.getDisplayName(cx) + " (" + localInterface.getAdapterId().getAdapterId() + "))"));
                    if (lastUsedDiscoveryKnxInsallation.getInt() != knxInstallation.getKnxInstallationId()) continue;
                    sel = knxInstallation.getKnxInstallationId();
                }
            }
            return BDynamicEnum.make((int)sel, (BEnumRange)BEnumRange.make((int[])ids, (String[])names));
        }
        return null;
    }

    public final BDynamicEnum doFetchKnxInstallationsEnum(BDynamicEnum dynamicEnum, Context cx) {
        if (this.isRunning()) {
            BKnxInstallation currentKnxInstallation = this.getKnxInstallationById(dynamicEnum.getOrdinal());
            int idx = currentKnxInstallation == null && dynamicEnum.getOrdinal() != 0 ? 2 : 1;
            BKnxInstallation[] knxInstallations = this.getKnxInstallations();
            int knxInstallationCount = knxInstallations.length + idx;
            int[] ordinals = new int[knxInstallationCount];
            String[] tags = new String[knxInstallationCount];
            ordinals[0] = 0;
            tags[0] = SlotPath.escape((String)"No 'KNX Installation' selected");
            int sel = 0;
            if (idx == 2) {
                ordinals[1] = dynamicEnum.getOrdinal();
                tags[1] = SlotPath.escape((String)(dynamicEnum.getTag() + " [" + this.getLexicon().get("notFound") + "]"));
                sel = 1;
            }
            for (int i = 0; i < knxInstallations.length; ++i) {
                String name;
                BKnxInstallation knxInstallation = knxInstallations[i];
                knxInstallation.loadSlots();
                ordinals[i + idx] = knxInstallation.getKnxInstallationId();
                tags[i + idx] = name = SlotPath.escape((String)(knxInstallation.getDisplayName(cx) + " (" + knxInstallation.getLocalInterface().getDisplayName(cx) + " (" + knxInstallation.getLocalInterface().getAdapterId().getAdapterId() + "))"));
                if (dynamicEnum.getOrdinal() != knxInstallation.getKnxInstallationId()) continue;
                sel = knxInstallation.getKnxInstallationId();
            }
            return BDynamicEnum.make((int)sel, (BEnumRange)BEnumRange.make((int[])ordinals, (String[])tags));
        }
        return null;
    }

    public final BTcpIpHostSettings doFetchTcpIpHostSettings() {
        if (this.isRunning()) {
            BTcpIpPlatformService svc = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
            svc.lease(0, 10L);
            svc.poll();
            return svc.getSettings();
        }
        return null;
    }

    public final BOrd doSubmitDeviceDiscoveryJob(BDiscoveryKnxInstallations discoveryKnxInstallations, Context cx) {
        if (!this.isRunning()) {
            throw new NotRunningException("Cannot discover devices - The station is not running.");
        }
        BInteger[] knxInstallationIds = discoveryKnxInstallations.getKnxInstallationIds();
        int knxInstallationId = discoveryKnxInstallations.getKnxInstallationToSearch();
        BKnxInstallation knxInstallationToSearch = null;
        BKnxInstallation[] knxInstallations = new BKnxInstallation[knxInstallationIds.length];
        for (int i = 0; i < knxInstallationIds.length; ++i) {
            knxInstallations[i] = BKnxInstallation.getKnxInstallationById(knxInstallationIds[i].getInt());
            if (knxInstallationIds[i].getInt() != knxInstallationId) continue;
            knxInstallationToSearch = knxInstallations[i];
        }
        return new BDiscoverDevicesJob(knxInstallations, knxInstallationToSearch).submit(cx);
    }

    public void doDumpNetworkInterfaces() {
        DumpComms.dumpNetworkInterfaces();
    }

    public void doDumpTcpIpPlatformService() {
        BTcpIpPlatformService svc = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        svc.lease(0, 10L);
        svc.poll();
        DumpComms.dump(svc);
    }

    public void doDumpEthernetPlatformService() {
        DumpComms.dump(BLocalInterface.getBacnetPlatformService());
    }
}

