/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridium.platBacnet.BBacnetEthernetPlatformService;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import com.tridiumX.knxnetIp.comms.KnxMulticastSocket;
import com.tridiumX.knxnetIp.util.Dump;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import javax.baja.sys.BComplex;

public abstract class DumpComms {
    private DumpComms() {
    }

    public static final void dumpSocket(Object socket) {
        if (socket instanceof DatagramSocket) {
            System.out.println("socket.isBound() = " + ((DatagramSocket)socket).isBound());
            System.out.println("socket.isClosed() = " + ((DatagramSocket)socket).isClosed());
            System.out.println("socket.isConnected() = " + ((DatagramSocket)socket).isConnected());
            try {
                System.out.println("socket.getBroadcast() = " + ((DatagramSocket)socket).getBroadcast());
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
            System.out.println("socket.getInetAddress() = " + ((DatagramSocket)socket).getInetAddress());
            System.out.println("socket.getLocalAddress() = " + ((DatagramSocket)socket).getLocalAddress());
            System.out.println("socket.getLocalPort() = " + ((DatagramSocket)socket).getLocalPort());
            System.out.println("socket.getLocalSocketAddress() = " + ((DatagramSocket)socket).getLocalSocketAddress());
            System.out.println("socket.getPort() = " + ((DatagramSocket)socket).getPort());
            try {
                System.out.println("socket.getReceiveBufferSize() = " + ((DatagramSocket)socket).getReceiveBufferSize());
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
            System.out.println("socket.getRemoteSocketAddress() = " + ((DatagramSocket)socket).getRemoteSocketAddress());
            try {
                System.out.println("socket.getReuseAddress() = " + ((DatagramSocket)socket).getReuseAddress());
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
            try {
                System.out.println("socket.getSendBufferSize() = " + ((DatagramSocket)socket).getSendBufferSize());
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
            try {
                System.out.println("socket.getSoTimeout() = " + ((DatagramSocket)socket).getSoTimeout());
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
            try {
                System.out.println("socket.getTrafficClass() = " + ((DatagramSocket)socket).getTrafficClass());
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
        }
        if (socket instanceof MulticastSocket) {
            try {
                System.out.println("socket.getInterface() = " + ((MulticastSocket)socket).getInterface());
            }
            catch (SocketException ex1) {
                ex1.printStackTrace();
            }
            try {
                System.out.println("socket.getLoopbackMode() = " + ((MulticastSocket)socket).getLoopbackMode());
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
            try {
                System.out.println("socket.getNetworkInterface() = " + ((MulticastSocket)socket).getNetworkInterface());
            }
            catch (SocketException ex1) {
                ex1.printStackTrace();
            }
            try {
                System.out.println("socket.getTimeToLive() = " + ((MulticastSocket)socket).getTimeToLive());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (socket instanceof KnxMulticastSocket) {
            System.out.println("socket.getLocalInetAddress() = " + ((KnxMulticastSocket)socket).getLocalInetAddress());
            System.out.println("socket.getLocalKnxSocketAddress() = " + ((KnxMulticastSocket)socket).getLocalKnxSocketAddress());
            System.out.println("socket.getRemoteKnxSocketAddress() = " + ((KnxMulticastSocket)socket).getRemoteKnxSocketAddress());
            System.out.println("socket.getUdpAdapter() = " + ((KnxMulticastSocket)socket).getUdpAdapter());
            System.out.println("socket.getMacAddress() = " + ((KnxMulticastSocket)socket).getMacAddress());
        }
    }

    static final void dumpAdapter(BTcpIpAdapterSettings as) {
        if (as == null) {
            System.out.println("Adapter is NULL!");
            return;
        }
        System.out.println("  adapterId = " + as.getAdapterId());
        System.out.println("  isAdapterEnabled = " + as.getIsAdapterEnabled());
        System.out.println("  canDisableAdapter = " + as.getCanDisableAdapter());
        System.out.println("  description = " + as.getDescription());
        System.out.println("  isDhcpEnabled = " + as.getIsDhcpEnabled());
        System.out.println("  canUseDhcp = " + as.getCanUseDhcp());
        System.out.println("  defaultGateway = " + as.getDefaultGateway());
        System.out.println("  dnsHosts = " + Dump.dumpVec(as.getDnsHosts()));
        System.out.println("  domain = " + as.getDomain());
        System.out.println("  ipaddress = " + as.getIpAddress());
        System.out.println("  subnetmask = " + as.getSubnetMask());
        System.out.println("  dhcpHost = " + as.getDhcpHost());
        System.out.println("  dchpLeaseGranted = " + as.getDhcpLeaseGranted());
        System.out.println("  dhcpLeaseExpires = " + as.getDhcpLeaseExpires());
        BTcpIpHostSettings hs = as.getHostSettings();
        System.out.println("  hostSettings = " + hs.toString());
    }

    static final void dumpNetworkInterfaces() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface intf = enumeration.nextElement();
                System.out.println("  interface.getDisplayName() = " + intf.getDisplayName());
                System.out.println("  interface.getInetAddresses() = " + intf.getInetAddresses());
                System.out.println("  interface.getName() = " + intf.getName());
                System.out.println();
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
    }

    static final void dump(BTcpIpPlatformService svc) {
        System.out.println("BTcpIpPlatformService svc = " + Dump.dump((BComplex)svc, "\t"));
    }

    static final void dump(BBacnetEthernetPlatformService svc) {
        System.out.println("BBacnetEthernetPlatformService svc = " + Dump.dump((BComplex)svc, "\t"));
        Vector adapterTitles = new Vector();
        Vector adapterDescriptions = new Vector();
        Vector adapterNames = new Vector();
        try {
            svc.getAdapterChoices(adapterTitles, adapterDescriptions, adapterNames);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < adapterNames.size(); ++i) {
            String adapterTitle = (String)adapterTitles.elementAt(i);
            String adapterDescription = (String)adapterDescriptions.elementAt(i);
            String adapterName = (String)adapterNames.elementAt(i);
            System.out.println("adapterTitle " + i + ":" + adapterTitle);
            System.out.println("adapterDescription " + i + ":" + adapterDescription);
            System.out.println("adapterName " + i + ":" + adapterName);
        }
    }
}

