/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms;

import com.tridium.platBacnet.BacnetEthernetAdapter;
import com.tridiumX.knxnetIp.comms.udp.UdpMulticastMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;

public final class KnxMulticastSocket
extends MulticastSocket {
    private final InetAddress localInetAddress;
    private final SocketAddress localKnxSocketAddress;
    private final SocketAddress remoteKnxSocketAddress;
    private final BacnetEthernetAdapter udpAdapter;
    private byte[] macAddress;

    public KnxMulticastSocket(int port, SocketAddress localSocketAddress, SocketAddress remoteSocketAddress, BacnetEthernetAdapter udpAdapter, InetAddress localInetAddress) throws IOException {
        super(port);
        this.localKnxSocketAddress = localSocketAddress;
        this.remoteKnxSocketAddress = remoteSocketAddress;
        this.udpAdapter = udpAdapter;
        this.localInetAddress = localInetAddress;
    }

    @Override
    public void send(DatagramPacket packet) throws IOException {
        if (this.udpAdapter == null) {
            super.send(packet);
        } else {
            byte[] destIp;
            if (this.macAddress == null) {
                this.macAddress = new byte[6];
                try {
                    this.udpAdapter.getAddress(this.macAddress);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("unable to determine adapter's mac address");
                }
            }
            byte[] udpBytes = packet.getData();
            byte[] srcIp = this.localInetAddress.getAddress();
            UdpMulticastMessage umm = new UdpMulticastMessage(this.macAddress, 8, srcIp, destIp = packet.getAddress().getAddress(), null, packet.getPort(), packet.getPort(), udpBytes, false);
            byte[] outBuffer = umm.getBytes();
            if (outBuffer == null) {
                throw new IOException("null UdpMulticastMessage message - cannot send");
            }
            try {
                this.udpAdapter.sendPacket(outBuffer);
            }
            catch (Exception ex) {
                throw new IOException("Error sending UdpMulticastMessage packet: " + ex);
            }
        }
    }

    public String toString() {
        return super.toString() + ", localKnxSocketAddress = " + this.localKnxSocketAddress + ", remoteKnxSocketAddress = " + this.remoteKnxSocketAddress;
    }

    public final InetAddress getLocalInetAddress() {
        return this.localInetAddress;
    }

    public final SocketAddress getLocalKnxSocketAddress() {
        return this.localKnxSocketAddress;
    }

    public final SocketAddress getRemoteKnxSocketAddress() {
        return this.remoteKnxSocketAddress;
    }

    public final BacnetEthernetAdapter getUdpAdapter() {
        return this.udpAdapter;
    }

    public final byte[] getMacAddress() {
        return this.macAddress;
    }
}

