/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.cemi;

import com.tridiumX.knxnetIp.addresses.BGroupAddress;
import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddress;
import com.tridiumX.knxnetIp.addresses.IKnxAddress;
import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.cemi.BCemiMessageValidationEnum;
import com.tridiumX.knxnetIp.comms.cemi.BCemiServiceGroupEnum;
import com.tridiumX.knxnetIp.comms.cemi.CemiApdu;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.comms.cemi.CemiTpdu;
import com.tridiumX.knxnetIp.knxSpec.BApciCodesEnum;
import com.tridiumX.knxnetIp.knxSpec.BBusAccessPriorityEnum;
import com.tridiumX.knxnetIp.knxSpec.BCemiMessageCodesEnum;
import com.tridiumX.knxnetIp.knxSpec.BExtendedFrameFormatEnum;
import com.tridiumX.knxnetIp.knxSpec.BTpciCodesEnum;
import java.io.IOException;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.InvalidEnumException;

public class CemiMessage {
    public BCemiMessageValidationEnum validationResult = BCemiMessageValidationEnum.DEFAULT;
    private BBusAccessPriorityEnum priority = BBusAccessPriorityEnum.DEFAULT;
    private BCemiMessageCodesEnum cemiMessageCode = BCemiMessageCodesEnum.DEFAULT;
    private byte[] additionalInfo = null;
    private byte ctrl1;
    private byte ctrl2;
    private IKnxAddress source = new BIndividualDeviceAddress();
    private IKnxAddress destination = new BGroupAddress();
    private CemiTpdu tpdu;
    private byte[] data;
    private int interfaceObjectType;
    private int objectInstanceIndex;
    private int propertyIdentifier;
    private int numberOfElements;
    private int startIndex;

    private CemiMessage() {
    }

    public CemiMessage(KnxInputStream in) throws IOException {
        this.fromStream(in);
    }

    public static final CemiMessage make(BCemiMessageCodesEnum messageCode, int interfaceObjectType, int objectInstanceIndex, int propertyIdentifier, int numberOfElements, int startIndex, int data) {
        byte[] bytes = new byte[]{(byte)(data >>> 8), (byte)(data & 0xFF)};
        return CemiMessage.factory(messageCode, interfaceObjectType, objectInstanceIndex, propertyIdentifier, numberOfElements, startIndex, bytes);
    }

    public static final CemiMessage make(BCemiMessageCodesEnum messageCode, int interfaceObjectType, int objectInstanceIndex, int propertyIdentifier, int numberOfElements, int startIndex, byte[] data) {
        return CemiMessage.factory(messageCode, interfaceObjectType, objectInstanceIndex, propertyIdentifier, numberOfElements, startIndex, data);
    }

    private static final CemiMessage factory(BCemiMessageCodesEnum messageCode, int interfaceObjectType, int objectInstanceIndex, int propertyIdentifier, int numberOfElements, int startIndex, byte[] data) {
        CemiMessage msg = new CemiMessage();
        msg.cemiMessageCode = messageCode;
        msg.interfaceObjectType = interfaceObjectType;
        msg.objectInstanceIndex = objectInstanceIndex;
        msg.propertyIdentifier = propertyIdentifier;
        msg.numberOfElements = numberOfElements;
        msg.startIndex = startIndex;
        msg.data = data;
        return msg;
    }

    public static final CemiMessage make(boolean acknowledgeRequested, BCemiMessageCodesEnum messageCode, int hopCount, BIndividualDeviceAddress source, BGroupAddress destination, CemiTpdu tpdu) {
        return CemiMessage.factory(false, BBusAccessPriorityEnum.DEFAULT, acknowledgeRequested, messageCode, hopCount, source, destination, tpdu);
    }

    public static final CemiMessage make(BBusAccessPriorityEnum priority, int hopCount, BIndividualDeviceAddress source, BIndividualDeviceAddress destination, CemiTpdu tpdu) {
        return CemiMessage.factory(true, priority, true, BCemiMessageCodesEnum.L_Data_ind, hopCount, source, destination, tpdu);
    }

    public static final CemiMessage make(BBusAccessPriorityEnum priority, BCemiMessageCodesEnum messageCode, int hopCount, BIndividualDeviceAddress source, BIndividualDeviceAddress destination, CemiTpdu tpdu) {
        return CemiMessage.factory(true, priority, true, messageCode, hopCount, source, destination, tpdu);
    }

    private static final CemiMessage factory(boolean systemBroadcast, BBusAccessPriorityEnum priority, boolean acknowledgeRequested, BCemiMessageCodesEnum messageCode, int hopCount, BIndividualDeviceAddress source, BKnxAddress destination, CemiTpdu tpdu) {
        byte ctrl1 = (byte)(0x80 | (systemBroadcast ? 0 : 16) | 0x20 | priority.getOrdinal() << 2 | (acknowledgeRequested ? 2 : 0));
        byte ctrl2 = (byte)((destination instanceof BIndividualDeviceAddress ? 0 : 128) | (hopCount & 7) << 4);
        return CemiMessage.factory(messageCode, null, ctrl1, ctrl2, source, destination, tpdu);
    }

    private static final CemiMessage factory(BCemiMessageCodesEnum messageCode, byte[] additionalInfo, byte ctrl1, byte ctrl2, BIndividualDeviceAddress source, BKnxAddress destination, CemiTpdu tpdu) {
        CemiMessage msg = new CemiMessage();
        msg.cemiMessageCode = messageCode;
        msg.additionalInfo = additionalInfo;
        msg.ctrl1 = ctrl1;
        msg.ctrl2 = ctrl2;
        msg.source = source;
        msg.destination = destination;
        msg.tpdu = tpdu;
        return msg;
    }

    public void toStream(KnxOutputStream out) throws IOException {
        out.write(this.cemiMessageCode.getOrdinal());
        BCemiServiceGroupEnum serviceGroup = this.cemiMessageCode.getServiceGroup();
        switch (serviceGroup.getOrdinal()) {
            case 2: {
                out.writeInt(this.interfaceObjectType);
                out.write(this.objectInstanceIndex);
                out.write(this.propertyIdentifier);
                out.write(this.numberOfElements);
                out.write(this.startIndex);
                out.write(this.data, 0, this.data.length);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                if (this.additionalInfo == null) {
                    out.write(0);
                } else {
                    out.write(this.additionalInfo.length);
                    out.write(this.additionalInfo);
                }
                out.write(this.ctrl1);
                out.write(this.ctrl2);
                out.writeInt(this.source.getAddress());
                out.writeInt(this.destination.getAddress());
                this.tpdu.toStream(out);
            }
        }
    }

    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            this.cemiMessageCode = BCemiMessageCodesEnum.make(in.read());
        }
        catch (InvalidEnumException ex) {
            this.validationResult = BCemiMessageValidationEnum.unsupportedMessageCode;
            throw new IOException("unsupported MessageCode");
        }
        try {
            BCemiServiceGroupEnum serviceGroup = this.cemiMessageCode.getServiceGroup();
            switch (serviceGroup.getOrdinal()) {
                case 2: {
                    this.interfaceObjectType = in.readInt();
                    this.objectInstanceIndex = in.read();
                    this.propertyIdentifier = in.read();
                    this.numberOfElements = in.read();
                    this.startIndex = in.read();
                    if (in.available() > 0) {
                        this.data = new byte[in.available()];
                        in.read(this.data, 0, this.data.length);
                    }
                    this.validationResult = BCemiMessageValidationEnum.messageIsValid;
                    break;
                }
                case 3: {
                    this.interfaceObjectType = in.readInt();
                    this.objectInstanceIndex = in.read();
                    this.propertyIdentifier = in.read();
                    if (in.available() > 0) {
                        this.data = new byte[in.available()];
                        in.read(this.data, 0, this.data.length);
                    }
                    this.validationResult = BCemiMessageValidationEnum.messageIsValid;
                    break;
                }
                case 4: {
                    this.validationResult = BCemiMessageValidationEnum.messageIsValid;
                    break;
                }
                case 1: {
                    CemiTpdu tpdu;
                    int additionalInfoLength = in.read();
                    if (additionalInfoLength > 0) {
                        this.additionalInfo = new byte[additionalInfoLength];
                        in.read(this.additionalInfo);
                    }
                    this.ctrl1 = (byte)in.read();
                    if ((this.ctrl1 & 0x80) == 0) {
                        // empty if block
                    }
                    this.priority = BBusAccessPriorityEnum.make((this.ctrl1 & 0xC) >>> 2);
                    this.ctrl2 = (byte)in.read();
                    this.source = new BIndividualDeviceAddress(in.readInt());
                    if ((this.ctrl2 & 0x80) == 128) {
                        this.setDestination(new BGroupAddress(in.readInt()));
                    } else {
                        this.setDestination(new BIndividualDeviceAddress(in.readInt()));
                    }
                    this.tpdu = tpdu = CemiTpdu.make(in, this.getDestination());
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.toString());
        }
    }

    public String toString() {
        String s = "CemiMessage [ ";
        s = s + "msgCode=" + this.getCemiMessageCode().getTag();
        switch (this.getCemiMessageCode().getServiceGroup().getOrdinal()) {
            case 2: {
                s = s + ", interfaceObjectType=" + this.interfaceObjectType;
                s = s + ", objectInstanceIndex=" + this.objectInstanceIndex;
                s = s + ", propertyIdentifier=" + this.propertyIdentifier;
                s = s + ", numberOfElements=" + this.numberOfElements;
                s = s + ", startIndex=" + this.startIndex;
                s = s + ", data={ " + ByteArrayUtil.toHexString((byte[])this.data, (String)" ") + " }";
                break;
            }
            case 3: {
                s = s + ", interfaceObjectType=" + this.interfaceObjectType;
                s = s + ", objectInstanceIndex=" + this.objectInstanceIndex;
                s = s + ", propertyIdentifier=" + this.propertyIdentifier;
                s = s + ", data={ " + ByteArrayUtil.toHexString((byte[])this.data, (String)" ") + " }";
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                s = s + ", additionalInfoLength=" + (this.additionalInfo == null ? 0 : this.additionalInfo.length);
                if (this.additionalInfo != null && this.additionalInfo.length > 0) {
                    s = s + ", additionalInfo={ " + ByteArrayUtil.toHexString((byte[])this.additionalInfo, (String)" ") + " }";
                }
                s = s + ", ctrl1=" + TextUtil.byteToHexString((int)this.ctrl1) + "{ ";
                s = s + "frameType=" + ((this.ctrl1 & 0x80) == 0 ? "Extended" : "Standard");
                s = s + ", repeatFlag=" + ((this.ctrl1 & 0x20) == 0 ? "Repeat_If_Error" : "Do_Not_Repeat");
                s = s + ", broadcastFlag=" + ((this.ctrl1 & 0x10) == 0 ? "SystemBroadcast" : "Broadcast");
                s = s + ", priority=" + (Object)((Object)this.priority);
                s = s + ", ackRequest=" + ((this.ctrl1 & 2) == 0 ? "No_ACK_Requested" : "ACK_Requested");
                s = s + ", confirm=" + ((this.ctrl1 & 1) == 0 ? "Ok" : "Error");
                s = s + " }";
                s = s + ", ctrl2=" + TextUtil.byteToHexString((int)this.ctrl2) + "{ ";
                s = s + "addressType=" + ((this.ctrl2 & 0x80) == 0 ? "Individual" : "Group");
                s = s + ", routingCount=" + ((this.ctrl2 & 0x70) >>> 4);
                s = s + ", extendedFrameFormat=" + (Object)((Object)BExtendedFrameFormatEnum.make(this.ctrl2 & 0xF));
                s = s + " }";
                s = s + ", source=" + this.source;
                s = s + ", destination=" + this.destination;
                s = this.tpdu != null ? s + ", tpdu={ " + this.tpdu.toString() + " }" : s + ", tpdu={ NULL }";
            }
        }
        s = s + " ]";
        return s;
    }

    public boolean isMessageValid() {
        if (this.tpdu != null) {
            return this.tpdu.isMessageValid();
        }
        return this.validationResult.equals((Object)BCemiMessageValidationEnum.messageIsValid);
    }

    public BCemiMessageCodesEnum getCemiMessageCode() {
        return this.cemiMessageCode;
    }

    public CemiMessageData getData() {
        if (this.tpdu != null) {
            return this.tpdu.getData();
        }
        if (this.data != null) {
            CemiMessageData msgData = new CemiMessageData();
            msgData.data = this.data;
            msgData.sizeInBits = this.data.length * 8;
            return msgData;
        }
        return null;
    }

    public final BBusAccessPriorityEnum getPriority() {
        return this.priority;
    }

    public boolean isConfirmError() {
        return (this.ctrl1 & 1) == 1;
    }

    public final boolean isIndividualAddressType() {
        return (this.ctrl2 & 0x80) == 0;
    }

    public int getHopCount() {
        return this.ctrl2 >>> 4 & 7;
    }

    public CemiApdu getApdu() {
        if (this.tpdu != null) {
            return this.tpdu.getApdu();
        }
        return null;
    }

    public BApciCodesEnum getApciCode() {
        if (this.tpdu != null) {
            return this.tpdu.getApciCode();
        }
        return BApciCodesEnum.unknown;
    }

    public IKnxAddress getDestination() {
        return this.destination;
    }

    public void setDestination(IKnxAddress destination) {
        this.destination = destination;
    }

    public IKnxAddress getSource() {
        return this.source;
    }

    public final BTpciCodesEnum getTpciCode() {
        if (this.tpdu != null) {
            return this.tpdu.getTpciCode();
        }
        return BTpciCodesEnum.unknown;
    }

    public final int getTransportSequenceNumber() {
        if (this.tpdu != null) {
            return this.tpdu.getTransportSequenceNumber();
        }
        return -1;
    }

    public final int getInterfaceObjectType() {
        return this.interfaceObjectType;
    }

    public final void setInterfaceObjectType(int interfaceObjectType) {
        this.interfaceObjectType = interfaceObjectType;
    }

    public final int getObjectInstanceIndex() {
        return this.objectInstanceIndex;
    }

    public final void setObjectInstanceIndex(int objectInstanceIndex) {
        this.objectInstanceIndex = objectInstanceIndex;
    }

    public final int getPropertyIdentifier() {
        return this.propertyIdentifier;
    }

    public final void setPropertyIdentifier(int propertyIdentifier) {
        this.propertyIdentifier = propertyIdentifier;
    }

    public final int getNumberOfElements() {
        return this.numberOfElements;
    }

    public final void setNumberOfElements(int numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }
}

