/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.cemi;

import com.tridiumX.knxnetIp.addresses.BGroupAddress;
import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.addresses.IKnxAddress;
import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.cemi.BCemiMessageValidationEnum;
import com.tridiumX.knxnetIp.comms.cemi.CemiApdu;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.comms.cemi.GroupValueApdu;
import com.tridiumX.knxnetIp.comms.cemi.IApduFactory;
import com.tridiumX.knxnetIp.knxSpec.BApciCodesEnum;
import com.tridiumX.knxnetIp.knxSpec.BTpciCodesEnum;
import java.io.IOException;

public class CemiTpdu {
    private static final int TRANSPORT_CONTROL_FIELD_MASK = 252;
    private static final int TRANSPORT_LAYER_INDIVIDUAL_ADDRESS_TPDU_TYPE_BIT_MASK = 192;
    private static final int TRANSPORT_CONTROL_FIELD_ACPI_BITS_MASK = 3;
    private static final int TRANSPORT_SEQUENCE_NUMBER_BIT_MASK = 60;
    private static final int TRANSPORT_SEQUENCE_NUMBER_BIT_OFFSET = 2;
    private BCemiMessageValidationEnum validationResult = BCemiMessageValidationEnum.DEFAULT;
    private BTpciCodesEnum tpciCode = BTpciCodesEnum.DEFAULT;
    private int transportSequenceNumber = 0;
    private CemiApdu apdu;
    private static IApduFactory apduFactory;

    public static final CemiTpdu make(BTpciCodesEnum tpciCode, int sequenceNumber, CemiApdu cemiApdu) {
        CemiTpdu tpdu = new CemiTpdu();
        tpdu.tpciCode = tpciCode;
        tpdu.transportSequenceNumber = sequenceNumber;
        tpdu.apdu = cemiApdu;
        return tpdu;
    }

    public static final CemiTpdu make(KnxInputStream in, IKnxAddress destination) throws IOException {
        CemiTpdu tpdu = new CemiTpdu();
        int acpiLength = in.read();
        int transportControlField = in.read();
        if (destination instanceof BGroupAddress) {
            if ((transportControlField & 0xFC) == 0) {
                tpdu.tpciCode = destination.getAddress() == 0 ? BTpciCodesEnum.T_Data_Broadcast_PDU : BTpciCodesEnum.T_Data_Group_PDU;
            } else if ((transportControlField & 0xFC) == 1) {
                tpdu.tpciCode = BTpciCodesEnum.T_Data_Tag_Group_PDU;
            } else {
                tpdu.validationResult = BCemiMessageValidationEnum.unsupportedGroupTypeTransportControlField;
            }
        } else if (destination instanceof BIndividualDeviceAddress) {
            if (transportControlField == 128) {
                tpdu.tpciCode = BTpciCodesEnum.T_Connect_PDU;
            } else if (transportControlField == 129) {
                tpdu.tpciCode = BTpciCodesEnum.T_Disconnect_PDU;
            } else {
                int individualAddressTpduType = transportControlField & 0xC0;
                if (individualAddressTpduType == 0) {
                    tpdu.tpciCode = BTpciCodesEnum.T_Data_Individual_PDU;
                } else if (individualAddressTpduType == 64) {
                    tpdu.tpciCode = BTpciCodesEnum.T_Data_Connected_PDU;
                    tpdu.transportSequenceNumber = (transportControlField & 0x3C) >>> 2;
                } else if (individualAddressTpduType == 192) {
                    if ((transportControlField & 3) == 2) {
                        tpdu.tpciCode = BTpciCodesEnum.T_Ack_PDU;
                        tpdu.transportSequenceNumber = (transportControlField & 0x3C) >>> 2;
                    } else if ((transportControlField & 3) == 3) {
                        tpdu.tpciCode = BTpciCodesEnum.T_Nak_PDU;
                        tpdu.transportSequenceNumber = (transportControlField & 0x3C) >>> 2;
                    } else {
                        tpdu.validationResult = BCemiMessageValidationEnum.unsupportedIndividualTypeTransportControlField;
                    }
                } else {
                    tpdu.validationResult = BCemiMessageValidationEnum.unsupportedIndividualTypeTransportControlField;
                }
            }
        }
        if (acpiLength > 0) {
            int appControlField = in.read() | (transportControlField & 3) << 8;
            if (tpdu.tpciCode.equals((Object)BTpciCodesEnum.T_Data_Group_PDU)) {
                switch (appControlField & 0x3C0) {
                    case 0: {
                        tpdu.apdu = GroupValueApdu.fromStream(BApciCodesEnum.A_GroupValue_Read_PDU, in, 0, 0);
                        break;
                    }
                    case 64: {
                        tpdu.apdu = GroupValueApdu.fromStream(BApciCodesEnum.A_GroupValue_Response_PDU, in, acpiLength, appControlField);
                        break;
                    }
                    case 128: {
                        tpdu.apdu = GroupValueApdu.fromStream(BApciCodesEnum.A_GroupValue_Write_PDU, in, acpiLength, appControlField);
                        break;
                    }
                    default: {
                        tpdu.validationResult = BCemiMessageValidationEnum.unsupportedTDataGroupApduType;
                    }
                }
                if (tpdu.validationResult.equals((Object)BCemiMessageValidationEnum.DEFAULT)) {
                    tpdu.validationResult = BCemiMessageValidationEnum.messageIsValid;
                }
            } else if (apduFactory != null) {
                tpdu.apdu = apduFactory.makeFromStream(tpdu.tpciCode, in, appControlField);
                if (tpdu.validationResult.equals((Object)BCemiMessageValidationEnum.DEFAULT)) {
                    tpdu.validationResult = tpdu.apdu == null ? BCemiMessageValidationEnum.unsupportedTpciCode : BCemiMessageValidationEnum.messageIsValid;
                }
            } else {
                tpdu.validationResult = BCemiMessageValidationEnum.unsupportedTpciCode;
            }
        } else if (tpdu.validationResult.equals((Object)BCemiMessageValidationEnum.DEFAULT)) {
            tpdu.validationResult = BCemiMessageValidationEnum.messageIsValid;
        }
        return tpdu;
    }

    public boolean isMessageValid() {
        return this.validationResult.equals((Object)BCemiMessageValidationEnum.messageIsValid);
    }

    public CemiApdu getApdu() {
        if (this.apdu != null) {
            return this.apdu;
        }
        return null;
    }

    public BApciCodesEnum getApciCode() {
        if (this.apdu != null) {
            return this.apdu.apciCode;
        }
        return BApciCodesEnum.unknown;
    }

    public CemiMessageData getData() {
        if (this.apdu instanceof GroupValueApdu) {
            return ((GroupValueApdu)this.apdu).getData();
        }
        return null;
    }

    public void toStream(KnxOutputStream out) throws IOException {
        int acpiLength = 0;
        if (this.apdu != null) {
            acpiLength = 1 + this.apdu.getAcpiLength();
        }
        out.write(acpiLength);
        int tcf = this.tpciCode.getOrdinal() | this.transportSequenceNumber << 2;
        if (this.apdu == null) {
            out.write(tcf);
        } else {
            this.apdu.toStream(out, (tcf & 0xFC) << 8);
        }
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer();
            int acpiLength = 0;
            if (this.apdu != null) {
                acpiLength = 1 + this.apdu.getAcpiLength();
            }
            sb.append("acpiLength=" + acpiLength);
            sb.append(", tpciCode=" + this.tpciCode.getTag());
            if (this.tpciCode.equals((Object)BTpciCodesEnum.T_Data_Connected_PDU) || this.tpciCode.equals((Object)BTpciCodesEnum.T_Ack_PDU) || this.tpciCode.equals((Object)BTpciCodesEnum.T_Nak_PDU)) {
                sb.append(", transportSequenceNumber=" + this.transportSequenceNumber);
            }
            if (this.apdu != null) {
                sb.append(", " + this.apdu.toString());
            }
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "{[ Exception :- " + ex.toString() + " !!! ]}";
        }
    }

    public final BTpciCodesEnum getTpciCode() {
        return this.tpciCode;
    }

    public final int getTransportSequenceNumber() {
        return this.transportSequenceNumber;
    }

    public static final void setApduFactory(IApduFactory factory) {
        apduFactory = factory;
    }
}

