/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.cemi;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.cemi.CemiApdu;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.knxSpec.BApciCodesEnum;
import java.io.IOException;

public final class GroupValueApdu
extends CemiApdu {
    private CemiMessageData msgData;

    private GroupValueApdu(BApciCodesEnum apciCode) {
        super(apciCode);
    }

    public static final CemiApdu make(BApciCodesEnum apciCode) {
        return GroupValueApdu.factory(apciCode, null);
    }

    public static final CemiApdu make(BApciCodesEnum apciCode, CemiMessageData msgData) {
        return GroupValueApdu.factory(apciCode, msgData);
    }

    private static final CemiApdu factory(BApciCodesEnum apciCode, CemiMessageData msgData) {
        GroupValueApdu apdu = new GroupValueApdu(apciCode);
        apdu.msgData = msgData;
        return apdu;
    }

    public static final CemiApdu fromStream(BApciCodesEnum apciCode, KnxInputStream in, int acpiLength, int appControlField) {
        GroupValueApdu apdu = new GroupValueApdu(apciCode);
        if (acpiLength > 0) {
            CemiMessageData msgData = new CemiMessageData();
            if (acpiLength == 1) {
                msgData.data = new byte[1];
                msgData.data[0] = (byte)(appControlField & 0x3F);
                msgData.sizeInBits = 6;
            } else {
                msgData.data = new byte[acpiLength - 1];
                in.read(msgData.data, 0, msgData.data.length);
                msgData.sizeInBits = msgData.data.length * 8;
            }
            apdu.msgData = msgData;
        }
        return apdu;
    }

    @Override
    public int getAcpiLength() {
        if (this.msgData != null && this.msgData.data != null && !this.msgData.shouldOptimize()) {
            return this.msgData.data.length;
        }
        return 0;
    }

    @Override
    public void toStream(KnxOutputStream out, int transportControlField) throws IOException {
        int apciVal = this.apciCode.getOrdinal();
        if (this.msgData != null && this.msgData.data != null && this.msgData.shouldOptimize()) {
            apciVal |= this.msgData.data[0] & 0x3F;
        }
        out.writeInt(transportControlField | apciVal);
        if (this.msgData != null && this.msgData.data != null && !this.msgData.shouldOptimize()) {
            out.write(this.msgData.data);
        }
    }

    @Override
    protected void toString(StringBuffer sb) {
        if (this.msgData != null) {
            sb.append(", " + this.msgData.toString());
        }
    }

    public CemiMessageData getData() {
        return this.msgData;
    }
}

