/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.ConnectionResponseData;
import com.tridiumX.knxnetIp.comms.frames.parts.HostProtocolAddressInformation;
import com.tridiumX.knxnetIp.knxSpec.BKnxErrorCodesEnum;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;

public final class CoreConnectResponse
extends KnxIpFrame {
    private int channelId = -1;
    private int status = 0;
    private HostProtocolAddressInformation hpai = null;
    private ConnectionResponseData crd;

    public CoreConnectResponse() {
    }

    public CoreConnectResponse(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public CoreConnectResponse(int channelId, int status) {
        this.channelId = channelId;
        this.status = status;
    }

    public CoreConnectResponse(int channelId, int status, InetAddress address, int port, ConnectionResponseData crd) {
        this.channelId = channelId;
        this.status = status;
        this.hpai = new HostProtocolAddressInformation(address, port);
        this.crd = crd;
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.coreConnectResponse;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 8;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            this.channelId = in.read();
            this.status = in.read();
            if (this.status == 0) {
                this.hpai = new HostProtocolAddressInformation(in);
                this.crd = ConnectionResponseData.makeFromStream(in);
            }
        }
        catch (Exception ex) {
            if (CoreConnectResponse.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        out.write(this.channelId);
        out.write(this.status);
        if (this.status == 0) {
            if (this.hpai.getAddress() == null) {
                throw new IOException("HPAI address is null");
            }
            if (this.hpai.getPort() == -1) {
                throw new IOException("HPAI port == Constants.NO_IP_PORT_NUMBER (-1)");
            }
            if (this.crd == null) {
                throw new IOException("ConnectionResponseData is null");
            }
            this.hpai.toStream(out);
            this.crd.toStream(out);
        }
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        sb.append("Channel_ID = " + this.channelId);
        sb.append(", Status = " + this.status + " - " + BKnxErrorCodesEnum.make(this.status).getDisplayTag(null));
        if (this.status == 0) {
            sb.append(", HPAI = " + (this.hpai == null ? "null" : this.hpai.getLogString()));
            sb.append(", CRD = { " + (this.crd == null ? "null" : this.crd.getLogString()) + " }");
        }
    }

    public int getChannelId() {
        return this.channelId;
    }

    public int getStatus() {
        return this.status;
    }

    public HostProtocolAddressInformation getHpai() {
        return this.hpai;
    }

    public ConnectionResponseData getCrd() {
        return this.crd;
    }
}

