/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.HostProtocolAddressInformation;
import com.tridiumX.knxnetIp.knxSpec.BKnxErrorCodesEnum;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;

public final class CoreConnectionStateRequest
extends KnxIpFrame {
    private int channelId = -1;
    private int status = 0;
    private HostProtocolAddressInformation hpai;

    public CoreConnectionStateRequest() {
    }

    public CoreConnectionStateRequest(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public CoreConnectionStateRequest(int channel, InetAddress address, int port) {
        this.channelId = channel;
        this.hpai = new HostProtocolAddressInformation(address, port);
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.coreConnectionStateRequest;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 16;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            this.channelId = in.read();
            this.status = in.read();
            this.hpai = new HostProtocolAddressInformation(in);
        }
        catch (Exception ex) {
            if (CoreConnectionStateRequest.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        if (this.channelId == -1) {
            throw new IOException("channelId == KnxSpec.NO_CHANNEL_ID (-1)");
        }
        if (this.hpai.getAddress() == null) {
            throw new IOException("endpoint address is null");
        }
        if (this.hpai.getPort() == -1) {
            throw new IOException("endpoint Port port == Constants.NO_IP_PORT_NUMBER (-1)");
        }
        out.write(this.channelId);
        out.write(this.status);
        this.hpai.toStream(out);
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        sb.append("Channel_ID = " + this.channelId);
        sb.append(", Status = " + this.status + " - " + BKnxErrorCodesEnum.make(this.status).getDisplayTag(null));
        sb.append(", HPAI = " + this.hpai.getLogString());
    }

    public int getChannelId() {
        return this.channelId;
    }

    public final HostProtocolAddressInformation getHpai() {
        return this.hpai;
    }
}

