/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.HostProtocolAddressInformation;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;

public final class CoreDescriptionRequest
extends KnxIpFrame {
    private HostProtocolAddressInformation hpai;

    public CoreDescriptionRequest() {
    }

    public CoreDescriptionRequest(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public CoreDescriptionRequest(InetAddress address, int port) {
        this.hpai = new HostProtocolAddressInformation(address, port);
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.coreDescriptionRequest;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 14;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            this.hpai = new HostProtocolAddressInformation(in);
        }
        catch (Exception ex) {
            if (CoreDescriptionRequest.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        if (this.hpai.getAddress() == null) {
            throw new IOException("HPAI address is null");
        }
        if (this.hpai.getPort() == -1) {
            throw new IOException("HPAI port == Constants.NO_IP_PORT_NUMBER (-1)");
        }
        this.hpai.toStream(out);
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        sb.append("HPAI = " + this.hpai.getLogString());
    }

    public HostProtocolAddressInformation getHpai() {
        return this.hpai;
    }
}

