/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames.parts;

import com.tridium.nre.util.IPAddressUtil;
import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.parts.BDescriptionInformationBlock;
import com.tridiumX.knxnetIp.knxSpec.BKnxMediumCodeEnum;
import java.io.IOException;
import java.net.InetAddress;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="knxMedium", type="BEnum", defaultValue="BKnxMediumCodeEnum.unknown"), @NiagaraProperty(name="deviceStatus", type="boolean", defaultValue="false", flags=2, facets={@Facet(value="BFacets.makeBoolean(\"%lexicon(knxnetIp:deviceInfoDib.status.programMode)%\", \"%lexicon(knxnetIp:deviceInfoDib.status.ok)%\")")}), @NiagaraProperty(name="individualAddress", type="BIndividualDeviceAddress", defaultValue="new BIndividualDeviceAddress()"), @NiagaraProperty(name="projectNumber", type="int", defaultValue="0"), @NiagaraProperty(name="installationNumber", type="int", defaultValue="0"), @NiagaraProperty(name="serialNumber", type="String", defaultValue="KnxStrings.EMPTY_STRING", facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, 12)")}), @NiagaraProperty(name="routingMulticastAddress", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, \"platform:IpHostFE\")")}), @NiagaraProperty(name="macAddress", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="friendlyName", type="String", defaultValue="KnxStrings.EMPTY_STRING", facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, 30)")})})
public final class BDeviceInfoDIB
extends BDescriptionInformationBlock {
    public static final Property knxMedium = BDeviceInfoDIB.newProperty((int)0, (BValue)BKnxMediumCodeEnum.unknown, null);
    public static final Property deviceStatus = BDeviceInfoDIB.newProperty((int)2, (boolean)false, (BFacets)BFacets.makeBoolean((String)"%lexicon(knxnetIp:deviceInfoDib.status.programMode)%", (String)"%lexicon(knxnetIp:deviceInfoDib.status.ok)%"));
    public static final Property individualAddress = BDeviceInfoDIB.newProperty((int)0, (BValue)new BIndividualDeviceAddress(), null);
    public static final Property projectNumber = BDeviceInfoDIB.newProperty((int)0, (int)0, null);
    public static final Property installationNumber = BDeviceInfoDIB.newProperty((int)0, (int)0, null);
    public static final Property serialNumber = BDeviceInfoDIB.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (int)12));
    public static final Property routingMulticastAddress = BDeviceInfoDIB.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"platform:IpHostFE"));
    public static final Property macAddress = BDeviceInfoDIB.newProperty((int)1, (String)"", null);
    public static final Property friendlyName = BDeviceInfoDIB.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (int)30));
    public static final Type TYPE = Sys.loadType(BDeviceInfoDIB.class);

    public BEnum getKnxMedium() {
        return (BEnum)this.get(knxMedium);
    }

    public void setKnxMedium(BEnum v) {
        this.set(knxMedium, (BValue)v, null);
    }

    public boolean getDeviceStatus() {
        return this.getBoolean(deviceStatus);
    }

    public void setDeviceStatus(boolean v) {
        this.setBoolean(deviceStatus, v, null);
    }

    public BIndividualDeviceAddress getIndividualAddress() {
        return (BIndividualDeviceAddress)this.get(individualAddress);
    }

    public void setIndividualAddress(BIndividualDeviceAddress v) {
        this.set(individualAddress, (BValue)v, null);
    }

    public int getProjectNumber() {
        return this.getInt(projectNumber);
    }

    public void setProjectNumber(int v) {
        this.setInt(projectNumber, v, null);
    }

    public int getInstallationNumber() {
        return this.getInt(installationNumber);
    }

    public void setInstallationNumber(int v) {
        this.setInt(installationNumber, v, null);
    }

    public String getSerialNumber() {
        return this.getString(serialNumber);
    }

    public void setSerialNumber(String v) {
        this.setString(serialNumber, v, null);
    }

    public String getRoutingMulticastAddress() {
        return this.getString(routingMulticastAddress);
    }

    public void setRoutingMulticastAddress(String v) {
        this.setString(routingMulticastAddress, v, null);
    }

    public String getMacAddress() {
        return this.getString(macAddress);
    }

    public void setMacAddress(String v) {
        this.setString(macAddress, v, null);
    }

    public String getFriendlyName() {
        return this.getString(friendlyName);
    }

    public void setFriendlyName(String v) {
        this.setString(friendlyName, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static final BDeviceInfoDIB make(KnxInputStream in) throws IOException {
        BDeviceInfoDIB dib = new BDeviceInfoDIB();
        dib.fromStream(in);
        return dib;
    }

    @Override
    public void fromStream(KnxInputStream in) throws IOException {
        if (in.read() != 54) {
            throw new IOException("incorrect struct length for hardware DIB");
        }
        if (in.read() != 1) {
            throw new IOException("DIB is not a 'Device Info' DIB");
        }
        this.setKnxMedium((BEnum)BKnxMediumCodeEnum.make(in.read()));
        this.setDeviceStatus(in.read() != 0);
        this.setIndividualAddress(new BIndividualDeviceAddress(in.readInt()));
        int proj = in.readInt();
        this.setProjectNumber(proj >>> 4);
        this.setInstallationNumber(proj & 0xF);
        byte[] sn = new byte[6];
        in.read(sn);
        this.setSerialNumber(ByteArrayUtil.toHexString((byte[])sn));
        byte[] rma = new byte[4];
        in.read(rma);
        this.setRoutingMulticastAddress(InetAddress.getByAddress(rma).getHostAddress());
        byte[] mac = new byte[6];
        in.read(mac);
        this.setMacAddress(ByteArrayUtil.toHexString((byte[])mac));
        byte[] characters = new byte[30];
        int count = 0;
        for (int i = 0; i < 30; ++i) {
            int nextChar = in.read();
            if (nextChar != 0) {
                characters[i] = (byte)nextChar;
                ++count;
                continue;
            }
            in.skip(30 - i - 1);
            break;
        }
        this.setFriendlyName(new String(characters, 0, count).trim());
    }

    @Override
    public void toStream(KnxOutputStream out) throws IOException {
        out.write(54);
        out.write(1);
        out.write(this.getKnxMedium().getOrdinal());
        out.write(0);
        out.writeInt(this.getIndividualAddress().getAddress());
        int iProj = this.getProjectNumber() << 4 | this.getInstallationNumber() & 0xF;
        out.writeInt(iProj);
        byte[] sn = ByteArrayUtil.hexStringToBytes((String)this.getSerialNumber());
        if (sn.length >= 6) {
            out.write(sn, 0, 6);
        } else {
            out.write(sn, 0, sn.length);
            for (int i = sn.length; i < 6; ++i) {
                out.write(0);
            }
        }
        out.write(IPAddressUtil.numericStringToByteArray((String)this.getRoutingMulticastAddress()), 0, 4);
        out.write(ByteArrayUtil.hexStringToBytes((String)TextUtil.replace((String)this.getMacAddress(), (String)":", (String)"")));
        byte[] friendlyName = this.getFriendlyName().getBytes();
        if (friendlyName.length >= 30) {
            out.write(friendlyName, 0, 30);
        } else {
            out.write(friendlyName, 0, friendlyName.length);
            for (int i = friendlyName.length; i < 30; ++i) {
                out.write(0);
            }
        }
    }

    @Override
    public void toLogString(StringBuffer sb) {
        sb.append("knxMedium = " + this.getKnxMedium());
        sb.append(", deviceStatus = " + this.getDeviceStatus());
        sb.append(", individualAddress = " + this.getIndividualAddress());
        sb.append(", projectNumber = " + this.getProjectNumber());
        sb.append(", installationNumber = " + this.getInstallationNumber());
        sb.append(", serialNumber = " + this.getSerialNumber());
        sb.append(", routingMulticastAddress = " + this.getRoutingMulticastAddress());
        sb.append(", macAddress = " + this.getMacAddress());
        sb.append(", friendlyName = " + this.getFriendlyName());
    }
}

