/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames.parts;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.parts.BDescriptionInformationBlock;
import com.tridiumX.knxnetIp.comms.frames.parts.BServiceFamily;
import com.tridiumX.knxnetIp.knxSpec.BKnxConnectionTypeEnum;
import com.tridiumX.knxnetIp.knxSpec.BServiceFamilyEnum;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="core", type="BServiceFamily", defaultValue="new BServiceFamily(BServiceFamilyEnum.core)", flags=1), @NiagaraProperty(name="deviceManagement", type="BServiceFamily", defaultValue="new BServiceFamily(BServiceFamilyEnum.devMgmt)", flags=1), @NiagaraProperty(name="tunneling", type="BServiceFamily", defaultValue="new BServiceFamily(BServiceFamilyEnum.tunnelling)", flags=1), @NiagaraProperty(name="routing", type="BServiceFamily", defaultValue="new BServiceFamily(BServiceFamilyEnum.routing)", flags=1), @NiagaraProperty(name="remoteLogging", type="BServiceFamily", defaultValue="new BServiceFamily(BServiceFamilyEnum.remLog)", flags=1), @NiagaraProperty(name="remoteConfiguration", type="BServiceFamily", defaultValue="new BServiceFamily(BServiceFamilyEnum.remConf)", flags=1), @NiagaraProperty(name="objectServer", type="BServiceFamily", defaultValue="new BServiceFamily(BServiceFamilyEnum.objSrv)", flags=1)})
public class BSupportedServiceFamiliesDIB
extends BDescriptionInformationBlock {
    public static final Property core = BSupportedServiceFamiliesDIB.newProperty((int)1, (BValue)new BServiceFamily(BServiceFamilyEnum.core), null);
    public static final Property deviceManagement = BSupportedServiceFamiliesDIB.newProperty((int)1, (BValue)new BServiceFamily(BServiceFamilyEnum.devMgmt), null);
    public static final Property tunneling = BSupportedServiceFamiliesDIB.newProperty((int)1, (BValue)new BServiceFamily(BServiceFamilyEnum.tunnelling), null);
    public static final Property routing = BSupportedServiceFamiliesDIB.newProperty((int)1, (BValue)new BServiceFamily(BServiceFamilyEnum.routing), null);
    public static final Property remoteLogging = BSupportedServiceFamiliesDIB.newProperty((int)1, (BValue)new BServiceFamily(BServiceFamilyEnum.remLog), null);
    public static final Property remoteConfiguration = BSupportedServiceFamiliesDIB.newProperty((int)1, (BValue)new BServiceFamily(BServiceFamilyEnum.remConf), null);
    public static final Property objectServer = BSupportedServiceFamiliesDIB.newProperty((int)1, (BValue)new BServiceFamily(BServiceFamilyEnum.objSrv), null);
    public static final Type TYPE = Sys.loadType(BSupportedServiceFamiliesDIB.class);

    public BServiceFamily getCore() {
        return (BServiceFamily)this.get(core);
    }

    public void setCore(BServiceFamily v) {
        this.set(core, (BValue)v, null);
    }

    public BServiceFamily getDeviceManagement() {
        return (BServiceFamily)this.get(deviceManagement);
    }

    public void setDeviceManagement(BServiceFamily v) {
        this.set(deviceManagement, (BValue)v, null);
    }

    public BServiceFamily getTunneling() {
        return (BServiceFamily)this.get(tunneling);
    }

    public void setTunneling(BServiceFamily v) {
        this.set(tunneling, (BValue)v, null);
    }

    public BServiceFamily getRouting() {
        return (BServiceFamily)this.get(routing);
    }

    public void setRouting(BServiceFamily v) {
        this.set(routing, (BValue)v, null);
    }

    public BServiceFamily getRemoteLogging() {
        return (BServiceFamily)this.get(remoteLogging);
    }

    public void setRemoteLogging(BServiceFamily v) {
        this.set(remoteLogging, (BValue)v, null);
    }

    public BServiceFamily getRemoteConfiguration() {
        return (BServiceFamily)this.get(remoteConfiguration);
    }

    public void setRemoteConfiguration(BServiceFamily v) {
        this.set(remoteConfiguration, (BValue)v, null);
    }

    public BServiceFamily getObjectServer() {
        return (BServiceFamily)this.get(objectServer);
    }

    public void setObjectServer(BServiceFamily v) {
        this.set(objectServer, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static final BSupportedServiceFamiliesDIB make(KnxInputStream in) throws IOException {
        BSupportedServiceFamiliesDIB dib = new BSupportedServiceFamiliesDIB();
        dib.fromStream(in);
        return dib;
    }

    public boolean isServiceTypeSupported(BKnxConnectionTypeEnum typeCode) {
        switch (typeCode.getOrdinal()) {
            case 3: {
                return this.getDeviceManagement().getSupport();
            }
            case 4: {
                return this.getTunneling().getSupport();
            }
            case 5: {
                return this.getRouting().getSupport();
            }
            case 6: {
                return this.getRemoteLogging().getSupport();
            }
            case 7: {
                return this.getRemoteConfiguration().getSupport();
            }
            case 8: {
                return this.getObjectServer().getSupport();
            }
        }
        return false;
    }

    @Override
    public void fromStream(KnxInputStream in) throws IOException {
        int serviceDibLen = in.read();
        if (in.read() != 2) {
            throw new IOException("DIB is not a 'Supported Service Families' DIB");
        }
        for (int i = 0; i < serviceDibLen - 2; i += 2) {
            int service = in.read();
            int version = in.read();
            BServiceFamily serviceFamily = null;
            switch (service) {
                case 2: {
                    serviceFamily = this.getCore();
                    break;
                }
                case 3: {
                    serviceFamily = this.getDeviceManagement();
                    break;
                }
                case 4: {
                    serviceFamily = this.getTunneling();
                    break;
                }
                case 5: {
                    serviceFamily = this.getRouting();
                    break;
                }
                case 6: {
                    serviceFamily = this.getRemoteLogging();
                    break;
                }
                case 7: {
                    serviceFamily = this.getRemoteConfiguration();
                    break;
                }
                case 8: {
                    serviceFamily = this.getObjectServer();
                    break;
                }
            }
            if (serviceFamily == null) continue;
            serviceFamily.setSupport(true);
            serviceFamily.setVersion(version);
        }
    }

    @Override
    public void toStream(KnxOutputStream out) throws IOException {
        int i;
        Property[] properties = this.getPropertiesArray();
        BServiceFamily[] serviceFamilies = new BServiceFamily[properties.length];
        int count = 0;
        for (i = 0; i < properties.length; ++i) {
            BServiceFamily serviceFamily;
            BValue value = this.get(properties[i]);
            if (!(value instanceof BServiceFamily) || !(serviceFamily = (BServiceFamily)value).getSupport()) continue;
            serviceFamilies[count++] = serviceFamily;
        }
        out.write(2 + count * 2);
        out.write(2);
        for (i = 0; i < count; ++i) {
            BServiceFamily serviceFamily = serviceFamilies[i];
            out.write(serviceFamily.getServiceFamilyId().getOrdinal());
            out.write(serviceFamily.getVersion());
        }
    }

    @Override
    public void toLogString(StringBuffer sb) {
        Property[] properties = this.getPropertiesArray();
        int count = 0;
        for (int i = 0; i < properties.length; ++i) {
            BServiceFamily serviceFamily;
            BValue value = this.get(properties[i]);
            if (!(value instanceof BServiceFamily) || !(serviceFamily = (BServiceFamily)value).getSupport()) continue;
            if (count > 0) {
                sb.append(", ");
            }
            sb.append("service=" + (Object)((Object)serviceFamily.getServiceFamilyId()));
            sb.append(", version=" + serviceFamily.getVersion());
            ++count;
        }
        if (count == 0) {
            sb.append("NO SUPPORTED SERVICE FAMILIES!");
        }
    }
}

