/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames.parts;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.enums.BKnxIpFrameValidationResultEnum;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;

public final class KnxIpFrameHeader {
    public int headerSize;
    public int protocolVersion;
    public final BKnxIpFrameTypeEnum frameType;
    public int totalSize;

    private KnxIpFrameHeader(KnxInputStream in) {
        this.headerSize = in.read();
        this.protocolVersion = in.read();
        this.frameType = BKnxIpFrameTypeEnum.make(in.readInt());
        this.totalSize = in.readInt();
    }

    public KnxIpFrameHeader(BKnxIpFrameTypeEnum knxIpFrameType) {
        this.headerSize = 6;
        this.protocolVersion = 16;
        this.frameType = knxIpFrameType;
        this.totalSize = 0;
    }

    public static KnxIpFrameHeader make(KnxInputStream in) {
        return new KnxIpFrameHeader(in);
    }

    public void toStream(KnxOutputStream out) {
        out.write(this.headerSize);
        out.write(this.protocolVersion);
        out.writeInt(this.frameType.getOrdinal());
        out.writeInt(this.totalSize);
    }

    public BKnxIpFrameValidationResultEnum validate() {
        if (this.protocolVersion != 16) {
            return BKnxIpFrameValidationResultEnum.unsupportedProtocolVersion;
        }
        if (this.headerSize != 6) {
            return BKnxIpFrameValidationResultEnum.wrongHeaderSize;
        }
        if (this.totalSize < 6) {
            return BKnxIpFrameValidationResultEnum.totalSizeTooSmall;
        }
        return BKnxIpFrameValidationResultEnum.packetIsValid;
    }

    public int getServiceType() {
        return this.frameType.getOrdinal() >>> 8 & 0xFF;
    }
}

