/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.udp;

import com.tridiumX.knxnetIp.comms.udp.UdpMulticastMessage;
import javax.baja.nre.util.ByteArrayUtil;

public final class IgmpMembershipReportMessage
extends UdpMulticastMessage {
    private static final int IGMP_V2_DATA_LENGTH = 8;
    private static final byte IGMP_TYPE_V2_MEMBERSHIP_REPORT = 22;
    private static final byte IGMP_TTL = 1;
    private static final byte[] IP_OPTIONS = new byte[]{-108, 4, 0, 0};

    public IgmpMembershipReportMessage(byte[] sourceMacAddress, byte[] sourceIpAddress, byte[] destIpAddress, int sourcePort, int destPort, boolean debugOutput) {
        byte[] igmpBytes = new byte[]{22, 0, 0, 0, destIpAddress[0], destIpAddress[1], destIpAddress[2], destIpAddress[3]};
        int checkSum = this.runningChecksum(0, igmpBytes);
        igmpBytes[2] = (byte)(checkSum >>> 8 & 0xFF);
        igmpBytes[3] = (byte)(checkSum & 0xFF);
        this.make(sourceMacAddress, (byte)1, sourceIpAddress, destIpAddress, IP_OPTIONS, sourcePort, destPort, igmpBytes, debugOutput);
    }

    @Override
    public String toString() {
        if (this.bytes == null) {
            return "IgmpMembershipReportMessage:null";
        }
        return "IgmpMembershipReportMessage:" + ByteArrayUtil.toHexString((byte[])this.bytes);
    }
}

