/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.driver;

import com.tridiumX.knxnetIp.comms.BKnxInstallation;
import com.tridiumX.knxnetIp.comms.BLocalInterfaces;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.driver.BKnxDeviceFolder;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxStationDataDefs;
import com.tridiumX.knxnetIp.point.BKnxPollScheduler;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.util.actions.BCheckTraceablesActionsAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BIService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="tuningPolicies", type="BTuningPolicyMap", defaultValue="new BTuningPolicyMap()"), @NiagaraProperty(name="pollScheduler", type="BPollScheduler", defaultValue="new BKnxPollScheduler()"), @NiagaraProperty(name="localInterfaces", type="BLocalInterfaces", defaultValue="new BLocalInterfaces()"), @NiagaraProperty(name="knxDataDefs", type="BKnxStationDataDefs", defaultValue="new BKnxStationDataDefs()", flags=65536), @NiagaraProperty(name="propertiesVersion", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="addTraceablesActions", flags=4), @NiagaraAction(name="removeTraceablesActions", flags=4)})
public final class BKnxNetwork
extends BDeviceNetwork
implements BIService {
    public static final Property tuningPolicies = BKnxNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    public static final Property pollScheduler = BKnxNetwork.newProperty((int)0, (BValue)new BKnxPollScheduler(), null);
    public static final Property localInterfaces = BKnxNetwork.newProperty((int)0, (BValue)new BLocalInterfaces(), null);
    public static final Property knxDataDefs = BKnxNetwork.newProperty((int)65536, (BValue)new BKnxStationDataDefs(), null);
    public static final Property propertiesVersion = BKnxNetwork.newProperty((int)5, (String)"", null);
    public static final Action addTraceablesActions = BKnxNetwork.newAction((int)4, null);
    public static final Action removeTraceablesActions = BKnxNetwork.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BKnxNetwork.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    private static BKnxNetwork knxnetService = null;
    protected static final Logger knxLog = Logger.getLogger(TYPE.getModule().getModuleName());
    private static final Logger commsLog = Logger.getLogger(knxLog.getName() + ".comms");
    private static Lexicon lex = Lexicon.make(BKnxNetwork.class);
    private int lastUsedDeviceId = 0;

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap v) {
        this.set(tuningPolicies, (BValue)v, null);
    }

    public BPollScheduler getPollScheduler() {
        return (BPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public BLocalInterfaces getLocalInterfaces() {
        return (BLocalInterfaces)this.get(localInterfaces);
    }

    public void setLocalInterfaces(BLocalInterfaces v) {
        this.set(localInterfaces, (BValue)v, null);
    }

    public BKnxStationDataDefs getKnxDataDefs() {
        return (BKnxStationDataDefs)this.get(knxDataDefs);
    }

    public void setKnxDataDefs(BKnxStationDataDefs v) {
        this.set(knxDataDefs, (BValue)v, null);
    }

    public String getPropertiesVersion() {
        return this.getString(propertiesVersion);
    }

    public void setPropertiesVersion(String v) {
        this.setString(propertiesVersion, v, null);
    }

    public void addTraceablesActions() {
        this.invoke(addTraceablesActions, null, null);
    }

    public void removeTraceablesActions() {
        this.invoke(removeTraceablesActions, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BKnxNetwork() {
        this.setFlags((Slot)ping, 4);
        this.getMonitor().setPingFrequency(BRelTime.makeSeconds((int)5));
        this.getMonitor().setStartupAlarmDelay(BRelTime.makeMinutes((int)2));
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final void serviceStarted() {
        knxnetService = this;
    }

    public final void serviceStopped() {
        knxnetService = null;
    }

    public Type getDeviceType() {
        return BKnxDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BKnxDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", TYPE.getModule().getModuleName());
    }

    public void doPing() throws Exception {
        try {
            this.checkDataValueTypeDefs(true);
            this.getLocalInterfaces().pingInterfaces();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BDriverContainer;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BKnxDeviceFolder || child instanceof BKnxDevice;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (context != null && !context.equals(Context.decoding) && !context.equals(Context.copying) && property.getType().equals(BKnxDevice.TYPE)) {
            this.deviceAdded((BKnxDevice)this.get(property));
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (property.getType().equals(BKnxDevice.TYPE)) {
            this.checkConfigDeviceIps();
        }
    }

    public void reordered(Context context) {
        super.reordered(context);
        if (this.isRunning()) {
            this.checkConfigDeviceIps();
        }
    }

    public void started() throws Exception {
        try {
            super.started();
            if (Sys.getService((Type)TYPE) != this) {
                this.configFail(lex.get(TYPE.getTypeName() + ".duplicateNetwork"));
                throw new IllegalStateException("Only one BKnxNetwork allowed per station!");
            }
        }
        catch (ServiceNotFoundException e) {
            knxLog.log(Level.SEVERE, "BKnxNetwork not registered as a service!");
        }
        UnitDatabase.getDefault();
        this.checkDataValueTypeDefs(true);
        this.getLocalInterfaces().checkInterfaceIds();
        this.checkDeviceIds();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.getLocalInterfaces().updateStatus();
        this.checkConfigDeviceIps();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(enabled)) {
            this.ping();
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.ping();
    }

    public BKnxDevice getDeviceById(int id) {
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BKnxDevice)) continue;
            devices[i].loadSlots();
            if (((BKnxDevice)devices[i]).getDeviceId() != id) continue;
            return (BKnxDevice)devices[i];
        }
        return null;
    }

    public void checkDeviceIds() {
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BKnxDevice)) continue;
            this.checkDeviceId((BKnxDevice)devices[i]);
            if (i <= 0) continue;
            for (int j = 0; j < i; ++j) {
                if (!(devices[j] instanceof BKnxDevice) || ((BKnxDevice)devices[i]).getDeviceId() != ((BKnxDevice)devices[j]).getDeviceId()) continue;
                ((BKnxDevice)devices[i]).setDeviceId(this.getNextAvailableDeviceId());
            }
        }
    }

    private void checkDeviceId(BKnxDevice device) {
        if (device.getDeviceId() == 0) {
            device.setDeviceId(this.getNextAvailableDeviceId());
        }
    }

    private int getNextAvailableDeviceId() {
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BKnxDevice) || this.lastUsedDeviceId >= ((BKnxDevice)devices[i]).getDeviceId()) continue;
            this.lastUsedDeviceId = ((BKnxDevice)devices[i]).getDeviceId();
        }
        return ++this.lastUsedDeviceId;
    }

    public void checkDataValueTypeDefs(boolean calculateIfUnknown) {
        if (this.getKnxDataDefs().isDataIntegrityGood(calculateIfUnknown)) {
            this.pingOk();
        } else {
            this.pingFail(this.getKnxDataDefs().getStatus().getDisplayTag(null));
        }
    }

    public void deviceAdded(BKnxDevice device) {
        if (device != null) {
            BKnxInstallation[] knxInstallations;
            this.checkDeviceId(device);
            if (device.getKnxInstallation().getKnxInstallationIdEnum().getOrdinal() == 0 && (knxInstallations = this.getLocalInterfaces().getKnxInstallations()) != null && knxInstallations.length == 1) {
                device.getKnxInstallation().setKnxInstallationIdEnum(BDynamicEnum.make((int)knxInstallations[0].getKnxInstallationId()));
            }
            if (this.isRunning()) {
                this.checkConfigDeviceIps();
            }
        }
    }

    public void checkConfigDeviceIps() {
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BKnxDevice)) continue;
            BKnxDevice device = (BKnxDevice)devices[i];
            try {
                device.updateConfigStatus();
                continue;
            }
            catch (Throwable t) {
                CatchAll.throwable(t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }

    public boolean isDuplicateDeviceIpAddress(BKnxDevice knxDevice) {
        boolean isDuplicate = false;
        String deviceAddress = knxDevice.getIpAddress();
        if (!deviceAddress.equals(BKnxDevice.ipAddress.getDefaultValue().toString())) {
            BDevice[] devices = this.getDevices();
            for (int i = 0; i < devices.length; ++i) {
                BKnxDevice device;
                String address;
                if (!(devices[i] instanceof BKnxDevice) || !(address = (device = (BKnxDevice)devices[i]).getIpAddress()).equals(deviceAddress)) continue;
                if (device.equals(knxDevice)) break;
                isDuplicate = true;
                break;
            }
        }
        return isDuplicate;
    }

    public static final BKnxNetwork knxnet() {
        try {
            if (Sys.getStation() == null && knxnetService != null) {
                return knxnetService;
            }
            return (BKnxNetwork)Sys.getService((Type)TYPE);
        }
        catch (ServiceNotFoundException ex) {
            return null;
        }
    }

    public void doAddTraceablesActions() throws Exception {
        BCheckTraceablesActionsAction.doCheckActions((BComponent)this, true);
    }

    public void doRemoveTraceablesActions() throws Exception {
        BCheckTraceablesActionsAction.doCheckActions((BComponent)this, false);
    }

    public static boolean isCommsTraceOn() {
        return BKnxNetwork.getCommsLog().isLoggable(Level.FINE);
    }

    private static Logger getCommsLog() {
        if (commsLog == null) {
            return knxLog;
        }
        return commsLog;
    }

    public static void commsTrace(Type type, BKnxDevice device, String traceMessage) {
        StringBuffer sbTraceDetail = new StringBuffer();
        if (device != null) {
            sbTraceDetail.append("  device.deviceInetAddress = ").append(device.getDeviceInetAddress().getHostAddress());
        }
        BKnxNetwork.knxTrace(BKnxNetwork.getCommsLog(), null, type, traceMessage, sbTraceDetail.toString());
    }

    public static void commsTrace(Type type, String traceMessage) {
        BKnxNetwork.knxTrace(BKnxNetwork.getCommsLog(), null, type, traceMessage, "");
    }

    public static final Logger getNetworkLog() {
        return knxLog;
    }

    public static void knxTrace(Logger log, Thread thread, Type type, String traceMessage, String traceDetail) {
        BKnxNetwork.knxTrace(log, thread, type.getTypeInfo().getTypeName(), traceMessage, traceDetail);
    }

    public static void knxTrace(Logger log, Thread thread, String className, String traceMessage, String traceDetail) {
        if (log != null && log.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer(className);
            sb.append("::").append(traceMessage);
            if (thread != null) {
                sb.append(" called on thread: " + thread.toString());
            }
            if (!traceDetail.equals("")) {
                sb.append(traceDetail);
            }
            log.fine(sb.toString());
        }
    }
}

