/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.enums;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Locale;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public abstract class BConfigStatus
extends BBitString {
    public static final Type TYPE = Sys.loadType(BConfigStatus.class);
    protected int bits;

    public Type getType() {
        return TYPE;
    }

    protected BConfigStatus(int bits) {
        this.bits = bits;
    }

    protected abstract BConfigStatus make(int var1);

    protected static final BConfigStatus make(int bits, BConfigStatus[] lookupTable, Class<? extends BConfigStatus> typeClass) {
        if (bits < lookupTable.length) {
            if (lookupTable[bits] == null) {
                try {
                    BConfigStatus newConfigStatus = typeClass.newInstance();
                    newConfigStatus.bits = bits;
                    lookupTable[bits] = newConfigStatus;
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            return lookupTable[bits];
        }
        try {
            Type subType = Sys.loadType(typeClass);
            BConfigStatus newConfigStatus = (BConfigStatus)((Object)subType.getTypeClass().newInstance());
            newConfigStatus.bits = bits;
            return (BConfigStatus)newConfigStatus.intern();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public abstract boolean isConfigFault();

    public final boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    public final boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public final int[] getOrdinals() {
        return this.getSupport().getOrdinals();
    }

    public final boolean isOrdinal(int ordinal) {
        return this.getSupport().isOrdinal(ordinal);
    }

    public final String getTag(int ordinal) {
        return this.getSupport().getTag(ordinal);
    }

    public final String getDisplayTag(int ordinal, Context cx) {
        return this.getSupport().getDisplayTag(ordinal, cx);
    }

    public final BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask |= ordinals[i];
        }
        return this.make(mask);
    }

    public final boolean isTag(String tag) {
        return this.getSupport().isTag(tag);
    }

    public final int tagToOrdinal(String tag) {
        return this.getSupport().tagToOrdinal(tag);
    }

    public final boolean isEmpty() {
        return this.bits == 0;
    }

    public final String getEmptyTag() {
        return Lexicon.make((BModule)Sys.getBajaModule(), (Locale)Locale.getDefault()).getText("Status.ok");
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BConfigStatus) {
            BConfigStatus x = (BConfigStatus)((Object)obj);
            return x.bits == this.bits;
        }
        return false;
    }

    public final void encode(DataOutput encoder) throws IOException {
        encoder.writeInt(this.bits);
    }

    public final BObject decode(DataInput decoder) throws IOException {
        return this.make(decoder.readInt());
    }

    public final String encodeToString() throws IOException {
        return Integer.toHexString(this.bits);
    }

    public final BObject decodeFromString(String s) throws IOException {
        try {
            return this.make(Integer.parseInt(s, 16));
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    public final String toString(Context context) {
        StringBuffer sb = new StringBuffer();
        sb.append('{').append(this.flagsToString(context)).append('}');
        return sb.toString();
    }

    public final int getBits() {
        return this.bits;
    }

    public String flagsToString(Context cx) {
        if (this.bits == 0) {
            return Lexicon.make((BModule)Sys.getBajaModule(), (Context)cx).getText("Status.ok");
        }
        StringBuffer sb = new StringBuffer();
        int mask = 1;
        for (int i = 0; i < this.getNumberOfConfigStatusBits(); ++i) {
            if ((this.bits & mask) != 0) {
                sb.append(this.getDisplayTag(mask, cx)).append(',');
            }
            mask <<= 1;
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    protected abstract int getNumberOfConfigStatusBits();

    protected abstract BBitString.Support getSupport();
}

