/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.knxDataDefs;

import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxDataDefs;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxDataDefsStatusEnum;
import java.text.MessageFormat;
import javax.baja.driver.BNetworkExt;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="dataDefsStatus", type="BKnxDataDefsStatusEnum", defaultValue="BKnxDataDefsStatusEnum.DEFAULT", flags=3), @NiagaraProperty(name="version", type="String", defaultValue="BKnxStationDataDefs.UNKNOWN_VERSION", flags=3), @NiagaraProperty(name="stats", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=3, facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, 60)")}), @NiagaraProperty(name="integrityChecksCount", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="integrityChecksAverage", type="double", defaultValue="0.0", flags=5), @NiagaraProperty(name="integrityChecksSince", type="BAbsTime", defaultValue="BAbsTime.make(0)", flags=5), @NiagaraProperty(name="knxDefs", type="BKnxDataDefs", defaultValue="new BKnxDataDefs()", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="checkDataIntegrity"), @NiagaraAction(name="resetIntegrityChecksStatistics")})
public class BKnxStationDataDefs
extends BNetworkExt {
    public static final Property dataDefsStatus = BKnxStationDataDefs.newProperty((int)3, (BValue)BKnxDataDefsStatusEnum.DEFAULT, null);
    public static final Property version = BKnxStationDataDefs.newProperty((int)3, (String)"???", null);
    public static final Property stats = BKnxStationDataDefs.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (int)60));
    public static final Property integrityChecksCount = BKnxStationDataDefs.newProperty((int)5, (int)0, null);
    public static final Property integrityChecksAverage = BKnxStationDataDefs.newProperty((int)5, (double)0.0, null);
    public static final Property integrityChecksSince = BKnxStationDataDefs.newProperty((int)5, (BValue)BAbsTime.make((long)0L), null);
    public static final Property knxDefs = BKnxStationDataDefs.newProperty((int)5, (BValue)new BKnxDataDefs(), null);
    public static final Action checkDataIntegrity = BKnxStationDataDefs.newAction((int)0, null);
    public static final Action resetIntegrityChecksStatistics = BKnxStationDataDefs.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BKnxStationDataDefs.class);
    private final Object integrityChecksStatisticsLock = new Object();
    private static final String UNKNOWN_VERSION = "???";
    private static final Lexicon lex = Lexicon.make((String)TYPE.getModule().getModuleName());
    private static final String INTEGRITY_CHECKS_STATS_FORMAT_LEX_KEY = "integrityChecksStatsFormat";
    private static final String INTEGRITY_CHECKS_STATS_FORMAT_DEFAULT = "{0} checks, average {1,number,0.000}ms, since {2}";

    public BKnxDataDefsStatusEnum getDataDefsStatus() {
        return (BKnxDataDefsStatusEnum)this.get(dataDefsStatus);
    }

    public void setDataDefsStatus(BKnxDataDefsStatusEnum v) {
        this.set(dataDefsStatus, (BValue)v, null);
    }

    public String getVersion() {
        return this.getString(version);
    }

    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    public String getStats() {
        return this.getString(stats);
    }

    public void setStats(String v) {
        this.setString(stats, v, null);
    }

    public int getIntegrityChecksCount() {
        return this.getInt(integrityChecksCount);
    }

    public void setIntegrityChecksCount(int v) {
        this.setInt(integrityChecksCount, v, null);
    }

    public double getIntegrityChecksAverage() {
        return this.getDouble(integrityChecksAverage);
    }

    public void setIntegrityChecksAverage(double v) {
        this.setDouble(integrityChecksAverage, v, null);
    }

    public BAbsTime getIntegrityChecksSince() {
        return (BAbsTime)this.get(integrityChecksSince);
    }

    public void setIntegrityChecksSince(BAbsTime v) {
        this.set(integrityChecksSince, (BValue)v, null);
    }

    public BKnxDataDefs getKnxDefs() {
        return (BKnxDataDefs)this.get(knxDefs);
    }

    public void setKnxDefs(BKnxDataDefs v) {
        this.set(knxDefs, (BValue)v, null);
    }

    public void checkDataIntegrity() {
        this.invoke(checkDataIntegrity, null, null);
    }

    public void resetIntegrityChecksStatistics() {
        this.invoke(resetIntegrityChecksStatistics, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BKnxNetwork;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BKnxDataDefs;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(knxDefs) && (context == null || !context.equals(Context.copying) && !context.equals(Context.decoding))) {
            this.updateVersion();
            BComplex parent = this.getParent();
            if (parent instanceof BKnxNetwork) {
                BKnxNetwork network = (BKnxNetwork)parent;
                network.checkDataValueTypeDefs(false);
            }
        }
        if (property.equals(dataDefsStatus)) {
            BKnxNetwork network;
            this.updateVersion();
            if (this.isRunning() && (network = (BKnxNetwork)this.getNetwork()) != null) {
                network.checkDataValueTypeDefs(false);
            }
        }
    }

    public String toString(Context context) {
        return "status=" + (Object)((Object)this.getDataDefsStatus()) + ", version=" + this.getVersion();
    }

    public void doCheckDataIntegrity() {
        this.updateConfigStatus();
        this.updateVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doResetIntegrityChecksStatistics() {
        Object object = this.integrityChecksStatisticsLock;
        synchronized (object) {
            this.setIntegrityChecksCount(0);
            this.setIntegrityChecksAverage(0.0);
            this.setIntegrityChecksSince(BAbsTime.make());
            this.updateStats();
        }
    }

    public void dataDefsStatusChanged() {
        BComplex parent = this.getParent();
        if (parent instanceof BKnxNetwork) {
            BKnxNetwork network = (BKnxNetwork)parent;
            network.checkDataValueTypeDefs(false);
        }
    }

    private BKnxDataDefsStatusEnum updateConfigStatus() {
        this.loadSlots();
        BKnxDataDefsStatusEnum knxDataDefsStatus = this.getKnxDefs().calculateDataIntegrityStatus((Object)this);
        this.setStatus(knxDataDefsStatus);
        return knxDataDefsStatus;
    }

    private void updateVersion() {
        this.setVersion(this.getDataDefsStatus().equals((Object)BKnxDataDefsStatusEnum.goodDataDefs) ? this.getKnxDefs().getVersion() : UNKNOWN_VERSION);
    }

    public boolean isDataIntegrityGood(boolean calculateIfUnknown) {
        if (this.getStatus().equals((Object)BKnxDataDefsStatusEnum.unknownDataDefsStatus) || calculateIfUnknown && !this.getStatus().equals((Object)BKnxDataDefsStatusEnum.goodDataDefs)) {
            this.updateConfigStatus();
        }
        return this.getStatus().equals((Object)BKnxDataDefsStatusEnum.goodDataDefs);
    }

    public BKnxDataDefsStatusEnum getStatus() {
        return this.getDataDefsStatus();
    }

    public void setStatus(BKnxDataDefsStatusEnum dataDefsStatus) {
        this.setDataDefsStatus(dataDefsStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateIntegrityChecksStatistics(long duration) {
        Object object = this.integrityChecksStatisticsLock;
        synchronized (object) {
            int count = this.getIntegrityChecksCount();
            if (count < Integer.MAX_VALUE) {
                double total = this.getIntegrityChecksAverage() * (double)count;
                this.setIntegrityChecksAverage((total += (double)duration) / (double)(count + 1));
                this.setIntegrityChecksCount(count + 1);
            }
            if (this.getIntegrityChecksSince().equals((Object)BAbsTime.NULL)) {
                this.setIntegrityChecksSince(BAbsTime.make());
            }
            this.updateStats();
        }
    }

    private void updateStats() {
        MessageFormat mf = new MessageFormat(lex.get(INTEGRITY_CHECKS_STATS_FORMAT_LEX_KEY, INTEGRITY_CHECKS_STATS_FORMAT_DEFAULT));
        this.setStats(mf.format(new Object[]{new Integer(this.getIntegrityChecksCount()), new Double(this.getIntegrityChecksAverage()), this.getIntegrityChecksSince()}));
    }
}

