/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.knxDataDefs;

import javax.baja.nre.util.ByteArrayUtil;

public final class KnxCodecFuncs {
    private KnxCodecFuncs() {
    }

    public static final long getLongFromBytes(byte[] b, int bitOffset, int sizeInBits) {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        if (b.length == 0) {
            throw new IllegalArgumentException("b.length == 0");
        }
        if (bitOffset < 0) {
            throw new IllegalArgumentException("bitOffset < 0");
        }
        if (bitOffset >= b.length * 8) {
            throw new IllegalArgumentException("bitOffset >= (b.length * BITS_IN_A_BYTE)");
        }
        if (sizeInBits < 1) {
            throw new IllegalArgumentException("sizeInBits < 1");
        }
        if (sizeInBits > 64) {
            throw new IllegalArgumentException("sizeInBits > 64");
        }
        if (sizeInBits > b.length * 8) {
            throw new IllegalArgumentException("sizeInBits > (b.length * BITS_IN_A_BYTE)");
        }
        if (bitOffset + sizeInBits > b.length * 8) {
            throw new IllegalArgumentException("bitOffset + sizeInBits > (b.length * BITS_IN_A_BYTE)");
        }
        int byteOffset = bitOffset / 8;
        long val = 0L;
        int sizeInBytes = (sizeInBits + 7) / 8;
        int iOffset = bitOffset % 8;
        int iShift = (bitOffset + sizeInBits) % 8;
        int iBytesToCopy = (iOffset + (sizeInBits - 1)) / 8 + 1;
        for (int i = 0; i < sizeInBytes; ++i) {
            val <<= 8;
            val |= (long)(b[i + byteOffset] & 0xFF);
        }
        if (sizeInBytes < iBytesToCopy) {
            val <<= iShift;
            val |= (long)(b[sizeInBytes + byteOffset] >>> 8 - iShift & (1 << iShift) - 1);
        } else if (iShift != 0) {
            val >>= 8 - iShift;
        }
        if (sizeInBits < 64) {
            long mask = (1L << sizeInBits) - 1L;
            val &= mask;
        }
        return val;
    }

    public static final int getIntFromBytes(byte[] b, int bitOffset, int sizeInBits) {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        if (b.length == 0) {
            throw new IllegalArgumentException("b.length == 0");
        }
        if (bitOffset < 0) {
            throw new IllegalArgumentException("bitOffset < 0");
        }
        if (bitOffset >= b.length * 8) {
            throw new IllegalArgumentException("bitOffset >= (b.length * BITS_IN_A_BYTE)");
        }
        if (sizeInBits < 1) {
            throw new IllegalArgumentException("sizeInBits < 1");
        }
        if (sizeInBits > 32) {
            throw new IllegalArgumentException("sizeInBits > 32");
        }
        if (sizeInBits > b.length * 8) {
            throw new IllegalArgumentException("sizeInBits > (b.length * BITS_IN_A_BYTE)");
        }
        if (bitOffset + sizeInBits > b.length * 8) {
            throw new IllegalArgumentException("bitOffset + sizeInBits > (b.length * BITS_IN_A_BYTE)");
        }
        int byteOffset = bitOffset / 8;
        int val = 0;
        int sizeInBytes = (sizeInBits + 7) / 8;
        int iOffset = bitOffset % 8;
        int iShift = (bitOffset + sizeInBits) % 8;
        int iBytesToCopy = (iOffset + (sizeInBits - 1)) / 8 + 1;
        for (int i = 0; i < sizeInBytes; ++i) {
            val <<= 8;
            val |= b[i + byteOffset] & 0xFF;
        }
        if (sizeInBytes < iBytesToCopy) {
            val <<= iShift;
            val |= b[sizeInBytes + byteOffset] >>> 8 - iShift & (1 << iShift) - 1;
        } else if (iShift != 0) {
            val >>>= 8 - iShift;
        }
        if (sizeInBits < 32) {
            int mask = (1 << sizeInBits) - 1;
            val &= mask;
        }
        return val;
    }

    public static final double decodeFloat16FromBytes(byte[] b, int byteOffset) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        if (b.length == 0) {
            throw new IllegalArgumentException("b.length == 0");
        }
        if (byteOffset < 0) {
            throw new IllegalArgumentException("byteOffset < 0");
        }
        if (byteOffset >= b.length) {
            throw new IllegalArgumentException("byteOffset >= b.length");
        }
        if (byteOffset + 2 > b.length) {
            throw new IllegalArgumentException("byteOffset + 2 > b.length");
        }
        int rawValue = ByteArrayUtil.readUnsignedShort((byte[])b, (int)byteOffset);
        if (rawValue == Short.MAX_VALUE) {
            return Double.NaN;
        }
        boolean isNegative = (rawValue & 0x8000) == 32768;
        int mantissa = rawValue & 0x7FF;
        int exponent = rawValue >>> 11 & 0xF;
        if (isNegative) {
            mantissa = (~mantissa & 0x7FF) + 1;
        }
        double value = (double)mantissa * Math.pow(2.0, exponent) / 100.0;
        if (isNegative) {
            return -value;
        }
        return value;
    }

    public static final byte[] encodeFloat16ToBytes(double value) {
        if (value < -671088.64) {
            throw new IllegalArgumentException("value (" + value + ") < F16_MIN_VALUE (" + -671088.64 + ")");
        }
        if (value > 670433.28) {
            throw new IllegalArgumentException("value (" + value + ") > F16_MAX_VALUE (" + 670433.28 + ")");
        }
        byte[] data = new byte[2];
        if (Double.isNaN(value)) {
            ByteArrayUtil.writeShort((byte[])data, (int)0, (int)Short.MAX_VALUE);
        } else {
            int results;
            int mantissa = (int)Math.round(value * 100.0);
            int exponent = 0;
            int sign = 0;
            if (value >= 0.0) {
                results = mantissa;
                while (results > 2047) {
                    results = mantissa / (int)Math.pow(2.0, ++exponent);
                }
                mantissa = results;
                sign = 0;
            } else {
                results = -mantissa - 1;
                while (results > 2048) {
                    results = (-mantissa - 1) / (int)Math.pow(2.0, ++exponent);
                }
                mantissa = ~results & 0x7FF;
                sign = 32768;
            }
            int encodedValue = sign | exponent << 11 | mantissa;
            ByteArrayUtil.writeShort((byte[])data, (int)0, (int)encodedValue);
        }
        return data;
    }

    public static final float decodeFloat32FromBytes(byte[] b, int byteOffset) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        if (b.length == 0) {
            throw new IllegalArgumentException("b.length == 0");
        }
        if (byteOffset < 0) {
            throw new IllegalArgumentException("byteOffset < 0");
        }
        if (byteOffset >= b.length) {
            throw new IllegalArgumentException("byteOffset >= b.length");
        }
        if (byteOffset + 4 > b.length) {
            throw new IllegalArgumentException("byteOffset + 4 > b.length");
        }
        int dataBits = ByteArrayUtil.readInt((byte[])b, (int)byteOffset);
        return Float.intBitsToFloat(dataBits);
    }

    public static final byte[] encodeFloat32ToBytes(double value) {
        if (Math.abs(value) != 0.0 && Math.abs(value) < (double)1.4E-45f) {
            throw new IllegalArgumentException("Math.abs(value) (" + Math.abs(value) + ") != 0.0f AND Math.abs(value) (" + Math.abs(value) + ") < Float.MIN_VALUE (" + Float.MIN_VALUE + ")");
        }
        if (Math.abs(value) != Double.POSITIVE_INFINITY && Math.abs(value) > 3.4028234663852886E38) {
            throw new IllegalArgumentException("Math.abs(value) != Float.POSITIVE_INFINITY AND Math.abs(value) (" + Math.abs(value) + ") > Float.MAX_VALUE (" + Float.MAX_VALUE + ")");
        }
        byte[] data = new byte[4];
        int rawdata = Float.floatToIntBits((float)value);
        ByteArrayUtil.writeInt((byte[])data, (int)0, (int)rawdata);
        return data;
    }
}

