/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point;

import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import com.tridiumX.knxnetIp.util.CatchAll;
import javax.baja.control.BBooleanPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BKnxBooleanProxyExt
extends BKnxProxyExt {
    public static final Type TYPE = Sys.loadType(BKnxBooleanProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBooleanPoint;
    }

    @Override
    public BStatusValue decodeFromBytes(CemiMessageData msgData) {
        byte[] b = msgData.data;
        BDataValueTypeDef def = this.getActingDataValueTypeDef();
        if (def != null) {
            def.checkReservedBitsAreZero(b);
            if (!BKnxBooleanProxyExt.isEncodingFormatValid(def)) {
                throw new IllegalArgumentException("decodeFromBytes() of DataValueType '" + def.getKNX_ID() + "' to '" + this.getParentPoint().getTypeDisplayName(null) + "' is not supported.");
            }
            BValue value = def.bytesToBValue(msgData);
            if (value instanceof BBoolean) {
                return new BStatusBoolean(((BBoolean)value).getBoolean());
            }
            if (value instanceof BDouble) {
                return new BStatusBoolean(!((BDouble)value).equals((Object)BDouble.DEFAULT));
            }
            if (value instanceof BInteger) {
                return new BStatusBoolean(!((BInteger)value).equals((Object)BInteger.DEFAULT));
            }
            if (value instanceof BLong) {
                return new BStatusBoolean(!((BLong)value).equals((Object)BLong.DEFAULT));
            }
            if (value instanceof BString) {
                BFacets facets = def.getDefinedFacets();
                try {
                    String sFalseText = facets.gets("falseText", "false");
                    if (value.toString().equals(sFalseText)) {
                        return new BStatusBoolean(false);
                    }
                    String sTrueText = facets.gets("trueText", "true");
                    if (value.toString().equals(sTrueText)) {
                        return new BStatusBoolean(true);
                    }
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
                try {
                    int radix = facets.geti("radix", 10);
                    int iVal = Integer.parseInt(((BString)value).getString(), radix);
                    return new BStatusBoolean(iVal != 0);
                }
                catch (NumberFormatException radix) {
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
                throw new IllegalArgumentException("The String '" + value + "' doesn't match the Facets 'trueText' or 'falseText' and is not numeric.");
            }
            throw new IllegalArgumentException("BDataValueTypeDef.bytesToBValue() returned an un-expected BValue Type ('" + value.getTypeDisplayName(null) + "') not supported:" + ByteArrayUtil.toHexString((byte[])b, (String)" "));
        }
        throw new IllegalArgumentException("unknown DataValueType in bytesToBoolean(...) (ID = '" + this.getDataValueTypeId() + "') not supported:" + ByteArrayUtil.toHexString((byte[])b, (String)" "));
    }

    @Override
    public final CemiMessageData encodeToBytes(BStatusValue statVal) throws IllegalArgumentException {
        return BKnxBooleanProxyExt.encodeToCemiMessageData(this.getActingDataValueTypeDef(), statVal);
    }

    public static final CemiMessageData encodeToCemiMessageData(BDataValueTypeDef def, BStatusValue statVal) throws IllegalArgumentException {
        if (!(statVal instanceof BStatusBoolean)) {
            throw new IllegalArgumentException("unsupported data type");
        }
        if (def == null) {
            throw new NullPointerException("no DataValueType provided");
        }
        BBoolean value = (BBoolean)statVal.getValueValue();
        BStatus status = statVal.getStatus();
        int iSizeInBits = def.getSizeInBits();
        switch (def.getEncodingFormat().getOrdinal()) {
            case 1: {
                String s = def.getDefinedFacets().gets(value.getBoolean() ? "trueText" : "falseText", value.getBoolean() ? "true" : "false");
                BString sVal = BString.make((String)s);
                return def.bytesFromBValue((BValue)sVal, status);
            }
            case 3: {
                if (iSizeInBits == 1) {
                    return def.bytesFromBValue((BValue)value, status);
                }
                BLong lngVal = BLong.make((long)value.getOrdinal());
                return def.bytesFromBValue((BValue)lngVal, status);
            }
            case 6: {
                BDouble dVal = BDouble.make((double)value.getOrdinal());
                return def.bytesFromBValue((BValue)dVal, status);
            }
            case 8: {
                BInteger intVal = BInteger.make((int)value.getOrdinal());
                return def.bytesFromBValue((BValue)intVal, status);
            }
            case 11: {
                BLong lngVal = BLong.make((long)value.getOrdinal());
                return def.bytesFromBValue((BValue)lngVal, status);
            }
            case 12: {
                BLong lngVal = BLong.make((long)value.getOrdinal());
                return def.bytesFromBValue((BValue)lngVal, status);
            }
            case 13: {
                throw new IllegalArgumentException("TODO - encodeToBytes() of 'Z8' Format Encoding in BKnxBooleanProxyExt - NOT YET IMPLEMENTED!");
            }
            case 15: {
                throw new IllegalArgumentException("encodeToBytes() of BKnxBooleanProxyExt to 'H' Format Encoding - NOT SUPPORTED.");
            }
        }
        throw new IllegalArgumentException("unknown Format Encoding in encodeToBytes() in BKnxBooleanProxyExt - Ordinal = " + def.getEncodingFormat().getOrdinal());
    }

    private static boolean isEncodingFormatValid(BDataValueTypeDef def) {
        switch (def.getEncodingFormat().getOrdinal()) {
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                return true;
            }
            case 13: 
            case 15: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown Format Encoding in encodeToBytes() in BKnxBooleanProxyExt - Ordinal = " + def.getEncodingFormat().getOrdinal());
            }
        }
        return false;
    }

    @Override
    public final boolean setWriteValueAndWrite(BStatusValue out) {
        BStatusBoolean deviceValue = new BStatusBoolean();
        this.convertProxyToDevice(out, (BStatusValue)deviceValue);
        return super.setWriteValueAndWrite((BStatusValue)deviceValue);
    }
}

