/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point;

import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import com.tridiumX.knxnetIp.util.CatchAll;
import javax.baja.control.BEnumPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BKnxEnumProxyExt
extends BKnxProxyExt {
    public static final Type TYPE = Sys.loadType(BKnxEnumProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BEnumPoint;
    }

    @Override
    public BStatusValue decodeFromBytes(CemiMessageData msgData) {
        BEnumRange range = (BEnumRange)this.getDeviceFacets().get("range");
        if (range == null) {
            throw new IllegalStateException("missing 'Device Facets' 'range'.");
        }
        byte[] b = msgData.data;
        BDataValueTypeDef def = this.getActingDataValueTypeDef();
        if (def != null) {
            def.checkReservedBitsAreZero(b);
            if (!BKnxEnumProxyExt.isEncodingFormatValid(def)) {
                throw new IllegalArgumentException("decodeFromBytes() of DataValueType '" + def.getKNX_ID() + "' to '" + this.getParentPoint().getTypeDisplayName(null) + "' is not supported.");
            }
            BValue value = def.bytesToBValue(msgData);
            if (value instanceof BBoolean) {
                return new BStatusEnum(range.get(((BBoolean)value).getOrdinal()));
            }
            if (value instanceof BDouble) {
                return new BStatusEnum(range.get(((BDouble)value).getInt()));
            }
            if (value instanceof BInteger) {
                return new BStatusEnum(range.get(((BInteger)value).getInt()));
            }
            if (value instanceof BLong) {
                return new BStatusEnum(range.get(((BLong)value).getInt()));
            }
            if (value instanceof BString) {
                try {
                    return new BStatusEnum(range.get(((BString)value).getString()));
                }
                catch (InvalidEnumException invalidEnumException) {
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
                try {
                    int iOrdinal = Integer.parseInt(((BString)value).getString(), def.getDefinedFacets().geti("radix", 10));
                    return new BStatusEnum(range.get(iOrdinal));
                }
                catch (NumberFormatException iOrdinal) {
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
                throw new IllegalArgumentException("data cannot be converted to an Enumeration, value '" + ((BString)value).getString() + "' is neither a valid Enum Tag nor Ordinal.: " + ByteArrayUtil.toHexString((byte[])b, (String)" "));
            }
            throw new IllegalArgumentException("BKnxProxyExt.bytesToBValue() returned an un-expected BValue Type ('" + value.getTypeDisplayName(null) + "') not supported:" + ByteArrayUtil.toHexString((byte[])b, (String)" "));
        }
        throw new IllegalArgumentException("unknown DataValueType in bytesToEnum(...) (ID = '" + this.getDataValueTypeId() + "') not supported:" + ByteArrayUtil.toHexString((byte[])b, (String)" "));
    }

    @Override
    public CemiMessageData encodeToBytes(BStatusValue statVal) throws IllegalArgumentException {
        return BKnxEnumProxyExt.encodeToCemiMessageData(this.getActingDataValueTypeDef(), statVal);
    }

    public static final CemiMessageData encodeToCemiMessageData(BDataValueTypeDef def, BStatusValue statVal) throws IllegalArgumentException {
        if (!(statVal instanceof BStatusEnum)) {
            throw new IllegalArgumentException("unsupported data type");
        }
        if (def == null) {
            throw new NullPointerException("no DataValueType provided");
        }
        BEnum value = ((BStatusEnum)statVal).getEnum();
        BStatus status = statVal.getStatus();
        int iSizeInBits = def.getSizeInBits();
        switch (def.getEncodingFormat().getOrdinal()) {
            case 1: {
                BString sVal = BString.make((String)value.getTag());
                return def.bytesFromBValue((BValue)sVal, status);
            }
            case 3: {
                if (iSizeInBits == 1) {
                    BBoolean bVal = BBoolean.make((value.getOrdinal() != BInteger.DEFAULT.getInt() ? 1 : 0) != 0);
                    return def.bytesFromBValue((BValue)bVal, status);
                }
                BLong lngVal = BLong.make((long)value.getOrdinal());
                return def.bytesFromBValue((BValue)lngVal, status);
            }
            case 6: {
                BDouble dVal = BDouble.make((double)value.getOrdinal());
                return def.bytesFromBValue((BValue)dVal, status);
            }
            case 8: {
                BInteger intVal = BInteger.make((int)value.getOrdinal());
                return def.bytesFromBValue((BValue)intVal, status);
            }
            case 11: {
                BLong lngVal = BLong.make((long)value.getOrdinal());
                return def.bytesFromBValue((BValue)lngVal, status);
            }
            case 12: {
                BLong lngVal = BLong.make((long)value.getOrdinal());
                return def.bytesFromBValue((BValue)lngVal, status);
            }
            case 13: {
                throw new IllegalArgumentException("TODO - encodeToBytes() of 'Z8' Format Encoding in BKnxEnumProxyExt - NOT YET IMPLEMENTED!");
            }
            case 15: {
                throw new IllegalArgumentException("TODO - encodeToBytes() of 'H' Format Encoding in BKnxEnumProxyExt - NOT YET IMPLEMENTED!");
            }
        }
        throw new IllegalArgumentException("unknown Format Encoding in encodeToBytes() in BKnxEnumProxyExt - Ordinal = " + def.getEncodingFormat().getOrdinal());
    }

    private static boolean isEncodingFormatValid(BDataValueTypeDef def) {
        switch (def.getEncodingFormat().getOrdinal()) {
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                return true;
            }
            case 13: 
            case 15: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown Format Encoding in encodeToBytes() in BKnxEnumProxyExt - Ordinal = " + def.getEncodingFormat().getOrdinal());
            }
        }
        return false;
    }
}

