/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point;

import com.tridiumX.knxnetIp.addresses.BGroupAddresses;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessage;
import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.comms.enums.BSendCemiMessageResultEnum;
import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.driver.BKnxPointDeviceExt;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.point.BDataValueType;
import com.tridiumX.knxnetIp.point.BIKnxPollable;
import com.tridiumX.knxnetIp.point.BKnxPollScheduler;
import com.tridiumX.knxnetIp.point.ValueExecuteWatcher;
import com.tridiumX.knxnetIp.point.actions.BKnxAction;
import com.tridiumX.knxnetIp.util.CatchAll;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BIWritablePoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.QueueFullException;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="knxId", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=9), @NiagaraProperty(name="groupAddresses", type="BGroupAddresses", defaultValue="new BGroupAddresses()"), @NiagaraProperty(name="dataValueTypeId", type="String", defaultValue="KnxStrings.EMPTY_STRING"), @NiagaraProperty(name="pollEnable", type="boolean", defaultValue="false"), @NiagaraProperty(name="pollOnceOnSubscribed", type="boolean", defaultValue="false"), @NiagaraProperty(name="pollOnceOnOperational", type="boolean", defaultValue="false"), @NiagaraProperty(name="pollUntilAnswer", type="boolean", defaultValue="false"), @NiagaraProperty(name="pollAfterWrite", type="boolean", defaultValue="false"), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="writeOnly", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="pollNow"), @NiagaraAction(name="writeNow"), @NiagaraAction(name="dump", flags=4)})
@NiagaraTopics(value={@NiagaraTopic(name="busDataReceived"), @NiagaraTopic(name="busDataExecuted")})
public abstract class BKnxProxyExt
extends BProxyExt
implements BIKnxPollable {
    public static final Property knxId = BKnxProxyExt.newProperty((int)9, (String)"", null);
    public static final Property groupAddresses = BKnxProxyExt.newProperty((int)0, (BValue)new BGroupAddresses(), null);
    public static final Property dataValueTypeId = BKnxProxyExt.newProperty((int)0, (String)"", null);
    public static final Property pollEnable = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property pollOnceOnSubscribed = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property pollOnceOnOperational = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property pollUntilAnswer = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property pollAfterWrite = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property pollFrequency = BKnxProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property writeOnly = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Action pollNow = BKnxProxyExt.newAction((int)0, null);
    public static final Action writeNow = BKnxProxyExt.newAction((int)0, null);
    public static final Action dump = BKnxProxyExt.newAction((int)4, null);
    public static final Topic busDataReceived = BKnxProxyExt.newTopic((int)0, null);
    public static final Topic busDataExecuted = BKnxProxyExt.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BKnxProxyExt.class);
    protected boolean m_bDataValueTypeSpecNotFound;
    private boolean pollSubscribed;
    private final Object pollSubscribedLock = new Object();
    private BStatus oldStatus = BStatus.DEFAULT;
    protected static final Lexicon lex = Lexicon.make(BKnxProxyExt.class);
    public static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName() + ".proxyext");
    protected static final String DATA_VALUE_TYPE_SPEC_NOT_FOUND = "'Data Value Type' Spec. Not Found";

    public String getKnxId() {
        return this.getString(knxId);
    }

    public void setKnxId(String v) {
        this.setString(knxId, v, null);
    }

    public BGroupAddresses getGroupAddresses() {
        return (BGroupAddresses)this.get(groupAddresses);
    }

    public void setGroupAddresses(BGroupAddresses v) {
        this.set(groupAddresses, (BValue)v, null);
    }

    public String getDataValueTypeId() {
        return this.getString(dataValueTypeId);
    }

    public void setDataValueTypeId(String v) {
        this.setString(dataValueTypeId, v, null);
    }

    public boolean getPollEnable() {
        return this.getBoolean(pollEnable);
    }

    public void setPollEnable(boolean v) {
        this.setBoolean(pollEnable, v, null);
    }

    public boolean getPollOnceOnSubscribed() {
        return this.getBoolean(pollOnceOnSubscribed);
    }

    public void setPollOnceOnSubscribed(boolean v) {
        this.setBoolean(pollOnceOnSubscribed, v, null);
    }

    public boolean getPollOnceOnOperational() {
        return this.getBoolean(pollOnceOnOperational);
    }

    public void setPollOnceOnOperational(boolean v) {
        this.setBoolean(pollOnceOnOperational, v, null);
    }

    public boolean getPollUntilAnswer() {
        return this.getBoolean(pollUntilAnswer);
    }

    public void setPollUntilAnswer(boolean v) {
        this.setBoolean(pollUntilAnswer, v, null);
    }

    public boolean getPollAfterWrite() {
        return this.getBoolean(pollAfterWrite);
    }

    public void setPollAfterWrite(boolean v) {
        this.setBoolean(pollAfterWrite, v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public boolean getWriteOnly() {
        return this.getBoolean(writeOnly);
    }

    public void setWriteOnly(boolean v) {
        this.setBoolean(writeOnly, v, null);
    }

    public void pollNow() {
        this.invoke(pollNow, null, null);
    }

    public void writeNow() {
        this.invoke(writeNow, null, null);
    }

    public void dump() {
        this.invoke(dump, null, null);
    }

    public void fireBusDataReceived(BValue event) {
        this.fire(busDataReceived, event, null);
    }

    public void fireBusDataExecuted(BValue event) {
        this.fire(busDataExecuted, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setFlags((Slot)deviceFacets, 1);
        this.checkDataValueTypeFacets();
        this.checkActionSlots();
        this.setToStale();
        this.oldStatus = this.getStatus();
        if (!(this.getParentPoint() instanceof BIWritablePoint)) {
            this.setFlags((Slot)writeNow, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        Object object = this.pollSubscribedLock;
        synchronized (object) {
            if (this.pollSubscribed) {
                this.network().getPollScheduler().unsubscribe((BIPollable)this);
                this.pollSubscribed = false;
            }
        }
        this.device().getGroupDataManager().unregisterProxyExt(this);
        super.stopped();
    }

    public void changed(Property property, Context context) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getGroupAddresses().getPrimaryGroupAddress() + " changed(property = '" + property.getName() + "')");
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(status)) {
            this.statusChanged();
        } else if (property.equals(pollOnceOnOperational) || property.equals(pollOnceOnSubscribed)) {
            if ((this.getPollOnceOnOperational() || this.getPollOnceOnSubscribed()) && this.getPollUntilAnswer()) {
                if (this.isSubscribed()) {
                    this.readSubscribe();
                }
            } else {
                this.readUnsubscribe();
            }
        } else if (property.equals(dataValueTypeId)) {
            BStatus newStatus;
            BDataValueTypeDef def = this.getActingDataValueTypeDef();
            if (def != null) {
                this.setDeviceFacets(def.getDefinedFacets(this.getParentPoint()));
                if (this.getParentPoint() != null) {
                    this.getParentPoint().setFacets(this.getDeviceFacets());
                }
            }
            if (BKnxProxyExt.isOperational(newStatus = BStatus.make((int)(this.getStatus().getBits() & 0xFFFFFFFD | this.device().getStatus().getBits() & 2))) && this.getPollOnceOnOperational()) {
                if (this.getPollUntilAnswer()) {
                    this.readSubscribe();
                } else {
                    this.pollOnce();
                }
            }
        } else if (property.equals(pollEnable)) {
            if (this.getPollEnable() && this.getEnabled()) {
                this.readSubscribe();
            } else {
                this.readUnsubscribe();
            }
        } else if (property.equals(pollUntilAnswer) && !this.getPollUntilAnswer() && !this.getPollEnable()) {
            this.readUnsubscribe();
        }
    }

    private void statusChanged() {
        BStatus newStatus = BStatus.make((int)(this.getStatus().getBits() & 0xFFFFFFFD | this.device().getStatus().getBits() & 2));
        if (BKnxProxyExt.isOperational(newStatus)) {
            if (!BKnxProxyExt.isOperational(this.oldStatus)) {
                this.transitionToOperational();
            }
        } else if (BKnxProxyExt.isOperational(this.oldStatus)) {
            this.transitionToUnoperational(newStatus);
        }
        this.oldStatus = newStatus;
    }

    private void pollOnce() {
        this.doPollNow();
        ((BKnxPollScheduler)this.network().getPollScheduler().as(BKnxPollScheduler.class)).incrementUnscheduledPolls();
    }

    private void transitionToOperational() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getGroupAddresses().getPrimaryGroupAddress() + " transition to operational");
        }
        if (this.getPollOnceOnOperational()) {
            if (this.getPollUntilAnswer()) {
                this.readSubscribe();
            } else {
                this.pollOnce();
            }
        }
    }

    private void transitionToUnoperational(BStatus newStatus) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getGroupAddresses().getPrimaryGroupAddress() + " transition to non operational");
        }
        if (!newStatus.isFault()) {
            this.readUnsubscribe();
        }
        this.setToStale();
    }

    private void readSubscribe() {
        try {
            this.readSubscribed(null);
        }
        catch (Exception e) {
            log.log(Level.WARNING, this.getGroupAddresses().getPrimaryGroupAddress() + " failed to subscribe", e);
        }
    }

    private void readUnsubscribe() {
        try {
            this.readUnsubscribed(null);
        }
        catch (Exception e) {
            log.log(Level.WARNING, this.getGroupAddresses().getPrimaryGroupAddress() + " failed to unsubscribe", e);
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.device().getGroupDataManager().registerProxyExt(this);
    }

    @Override
    public void poll() {
        this.commsTrace("poll()");
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getGroupAddresses().getPrimaryGroupAddress() + " poll");
        }
        this.doPollNow();
    }

    public final void updateConfigStatus() {
        IntHashMap groupAddresses = this.getGroupAddresses().getGroups();
        if (groupAddresses.isEmpty()) {
            this.readFail("No valid 'Group Addresses' configured.");
        } else if (this.getFaultCause().equals("Read fault: No valid 'Group Addresses' configured.")) {
            this.readOk(this.getReadValue());
        }
    }

    static boolean isOperational(BStatus s) {
        return !s.isDisabled() && !s.isDown() && !s.isFault();
    }

    public void registerLDataListener() {
        this.updateConfigStatus();
        if (!this.isRunning()) {
            return;
        }
        this.device().getGroupDataManager().registerProxyExt(this);
        this.setToStale();
    }

    public void unregisterLDataListener() {
        if (!this.isRunning()) {
            return;
        }
        this.device().getGroupDataManager().unregisterProxyExt(this);
    }

    public void setValue(CemiMessage msg) {
        CemiMessageData data;
        this.commsTrace("setValue(...)");
        try {
            data = msg.getData();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Data unavailable in CemiMessage", e);
            this.readFail("data unavailable");
            return;
        }
        try {
            BStatusValue val = this.decodeFromBytes(data);
            ValueExecuteWatcher.newValue(this, val);
            this.readOk(val);
            this.fireBusDataReceived((BValue)val);
            this.checkPollOnceSatisfied(msg);
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
        }
    }

    void checkPollOnceSatisfied(CemiMessage msg) {
        this.commsTrace("checkPollOnceSatisfied(...)");
        if (msg.getDestination().getAddress() == this.getGroupAddresses().getPrimaryGroupAddress().getAddress()) {
            this.readUnsubscribe();
        }
    }

    public abstract BStatusValue decodeFromBytes(CemiMessageData var1);

    protected void readOkAll(CemiMessageData msgData) {
        int primaryGroupAddress = this.getGroupAddresses().getPrimaryGroupAddress().getAddress();
        Vector<BKnxProxyExt> v = this.device().getGroupDataManager().getGroupedExtensions(primaryGroupAddress);
        for (int i = 0; i < v.size(); ++i) {
            BKnxProxyExt ext = v.elementAt(i);
            try {
                BStatusValue val = ext.decodeFromBytes(msgData);
                ext.readOk(val);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                ext.readFail(t.getMessage());
            }
        }
    }

    public Type getDeviceExtType() {
        return BKnxPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? (this.getWriteOnly() ? BReadWriteMode.writeonly : BReadWriteMode.readWrite) : BReadWriteMode.readonly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSubscribed(Context cx) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("%s readSubscribed() called - alreadySubscribed: (%s/%s/%s)", this.getGroupAddresses().getPrimaryGroupAddress(), this.pollSubscribed, this.isSubscribed(), this.isPermanentlySubscribed()));
        }
        Object object = this.pollSubscribedLock;
        synchronized (object) {
            if (this.pollSubscribed) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Already Sub <" + this + '>');
                }
                return;
            }
            if (this.getPollEnable()) {
                this.network().getPollScheduler().subscribe((BIPollable)this);
                this.pollSubscribed = true;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Sub [Poll Enabled] <" + this + '>');
                }
            } else if (this.getPollUntilAnswer()) {
                if (this.getPollOnceOnOperational() || this.getPollOnceOnSubscribed()) {
                    this.network().getPollScheduler().subscribe((BIPollable)this);
                    this.pollSubscribed = true;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Sub [Poll Until Answer] <" + this + '>');
                    }
                }
            } else if (this.getPollOnceOnSubscribed() && !this.isUnoperational()) {
                this.pollOnce();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUnsubscribed(Context cx) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("%s readUnsubscribed() called - alreadySubscribed: (%s/%s/%s)", this.getGroupAddresses().getPrimaryGroupAddress(), this.pollSubscribed, this.isSubscribed(), this.isPermanentlySubscribed()));
        }
        Object object = this.pollSubscribedLock;
        synchronized (object) {
            if (!this.pollSubscribed) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Already Unsub <" + this + ">");
                }
                return;
            }
            if (!this.isUnoperational() && (this.isSubscribedDesired() || this.isSubscribed()) && this.getPollEnable()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("NOT Unsub [Poll Enabled] <" + this + ">");
                }
                return;
            }
            this.network().getPollScheduler().unsubscribe((BIPollable)this);
            this.pollSubscribed = false;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unsub <" + this + ">");
            }
        }
    }

    public void readFail(String cause) {
        this.commsTrace("readFail(...) cause = " + cause);
        super.readFail(cause);
    }

    public boolean write(Context cx) throws Exception {
        this.commsTrace("write(...)");
        if (this.getMode() != BReadWriteMode.readonly) {
            BStatusValue out = this.getWriteValue();
            if (out.getStatus().isNull()) {
                this.commsTrace("the point is auto'd with no fallback");
                return false;
            }
            if (this.network().getLogger().isLoggable(Level.FINE)) {
                this.network().getLogger().fine("Write <" + this + "> " + out);
            }
            this.commsTrace("Posting a WriteAsyncRequest <" + this + "> " + out);
            try {
                return this.enqueueTunnelWrite(out);
            }
            catch (Exception e) {
                this.commsTrace("Posting of WriteAsyncRequest Failed");
                this.writeFail(lex.getText("postWriteFail") + ": " + e);
                this.network().getLogger().log(Level.SEVERE, "Could not post write for " + this.getParent().getName(), e);
            }
        }
        return false;
    }

    public final void writeFail(String cause) {
        this.commsTrace("writeFail(...)");
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.SEVERE, this.getSlotPath().toDisplayString() + ' ' + this.getParentPoint().getOutStatusValue() + " to " + this.getWriteValue() + ' ' + cause);
        }
        super.writeFail(cause);
    }

    protected boolean setWriteValueAndWrite(BStatusValue out) {
        this.setWriteValue(out);
        return this.enqueueTunnelWrite(out);
    }

    private boolean enqueueTunnelWrite(BStatusValue out) {
        try {
            CemiMessageData msgData = this.encodeToBytes(out);
            return this.enqueueTunnelWrite(msgData);
        }
        catch (IllegalArgumentException ex) {
            this.writeFail(ex.getMessage());
            return false;
        }
    }

    private boolean enqueueTunnelWrite(CemiMessageData msgData) {
        try {
            BDataValueTypeDef def = this.getDataValueTypeDef();
            if (def == null) {
                this.writeFail("The specified Data Value Type " + this.getDataValueTypeId() + " is not supported.");
                return false;
            }
            this.device().getGroupDataManager().postWrite(this, this.getGroupAddresses().getPrimaryGroupAddress(), def, msgData);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.writeFail(ex.getMessage());
            return false;
        }
    }

    public void writeCompleted(BSendCemiMessageResultEnum result, CemiMessageData msgData) {
        if (result == null) {
            this.writeFail("write operation returned a 'null'");
            return;
        }
        if (msgData == null) {
            this.writeFail("write operation lost the write message data");
            return;
        }
        if (result.equals((Object)BSendCemiMessageResultEnum.good)) {
            BStatusValue val = this.decodeFromBytes(msgData);
            this.writeOk(val);
            this.readOkAll(msgData);
            if (this.getParentPoint().isSubscribed() && this.getPollAfterWrite()) {
                this.pollNow();
            }
        } else {
            this.writeFail("confirmation - " + result.getDisplayTag(null));
        }
    }

    public abstract CemiMessageData encodeToBytes(BStatusValue var1) throws IllegalArgumentException;

    public void setFaultCause(String v) {
        if (v.equals("") && this.m_bDataValueTypeSpecNotFound) {
            super.setFaultCause(DATA_VALUE_TYPE_SPEC_NOT_FOUND);
            return;
        }
        super.setFaultCause(v);
    }

    public void setStatus(BStatus newStatus) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getGroupAddresses().getPrimaryGroupAddress() + " setStatus(v = '" + newStatus + "')");
        }
        if (!newStatus.isFault() && this.m_bDataValueTypeSpecNotFound) {
            super.setStatus(BStatus.make((BStatus)newStatus, (int)(newStatus.getBits() | 2)));
            return;
        }
        super.setStatus(newStatus);
    }

    public void doDump() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName()).append("group addreses:").append(this.getGroupAddresses().dump());
        System.out.println(sb.toString());
    }

    public void doPollNow() {
        try {
            if (!this.isUnoperational()) {
                this.commsTrace("doPollNow() posting async runnable for " + this.getGroupAddresses().getPrimaryGroupAddress());
                this.device().getGroupDataManager().postRead(this, this.getGroupAddresses().getPrimaryGroupAddress());
            }
        }
        catch (QueueFullException ex) {
            log.log(Level.SEVERE, "Failed to enqueue a 'read request' for '" + this.getParentPoint().getDisplayName(null) + "'. The 'Read' queue for Device '" + this.getDevice().getDisplayName(null) + "' is full.");
            this.readFail("The 'Read' queue is full.");
        }
        catch (Throwable t) {
            CatchAll.throwable(t);
        }
    }

    public void doWriteNow() {
        this.commsTrace("doWriteNow");
        try {
            this.write(null);
        }
        catch (Exception e) {
            this.commsTrace("doWriteNow Failed - " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String toString(Context cx) {
        this.getGroupAddresses().loadSlots();
        return super.toString(cx) + " - Group Address:" + this.getGroupAddresses().getPrimaryGroupAddress();
    }

    public BDataValueTypeDef getDataValueTypeDef() {
        try {
            BDataValueTypeDef spec = this.network().getKnxDataDefs().getKnxDefs().getDataValueTypeDef(this.getDataValueTypeId());
            this.setDataValueTypeSpecNotFound(spec == null);
            return spec;
        }
        catch (Exception ex) {
            this.setDataValueTypeSpecNotFound(true);
        }
        catch (Throwable t) {
            CatchAll.throwable(t);
        }
        this.setDataValueTypeSpecNotFound(true);
        return null;
    }

    public BDataValueTypeDef getActingDataValueTypeDef() {
        BDataValueTypeDef dataDef = this.getDataValueTypeDef();
        if (dataDef != null && !dataDef.isCompositeDataValueType() && !dataDef.isAField()) {
            BDataValueTypeDef[] fields = dataDef.getDataValueTypeFieldDefs();
            if (fields.length == 1) {
                fields[0].loadSlots();
                return fields[0];
            }
            return null;
        }
        return dataDef;
    }

    private void setDataValueTypeSpecNotFound(boolean notFound) {
        if (this.m_bDataValueTypeSpecNotFound != notFound) {
            this.m_bDataValueTypeSpecNotFound = notFound;
            this.updateStatus();
        }
    }

    private void setToStale() {
        if (!this.getMode().isWriteonly()) {
            this.setStale(true, null);
        }
    }

    private void checkDataValueTypeFacets() {
        if (this.getParentPoint() != null) {
            String s = this.getParentPoint().getType().getTypeName();
            this.setFacets((Slot)dataValueTypeId, BFacets.make((String)"fieldEditor", (String)(BDataValueType.TYPE.getTypeSpec() + "FE" + s)));
        }
    }

    protected final BKnxDevice device() {
        try {
            return (BKnxDevice)this.getDevice();
        }
        catch (NotRunningException ex) {
            if (Sys.getStation() != null) {
                for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof BKnxDevice)) continue;
                    return (BKnxDevice)parent;
                }
            }
        }
        catch (Throwable t) {
            CatchAll.throwable(t);
        }
        return null;
    }

    protected final BKnxNetwork network() {
        return this.device().getKnxNetwork();
    }

    public final void checkActionSlots() {
        BKnxAction[] actions = (BKnxAction[])this.getParentPoint().getChildren(BKnxAction.class);
        for (int i = 0; i < actions.length; ++i) {
            BKnxAction action = actions[i];
            BKnxAction.SlotDefinition[] slotDefs = action.getSlotDefinitions();
            for (int j = 0; j < slotDefs.length; ++j) {
                BKnxAction.SlotDefinition slotDef = slotDefs[j];
                if (this.get(slotDef.slotName) != null) continue;
                this.add(slotDef.slotName, slotDef.value, slotDef.flags, slotDef.facets, null);
            }
        }
    }

    protected void commsTrace(String traceMessage) {
        if (BKnxNetwork.isCommsTraceOn()) {
            StringBuffer sb = new StringBuffer("  Group Address = ").append(this.getGroupAddresses().getPrimaryGroupAddress());
            BKnxDevice device = this.device();
            if (device != null) {
                if (device.getDeviceInetAddress() != null) {
                    sb.append("  device().getDeviceInetAddress().getHostAddress() = ").append(this.device().getDeviceInetAddress().getHostAddress());
                } else {
                    sb.append("  device().getDeviceInetAddress() = ").append(this.device().getDeviceInetAddress());
                }
            } else {
                sb.append("\tdevice() == null !!!");
            }
            BKnxNetwork.commsTrace(TYPE, traceMessage + sb.toString());
        }
    }
}

