/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point;

import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.driver.point.BProxyExt;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;

public final class ValueExecuteWatcher {
    private static boolean enabled = "false".equalsIgnoreCase(System.getProperty("knxnetIp.disableValueWatcher", "false"));
    private static Thread watcherThread;
    private static final Map<String, ToWatch> watchMap;
    private static final ValueExecuteWatcher instance;
    private static final BRelTime maxWait;

    private ValueExecuteWatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newValue(BKnxProxyExt knxProxyExt, BStatusValue val) {
        if (!enabled) {
            return;
        }
        Object object = instance;
        synchronized (object) {
            if (watcherThread == null || !watcherThread.isAlive()) {
                watcherThread = new Thread(() -> {
                    while (true) {
                        BAbsTime now = BAbsTime.now();
                        Map<String, ToWatch> map = watchMap;
                        synchronized (map) {
                            watchMap.entrySet().removeIf(entry -> now.isAfter(((ToWatch)entry.getValue()).giveUp) || ValueExecuteWatcher.executed(entry));
                        }
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                });
                watcherThread.setName("ValueExecuteWatcher");
                watcherThread.start();
            }
        }
        object = watchMap;
        synchronized (object) {
            watchMap.put(knxProxyExt.getHandle().toString() + val.toString(), new ToWatch(knxProxyExt, val));
        }
    }

    private static boolean executed(Map.Entry<String, ToWatch> entry) {
        BKnxProxyExt ext = entry.getValue().proxyExt;
        if (ValueExecuteWatcher.getPointExecCount(ext) != entry.getValue().pointLastExecCount) {
            ext.fireBusDataExecuted((BValue)entry.getValue().valueToExecute);
            return true;
        }
        return false;
    }

    private static long getPointExecCount(BProxyExt proxyExt) {
        return proxyExt != null ? (Long)proxyExt.getParent().fw(31) : -1L;
    }

    static {
        watchMap = new LinkedHashMap<String, ToWatch>();
        instance = new ValueExecuteWatcher();
        maxWait = BRelTime.makeSeconds((int)1);
    }

    static class ToWatch {
        final long pointLastExecCount;
        final BStatusValue valueToExecute;
        final BKnxProxyExt proxyExt;
        final BAbsTime giveUp;

        ToWatch(BKnxProxyExt proxyExt, BStatusValue valueToExecute) {
            this.proxyExt = proxyExt;
            this.valueToExecute = valueToExecute;
            this.pointLastExecCount = ValueExecuteWatcher.getPointExecCount(proxyExt);
            this.giveUp = BAbsTime.now().add(maxWait);
        }
    }
}

