/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point.actions;

import com.tridiumX.knxnetIp.enums.BKnxComObjectSizeEnum;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BKnxAction
extends BAction {
    public static final Type TYPE = Sys.loadType(BKnxAction.class);

    public Type getType() {
        return TYPE;
    }

    public abstract Type getControlPointType();

    public BKnxComObjectSizeEnum getComObjectSize() {
        return BKnxComObjectSizeEnum.DEFAULT;
    }

    public String getActionSlotName() {
        String s = this.getType().getTypeName();
        if (s.startsWith("Knx")) {
            s = s.substring(3);
        }
        if (s.endsWith("Action")) {
            s = s.substring(0, s.length() - 6);
        }
        s = s.substring(0, 1).toLowerCase() + s.substring(1);
        return s;
    }

    public SlotDefinition[] getSlotDefinitions() {
        return new SlotDefinition[0];
    }

    public Type getParameterType() {
        return null;
    }

    public BValue getParameterDefault() {
        Type paramType = this.getParameterType();
        if (paramType != null) {
            return (BValue)paramType.getInstance();
        }
        return null;
    }

    public Type getReturnType() {
        return null;
    }

    public BFacets getFacets() {
        Type paramType = this.getParameterType();
        if (paramType != null) {
            BControlPoint pt = (BControlPoint)this.getParent();
            return pt.getSlotFacets((Slot)pt.getOutProperty());
        }
        return BFacets.NULL;
    }

    protected final BControlPoint invokeCheck(BComponent target, BValue value) {
        if (!target.isRunning()) {
            throw new IllegalStateException(this.getFriendlyActionName() + " cannot be invoked on " + target.getDisplayName(null) + " while it is not running.");
        }
        if (!target.getType().is(this.getControlPointType().getTypeInfo())) {
            throw new IllegalArgumentException(this.getFriendlyActionName() + " cannot be invoked on " + target.getType());
        }
        BControlPoint controlPoint = (BControlPoint)target;
        BAbstractProxyExt proxyExt = controlPoint.getProxyExt();
        Type t = proxyExt.getType();
        if (!t.is(BKnxProxyExt.TYPE)) {
            throw new IllegalArgumentException(this.getFriendlyActionName() + " cannot be invoked on proxy point type " + t);
        }
        if (((BKnxProxyExt)proxyExt).isDisabled()) {
            throw new IllegalStateException(this.getFriendlyActionName() + " cannot be invoked on " + target.getDisplayName(null) + " while it is disabled.");
        }
        Type paramType = this.getParameterType();
        if (paramType != null && !value.getType().is(paramType)) {
            throw new IllegalArgumentException("Invalid " + this.getFriendlyActionName() + " parameter type " + value.getType() + " for " + controlPoint);
        }
        return controlPoint;
    }

    private String getFriendlyActionName() {
        return "'" + TextUtil.toFriendly((String)this.getActionSlotName()) + "'";
    }

    public static class SlotDefinition {
        public String slotName;
        public BValue value;
        public int flags;
        public BFacets facets;

        public static final SlotDefinition make(String slotName, BValue value, int flags, BFacets facets) {
            SlotDefinition sd = new SlotDefinition();
            sd.slotName = slotName;
            sd.value = value;
            sd.flags = flags;
            sd.facets = facets;
            return sd;
        }
    }
}

