/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.comm;

import com.miratech.serialization.DataMarker;
import java.util.ArrayList;
import java.util.Arrays;

public class Endpoint {
    public static final Endpoint Authorize = new Endpoint(Method.Post, DataMarker.AuthorizationRequest, "Authorize", 3000);
    public static final Endpoint Connect = new Endpoint(Method.Post, DataMarker.ConnectRequest, "Connect", 3000);
    public static final Endpoint Logs = new Endpoint(Method.Get, DataMarker.LogRequest, "Logs", 90000);
    public static final Endpoint Poll = new Endpoint(Method.Get, DataMarker.PollRequest, "Poll");
    public static final Endpoint Schema = new Endpoint(Method.Get, DataMarker.DeviceSchemaRequest, "Schema", 90000, true, DataMarker.ComponentSchema, DataMarker.ServiceSchema, DataMarker.ExtensionSchema, DataMarker.AssemblyInfoData);
    public static final Endpoint Subscribe = new Endpoint(Method.Post, DataMarker.SubscribeRequest, "Subscribe", 90000);
    public static final Endpoint Unsubscribe = new Endpoint(Method.Get, DataMarker.UnsubscribeRequest, "Unsubscribe");
    public static final Endpoint Invoke = new Endpoint(Method.Post, DataMarker.WriteRequest, "Invoke");
    public static final Endpoint Add = new Endpoint(Method.Put, DataMarker.AddRequest, "Add", 90000);
    public static final Endpoint Link = new Endpoint(Method.Post, DataMarker.LinkRequest, "Link");
    public static final Endpoint Remove = new Endpoint(Method.Delete, DataMarker.DeleteRequest, "Remove");
    public static final Endpoint Rename = new Endpoint(Method.Patch, DataMarker.RenameRequest, "Rename");
    public static final Endpoint Reorder = new Endpoint(Method.Patch, DataMarker.ReorderRequest, "Reorder");
    public static final Endpoint Tree = new Endpoint(Method.Get, DataMarker.TreeRequest, "Tree", 90000, true, DataMarker.TreeData);
    public static final Endpoint Unlink = new Endpoint(Method.Delete, DataMarker.LinkRequest, "Unlink");
    public static final Endpoint Write = new Endpoint(Method.Patch, DataMarker.WriteRequest, "Write");
    public static final Endpoint Extend = new Endpoint(Method.Put, DataMarker.AddExtensionRequest, "AddExtension");
    public static final Endpoint Shrink = new Endpoint(Method.Delete, DataMarker.DeleteExtensionRequest, "RemoveExtension");
    public static final Endpoint Libraries = new Endpoint(Method.Get, DataMarker.DeviceLibrariesRequest, "Libraries");
    public static final Endpoint FileDelete = new Endpoint(Method.Delete, DataMarker.DeleteFileRequest, "FileDelete", 90000);
    public static final Endpoint FileGet = new Endpoint(Method.Get, DataMarker.GetFileRequest, "FileGet");
    public static final Endpoint FilePut = new Endpoint(Method.Put, DataMarker.PutFileRequest, "FilePut");
    public static final Endpoint Folder = new Endpoint(Method.Get, DataMarker.GetFolderRequest, "Folder");
    public static final Endpoint FolderDelete = new Endpoint(Method.Delete, DataMarker.DeleteFolderRequest, "FolderDelete", 90000);
    public static final Endpoint UpdateAttr = new Endpoint(Method.Patch, DataMarker.UpdateAttributesRequest, "UpdateAttr");
    public static final Endpoint Tag = new Endpoint(Method.Post, null, "AddTags");
    public static final Endpoint Untag = new Endpoint(Method.Post, null, "RemoveTags");
    public static final Endpoint Schedule = new Endpoint(Method.Patch, null, "Schedule", 20000, false);
    public static final Endpoint Labels = new Endpoint(Method.Patch, null, "Labels", 20000, false);
    public static final Endpoint GetTrend = new Endpoint(Method.Get, null, "GetTrend", 90000);
    public static final Endpoint ClearTrend = new Endpoint(Method.Delete, null, "ClearTrend", 90000);
    public static final Endpoint Transform = new Endpoint(Method.Patch, DataMarker.ReorderExtensionRequest, "ReorderExtension");
    public static final String IFNetAddressBase = "iFNet/";
    public static final String[] LegacyEndpoints = new String[]{"Logs", "Poll", "Schema", "Subscribe", "Unsubscribe", "Invoke", "Add", "Link", "Remove", "Rename", "Tree", "Unlink", "Write", "AddExtension", "RemoveExtension", "Libraries", "FileDelete", "FileGet", "FilePut", "Folder", "FolderDelete", "UpdateAttr", "AddTags", "RemoveTags", "BNanoSchedule", "Labels", "GetTrend", "ClearTrend"};
    public String address;
    public Method method = Method.values()[0];
    public DataMarker marker = null;
    public int timeout;
    public DataMarker[] responseFilter;
    public boolean isResponseDataExpected = true;

    private Endpoint() {
    }

    private Endpoint(Method theMethod, DataMarker withMarker, String withId) {
        this(theMethod, withMarker, withId, 20000);
    }

    private Endpoint(Method theMethod, DataMarker withMarker, String withId, int timeoutMilliseconds) {
        this(theMethod, withMarker, withId, timeoutMilliseconds, true);
    }

    private Endpoint(Method theMethod, DataMarker withMarker, String withId, int timeoutMilliseconds, boolean isResponseBodyExpected) {
        this(theMethod, withMarker, withId, timeoutMilliseconds, isResponseBodyExpected, new DataMarker[]{null});
    }

    private Endpoint(Method theMethod, DataMarker withMarker, String withId, int timeoutMilliseconds, boolean isResponseBodyExpected, DataMarker ... acceptedResponseData) {
        this.marker = withMarker;
        this.address = this.Address(withId);
        this.timeout = timeoutMilliseconds;
        this.method = theMethod;
        this.isResponseDataExpected = isResponseBodyExpected;
        if (null != acceptedResponseData && acceptedResponseData.length > 0) {
            ArrayList<DataMarker> withError = new ArrayList<DataMarker>(Arrays.asList(acceptedResponseData));
            withError.add(DataMarker.ErrorData);
            this.responseFilter = withError.toArray(new DataMarker[0]);
        } else {
            this.responseFilter = null;
        }
    }

    String Address(String requestName) {
        return IFNetAddressBase + requestName;
    }

    public String toString() {
        return this.address.substring(IFNetAddressBase.length());
    }

    public static enum Method {
        Get,
        Post,
        Put,
        Patch,
        Delete;

        public static final int SIZE = 32;

        public static Method forValue(int value) {
            return Method.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

