/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.comm;

import com.miratech.ifnetclient.Internal.Helper;
import com.miratech.ifnetclient.comm.Endpoint;
import com.miratech.ifnetclient.comm.Headers;
import com.miratech.ifnetclient.comm.HttpHeaders;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import com.miratech.serialization.internal.EndOfStreamException;
import com.miratech.serialization.internal.InvalidCastException;
import java.util.ArrayList;

public class Response {
    public int status = 406;
    public HttpHeaders headers;
    public Endpoint endpoint;
    SerializableForm[] content;

    public Response(Endpoint forRequest) {
        this.endpoint = forRequest;
    }

    public Response(Endpoint request, int code, byte[] data) throws EndOfStreamException, Exception, InvalidCastException {
        this.status = code;
        try {
            this.content = Helper.ToSerializableForms(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.content = null;
        }
        this.headers = Headers.Empty;
        this.endpoint = request;
    }

    public static Response OK(Endpoint request, byte[] data) throws EndOfStreamException, Exception, InvalidCastException {
        return new Response(request, 200, data);
    }

    public static Response Failed(Endpoint request, int status) throws EndOfStreamException, Exception, InvalidCastException {
        return new Response(request, status, null);
    }

    public final boolean isValid() {
        return this.status == 200 && this.content != null && this.content.length > 0;
    }

    public final SerializableForm[] Errors() {
        if (this.content == null) {
            return new SerializableForm[0];
        }
        ArrayList<SerializableForm> serializableForms = new ArrayList<SerializableForm>();
        for (SerializableForm form : this.content) {
            if (form.marker != DataMarker.ErrorData) continue;
            serializableForms.add(form);
        }
        return serializableForms.toArray(new SerializableForm[0]);
    }

    public void invoke(Response failed) {
    }
}

