/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.model;

import com.miratech.ifnetclient.Internal.NotationOfIfnetData;
import com.miratech.ifnetclient.Internal.NotationOfTrend;
import com.miratech.ifnetclient.comm.ConnectionResult;
import com.miratech.ifnetclient.comm.Endpoint;
import com.miratech.ifnetclient.comm.Server;
import com.miratech.ifnetclient.comm.Session;
import com.miratech.ifnetclient.model.Choice;
import com.miratech.ifnetclient.model.DeviceCache;
import com.miratech.ifnetclient.model.Tag;
import com.miratech.ifnetclient.model.TrendModels.Trend;
import com.miratech.ifnetclient.utils.Action2Param;
import com.miratech.ifnetclient.utils.Event;
import com.miratech.nE2Link.schedules.BNanoSchedule;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import com.tridium.nre.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.baja.net.Http;

public class RemoteDevice {
    public final Event<Action2Param<Session, Http>> OnBadResponse = new Event();
    public static String defaultIfnetVersion = "1.0";
    public final Server Remote;
    String[] endpoints = Endpoint.LegacyEndpoints;
    private String ifnetVersion = defaultIfnetVersion;
    private DeviceCache deviceCache;

    public RemoteDevice(String ip, int port) {
        this.Remote = new Server(ip, port);
    }

    public RemoteDevice(Server remote) {
        this.Remote = remote;
    }

    private static boolean GenericResponseValidation(ArrayList<SerializableForm> requestTask) {
        return RemoteDevice.GenericResponseValidation(requestTask, "");
    }

    private static boolean GenericResponseValidation(ArrayList<SerializableForm> requestTask, String callerName) {
        return true;
    }

    public DeviceCache getDeviceCache() {
        return this.deviceCache;
    }

    public String getIfnetVersion() {
        return this.ifnetVersion;
    }

    void setIfnetVersion(String ifnetVersion) {
        this.ifnetVersion = ifnetVersion;
    }

    public final ConnectionResult Connect(String withUsername, String withPassword) {
        if (this.Remote.isConnected()) {
            return ConnectionResult.CONNECTED;
        }
        Pair<ArrayList<SerializableForm>, ConnectionResult> connectionResponse = this.Remote.Connect(withUsername, withPassword);
        this.ifnetVersion = NotationOfIfnetData.ExtractVersion((List)connectionResponse.getFirst());
        this.endpoints = NotationOfIfnetData.ExtractEndpoints((List)connectionResponse.getFirst());
        return (ConnectionResult)((Object)connectionResponse.getSecond());
    }

    public final Boolean AddTags(long elementPersistentId, Tag ... toBeAdded) {
        SerializableForm requestDataForm = SerializableForm.Make().WithTags(elementPersistentId, toBeAdded);
        ArrayList<SerializableForm> request = this.Remote.Tag(requestDataForm);
        return RemoteDevice.GenericResponseValidation(request);
    }

    public final Boolean RemoveTags(long elementPersistentId, Tag ... toBeAdded) {
        SerializableForm requestDataForm = SerializableForm.Make().WithTags(elementPersistentId, toBeAdded);
        ArrayList<SerializableForm> request = this.Remote.Untag(requestDataForm);
        return RemoteDevice.GenericResponseValidation(request);
    }

    public final Boolean AppendSchedule(String elementPersistentId, BNanoSchedule newSchedule) {
        SerializableForm requestForm = SerializableForm.Make().WithSchedule(elementPersistentId, newSchedule);
        ArrayList<SerializableForm> request = this.Remote.Schedule(requestForm);
        return RemoteDevice.GenericResponseValidation(request);
    }

    public boolean AppendLabels(long elementPersistentId, Choice newLabels) {
        SerializableForm requestForm = SerializableForm.Make().WithChoice(elementPersistentId, newLabels);
        ArrayList<SerializableForm> request = this.Remote.Labels(requestForm);
        return RemoteDevice.GenericResponseValidation(request);
    }

    public boolean GetTrend(String id, long startSeq) {
        SerializableForm requestParams = new SerializableForm(DataMarker.TrendData, new Object[]{id, startSeq});
        ArrayList<SerializableForm> response = this.Remote.GetTrend(requestParams);
        NotationOfTrend notationOfTrend = new NotationOfTrend();
        Trend newData = response.isEmpty() ? notationOfTrend.ExtractTrend(response) : Trend.EmptyTrend();
        this.getDeviceCache().getTrends().addOrUpdate(id, newData);
        return null != newData;
    }

    public boolean ClearTrend(String id, long startedStampRemoving) {
        SerializableForm requestParams = new SerializableForm(DataMarker.TrendRemoving, new Object[]{id, startedStampRemoving}, null);
        this.Remote.ClearTrend(requestParams);
        this.getDeviceCache().getTrends().delete(id);
        return true;
    }
}

