/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.model.scheduleLogic;

import com.miratech.ifnetclient.model.scheduleLogic.DaysFromCalendar;
import com.miratech.ifnetclient.model.scheduleLogic.ExceptionalDays;
import com.miratech.ifnetclient.model.scheduleLogic.ISchedule;
import com.miratech.ifnetclient.model.scheduleLogic.RawIScheduleData;
import com.miratech.nE2Link.schedules.BNanoSchedule;
import java.util.Hashtable;

public final class ScheduleData {
    public static Object[] WeeklyNotation(BNanoSchedule weekly, long withPersistentId, Class withOutputType) {
        RawIScheduleData rawData = weekly.ExtractRawData();
        Object[] data = new Object[]{withPersistentId, rawData.eventsTimes, rawData.eventsValues, withOutputType.getSimpleName()};
        return data;
    }

    public static Object[] IrregularDaysNotation(ISchedule eventData) {
        RawIScheduleData rawData = eventData.ExtractRawData();
        Object[] data = new Object[]{eventData.getClass().getSimpleName(), eventData.getScheduleName(), rawData.daysDefinition, rawData.eventsTimes, rawData.eventsValues, eventData.getPriority()};
        return data;
    }

    public static ISchedule ExtractExceptionalDay(RawIScheduleData compressedData) {
        ISchedule created = null;
        try {
            created = ScheduleData.Create(compressedData);
            created.ApplyRawData(compressedData);
        }
        catch (Exception e) {
            System.out.println("[ScheduleData.ExtractExceptionalDay] Failed to extract ExceptionalDay: " + e.getLocalizedMessage());
            created = null;
        }
        return created;
    }

    static ISchedule Create(RawIScheduleData compressedData) throws Exception {
        if (compressedData.typeId.equals("ExceptionalDays")) {
            return new ExceptionalDays();
        }
        if (compressedData.typeId.equals("DaysFromCalendar")) {
            return new DaysFromCalendar();
        }
        throw new Exception("Not supported type of irregular day. typeId = " + compressedData.typeId);
    }

    public static boolean ExtractExceptionalDays(RawIScheduleData[] exceptionalDaysData, ISchedule[] instantiated) {
        instantiated = new ISchedule[exceptionalDaysData.length];
        for (int i = 0; i < exceptionalDaysData.length; ++i) {
            ISchedule newInstance;
            instantiated[i] = newInstance = ScheduleData.ExtractExceptionalDay(exceptionalDaysData[i]);
        }
        return true;
    }

    public static RawIScheduleData ParseIrregularDay(Object[] data) {
        RawIScheduleData rawData = RawIScheduleData.Empty;
        try {
            Byte withPriority = data.length >= 6 ? (Byte)data[5] : (byte)16;
            rawData = new RawIScheduleData(String.valueOf(data[0]), ScheduleData.ExtractUints(data[3]), ScheduleData.ExtractDoubles(data[4]), data[2], (String)data[1], withPriority);
        }
        catch (Exception e) {
            System.out.println("[ScheduleData.ParseIrregularDay] Failed to parse IrregularSchedule: " + e.getLocalizedMessage());
        }
        return rawData;
    }

    public static ISchedule ExtractIrregularSchedule(Object[] data) {
        ISchedule extracted = null;
        try {
            RawIScheduleData rawData = ScheduleData.ParseIrregularDay(data);
            extracted = ScheduleData.Create(rawData);
            extracted.ApplyRawData(rawData);
        }
        catch (Exception e) {
            extracted = null;
            System.out.println("[ScheduleData.ExtractIrregularSchedule] Failed to extract IrregularSchedule: " + e.getLocalizedMessage());
        }
        return extracted;
    }

    private static long[] ExtractUints(Object wrapper) {
        Object[] asObjectsTable;
        Object[] objectArray = asObjectsTable = wrapper instanceof Object[] ? (Object[])wrapper : null;
        if (null != asObjectsTable) {
            long[] casted = new long[asObjectsTable.length];
            for (int i = 0; i < casted.length; ++i) {
                casted[i] = (Long)asObjectsTable[i];
            }
            return casted;
        }
        return new long[0];
    }

    private static double[] ExtractDoubles(Object wrapper) {
        Object[] asObjectsTable;
        Object[] objectArray = asObjectsTable = wrapper instanceof Object[] ? (Object[])wrapper : null;
        if (null != asObjectsTable) {
            double[] casted = new double[asObjectsTable.length];
            for (int i = 0; i < casted.length; ++i) {
                casted[i] = (Double)asObjectsTable[i];
            }
            return casted;
        }
        return new double[0];
    }

    public static Object[] ScheduleLexiconData(Hashtable basicData, String lexiconId) {
        int lexiconLength = basicData.size();
        Object[] keys = new Object[lexiconLength];
        String[] displayNames = new String[lexiconLength];
        int index = 0;
        for (Object choice : basicData.keySet()) {
            keys[index] = choice;
            displayNames[index] = basicData.get(choice).toString();
            ++index;
        }
        Object[] data = new Object[]{(byte)-1, lexiconId, "null", keys, displayNames};
        return data;
    }

    public static boolean ParseRegularWeek(Object[] freshData, RawIScheduleData parsed) {
        try {
            if (freshData.length < 4) {
                System.out.println(String.format("[ScheduleData.ParseRegularWeek] Wrong data size in schedule form: %1$s", freshData.length));
                throw new IllegalArgumentException();
            }
            parsed = new RawIScheduleData(BNanoSchedule.class.toString(), ScheduleData.ExtractUints(freshData[1]), ScheduleData.ExtractDoubles(freshData[2]), null, "Regular Week");
            return true;
        }
        catch (Exception e) {
            System.out.println("[ScheduleData.ParseRegularWeek] Failed to parse RegularWeek: " + e.getLocalizedMessage());
            parsed = null;
            return false;
        }
    }

    public static boolean ExtractLexicon(Object[] freshData, Hashtable result, String id) {
        try {
            Object[] keys = (Object[])freshData[3];
            String[] displayNames = (String[])freshData[4];
            result = new Hashtable<Object, String>(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                result.put(keys[i], displayNames[i]);
            }
            id = freshData[1] == null ? null : freshData[1].toString();
            return true;
        }
        catch (Exception e) {
            result = null;
            id = "";
            System.out.println("[ScheduleData.ExtractLexicon] Wrong lexicon data: " + e.getLocalizedMessage());
            return false;
        }
    }
}

