/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.nE2Link.BMarkerEnum;
import com.miratech.nE2Link.BNanoBaseNamed;
import com.miratech.nE2Link.BNanoExtension;
import com.miratech.nE2Link.BNanoStatusNumeric;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.actions.BDisplayModeEnum;
import com.miratech.nE2Link.actions.BNanoAddExtensionArg;
import com.miratech.nE2Link.actions.BNanoComponentListArg;
import com.miratech.nE2Link.actions.BNanoDeleteExtensionArg;
import com.miratech.nE2Link.actions.BNanoLinkInfoArg;
import com.miratech.nE2Link.actions.BNanoPropertyChangedArg;
import com.miratech.nE2Link.notifications.BMessageNotification;
import com.miratech.nE2Link.notifications.BMessageTypeEnum;
import com.miratech.nE2Link.parser.binary.AttributeData;
import com.miratech.nE2Link.parser.binary.SlotMetaData;
import com.miratech.nE2Link.schedules.BNanoCalendar;
import com.miratech.nE2Link.schedules.BNanoSchedule;
import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.util.ContextThread;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sync.ProxyBroker;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="icon", type="BIcon", defaultValue="DEFAULT_ICON", flags=5), @NiagaraProperty(name="marker", type="BMarkerEnum", defaultValue="BMarkerEnum.DEFAULT", flags=1), @NiagaraProperty(name="libraryId", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="typeId", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="globalIndex", type="int", defaultValue="-1", flags=65), @NiagaraProperty(name="parentGlobalIndex", type="int", defaultValue="-1", flags=65), @NiagaraProperty(name="originNameFromLibrary", type="String", defaultValue="", flags=1), @NiagaraProperty(name="AssemblyInfo", type="String", defaultValue="", flags=1), @NiagaraProperty(name="baseName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="interfaces", type="String", defaultValue="", flags=1), @NiagaraProperty(name="isLibraryComponent", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="initComplete", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="persistentId", type="String", defaultValue="", flags=65), @NiagaraProperty(name="componentFacets", type="BFacets", defaultValue="BFacets.NULL", flags=1), @NiagaraProperty(name="currentDisplayMode", type="BDisplayModeEnum", defaultValue="BDisplayModeEnum.DEFAULT", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="requestNanoSubscription", flags=20), @NiagaraAction(name="deleteLinkInTarget", parameterType="BLink", defaultValue="new BLink()", flags=20), @NiagaraAction(name="notifyNanoForPropertyChange", parameterType="BNanoPropertyChangedArg", defaultValue="new BNanoPropertyChangedArg(null, null, null, null)", flags=20), @NiagaraAction(name="selectDisplayMode", parameterType="BDisplayModeEnum", defaultValue="BDisplayModeEnum.DEFAULT", flags=20)})
public abstract class BNanoBaseComponent
extends BNanoBaseNamed {
    protected static final BOrd ICONS_X16_MODULE_ORD = BOrd.make((String)String.format("module://nE2Link/rc/icons/x16", new Object[0]));
    protected static final String DEFAULT_ICON_NAME = "defaultIcon.svg";
    protected static final BOrd DEFAULT_ICON_ORD = BOrd.make((String)(ICONS_X16_MODULE_ORD.toString() + '/' + "defaultIcon.svg"));
    protected static final BIcon DEFAULT_ICON = BIcon.make((BOrd)DEFAULT_ICON_ORD);
    public static final Property icon = BNanoBaseComponent.newProperty((int)5, (BValue)DEFAULT_ICON, null);
    public static final Property marker = BNanoBaseComponent.newProperty((int)1, (BValue)BMarkerEnum.DEFAULT, null);
    public static final Property libraryId = BNanoBaseComponent.newProperty((int)1, (int)-1, null);
    public static final Property typeId = BNanoBaseComponent.newProperty((int)1, (int)-1, null);
    public static final Property globalIndex = BNanoBaseComponent.newProperty((int)65, (int)-1, null);
    public static final Property parentGlobalIndex = BNanoBaseComponent.newProperty((int)65, (int)-1, null);
    public static final Property originNameFromLibrary = BNanoBaseComponent.newProperty((int)1, (String)"", null);
    public static final Property AssemblyInfo = BNanoBaseComponent.newProperty((int)1, (String)"", null);
    public static final Property baseName = BNanoBaseComponent.newProperty((int)1, (String)"", null);
    public static final Property interfaces = BNanoBaseComponent.newProperty((int)1, (String)"", null);
    public static final Property isLibraryComponent = BNanoBaseComponent.newProperty((int)65, (boolean)false, null);
    public static final Property initComplete = BNanoBaseComponent.newProperty((int)1, (boolean)false, null);
    public static final Property persistentId = BNanoBaseComponent.newProperty((int)65, (String)"", null);
    public static final Property componentFacets = BNanoBaseComponent.newProperty((int)1, (BValue)BFacets.NULL, null);
    public static final Property currentDisplayMode = BNanoBaseComponent.newProperty((int)4, (BValue)BDisplayModeEnum.DEFAULT, null);
    public static final Action requestNanoSubscription = BNanoBaseComponent.newAction((int)20, null);
    public static final Action deleteLinkInTarget = BNanoBaseComponent.newAction((int)20, (BValue)new BLink(), null);
    public static final Action notifyNanoForPropertyChange = BNanoBaseComponent.newAction((int)20, (BValue)new BNanoPropertyChangedArg(null, null, null, null), null);
    public static final Action selectDisplayMode = BNanoBaseComponent.newAction((int)20, (BValue)BDisplayModeEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BNanoBaseComponent.class);
    public static final String FACET_NAME_PREFIX_NANO = "nano_";
    public static final String FACET_NAME_PREFIX_NANO_ATTR = "nano_attr_";
    public static final String FACET_NAME_PREFIX_NANO_ATTR_TYPE = "nano_attr_type_";
    public static final String FACET_NAME_NANO_NAME = "nano_name";
    public static final String FACET_NAME_NANO_TYPE = "nano_type";
    public static final String FACET_NAME_NANO_ID = "nano_slotId";
    public static final String FACET_NAME_PROTECTED = "nano_attr_protected";
    public static final String FACET_NAME_NANO_SLOT_META_DATA = "slotMetaData";
    public static final String PROP_NAME_META = "meta";
    public static final String PROP_NAME_STATUS = "status";
    public static final String LEX_KEY_DELETE_FORBIDDEN = "DELETE_FORBIDDEN";
    public static final String LEX_KEY_RENAME_FORBIDDEN = "RENAME_FORBIDDEN";
    public static final String LEX_KEY_ILLEGAL_EXTENSION = "ILLEGAL_EXTENSION";
    protected static final String WIRESHEET_VIEW = "wiresheet:WireSheet";
    protected static final String PROPERTY_SHEET_VIEW = "workbench:PropertySheet";
    protected static final String[] COMPONENTS_TO_UNPROTECT = new String[]{""};
    public final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    public static final int DELAY_MILLIS_EXTENSION_SLOT_CREATION = 10;
    public static final List<String> TYPES_SUPRESSED_IN_IC_TOOL = Arrays.asList("Framework.Core.SystemServices.UserManagerService", "Framework.Core.Persistence.StorageService");
    private BAbsTime lastSubscription = BAbsTime.NULL;
    private static BRelTime MIN_RESUBSCRIPTION_INTERVAL = BRelTime.make((long)1000L);
    public HashMap<Integer, Property> nanoSlotsByOrdinal = new HashMap();
    public HashMap<String, Property> nanoActionsByName = new HashMap();
    protected Clock.Ticket pendingComponentAddNotificationTicket = null;
    protected Clock.Ticket updateTicket = null;
    protected BNanoComponentListArg addedComponents = new BNanoComponentListArg();
    private final Object extensionLock = new Object();
    private Map<Property, ArrayList<Property>> propertyCache = new HashMap<Property, ArrayList<Property>>();

    public BIcon getIcon() {
        return (BIcon)this.get(icon);
    }

    public void setIcon(BIcon v) {
        this.set(icon, (BValue)v, null);
    }

    public BMarkerEnum getMarker() {
        return (BMarkerEnum)this.get(marker);
    }

    public void setMarker(BMarkerEnum v) {
        this.set(marker, (BValue)v, null);
    }

    public int getLibraryId() {
        return this.getInt(libraryId);
    }

    public void setLibraryId(int v) {
        this.setInt(libraryId, v, null);
    }

    public int getTypeId() {
        return this.getInt(typeId);
    }

    public void setTypeId(int v) {
        this.setInt(typeId, v, null);
    }

    public int getGlobalIndex() {
        return this.getInt(globalIndex);
    }

    public void setGlobalIndex(int v) {
        this.setInt(globalIndex, v, null);
    }

    public int getParentGlobalIndex() {
        return this.getInt(parentGlobalIndex);
    }

    public void setParentGlobalIndex(int v) {
        this.setInt(parentGlobalIndex, v, null);
    }

    public String getOriginNameFromLibrary() {
        return this.getString(originNameFromLibrary);
    }

    public void setOriginNameFromLibrary(String v) {
        this.setString(originNameFromLibrary, v, null);
    }

    public String getAssemblyInfo() {
        return this.getString(AssemblyInfo);
    }

    public void setAssemblyInfo(String v) {
        this.setString(AssemblyInfo, v, null);
    }

    public String getBaseName() {
        return this.getString(baseName);
    }

    public void setBaseName(String v) {
        this.setString(baseName, v, null);
    }

    public String getInterfaces() {
        return this.getString(interfaces);
    }

    public void setInterfaces(String v) {
        this.setString(interfaces, v, null);
    }

    public boolean getIsLibraryComponent() {
        return this.getBoolean(isLibraryComponent);
    }

    public void setIsLibraryComponent(boolean v) {
        this.setBoolean(isLibraryComponent, v, null);
    }

    public boolean getInitComplete() {
        return this.getBoolean(initComplete);
    }

    public void setInitComplete(boolean v) {
        this.setBoolean(initComplete, v, null);
    }

    public String getPersistentId() {
        return this.getString(persistentId);
    }

    public void setPersistentId(String v) {
        this.setString(persistentId, v, null);
    }

    public BFacets getComponentFacets() {
        return (BFacets)this.get(componentFacets);
    }

    public void setComponentFacets(BFacets v) {
        this.set(componentFacets, (BValue)v, null);
    }

    public BDisplayModeEnum getCurrentDisplayMode() {
        return (BDisplayModeEnum)this.get(currentDisplayMode);
    }

    public void setCurrentDisplayMode(BDisplayModeEnum v) {
        this.set(currentDisplayMode, (BValue)v, null);
    }

    public void requestNanoSubscription() {
        this.invoke(requestNanoSubscription, null, null);
    }

    public void deleteLinkInTarget(BLink parameter) {
        this.invoke(deleteLinkInTarget, (BValue)parameter, null);
    }

    public void notifyNanoForPropertyChange(BNanoPropertyChangedArg parameter) {
        this.invoke(notifyNanoForPropertyChange, (BValue)parameter, null);
    }

    public void selectDisplayMode(BDisplayModeEnum parameter) {
        this.invoke(selectDisplayMode, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void added(Property property, Context context) {
        BRelTime deviceNotificationDelay = BRelTime.make((long)200L);
        if (this.isNanoSlot((Slot)property)) {
            int nanoSlotId = this.getNanoSlotId(property);
            if (nanoSlotId >= 0) {
                this.nanoSlotsByOrdinal.put(nanoSlotId, property);
            } else {
                String actionName = BNanoBaseComponent.getOriginNameFromProperty(property);
                if (!this.nanoActionsByName.containsKey(actionName)) {
                    Property property2 = this.nanoActionsByName.put(actionName, property);
                }
            }
        }
        if (this.checkContext(context)) {
            return;
        }
        if (!Context.decoding.equals(context) && !Context.copying.equals(context) && property.getType().is(BLink.TYPE)) {
            BLink link = (BLink)this.get(property);
            BNanoBaseComponent sourceComponent = (BNanoBaseComponent)link.getSourceComponent();
            BNanoBaseComponent targetComponent = (BNanoBaseComponent)link.getTargetComponent();
            BNanoLinkInfoArg linkInfoArg = new BNanoLinkInfoArg(sourceComponent.getGlobalIndex(), sourceComponent.getNanoSlotId(link.getSourceSlotName()), targetComponent.getGlobalIndex(), targetComponent.getNanoSlotId(link.getTargetSlotName()), context);
            this.getNe2DeviceExt().handleNanoLinkCreation(linkInfoArg);
        }
        if (property.getType().is(TYPE)) {
            BNanoBaseComponent newNanoBaseComponent = (BNanoBaseComponent)this.get(property);
            Type newComponentType = newNanoBaseComponent.getType();
            if (!(!this.isRunning() || Context.decoding.equals(context) || Context.copying.equals(context) || newNanoBaseComponent.getIsLibraryComponent() || newComponentType.is(BNanoExtension.TYPE))) {
                if (this.pendingComponentAddNotificationTicket != null) {
                    if (!this.pendingComponentAddNotificationTicket.isExpired()) {
                        this.pendingComponentAddNotificationTicket.cancel();
                    } else {
                        this.addedComponents.clear();
                    }
                }
                this.addedComponents.addComponent(newNanoBaseComponent);
                this.addedComponents.setCallContext(context.getFacets());
                this.pendingComponentAddNotificationTicket = Clock.schedule((BComponent)this.getNe2DeviceExt(), (BRelTime)deviceNotificationDelay, (Action)BNe2DeviceExt.handleNanoComponentsCreation, (BValue)this.addedComponents.newCopy());
            } else if (this.isRunning() && !Context.decoding.equals(context) && !Context.copying.equals(context) && newComponentType.is(BNanoExtension.TYPE)) {
                BNanoExtension newExtension = (BNanoExtension)newNanoBaseComponent;
                Clock.schedule((BComponent)this.getNe2DeviceExt(), (BRelTime)deviceNotificationDelay, (Action)BNe2DeviceExt.handleNanoExtensionCreation, (BValue)new BNanoAddExtensionArg(this, newExtension, context));
            }
        }
        super.added(property, context);
    }

    public void checkRemove(Property property, Context context) {
        if (this.checkContext(context) || !this.isRunning()) {
            return;
        }
        if (!Context.decoding.equals(context) && (this.isNanoSlot((Slot)property) && !this.isNanoExtensionSlot((Slot)property) || this.isProtectedSlot(property))) {
            throw new LocalizableRuntimeException(BNanoBaseComponent.LEX.module.getModuleName(), LEX_KEY_DELETE_FORBIDDEN);
        }
        if (!Context.decoding.equals(context) && property.getType().is(TYPE)) {
            BNanoBaseComponent deletedNanoBaseComponent = (BNanoBaseComponent)this.get(property);
            if (null != deletedNanoBaseComponent.get("wsAnnotation")) {
                deletedNanoBaseComponent.remove("wsAnnotation");
            }
            if (deletedNanoBaseComponent.getGlobalIndex() != -1 && !deletedNanoBaseComponent.getIsLibraryComponent() && !deletedNanoBaseComponent.getType().is(BNanoExtension.TYPE)) {
                this.getNe2DeviceExt().doHandleNanoComponentDeletion(deletedNanoBaseComponent);
            } else if (!Context.decoding.equals(context) && deletedNanoBaseComponent.getType().is(BNanoExtension.TYPE)) {
                this.getNe2DeviceExt().doHandleNanoExtensionDeletion(new BNanoDeleteExtensionArg(this, ((BNanoExtension)deletedNanoBaseComponent).getExtensionId(), context));
            }
        } else if (!Context.decoding.equals(context) && !Context.commit.equals(context) && property.getType().is(BLink.TYPE)) {
            BLink link = (BLink)this.get(property);
            BNanoBaseComponent sourceComponent = null;
            try {
                sourceComponent = (BNanoBaseComponent)link.getSourceOrd().resolve((BObject)this).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int sourceComponentGlobalIndex = sourceComponent != null ? sourceComponent.getGlobalIndex() : -1;
            int sourceSlotId = sourceComponent != null ? sourceComponent.getNanoSlotId(link.getSourceSlotName()) : -1;
            BNanoBaseComponent targetComponent = this;
            BNanoLinkInfoArg linkInfoArg = new BNanoLinkInfoArg(sourceComponentGlobalIndex, sourceSlotId, targetComponent.getGlobalIndex(), targetComponent.getNanoSlotId(link.getTargetSlotName()), context);
            this.getNe2DeviceExt().doHandleNanoLinkDeletion(linkInfoArg);
        } else {
            super.checkRemove(property, context);
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (this.isNanoExtensionSlot((Slot)property)) {
            int nanoSlotId = this.getNanoSlotId(property);
            if (nanoSlotId >= 0) {
                this.nanoSlotsByOrdinal.remove(nanoSlotId);
            } else {
                String actionName = BNanoBaseComponent.getOriginNameFromProperty(property);
                if (property.equals(this.nanoActionsByName.get(actionName))) {
                    this.nanoActionsByName.remove(actionName, property);
                }
            }
        }
        if (this.checkContext(context)) {
            return;
        }
        super.removed(property, oldValue, context);
    }

    @Override
    public void checkRename(Property property, String newName, Context context) {
        if (this.checkContext(context)) {
            return;
        }
        if (this.isNanoSlot((Slot)property) && !this.isNanoExtensionSlot((Slot)property)) {
            throw new LocalizableRuntimeException(BNanoBaseComponent.LEX.module.getModuleName(), LEX_KEY_RENAME_FORBIDDEN);
        }
        if (this.isNanoSlot((Slot)property) && this.isNanoExtensionSlot((Slot)property)) {
            String validName = "e" + (BNanoBaseComponent.getIdFromExtensionProperty(property) - 1) + "_";
            if (!newName.equals(validName = validName + BNanoBaseComponent.getOriginNameFromProperty(property))) {
                throw new LocalizableRuntimeException(BNanoBaseComponent.LEX.module.getModuleName(), LEX_KEY_RENAME_FORBIDDEN);
            }
        } else {
            super.checkRename(property, newName, context);
        }
    }

    public void stopped() throws Exception {
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(selectDisplayMode)) {
            switch (this.getCurrentDisplayMode().getOrdinal()) {
                case -1: {
                    return BDisplayModeEnum.Standard;
                }
                case 0: {
                    return BDisplayModeEnum.Developer;
                }
            }
        }
        return super.getActionParameterDefault(action);
    }

    public void doSelectDisplayMode(BDisplayModeEnum displayMode, Context cx) {
        Context tx;
        SlotCursor propCursor = this.getProperties();
        boolean inheritedTransaction = cx instanceof Transaction;
        Context context = tx = inheritedTransaction ? cx : Transaction.start((BComponent)this, (Context)cx);
        block5: while (propCursor.next()) {
            Property property = propCursor.property();
            if (property.isAction() || property.isTopic() || this.isNanoSlot((Slot)property) || property.getType().is(BNameMap.TYPE) || property.getType().is(BLink.TYPE) || property.isFrozen() && (property.getDefaultFlags() & 4) != 0) continue;
            if (!property.getType().is(TYPE)) {
                int currentFlags = this.getFlags((Slot)property);
                switch (displayMode.getOrdinal()) {
                    case -1: {
                        if ((currentFlags & 4) == 0) continue block5;
                        this.setFlags((Slot)property, currentFlags & 0xFFFFFFFB, tx);
                        break;
                    }
                    default: {
                        if ((currentFlags & 4) != 0) continue block5;
                        this.setFlags((Slot)property, currentFlags | 4, tx);
                        break;
                    }
                }
                continue;
            }
            BNanoBaseComponent nanoBaseComponent = (BNanoBaseComponent)propCursor.get().as(BNanoBaseComponent.class);
            nanoBaseComponent.doSelectDisplayMode(displayMode, tx);
        }
        try {
            if (!inheritedTransaction) {
                Transaction.end((BComponent)this, (Context)tx);
            }
            this.setCurrentDisplayMode(displayMode);
        }
        catch (Exception e) {
            throw new BajaRuntimeException("setDisplayMode failed", (Throwable)e);
        }
    }

    public boolean isComponentReadonly() {
        if (this.getIsLibraryComponent() || this.isProtected()) {
            return true;
        }
        return super.isComponentReadonly();
    }

    public boolean isNanoChildOf(BNanoBaseComponent parent) {
        if (parent == null || parent.getGlobalIndex() == -1 || this.getGlobalIndex() == -1) {
            return false;
        }
        return this.getParentGlobalIndex() == parent.getGlobalIndex();
    }

    public boolean isNanoParentOf(BNanoBaseComponent child) {
        if (child == null || child.getGlobalIndex() == -1 || this.getGlobalIndex() == -1) {
            return false;
        }
        return this.getGlobalIndex() == child.getParentGlobalIndex();
    }

    private void initSlotAndActionCaches() {
        this.nanoSlotsByOrdinal = (HashMap)Arrays.stream(this.getDynamicPropertiesArray()).filter(property -> this.isNanoSlot((Slot)property) && this.getNanoSlotId((Property)property) >= 0).collect(Collectors.toMap(this::getNanoSlotId, Function.identity()));
        this.nanoActionsByName = (HashMap)Arrays.stream(this.getDynamicPropertiesArray()).filter(property -> this.isNanoSlot((Slot)property) && this.getNanoSlotId((Property)property) < 0).collect(Collectors.toMap(BNanoBaseComponent::getOriginNameFromProperty, Function.identity(), (existingKey, newKey) -> existingKey));
    }

    public void changed(Property property, Context context) {
        String[] dependentProperties;
        if (!Sys.isStation()) {
            return;
        }
        if (property.getName().equals(PROP_NAME_META)) {
            this.updateWsAnnotationFromMetaData(context);
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BWsAnnotation.TYPE)) {
            this.updateMetaDataFromWsAnnotation(property, true, false);
            return;
        }
        for (String dependentProperty : dependentProperties = this.getDependentProperties(property.getName())) {
            Subscriber[] subscribers;
            Property propertyToUpdate = this.getProperty(dependentProperty);
            if (propertyToUpdate == null) continue;
            for (Subscriber subscriber : subscribers = this.getSubscribers()) {
                if (!ProxyBroker.class.isAssignableFrom(subscriber.getClass())) continue;
                BComponentEvent event = new BComponentEvent(0, (BComponent)this, (Slot)propertyToUpdate, this.get(propertyToUpdate));
                subscriber.event(event);
            }
        }
    }

    public BLink addLink(BNanoBaseComponent sourceComponent, Slot sourceSlot, Slot targetSlot) {
        BLink link = this.makeLink(sourceComponent, sourceSlot, targetSlot, null);
        String linkName = SlotPath.escape((String)(sourceComponent.getNanoName() + "." + sourceSlot.getName() + "\u25b8" + this.getNanoName() + "." + targetSlot.getName()));
        if (this.getSlot(linkName) == null) {
            this.add(linkName, (BValue)link, Context.decoding);
        } else {
            this.set(linkName, (BValue)link);
        }
        return link;
    }

    public static boolean isMetaDataSlot(Slot slot) {
        return slot.getName().equals(PROP_NAME_META);
    }

    public boolean isSuppressedInICTool() {
        return TYPES_SUPRESSED_IN_IC_TOOL.contains(this.getOriginNameFromLibrary());
    }

    public boolean isInvisibleInTree() {
        Property metaProp = this.getProperty(PROP_NAME_META);
        if (metaProp != null) {
            BValue rawValue = this.get(metaProp);
            double value = 0.0;
            if (rawValue.getType().is(BStatusNumeric.TYPE)) {
                value = ((BStatusNumeric)rawValue).getValue();
            }
            return this.isSuppressedInICTool() || ((long)value & 0xFFFFFFFFL & 0x400L) != 0L;
        }
        return false;
    }

    public boolean isInvisibleInLibrary() {
        boolean isProtected = Boolean.parseBoolean(this.getComponentFacets().gets(FACET_NAME_PROTECTED, null));
        return isProtected || this.getNanoName().equals("Library.IO.DiodeLED") || this.getNanoName().equals("Library.IO.PressureInput") || this.getNanoName().equals("Library.Logic.Numeric2Binary") || this.getNanoName().equals("Library.Other.Pulser") || this.getNanoName().equals("Library.Process.Deadband") || this.getNanoName().equals("Library.Process.MultiLinear") || this.getNanoName().equals("Library.Process.Sequence");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWsAnnotationFromMetaData(Context context) {
        Object object = this.instanceLock;
        synchronized (object) {
            Property metaProp = this.getProperty(PROP_NAME_META);
            if (metaProp != null) {
                long longValue;
                BValue rawValue = this.get(metaProp);
                double value = 0.0;
                if (rawValue.getType().is(BNanoStatusNumeric.TYPE)) {
                    value = ((BNanoStatusNumeric)rawValue).getValue();
                }
                if ((longValue = (long)value & 0xFFFFFFFFL) == 0L) {
                    return;
                }
                int x = (int)(longValue >>> 24 & 0xFFL);
                int y = (int)(longValue >>> 16 & 0xFFL);
                int width = (int)(longValue >>> 11 & 0x1FL);
                BWsAnnotation newAnnotation = BWsAnnotation.make((int)x, (int)y, (int)width);
                Property wsAnnotationProperty = this.getProperty("wsAnnotation");
                if (null != wsAnnotationProperty) {
                    if (!this.get(wsAnnotationProperty).equals((Object)newAnnotation)) {
                        this.set(wsAnnotationProperty, (BValue)newAnnotation);
                    }
                } else if (context != Context.decoding) {
                    this.add("wsAnnotation", (BValue)newAnnotation, context);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetaDataFromWsAnnotation(Property wsAnnotationProp, boolean notifyDevice, boolean forceSlotUpdate) {
        Object object = this.instanceLock;
        synchronized (object) {
            Property metaProp = this.getProperty(PROP_NAME_META);
            if (metaProp == null) {
                return;
            }
            BValue rawValue = this.get(metaProp);
            BNanoStatusNumeric existingMetaDataValue = null;
            double existingMetaDataValueValue = 0.0;
            if (rawValue.getType().is(BNanoStatusNumeric.TYPE)) {
                existingMetaDataValue = (BNanoStatusNumeric)rawValue;
                existingMetaDataValueValue = existingMetaDataValue.getValue();
            }
            BWsAnnotation wsAnnotation = (BWsAnnotation)this.get(wsAnnotationProp);
            long x = (long)wsAnnotation.p << 24;
            long y = (long)wsAnnotation.q << 16;
            long width = ((long)wsAnnotation.wixelWidth & 0x1FL) << 11;
            long invisible = (long)existingMetaDataValueValue & 0x400L;
            long leastSignificant10Bits = (long)existingMetaDataValueValue & 0x3FFL;
            long newMetaDataValue = (x | y | width | invisible | leastSignificant10Bits) & 0xFFFFFFFFL;
            if (newMetaDataValue == 0L || (double)newMetaDataValue == existingMetaDataValueValue & !forceSlotUpdate) {
                return;
            }
            BNanoStatusNumeric newValue = new BNanoStatusNumeric(newMetaDataValue);
            try {
                this.set(metaProp, (BValue)newValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!notifyDevice && !forceSlotUpdate) {
                return;
            }
            this.getNe2DeviceExt().handleNanoPropertyValueChange(new BNanoPropertyChangedArg(this, metaProp, (BValue)((BStatusNumeric)rawValue), (BValue)((BStatusValue)newValue.newCopy())));
        }
    }

    @Override
    public String getDefaultPropertyName() {
        String defaultName = this.toString(null);
        if (!this.getOriginNameFromLibrary().equals("Framework.Core.LogSetting")) {
            int lastIndexOfDot = defaultName.lastIndexOf(46) + 1;
            if (defaultName.length() - lastIndexOfDot > 0) {
                defaultName = defaultName.substring(lastIndexOfDot);
            }
        }
        return SlotPath.escape((String)defaultName);
    }

    public boolean isNanoSlot(Slot slot) {
        BFacets facets = this.getSlotFacets(slot);
        String nanoType = facets.gets(FACET_NAME_NANO_TYPE, "");
        return nanoType.length() != 0;
    }

    public boolean isNanoExtensionSlot(Slot slot) {
        return this.isNanoSlot(slot) && slot.getName().matches("e\\d+_\\D+.*");
    }

    public boolean isProtected() {
        AttributeData attribute = BNanoBaseComponent.getNanoAttribute(this.getComponentFacets(), "protected");
        return attribute != null && Boolean.parseBoolean(attribute.getAttrValue());
    }

    public boolean isProtectedSlot(Property slot) {
        if (slot == null) {
            return false;
        }
        BValue value = this.get(slot);
        if (value instanceof BNanoBaseComponent) {
            BNanoBaseComponent nanoBaseComponent = (BNanoBaseComponent)value;
            AttributeData attribute = BNanoBaseComponent.getNanoAttribute(nanoBaseComponent.getComponentFacets(), "protected");
            return attribute != null && Boolean.parseBoolean(attribute.getAttrValue());
        }
        return false;
    }

    public Integer getNanoSlotId(Property slot) {
        return BNanoBaseComponent.getNanoSlotId(this.getSlotFacets((Slot)slot));
    }

    public static Integer getNanoSlotId(BFacets facets) {
        if (facets == null) {
            return -1;
        }
        return facets.geti(FACET_NAME_NANO_ID, -1);
    }

    public Integer getNanoSlotId(String slotName) {
        Property property = this.getProperty(slotName);
        if (property == null) {
            return -1;
        }
        return this.getNanoSlotId(property);
    }

    public static AttributeData getNanoAttribute(BFacets slotFacets, String attrName) {
        return AttributeData.parse(slotFacets, attrName);
    }

    public AttributeData getNanoAttribute(Slot slot, String attrName) {
        BFacets facets = this.getSlotFacets(slot);
        return BNanoBaseComponent.getNanoAttribute(facets, attrName);
    }

    public AttributeData getNanoAttribute(String slotName, String attrName) {
        Slot slot = this.getSlot(slotName);
        if (slot == null) {
            return null;
        }
        BFacets facets = this.getSlotFacets(slot);
        return BNanoBaseComponent.getNanoAttribute(facets, attrName);
    }

    public SlotMetaData getSlotMetaData(int slotId) {
        Property slot = this.getNanoSlot(slotId);
        if (slot == null) {
            return null;
        }
        BFacets facets = this.getSlotFacets((Slot)slot);
        long slotMetaData = facets.getl(FACET_NAME_NANO_SLOT_META_DATA, 0L);
        return new SlotMetaData(slotMetaData);
    }

    public Property getNanoSlot(Integer slotId) {
        if (this.getComponentSpace() != null && this.getComponentSpace().isProxyComponentSpace()) {
            this.initSlotAndActionCaches();
        }
        return this.nanoSlotsByOrdinal.get(slotId);
    }

    public Property getNanoExtensionProperty(int extensionId) {
        return Arrays.stream(this.getPropertiesArray()).filter(property -> property.getType().is(BNanoExtension.TYPE) && ((BNanoExtension)this.get((Property)property)).getExtensionId() == extensionId).findFirst().orElse(null);
    }

    protected LinkCheck doCheckLink(BComponent sourceComponent, Slot sourceSlot, Slot targetSlot, Context cx) {
        Type sourceType = sourceComponent.getType();
        if (!sourceType.is(TYPE)) {
            Type targetType = this.getType();
            Object[] args = new Object[]{sourceType, targetType};
            Lexicon lex = Lexicon.make((BModule)this.getType().getModule(), (String)cx.getLanguage());
            return LinkCheck.makeInvalid((String)LEX.getText("linkcheck.niagaraToNanoMismatch", args));
        }
        if (sourceSlot.isAction() || targetSlot.isAction() || sourceSlot.isTopic() || targetSlot.isTopic()) {
            return LinkCheck.makeInvalid((String)LEX.getText("linkcheck.slotTypeMismatch"));
        }
        return LinkCheck.makeValid();
    }

    public void knobAdded(Knob knob, Context context) {
        super.knobAdded(knob, context);
        Type targetType = knob.getTargetComponent().getType();
        if (!targetType.is(TYPE)) {
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.invalidLinkNanoNiagara);
            notification.raise(!(Thread.currentThread() instanceof ContextThread));
            BLink link = knob.getLink();
            Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)200L), (Action)deleteLinkInTarget, (BValue)link);
        }
    }

    public void doDeleteLinkInTarget(BLink link) {
        if (link == null) {
            return;
        }
        BComponent targetComponent = link.getTargetComponent();
        Property linkProperty = link.getPropertyInParent();
        if (targetComponent != null && linkProperty != null) {
            targetComponent.remove(linkProperty);
        }
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.fixup(false);
        this.initSlotAndActionCaches();
        this.setIcon(this.getNanoIcon());
        this.selectDisplayMode(this.getNe2DeviceExt().getCurrentDisplayMode());
    }

    public BFacets getSlotFacets(Slot slot) {
        if (null != this.getComponentSpace() && this.getComponentSpace().isProxyComponentSpace() && !slot.isAction()) {
            this.requestNanoSubscription();
        }
        BFacets facets = super.getSlotFacets(slot);
        facets = this.replaceFacetValueByReference(facets, "trueText");
        facets = this.replaceFacetValueByReference(facets, "falseText");
        return facets;
    }

    public String getTypeDisplayName(Context context) {
        String nanoType = this.getOriginNameFromLibrary();
        int lastDotPos = nanoType.lastIndexOf(46);
        return lastDotPos > -1 && lastDotPos < nanoType.length() - 1 ? nanoType.substring(lastDotPos + 1) : nanoType;
    }

    private BFacets replaceFacetValueByReference(BFacets originalFacets, String facetKey) {
        String refSlotName;
        Property p;
        String originalFacetValue = originalFacets.gets(facetKey, null);
        if (originalFacetValue != null && originalFacetValue.startsWith("@") && (p = this.getProperty(refSlotName = originalFacetValue.replaceFirst("@", ""))) != null && p.getType().is(BStatusString.TYPE)) {
            if (!Sys.isStation()) {
                this.lease();
            }
            originalFacetValue = ((BStatusString)this.get(p).as(BStatusString.class)).getValue();
            return BFacets.make((BFacets)originalFacets, (String)facetKey, (BIDataValue)BString.make((String)originalFacetValue));
        }
        return originalFacets;
    }

    public boolean isLinkSource() {
        return this.getKnobs().length > 0;
    }

    public int getMaxNanoSlotId() {
        return this.nanoSlotsByOrdinal.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getKey).orElse(-1);
    }

    public BNanoBaseComponent getOriginFromLibrary() {
        if (this.getNe2DeviceExt() == null) {
            return null;
        }
        return this.getIsLibraryComponent() ? this : this.getNe2DeviceExt().getLibraries().getLibraryComponentsCache().get(this.getTypeId());
    }

    public int getOriginFlags(Slot slot) {
        int flags = this.getFlags(slot);
        if (!this.isMounted()) {
            return flags;
        }
        Property targetProp = slot.asProperty();
        String targetSlotName = BNanoBaseComponent.getOriginNameFromProperty(targetProp);
        if (!this.isNanoExtensionSlot(slot)) {
            BNanoBaseComponent libraryComponent = this.getOriginFromLibrary();
            Property librarySlot = libraryComponent.getProperty(targetSlotName);
            flags = libraryComponent.getFlags((Slot)librarySlot);
        } else {
            int extensionId = BNanoBaseComponent.getIdFromExtensionProperty(targetProp);
            Property extProp = this.getNanoExtensionProperty(extensionId);
            BNanoExtension extension = (BNanoExtension)this.get(extProp);
            Property extensionSlot = extension.getProperty(targetSlotName);
            flags = extension.getFlags((Slot)extensionSlot);
        }
        return flags;
    }

    public void doRequestNanoSubscription() {
        BNe2DeviceExt programExt = this.getNe2DeviceExt();
        if (programExt == null || !programExt.isConnected() || this.getGlobalIndex() == -1) {
            return;
        }
        if (Sys.isStationStarted() && Sys.isStation() && programExt.isSubscriptionEnabled() && !programExt.getApplicationIsLoading() && !this.getIsLibraryComponent() && !this.getType().is(BNanoExtension.TYPE) && BAbsTime.now().isAfter(this.lastSubscription.add(MIN_RESUBSCRIPTION_INTERVAL))) {
            this.lastSubscription = BAbsTime.now();
            this.getNe2DeviceExt().requestNanoSubscription(this);
        }
    }

    private void dumpSubscribers() {
        for (Subscriber subscriber : this.getSubscribers()) {
            System.out.println(String.format("[%s]: SUBSCRIBER FOR '%s': Canonical Class: %s", BNanoBaseComponent.formatTime(BAbsTime.now()), this.getNavOrd(), subscriber.getClass().getCanonicalName()));
        }
    }

    public <T extends BNanoBaseComponent> T[] getDescendants(Class<T> cls, boolean includeSelf, boolean includeExtensions) {
        BNanoBaseComponent[] children;
        ArrayList<BNanoBaseComponent> descendants = new ArrayList<BNanoBaseComponent>();
        if (includeSelf) {
            if (cls.isAssignableFrom(((Object)((Object)this)).getClass())) {
                descendants.add(this);
            } else {
                throw new ClassCastException("Cannot add this[" + ((Object)((Object)this)).getClass() + "] to Array of type [" + cls + "]");
            }
        }
        for (BNanoBaseComponent child : children = (BNanoBaseComponent[])this.getChildren(cls)) {
            BNanoBaseComponent[] grandChildren;
            if (!includeExtensions && child.getType().is(BNanoExtension.TYPE) || (grandChildren = child.getDescendants(cls, true, includeExtensions)).length <= 0) continue;
            Collections.addAll(descendants, grandChildren);
        }
        BNanoBaseComponent[] retVal = descendants.toArray((BNanoBaseComponent[])Array.newInstance(cls, descendants.size()));
        return retVal;
    }

    public void fixup(boolean informDeviceAboutNanoPropertyChanges) {
        if (!this.getIsLibraryComponent() && this.getGlobalIndex() == -1 && this.isMounted() && this.getParent() instanceof BNanoBaseComponent) {
            try {
                Property wsAnnotationProperty;
                BNanoBaseComponent parent = (BNanoBaseComponent)this.getParent().as(BNanoBaseComponent.class);
                this.setParentGlobalIndex(parent.getGlobalIndex());
                this.setNanoName(SlotPath.unescape((String)this.getPropertyInParent().getName()));
                BNanoBaseComponent libComponent = this.getOriginFromLibrary();
                BValue value = libComponent.get(PROP_NAME_STATUS);
                if (value != null) {
                    this.set(PROP_NAME_STATUS, value.newCopy());
                }
                if (null != (wsAnnotationProperty = this.getProperty("wsAnnotation"))) {
                    this.updateMetaDataFromWsAnnotation(wsAnnotationProperty, informDeviceAboutNanoPropertyChanges, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeLink(BNanoLinkInfoArg linkInfo) {
        this.removeLink(linkInfo.getTargetSlotId());
    }

    public void removeLink(int targetSlotId) {
        BLink[] linksToDelete;
        Property targetSlot = this.getNanoSlot(targetSlotId);
        for (BLink linkToDelete : linksToDelete = this.getLinks((Slot)targetSlot)) {
            this.remove(linkToDelete.getPropertyInParent(), Context.decoding);
        }
    }

    public boolean replaceNanoSlotId(Property slot, int newSlotId) {
        int currentSlotId = this.getNanoSlotId(slot);
        if (currentSlotId > -1) {
            BFacets facets = this.getSlotFacets((Slot)slot);
            this.setFacets((Slot)slot, BFacets.make((BFacets)facets, (String)FACET_NAME_NANO_ID, (BIDataValue)BInteger.make((int)newSlotId)));
            this.nanoSlotsByOrdinal.remove(currentSlotId);
            this.nanoSlotsByOrdinal.put(newSlotId, slot);
            return true;
        }
        return false;
    }

    public static String getOriginNameFromProperty(Property extensionProperty) {
        return extensionProperty.getName().replaceFirst("e\\d+_", "");
    }

    public static int getIdFromExtensionProperty(Property extensionProperty) {
        int extensionId = -1;
        try {
            extensionId = Integer.parseInt(extensionProperty.getName().replaceAll("(e)(\\d+)(_.*)", "$2"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return extensionId;
    }

    public void doNotifyNanoForPropertyChange(BNanoPropertyChangedArg changedPropertyInfo) {
        this.getNe2DeviceExt().handleNanoPropertyValueChange(changedPropertyInfo);
    }

    public BIcon getNanoIcon() {
        BIcon icon = DEFAULT_ICON;
        String iconFileName = this.getComponentFacets().gets("nano_attr_icon", DEFAULT_ICON_NAME);
        try {
            if (!iconFileName.equals(DEFAULT_ICON_NAME)) {
                iconFileName = iconFileName.replace('\\', '/');
                BOrd iconOrd = BOrd.make((String)(ICONS_X16_MODULE_ORD.toString() + "/" + iconFileName));
                iconOrd.get();
                icon = BIcon.make((BOrd)iconOrd);
            }
        }
        catch (Exception e3) {
            LOGGER.info("[BNanoBaseComponent.getNanoIcon()]: Failed to retrieve icon for " + this.getSlotPath() + "\nAssigning default icon");
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public Boolean addTriggerProperty(String triggerProperty, String dependentProperty, Context context) {
        BComponentSpace space = this.getComponentSpace();
        if (space != null && space.isProxyComponentSpace()) {
            try {
                return (Boolean)FoxRpcUtil.doRpc((BISpaceNode)this, (String)"addTriggerProperty", (Object[])new Object[]{triggerProperty, dependentProperty}).get();
            }
            catch (Exception exception) {
                return false;
            }
        }
        Property tp = this.getProperty(triggerProperty);
        Property dp = this.getProperty(dependentProperty);
        if (tp == null || dp == null) {
            return false;
        }
        Map<Property, ArrayList<Property>> map = this.propertyCache;
        synchronized (map) {
            if (!this.propertyCache.containsKey(tp)) {
                ArrayList<Property> dependentProps = new ArrayList<Property>();
                dependentProps.add(dp);
                this.propertyCache.put(tp, dependentProps);
            } else {
                ArrayList<Property> dependentProps = this.propertyCache.get(tp);
                if (!dependentProps.contains(dp)) {
                    dependentProps.add(dp);
                }
            }
        }
        return true;
    }

    public String[] getDependentProperties(String triggerProperty) {
        ArrayList<Property> dependentProps = this.propertyCache.get(triggerProperty);
        return dependentProps != null ? dependentProps.toArray(new String[0]) : new String[]{};
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        String originName = this.getOriginNameFromLibrary();
        boolean isLegal = child instanceof BNanoBaseComponent || originName.startsWith("Library.Schedules.") && originName.endsWith("Schedule") && child instanceof BNanoSchedule || originName.equals("Library.Schedules.Calendar") && child instanceof BNanoCalendar;
        return isLegal;
    }

    public boolean extensionExists(int extensionId) {
        if (extensionId == -1) {
            return false;
        }
        return Arrays.stream(this.getChildren(BNanoExtension.class)).anyMatch(extension -> extensionId == extension.getExtensionId());
    }
}

